/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.webapi;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.operate.webapi.ApiServiceLocalCache;
import kd.bos.entity.operate.webapi.OperationApi;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.webapi.EntyRowMatchStyle;
import kd.bos.form.operate.webapi.OperateDataConverter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public abstract class AbstractSave
extends OperationApi {
    private static Log log = LogFactory.getLog(AbstractSave.class);
    private static final String OPTION_NAME = "option";
    private static final String OPTION_IMPORTMODE = "importmode";
    private static final String OPTION_UPDATEFIELDS = "updateFields";
    private static final String OPTION_FIREPROPCHANGED = "firePropChanged";
    private static final String OPTION_FIREAFTERIMPORTDATA = "fireAfterImportData";
    private OperateDataConverter dataConverter;
    private Set<String> needUpDateFields;
    protected List<String> dataConvertOrder = new ArrayList<String>();
    private HasPermDimObjResult hasPermOrgResult;

    protected abstract OperationResult prepareDataEntity(IDataModel var1, Map<String, Object> var2, Supplier<OperationResult> var3);

    private Set<String> getNeedUpdateFields() {
        if (this.needUpDateFields == null) {
            this.needUpDateFields = new HashSet<String>();
            List strUpdateFields = (List)this.requestData.get(OPTION_UPDATEFIELDS);
            if (strUpdateFields != null) {
                for (String item : strUpdateFields) {
                    if (!StringUtils.isNotBlank((CharSequence)item)) continue;
                    this.needUpDateFields.add(item);
                }
            }
        }
        return this.needUpDateFields;
    }

    public HasPermDimObjResult getHasPermOrgResult() {
        if (this.hasPermOrgResult == null) {
            PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            this.hasPermOrgResult = permService.getHasPermDimObjs(Long.parseLong(RequestContext.get().getUserId()), (String)this.requestData.get("appid"), this.formId, "47150e89000000ac");
        }
        return this.hasPermOrgResult;
    }

    protected boolean isFirePropChanged() {
        Object paramValue;
        Map option = (Map)this.requestData.get(OPTION_NAME);
        boolean firePropChanged = false;
        if (option != null && (paramValue = option.get(OPTION_FIREPROPCHANGED)) != null) {
            firePropChanged = StringUtils.isBlank(paramValue) ? false : Boolean.parseBoolean(paramValue.toString());
        }
        return firePropChanged;
    }

    protected boolean isFireAfterImportData() {
        Map option = (Map)this.requestData.get(OPTION_NAME);
        boolean fireAfterImportData = true;
        if (option != null) {
            Object paramValue = option.get(OPTION_FIREAFTERIMPORTDATA);
            fireAfterImportData = StringUtils.isBlank(paramValue) || Boolean.parseBoolean(paramValue.toString());
        }
        return fireAfterImportData;
    }

    protected OperateDataConverter getDataConverter(IDataModel model) {
        if (this.dataConverter == null) {
            Object importModeObject;
            String entityNumber = model.getDataEntityType().getName();
            Map<BasedataItem, Object> cacheBasePKs = ApiServiceLocalCache.getBasePKs(entityNumber);
            Map<String, Map<Object, DynamicObject>> cacheBaseObjs = ApiServiceLocalCache.getBaseOBJs(entityNumber);
            this.dataConverter = new OperateDataConverter(model, cacheBasePKs, cacheBaseObjs);
            Map option = (Map)this.requestData.get(OPTION_NAME);
            boolean importMode = false;
            if (option != null && (importModeObject = option.get(OPTION_IMPORTMODE)) != null) {
                importMode = (Boolean)importModeObject;
            }
            this.dataConverter.setImportMode(importMode);
            this.dataConverter.setHasPermResult(this.getHasPermOrgResult());
        }
        return this.dataConverter;
    }

    protected void updateLocaleCache(IDataModel model) {
        if (this.dataConverter != null) {
            ApiServiceLocalCache.putBasePKs(this.formId, this.dataConverter.getBasePKs());
            ApiServiceLocalCache.putBaseOBJs(this.formId, this.dataConverter.getBaseObjs());
        }
    }

    protected Map<String, Object> getOption() {
        return new HashMap<String, Object>();
    }

    protected OperationResult resolve(IDataModel model, Map<String, Object> sourceData) {
        OperationResult result = null;
        try {
            result = this.prepareDataEntity(model, sourceData, () -> {
                boolean errorOccurred;
                Set<String> needUpDateFields = this.getNeedUpdateFields();
                OperateDataConverter convert = this.getDataConverter(model);
                int entityRowNum = sourceData.getOrDefault("rowNum", 3);
                convert.beginNewBill(entityRowNum);
                PKFieldProp pkProp = (PKFieldProp)model.getDataEntityType().getPrimaryKey();
                Object pkValue = model.getDataEntity().getPkValue();
                if (!pkProp.getValueComparator().compareValue(pkValue)) {
                    convert.setModify(true);
                } else {
                    convert.setModify(false);
                    if (pkProp instanceof LongProp) {
                        model.getDataEntity().set((IDataEntityProperty)pkProp, (Object)DBServiceHelper.genGlobalLongId());
                    } else if (pkProp instanceof VarcharProp) {
                        model.getDataEntity().set((IDataEntityProperty)pkProp, (Object)DBServiceHelper.genStringId());
                    }
                }
                convert.setNeedUpdateFields(needUpDateFields);
                convert.setDataConvertOrder(this.dataConvertOrder);
                model.putContextVariable("IGNORE_RELOADDATAMODEL", (Object)Boolean.TRUE);
                Map contextErrorMap = convert.getContextErrorInfo();
                boolean fireAfterImportData = this.isFireAfterImportData();
                Map<String, Object> option = this.getOption();
                boolean isForUpdateMultiLang = Boolean.TRUE.equals(option.get("ForUpdateMultiLangFields"));
                boolean overrideEntry = Boolean.TRUE.equals(option.get("OverrideEntry"));
                ModelEventProxy eventProxy = convert.getModelEventProxy();
                if (eventProxy != null && !isForUpdateMultiLang) {
                    BeforeImportDataEventArgs eventArgs = new BeforeImportDataEventArgs((Object)model, sourceData, convert.getBasePKs(), option);
                    eventProxy.fireBeforeImportData(eventArgs);
                    convert.setCheckImportable(eventArgs.isCheckImportable());
                    boolean bl = fireAfterImportData = fireAfterImportData && eventArgs.isFireAfterImportData() && !isForUpdateMultiLang;
                    if (eventArgs.isCancel()) {
                        this.mergeCancelMessages(eventArgs.getCancelMessages(), contextErrorMap);
                        return this.buildInitResult(contextErrorMap);
                    }
                }
                if (isForUpdateMultiLang || convert.isModify() && !overrideEntry) {
                    convert.setEntyRowMatchStyle(EntyRowMatchStyle.PrimaryKey);
                } else if (!convert.isModify()) {
                    convert.setEntyRowMatchStyle(EntyRowMatchStyle.Postion);
                }
                convert.filterBasedatas(sourceData, model.getDataEntity(), 0);
                convert.cacheBasedataPKIds();
                convert.convertComplexProperty(sourceData, model.getDataEntity(), 0);
                boolean bl = errorOccurred = sourceData.get("_ERROR_DATA_") != null;
                if (!errorOccurred && eventProxy != null && fireAfterImportData) {
                    ImportDataEventArgs eventArgs = new ImportDataEventArgs((Object)model, sourceData, convert.getBasePKs(), option);
                    eventProxy.fireAfterImportData(eventArgs);
                    if (eventArgs.isCancel()) {
                        this.mergeCancelMessages(eventArgs.getCancelMessages(), contextErrorMap);
                        return this.buildInitResult(contextErrorMap);
                    }
                }
                model.clearNoDataRow();
                model.removeContextVariable("IGNORE_RELOADDATAMODEL");
                OperationResult initResult = this.buildInitResult(contextErrorMap);
                if (errorOccurred) {
                    initResult.setSuccess(false);
                }
                return initResult;
            });
            return result;
        }
        catch (KDBizException bizExp) {
            result = new OperationResult();
            result.setSuccess(false);
            result.setMessage(bizExp.getMessage());
        }
        catch (Throwable exp) {
            if (SystemParamServiceHelper.isShowStackTrace()) {
                throw exp;
            }
            log.warn(exp);
            result = new OperationResult();
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u89e3\u6790\u6570\u636e\u5305\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"AbstractSave_1", (String)"bos-entity-business", (Object[])new Object[0]));
        }
        return result;
    }

    private void mergeCancelMessages(Map<Integer, List<String>> cancelMessages, Map<Integer, List<String>> contextErrorMap) {
        if (!cancelMessages.isEmpty()) {
            for (Map.Entry<Integer, List<String>> entry : cancelMessages.entrySet()) {
                List<String> errlist = contextErrorMap.get(entry.getKey());
                if (errlist == null) {
                    errlist = new ArrayList<String>();
                    contextErrorMap.put(entry.getKey(), errlist);
                }
                errlist.addAll((Collection<String>)entry.getValue());
            }
        } else {
            contextErrorMap.put(0, Collections.singletonList(ResManager.loadKDString((String)"\u63d2\u4ef6\u53d6\u6d88\u5f15\u5165\u672c\u5355", (String)"AbstractSave_0", (String)"bos-entity-business", (Object[])new Object[0])));
        }
    }

    private OperationResult buildInitResult(Map<Integer, List<String>> contextErrorMap) {
        OperationResult initResult = new OperationResult();
        if (!contextErrorMap.isEmpty()) {
            initResult.setSuccess(false);
            initResult.setMessage(JSONObject.toJSONString(contextErrorMap));
        }
        return initResult;
    }

    /*
     * Exception decompiling
     */
    public String formatException(Throwable throwable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

