/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.webapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.operate.webapi.OperationApi;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormMetadataCache;
import kd.bos.service.webapi.query.g.convert.FilterValueConvertHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class DeleteEntryRows
extends OperationApi {
    private static final String BOS_ENTITY_BUSINESS = "bos-entity-business";

    public ApiResult execute() {
        Map<String, Object> sourceData = this.getSourceData();
        IDataModel model = this.getView().getModel();
        Object pkId = sourceData.get("id");
        if (!QueryServiceHelper.exists((String)model.getDataEntityType().getName(), (Object)pkId)) {
            return ApiResult.fail((String)String.format("data id:%s does not exist", pkId));
        }
        model.beginInit();
        ((IBillModel)model).load(sourceData.get("id"), () -> {
            OperationResult result = new OperationResult();
            BillEntityType dt = (BillEntityType)model.getDataEntityType();
            String billStatusKey = dt.getBillStatus();
            if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !dt.getProperty(billStatusKey).isDbIgnore()) {
                Object status = model.getValue(billStatusKey);
                if (BillStatus.B.name().equals(status)) {
                    result.setSuccess(false);
                    result.setMessage(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"Save_6", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.B)));
                    return result;
                }
                if (BillStatus.C.name().equals(status)) {
                    String masterIdProp;
                    boolean isDefaultAudit;
                    boolean allowOverrideAudit = isDefaultAudit = BillStatus.C.name().equals(((FieldProp)dt.getProperty(billStatusKey)).getDefValue());
                    if (!isDefaultAudit && dt instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(masterIdProp = ((BasedataEntityType)dt).getMasteridPropName()))) {
                        Object masterId = model.getValue(masterIdProp);
                        if (this.isHashCtrlStrategy(dt) && pkId.equals(masterId)) {
                            allowOverrideAudit = true;
                        }
                    }
                    if (!allowOverrideAudit) {
                        result.setSuccess(false);
                        result.setMessage(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"Save_6", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.C)));
                        return result;
                    }
                }
            }
            return result;
        });
        model.endInit();
        String entryName = (String)this.requestData.get("entryName");
        List sourceEntryIds = (List)sourceData.get(entryName);
        if (sourceEntryIds == null) {
            return ApiResult.fail((String)String.format("input:data is not found entryKey:%s", entryName));
        }
        HashMap<Object, Boolean> entryIds = new HashMap<Object, Boolean>();
        for (Object item : sourceEntryIds) {
            Map edo = (Map)item;
            Object entryId = edo.remove("fentryid");
            if (entryId == null) {
                entryId = edo.remove("id");
            }
            if (entryId == null) continue;
            BillEntityType dt = (BillEntityType)model.getDataEntityType();
            Object convertResult = FilterValueConvertHelper.getConvertResult((IDataEntityProperty)((DynamicProperty)dt.getPrimaryKey()), entryId);
            entryIds.put(convertResult, Boolean.FALSE);
        }
        if (!model.getDataEntityType().getAllEntities().containsKey(entryName)) {
            return ApiResult.fail((String)String.format("formId:%s is not found entryKey:%s", this.formId, entryName));
        }
        ArrayList<Integer> deleteRows = new ArrayList<Integer>();
        for (int i = 0; i < model.getEntryEntity(entryName).size(); ++i) {
            DynamicObject row = model.getEntryRowEntity(entryName, i);
            Object pkValue = row.getPkValue();
            if (!entryIds.containsKey(pkValue)) continue;
            entryIds.put(pkValue, Boolean.TRUE);
            deleteRows.add(i);
        }
        for (Map.Entry checkMatched : entryIds.entrySet()) {
            if (((Boolean)checkMatched.getValue()).booleanValue()) continue;
            return ApiResult.fail((String)String.format("entry:%s pkid:%s does not exist", entryName, checkMatched.getKey()));
        }
        if (deleteRows.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u9700\u8981\u5904\u7406\u7684\u6570\u636e", (String)"DefaultOperate_\uff11", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
        }
        model.deleteEntryRows(entryName, deleteRows.stream().mapToInt(Integer::valueOf).toArray());
        DynamicObject billObj = model.getDataEntity(true);
        OperateOption option = OperateOption.create();
        option.setVariableValue("autogeneratebillno", String.valueOf(true));
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        Operations ops = this.getFormOperations(this.getView().getFormShowParameter().getFormId());
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)ops.getSave(), (String)model.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{billObj}, (OperateOption)option);
        return this.buildApiResult(saveResult);
    }

    private Object getStatusCaption(BillEntityType dt, String billStatusKey, BillStatus status) {
        BillStatusProp statusProp = (BillStatusProp)dt.getProperty(billStatusKey);
        for (ValueMapItem item : statusProp.getComboItems()) {
            if (!status.name().equals(item.getValue())) continue;
            return item.getName();
        }
        return status.getValue();
    }

    private boolean isHashCtrlStrategy(BillEntityType dt) {
        return dt.getProperty("createorg") != null && dt.getProperty("ctrlstrategy") != null;
    }

    private Operations getFormOperations(String formId) {
        String entityTypeId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
        return EntityMetadataCache.getDataEntityOperations((String)entityTypeId);
    }

    private ApiResult buildApiResult(OperationResult saveResult) {
        if (saveResult != null) {
            if (saveResult.isSuccess()) {
                return ApiResult.success((Object)saveResult);
            }
            ApiResult apiResult = new ApiResult();
            apiResult.setSuccess(false);
            apiResult.setMessage(DeleteEntryRows.getFirstErrorMessage(saveResult));
            apiResult.setData((Object)saveResult);
            return apiResult;
        }
        ApiResult apiResult = new ApiResult();
        apiResult.setSuccess(false);
        return apiResult;
    }

    private Map<String, Object> getSourceData() {
        Map dataObject = (Map)this.requestData.get("data");
        return dataObject;
    }
}

