/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.webapi;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.logging.log4j.util.Strings;

class OpWebApiHelper {
    private OpWebApiHelper() {
    }

    public static Object getPk(BillEntityType dt, Object pkId, String number, String orgNumber) {
        return OpWebApiHelper.getPk(dt, pkId, number, orgNumber, false);
    }

    public static Object getPk(BillEntityType dt, Object pkId, String number, String orgNumber, boolean submittedIgnore) {
        if (StringUtils.isEmpty((CharSequence)number)) {
            return null;
        }
        QFilter filter = new QFilter(dt.getBillNo(), "=", (Object)number);
        if (StringUtils.isNotBlank((CharSequence)dt.getMainOrg()) && StringUtils.isNotBlank((CharSequence)orgNumber)) {
            filter.and(dt.getMainOrg() + "." + dt.getMainOrgProperty().getNumberProp(), "=", (Object)orgNumber);
        }
        return OpWebApiHelper.getPk(dt, pkId, filter, submittedIgnore);
    }

    public static Object getPk(BillEntityType dt, Object pkId, QFilter filter, boolean submittedIgnore) {
        Object tempPkId = null;
        if (pkId != null) {
            if (pkId.getClass() != dt.getPrimaryKey().getPropertyType()) {
                tempPkId = ConvertUtils.convert((Object)pkId, (Class)dt.getPrimaryKey().getPropertyType());
            }
        } else {
            List pks;
            String billStatusKey;
            BasedataEntityType bdt;
            if (dt instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(bdt = (BasedataEntityType)dt).getMasteridPropName())) {
                filter.and(new QFilter("id", "=", (Object)bdt.getMasteridPropName(), true));
            }
            if (submittedIgnore && StringUtils.isNotBlank((CharSequence)(billStatusKey = dt.getBillStatus()))) {
                filter.and(billStatusKey, "!=", (Object)BillStatus.B.name()).and(billStatusKey, "!=", (Object)BillStatus.C.name());
            }
            if ((pks = QueryServiceHelper.queryPrimaryKeys((String)"kd.bos.entity.operate.webapi.load", (String)dt.getName(), (QFilter[])new QFilter[]{filter}, (String)"", (int)2)).size() == 1) {
                tempPkId = pks.get(0);
            } else if (pks.size() > 1) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6570\u636e\uff01- \u8fc7\u6ee4\u6761\u4ef6\uff1a{0}\u3002", (String)"OpWebApiHelper_0", (String)"bos-entity-business", (Object[])new Object[0]), filter.toString()));
            }
        }
        return tempPkId;
    }

    @Deprecated
    public static List<Object> getPks(BillEntityType dt, String[] numbers, String orgNumber) {
        QFilter filter = new QFilter(dt.getBillNo(), "in", (Object)numbers);
        if (dt instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)dt;
        } else if (StringUtils.isNotBlank((CharSequence)dt.getMainOrg()) && StringUtils.isBlank((CharSequence)orgNumber)) {
            filter.and(dt.getMainOrg(), "=", (Object)orgNumber);
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"kd.bos.entity.operate.webapi.load", (String)dt.getName(), (QFilter[])new QFilter[]{filter}, (String)"", (int)numbers.length);
    }

    private static List<Object> getPksIMP(BillEntityType dt, String[] numbers, String orgNumber) {
        QFilter filter = new QFilter(dt.getBillNo(), "in", (Object)numbers);
        if (dt instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)dt;
        } else if (StringUtils.isNotBlank((CharSequence)dt.getMainOrg()) && StringUtils.isBlank((CharSequence)orgNumber)) {
            filter.and(dt.getMainOrg(), "=", (Object)orgNumber);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)dt.getName(), (String)("id," + dt.getBillNo()), (QFilter[])new QFilter[]{filter});
        boolean canReturn = true;
        for (String number : numbers) {
            long count = dynamicObjects.stream().filter(i -> i.getString(dt.getBillNo()).equals(number)).count();
            if (count <= 1L) continue;
            canReturn = false;
        }
        List<Object> rpks = dynamicObjects.stream().map(i -> i.get("id")).collect(Collectors.toList());
        if (canReturn && !rpks.isEmpty()) {
            return rpks;
        }
        return new ArrayList<Object>();
    }

    static List<Object> getPks(BillEntityType dt, String[] numbers, String orgNumber, String apiOrgtype) {
        List<Object> pksIMP = OpWebApiHelper.getPksIMP(dt, numbers, orgNumber);
        if (!pksIMP.isEmpty()) {
            return pksIMP;
        }
        List<Object> pksbyNumber = OpWebApiHelper.getPksbyNumber(dt, numbers);
        if (!pksbyNumber.isEmpty()) {
            return pksbyNumber;
        }
        return OpWebApiHelper.getApiOrgtypePks(dt, numbers, orgNumber, apiOrgtype);
    }

    private static List<Object> getPksbyNumber(BillEntityType dt, String[] numbers) {
        QFilter filterBillNo = new QFilter(dt.getBillNo(), "in", (Object)numbers);
        DynamicObjectCollection dynamicObjectsBillNo = QueryServiceHelper.query((String)dt.getName(), (String)("id," + dt.getBillNo()), (QFilter[])new QFilter[]{filterBillNo});
        boolean canReturn = true;
        for (String number : numbers) {
            long count = dynamicObjectsBillNo.stream().filter(i -> i.getString(dt.getBillNo()).equals(number)).count();
            if (count <= 1L) continue;
            canReturn = false;
        }
        List<Object> rpksbyBillNo = dynamicObjectsBillNo.stream().map(i -> i.get("id")).collect(Collectors.toList());
        if (canReturn && !rpksbyBillNo.isEmpty()) {
            return rpksbyBillNo;
        }
        return new ArrayList<Object>();
    }

    private static List<Object> getApiOrgtypePks(BillEntityType dt, String[] numbers, String orgNumber, String apiOrgtype) {
        QFilter filter = new QFilter(dt.getBillNo(), "in", (Object)numbers);
        if (dt instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)dt;
        } else if (StringUtils.isNotBlank((CharSequence)dt.getMainOrg()) && StringUtils.isNotBlank((CharSequence)orgNumber)) {
            if ("id".equalsIgnoreCase(apiOrgtype) || Strings.isBlank((String)apiOrgtype)) {
                try {
                    filter.and(dt.getMainOrg(), "=", (Object)Long.parseLong(orgNumber));
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5185\u7801\u8f6c\u6362\u5931\u8d25", (String)"OpWebApiHelper_0", (String)"bos-open-service", (Object[])new Object[0]));
                }
            } else if ("number".equalsIgnoreCase(apiOrgtype)) {
                filter.and(dt.getMainOrg().concat(".number"), "=", (Object)orgNumber);
            } else if ("name".equalsIgnoreCase(apiOrgtype)) {
                filter.and(dt.getMainOrg().concat(".name"), "=", (Object)orgNumber);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u652f\u6301\u7684\u7ec4\u7ec7\u67e5\u627ekey", (String)"OpWebApiHelper_1", (String)"bos-open-service", (Object[])new Object[0]));
            }
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)dt.getName(), (String)("id," + dt.getBillNo()), (QFilter[])new QFilter[]{filter});
        for (String number : numbers) {
            long count = dynamicObjects.stream().filter(i -> i.getString(dt.getBillNo()).equals(number)).count();
            if (count <= 1L) continue;
            if (!(dt instanceof BasedataEntityType) && StringUtils.isBlank((CharSequence)apiOrgtype)) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u901a\u8fc7\u6761\u4ef6{0}\uff0c\u67e5\u627e\u5230{1}\u6761\u6570\u636e\uff0c\u53ef\u4f20\u5165\u201corg=\u7ec4\u7ec7\u503c&api.orgtype=[number|name]\u201d\u6761\u4ef6 \uff0c\u4ee5\u4fbf\u67e5\u627e\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (String)"OpWebApiHelper_2", (String)"bos-open-service", (Object[])new Object[0]), filter, dynamicObjects.size()));
            }
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u901a\u8fc7\u6761\u4ef6{0}\uff0c\u67e5\u627e\u5230\u7f16\u7801\uff1a{1}\uff0c\u5b58\u5728{2}\u6761\u6570\u636e\u3002", (String)"OpWebApiHelper_3", (String)"bos-open-service", (Object[])new Object[0]), filter, number, count));
        }
        return dynamicObjects.stream().map(i -> i.get("id")).collect(Collectors.toList());
    }
}

