/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.events.ConvertPkEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.operate.webapi.AbstractSave;
import kd.bos.entity.operate.webapi.ApiServiceLocalCache;
import kd.bos.entity.operate.webapi.SingleBillResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiConstant;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.servicehelper.BusinessDataApiServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.http.client.utils.CloneUtils;

@SdkInternal
public class Save
extends AbstractSave {
    private static final String OPTION = "option";
    private static final String BOS_ENTITY_BUSINESS = "bos-entity-business";
    private static final String IMPORT_TYPE = "importtype";
    private static final String SAVE_5 = "Save_5";
    private static final String IMPORT_PROP = "importprop";
    private static final String NUMBER = "number";
    private static Log log = LogFactory.getLog(Save.class);
    private DynamicObject blankDataEntity;
    private static final String CREATEORGKEY = "createorg";

    private List<Map<String, Object>> getSourceDatas() {
        Object data = this.requestData.get("data");
        Object datas = this.requestData.get("datas");
        if (data != null) {
            Map dataObject = (Map)data;
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            list.add(dataObject);
            return list;
        }
        if (datas != null) {
            return (List)datas;
        }
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public Map<String, Object> getOption() {
        HashMap option = (HashMap)this.requestData.get(OPTION);
        if (option == null) {
            option = new HashMap();
            this.requestData.put(OPTION, option);
        }
        return option;
    }

    protected FormShowParameter createShowParameter() {
        FormShowParameter showParameter = super.createShowParameter();
        showParameter.setAppId(this.getAppId());
        return showParameter;
    }

    private Object getBlankDataEntity(IDataModel model) {
        if (this.blankDataEntity == null) {
            this.blankDataEntity = ApiServiceLocalCache.getBlankDataEntity(model.getDataEntityType().getName(), String.valueOf(RequestContext.get().getOrgId()), RequestContext.get().getUserId());
        }
        if (this.blankDataEntity != null && !StringUtils.equals((CharSequence)((MainEntityType)this.blankDataEntity.getDataEntityType()).getVersion(), (CharSequence)model.getDataEntityType().getVersion())) {
            this.blankDataEntity = null;
        }
        if (this.blankDataEntity == null) {
            model.beginInit();
            model.createNewData();
            model.endInit();
            this.blankDataEntity = model.getDataEntity();
            ApiServiceLocalCache.putBlankDataEntity(model.getDataEntityType().getName(), String.valueOf(RequestContext.get().getOrgId()), RequestContext.get().getUserId(), this.blankDataEntity);
        } else {
            IDataEntityType dt = this.blankDataEntity.getDataEntityType();
            for (IDataEntityProperty property : dt.getProperties()) {
                if (!(property instanceof CreateDateProp)) continue;
                property.setValue((Object)this.blankDataEntity, (Object)new Date());
                break;
            }
        }
        return (DynamicObject)OrmUtils.clone((IDataEntityBase)this.blankDataEntity, (boolean)false, (boolean)true);
    }

    public ApiResult execute() {
        List<Map<String, Object>> sourceDatas = this.getSourceDatas();
        Map<String, Object> customOption = this.getOption();
        boolean isForUpdateMultiLang = Boolean.TRUE.equals(customOption.get("ForUpdateMultiLangFields"));
        if (sourceDatas.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5728\u8f93\u5165\u53c2\u6570\u5b57\u5178\u4e2d\uff0c\u6ca1\u6709\u627e\u5230\u6570\u636e\u53c2\u6570data\u6216datas\u8282\u70b9", (String)"Save_0", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
        }
        int defaultSize = sourceDatas.size();
        ArrayList<SingleBillResult> convResults = new ArrayList<SingleBillResult>(defaultSize);
        LinkedHashSet<String> pkIds = new LinkedHashSet<String>(defaultSize);
        IDataModel model = this.getView().getModel();
        model.putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)Boolean.TRUE);
        ModelEventProxy eventProxy = (ModelEventProxy)model.getService(ModelEventProxy.class);
        if (eventProxy != null && !isForUpdateMultiLang) {
            eventProxy.fireInitImportData(new InitImportDataEventArgs((Object)model, sourceDatas, customOption, this.dataConvertOrder));
        }
        try {
            this.fillPkIds(model, sourceDatas);
            List cloneDatas = (List)CloneUtils.cloneObject(sourceDatas);
            OperationResult saveResult = this.executeSave(model, cloneDatas, convResults, pkIds);
            return this.buildApiResult(model, convResults, pkIds, saveResult);
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[]{ApiConstant.OPERATIONFALSEMESSAGE.concat("\uff1a") + ex.getMessage()});
        }
    }

    private OperationResult executeSave(IDataModel model, List<Map<String, Object>> cloneDatas, List<SingleBillResult> convResults, Set<String> pkIds) {
        Map<String, Object> customOption = this.getOption();
        ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>();
        PKFieldProp pkProp = (PKFieldProp)model.getDataEntityType().getPrimaryKey();
        int len = cloneDatas.size();
        for (int i = 0; i < len; ++i) {
            SingleBillResult billResult = new SingleBillResult();
            billResult.setDIndex(i);
            convResults.add(billResult);
            Map<String, Object> map = cloneDatas.get(i);
            OperationResult convResult = this.resolve(model, map);
            if (convResult.isSuccess()) {
                billResult.setSuccess(true);
                DynamicObject billObj = model.getDataEntity(true);
                billResult.setId(pkProp.getValueFast((Object)billObj));
                billObjs.add(model.getDataEntity(true));
                pkIds.add(billResult.getId().toString());
                continue;
            }
            billResult.setSuccess(false);
            String msg = convResult.getMessage();
            if (msg != null && msg.startsWith("{") && msg.endsWith("}")) {
                try {
                    billResult.setConvertResult(JSONObject.parseObject((String)msg, HashMap.class));
                }
                catch (Exception e) {
                    log.warn(String.format("appid:%s", this.getAppId()), (Throwable)e);
                    billResult.setMessage(msg);
                }
                continue;
            }
            billResult.setMessage(msg);
        }
        if (!billObjs.isEmpty()) {
            OperateOption option = OperateOption.create();
            Map optionVariables = (Map)this.requestData.get("optionvariables");
            if (optionVariables != null) {
                for (Map.Entry entry : optionVariables.entrySet()) {
                    option.setVariableValue((String)entry.getKey(), (String)entry.getValue());
                }
            }
            option.setVariableValue(IMPORT_TYPE, String.valueOf(customOption.get(IMPORT_TYPE)));
            option.setVariableValue("autogeneratebillno", String.valueOf(true));
            option.setVariableValue("currbizappid", this.getAppId());
            option.setVariableValue("ignorewarn", String.valueOf(true));
            option.setVariableValue("ignoreinteraction", String.valueOf(true));
            option.setVariableValue("webapitag_of_datasource", String.valueOf(true));
            try {
                return OperationServiceHelper.executeOperate((String)this.getOperationNumber(), (String)model.getDataEntityType().getName(), (DynamicObject[])billObjs.toArray(new DynamicObject[billObjs.size()]), (OperateOption)option);
            }
            catch (Throwable e) {
                log.warn(e);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException && (cause = cause.getCause()) instanceof SQLException) {
                    e = cause;
                }
                if (e instanceof KDBizException || e instanceof SQLException || !SystemParamServiceHelper.isShowStackTrace()) {
                    operationResult.setMessage(e.getMessage());
                } else if (SystemParamServiceHelper.isShowStackTrace()) {
                    operationResult.setMessage(ImportLogger.formatException((Throwable)e));
                }
                return operationResult;
            }
        }
        return null;
    }

    private String getAppId() {
        return (String)this.requestData.get("appid");
    }

    private void fillPkIds(IDataModel model, List<Map<String, Object>> sourceDatas) throws ParseException {
        String entityName = model.getDataEntityType().getName();
        Object object = this.requestData.get(OPTION);
        if (object instanceof Map) {
            HashMap<Integer, Map<String, Object>> rowMappings;
            Map option = (Map)object;
            String importType = (String)option.get(IMPORT_TYPE);
            if ("new".equals(importType) || importType == null && option.get("KeyFields") == null) {
                return;
            }
            BillEntityType dt = (BillEntityType)model.getDataEntityType();
            Map<String, Set<Object>> params = this.prepareKeyFields(dt, option, sourceDatas, rowMappings = new HashMap<Integer, Map<String, Object>>());
            if (!params.isEmpty()) {
                QFilter filters = this.buildKeyFilters(params);
                HashSet<String> selectFields = new HashSet<String>(params.keySet());
                String masterIdKey = null;
                OrgProp createOrgProp = null;
                boolean isBasedata = dt instanceof BasedataEntityType;
                if (isBasedata) {
                    BasedataEntityType bdt = (BasedataEntityType)dt;
                    DynamicProperty orgProp = bdt.getProperty(CREATEORGKEY);
                    if (orgProp instanceof OrgProp && StringUtils.isNotBlank((CharSequence)orgProp.getAlias())) {
                        selectFields.add(CREATEORGKEY);
                        createOrgProp = (OrgProp)orgProp;
                    }
                    if (StringUtils.isNotBlank((CharSequence)bdt.getMasteridPropName())) {
                        masterIdKey = bdt.getMasteridPropName();
                        selectFields.add(masterIdKey);
                    }
                }
                String selectkey = selectFields.contains("id") ? String.join((CharSequence)",", selectFields) : "id," + String.join((CharSequence)",", selectFields);
                try (DataSet dataset = QueryServiceHelper.queryDataSet((String)("importdata." + entityName), (String)entityName, (String)selectkey, (QFilter[])new QFilter[]{filters}, (String)"");){
                    this.fillPkIdsByDataSet(dataset, params, rowMappings, createOrgProp, masterIdKey, sourceDatas, isBasedata);
                }
            }
        }
    }

    private Map<String, String> getSelectField(BillEntityType dt, Map<?, ?> option) {
        HashMap<String, String> fields = new HashMap<String, String>();
        List<Object> fieldkeys = new ArrayList<String>();
        String keyfields = (String)option.get("KeyFields");
        if (StringUtils.isBlank((CharSequence)keyfields)) {
            if (StringUtils.isNotBlank((CharSequence)dt.getMainOrg())) {
                fieldkeys.add(dt.getMainOrg());
            }
            if (StringUtils.isNotBlank((CharSequence)dt.getBillNo())) {
                fieldkeys.add(dt.getBillNo());
            }
            if (StringUtils.isNotBlank((CharSequence)dt.getBillStatus())) {
                fieldkeys.add(dt.getBillStatus());
            }
        } else {
            fieldkeys = Arrays.asList(keyfields.split(","));
        }
        if (fieldkeys == null || fieldkeys.isEmpty()) {
            return fields;
        }
        for (int i = 0; i < fieldkeys.size(); ++i) {
            LocaleString displayName;
            DynamicProperty prop;
            String field = (String)fieldkeys.get(i);
            if (!StringUtils.isNotBlank((CharSequence)field) || (prop = dt.getProperty(field)) == null) continue;
            String fieldName = null;
            fieldName = "id".equals(field) ? ResManager.loadKDString((String)"\u5185\u7801", (String)"Save_12", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]) : ("pid".equals(field) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"Save_13", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]) : ((displayName = prop.getDisplayName()) != null && StringUtils.isNotBlank((CharSequence)displayName.toString()) ? displayName.toString() : field));
            fields.put(field, fieldName);
        }
        return fields;
    }

    private void fillPkIdsByDataSet(DataSet dataset, Map<String, Set<Object>> params, Map<Integer, Map<String, Object>> rowMappings, OrgProp createOrgProp, String masterIdKey, List<Map<String, Object>> sourceDatas, boolean isBasedata) {
        List<Object> rows;
        HashMap<String, ArrayList<Object[]>> pkIdMapping = new HashMap<String, ArrayList<Object[]>>();
        for (Row data : dataset) {
            KeyParams kp = this.buildQueryKey(params.keySet(), createOrgProp, masterIdKey, data);
            rows = (ArrayList<Object[]>)pkIdMapping.get(kp.key);
            if (rows == null) {
                rows = new ArrayList<Object[]>();
                pkIdMapping.put(kp.key, (ArrayList<Object[]>)rows);
            }
            rows.add(new Object[]{kp.id, kp.masterId, kp.createOrgNumber, kp.createOrgName});
        }
        for (Map.Entry<Integer, Map<String, Object>> entry : rowMappings.entrySet()) {
            String queryKey = JSON.toJSONString(entry.getValue());
            rows = (List)pkIdMapping.get(queryKey);
            if (rows == null) continue;
            Map<String, Object> dataObject = sourceDatas.get(entry.getKey());
            if (isBasedata) {
                if (this.basedataFillPkIdsByDataSet(rows, createOrgProp, masterIdKey, dataObject)) continue;
                continue;
            }
            if (rows.size() == 1) {
                dataObject.put("id", ((Object[])rows.get(0))[0]);
                continue;
            }
            if (rows.size() <= 1) continue;
            StringBuilder sb = new StringBuilder();
            for (Object[] obj : rows) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                if (obj.length <= 0) continue;
                sb.append(obj[0]);
            }
            dataObject.put("id", null);
            dataObject.put("_errMsg_", String.format(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e:%s", (String)SAVE_5, (String)"bos-open-service", (Object[])new Object[0]), sb.toString()));
        }
    }

    private boolean basedataFillPkIdsByDataSet(List<Object[]> rows, OrgProp createOrgProp, String masterIdKey, Map<String, Object> dataObject) {
        StringBuilder sb;
        Map createOrgMap;
        boolean idFound = Boolean.TRUE;
        HashSet<Object> tempPks = new HashSet<Object>();
        if (createOrgProp != null && (createOrgMap = (Map)dataObject.get(createOrgProp.getName())) != null) {
            Object object = createOrgMap.get(IMPORT_PROP);
            String name = createOrgMap.containsKey(NUMBER) ? NUMBER : "name";
            String dataType = object != null ? (String)object : name;
            Object val = createOrgMap.get(dataType);
            if (StringUtils.isNotBlank(val)) {
                tempPks.clear();
                for (Object[] row : rows) {
                    if (!val.equals(row[NUMBER.equals(dataType) ? 2 : 3])) continue;
                    tempPks.add(row[0]);
                }
            }
        }
        if (tempPks.isEmpty()) {
            sb = new StringBuilder();
            for (Object[] row : rows) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(row[0]);
                if (StringUtils.isNotBlank((CharSequence)masterIdKey)) {
                    if (!row[0].equals(row[1]) && !StringUtils.isBlank((Object)row[1])) continue;
                    tempPks.add(row[0]);
                    continue;
                }
                tempPks.add(row[0]);
            }
            if (tempPks.size() == 1) {
                dataObject.put("id", tempPks.iterator().next());
            } else if (tempPks.size() > 1) {
                sb.insert(0, ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e:", (String)"Save_4", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
                dataObject.put("id", null);
                dataObject.put("_errMsg_", sb.toString());
            } else if (rows != null && !rows.isEmpty()) {
                dataObject.put("id", null);
                dataObject.put("_errMsg_", String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e0d\u5408\u6cd5\uff1a%s", (String)"Save_4", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), sb.toString()));
            } else {
                idFound = false;
            }
        } else if (tempPks.size() == 1) {
            dataObject.put("id", tempPks.iterator().next());
        } else {
            sb = new StringBuilder(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e:", (String)"Save_4", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
            for (Object obj : tempPks) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(obj);
            }
            dataObject.put("id", null);
            dataObject.put("_errMsg_", sb.toString());
        }
        return idFound;
    }

    private QFilter buildKeyFilters(Map<String, Set<Object>> params) {
        QFilter filter = null;
        for (Map.Entry<String, Set<Object>> entry : params.entrySet()) {
            String fieldKey = entry.getKey();
            Set<Object> value = entry.getValue();
            if (filter == null) {
                filter = new QFilter(fieldKey, "in", value);
                continue;
            }
            filter.and(fieldKey, "in", value);
        }
        return filter;
    }

    private Map<String, Set<Object>> prepareKeyFields(BillEntityType dt, Map<?, ?> option, List<Map<String, Object>> sourceDatas, Map<Integer, Map<String, Object>> rowMappings) throws ParseException {
        Map<String, String> fields = this.getSelectField(dt, option);
        HashMap<String, Set<Object>> params = new HashMap<String, Set<Object>>();
        for (int i = 0; i < sourceDatas.size(); ++i) {
            Map<String, Object> dataObject = sourceDatas.get(i);
            dataObject.put("_dindex_", i);
            ConvertPkEvent e = new ConvertPkEvent((Object)this.getView(), this.getOperationNumber(), dataObject);
            this.fireConvertPkEvent(e);
            if (e.getPK() == null) {
                Object pkId = dataObject.get("id");
                if (StringUtils.isNotBlank((Object)pkId) && pkId.getClass() != dt.getPrimaryKey().getPropertyType()) {
                    dataObject.put("_source_id_", pkId);
                    pkId = ConvertUtils.convert((Object)pkId, (Class)dt.getPrimaryKey().getPropertyType());
                    dataObject.put("id", pkId);
                }
                HashMap<String, Object> rowMapping = new HashMap<String, Object>();
                for (String field : fields.keySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)field)) continue;
                    DynamicProperty fieldProperty = dt.getProperty(field);
                    boolean isBaseData = fieldProperty instanceof BasedataProp;
                    Object tempVal = dataObject.get(field);
                    if (isBaseData) {
                        if (tempVal != null) {
                            Map tempMap = (Map)tempVal;
                            Object object = tempMap.get(IMPORT_PROP);
                            String name = tempMap.containsKey(NUMBER) ? NUMBER : "name";
                            String fieldName = object != null ? (String)object : name;
                            String dataType = tempMap.containsKey("id") ? "id" : fieldName;
                            tempVal = tempMap.get(dataType);
                            field = field + "." + dataType;
                        } else {
                            BasedataProp basedataProp = (BasedataProp)fieldProperty;
                            PKFieldProp baseatePK = (PKFieldProp)basedataProp.getDynamicComplexPropertyType().getPrimaryKey();
                            tempVal = baseatePK.getDefValue();
                        }
                    } else if (tempVal == null) {
                        tempVal = fieldProperty.getDefaultValue();
                    } else if (fieldProperty instanceof MuliLangTextProp) {
                        tempVal = LocaleString.fromMap((Map)((Map)tempVal)).toString();
                    } else if (fieldProperty instanceof DateTimeProp && !(tempVal instanceof Date)) {
                        tempVal = ((DateTimeProp)fieldProperty).getDateFormat().parse(tempVal.toString());
                    }
                    HashSet<Object> values = (HashSet<Object>)params.get(field);
                    if (values == null) {
                        values = new HashSet<Object>();
                        params.put(field, values);
                    }
                    values.add(tempVal);
                    rowMapping.put(field, tempVal);
                }
                rowMappings.put(i, rowMapping);
                continue;
            }
            dataObject.put("id", e.getPK());
        }
        return params;
    }

    private KeyParams buildQueryKey(Set<String> keys, OrgProp createOrgProp, String masterIdKey, Row row) {
        Object pk;
        DynamicObject createOrg;
        KeyParams qk = new KeyParams();
        HashMap<String, Object> keysObj = new HashMap<String, Object>(16);
        for (String key : keys) {
            keysObj.put(key, row.get(key));
        }
        if (createOrgProp != null && (createOrg = BusinessDataApiServiceHelper.loadSingleFromCache(pk = keys.contains(createOrgProp.getName()) ? keysObj.get(createOrgProp.getName()) : row.get(createOrgProp.getName()), (DynamicObjectType)createOrgProp.getDynamicComplexPropertyType())) != null) {
            qk.createOrgNumber = createOrg.getString(createOrgProp.getNumberProp());
            qk.createOrgName = createOrg.getString(createOrgProp.getDisplayProp());
        }
        if (StringUtils.isNotBlank((CharSequence)masterIdKey)) {
            qk.masterId = keys.contains(masterIdKey) ? keysObj.get(masterIdKey) : row.get(masterIdKey);
        }
        qk.id = row.get("id");
        qk.key = JSON.toJSONString(keysObj);
        return qk;
    }

    public String getOperationNumber() {
        String submit = (String)this.requestData.get("forcedsubmit");
        if (StringUtils.isEmpty((CharSequence)submit)) {
            return super.getOperationNumber();
        }
        return submit;
    }

    @Override
    protected OperationResult prepareDataEntity(IDataModel model, Map<String, Object> dataObject, Supplier<OperationResult> initializer) {
        OperationResult result = new OperationResult();
        if (dataObject == null) {
            return null;
        }
        Map option = (Map)this.requestData.get(OPTION);
        String importType = option != null ? (String)option.get(IMPORT_TYPE) : null;
        Object pkId = dataObject.get("id");
        if ("new".equals(importType) || "overridenew".equals(importType) && pkId == null || importType == null && pkId == null || importType != null && !"override".equals(importType) && !"overridenew".equals(importType)) {
            if (StringUtils.isNotBlank((Object)pkId) && QueryServiceHelper.exists((String)model.getDataEntityType().getName(), (Object)pkId)) {
                result.setSuccess(false);
                result.setMessage(String.format(ResManager.loadKDString((String)"\u5185\u7801\u5df2\u5b58\u5728\u65e0\u6cd5\u65b0\u589e\uff1a%s", (String)"Save_3", (String)"bos-open-service", (Object[])new Object[0]), dataObject.get("id")));
                return result;
            }
            model.beginInit();
            model.createNewData(this.getBlankDataEntity(model), initializer);
            model.endInit();
        } else {
            if (StringUtils.isBlank((Object)pkId) || pkId instanceof Number && Long.compare(Long.parseLong(pkId.toString()), 0L) == 0) {
                String errMsg = (String)dataObject.remove("_errMsg_");
                result.setSuccess(false);
                result.setMessage(StringUtils.isNotBlank((CharSequence)errMsg) ? errMsg : String.format(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u7cfb\u7edf\u627e\u4e0d\u5230\u201c%s\u201d\u7684\u6570\u636e\u884c", (String)"Save_11", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), this.getFilterDesc(model, option, dataObject)));
                return result;
            }
            if (QueryServiceHelper.exists((String)model.getDataEntityType().getName(), (Object)pkId)) {
                if (!this.isFirePropChanged()) {
                    model.beginInit();
                }
                boolean isForUpdateMultiLang = option != null && Boolean.TRUE.equals(option.get("ForUpdateMultiLangFields"));
                this.loadData(model, pkId, initializer, result, isForUpdateMultiLang);
                if (!this.isFirePropChanged()) {
                    model.endInit();
                }
            } else {
                result.setSuccess(false);
                result.setMessage(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\u5185\u7801ID\uff1a%s", (String)"Save_4", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), pkId));
            }
        }
        return result;
    }

    private String getFilterDesc(IDataModel model, Map<String, Object> option, Map<String, Object> dataObject) {
        Map<String, String> keyFields = this.getSelectField((BillEntityType)model.getDataEntityType(), option);
        StringBuilder sb = new StringBuilder();
        Map<String, Object> sourceData = this.getSourceDatas().get((Integer)dataObject.get("_dindex_"));
        for (Map.Entry<String, String> entry : keyFields.entrySet()) {
            if (sb.length() != 0) {
                sb.append(ResManager.loadKDString((String)"\u4e14", (String)"Save_0", (String)"bos-open-service", (Object[])new Object[0]));
            }
            sb.append(entry.getValue());
            Object sourceValue = sourceData.get(entry.getKey());
            if ("id".equals(entry.getKey()) && StringUtils.isNotBlank((Object)sourceData.get("_source_id_"))) {
                sb.append("=").append(sourceData.get("_source_id_"));
                continue;
            }
            if (StringUtils.isNotBlank((Object)sourceValue)) {
                if (sourceValue instanceof Map) {
                    Map sourceValueMap = (Map)sourceValue;
                    if (CollectionUtils.isEmpty((Map)sourceValueMap)) continue;
                    sb.append("=").append('{');
                    for (Map.Entry entryTmp : sourceValueMap.entrySet()) {
                        sb.append(entry.getKey()).append('.').append(entryTmp.getKey()).append('=').append(entryTmp.getValue()).append(',');
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append('}');
                    continue;
                }
                sb.append("=").append(sourceValue);
                continue;
            }
            sb.append(ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"Save_1", (String)"bos-open-service", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    private void loadData(IDataModel model, Object pkId, Supplier<OperationResult> initializer, OperationResult result, boolean forUpdateMultiLangFields) {
        ((IBillModel)model).load(pkId, () -> {
            BillEntityType dt = (BillEntityType)model.getDataEntityType();
            String billStatusKey = dt.getBillStatus();
            if (!forUpdateMultiLangFields && StringUtils.isNotBlank((CharSequence)billStatusKey) && !dt.getProperty(billStatusKey).isDbIgnore()) {
                Object status = model.getValue(billStatusKey);
                if (BillStatus.B.name().equals(status)) {
                    result.setSuccess(false);
                    result.setMessage(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"Save_6", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.B)));
                    return result;
                }
                if (BillStatus.C.name().equals(status)) {
                    String masterIdProp;
                    boolean isDefaultAudit;
                    boolean allowOverrideAudit = isDefaultAudit = BillStatus.C.name().equals(((FieldProp)dt.getProperty(billStatusKey)).getDefValue());
                    if (!isDefaultAudit && dt instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(masterIdProp = ((BasedataEntityType)dt).getMasteridPropName()))) {
                        Object masterId = model.getValue(masterIdProp);
                        if (this.isHashCtrlStrategy(dt) && pkId.equals(masterId)) {
                            allowOverrideAudit = Boolean.TRUE;
                        }
                    }
                    if (!allowOverrideAudit) {
                        result.setSuccess(false);
                        result.setMessage(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"Save_6", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.C)));
                        return result;
                    }
                }
            }
            return (OperationResult)initializer.get();
        });
    }

    private Object getStatusCaption(BillEntityType dt, String billStatusKey, BillStatus status) {
        BillStatusProp statusProp = (BillStatusProp)dt.getProperty(billStatusKey);
        for (ValueMapItem item : statusProp.getComboItems()) {
            if (!status.name().equals(item.getValue())) continue;
            return item.getName();
        }
        return status.getValue();
    }

    private boolean isHashCtrlStrategy(BillEntityType dt) {
        return dt.getProperty(CREATEORGKEY) != null && dt.getProperty("ctrlstrategy") != null;
    }

    private ApiResult buildApiResult(IDataModel model, List<SingleBillResult> convResults, Set<String> pkIds, OperationResult saveResult) {
        if (this.requestData.containsKey("data")) {
            if (saveResult != null && saveResult.isSuccess()) {
                return ApiResult.success((Object)saveResult);
            }
            ApiResult apiResult = new ApiResult();
            apiResult.setSuccess(false);
            if (saveResult != null) {
                if (!saveResult.getAllErrorOrValidateInfo().isEmpty()) {
                    apiResult.setMessage(((IOperateInfo)saveResult.getAllErrorOrValidateInfo().get(0)).getMessage());
                } else if (StringUtil.isNotEmpty((String)saveResult.getMessage())) {
                    apiResult.setMessage(saveResult.getMessage());
                }
                apiResult.setData((Object)saveResult);
            } else if (!convResults.isEmpty()) {
                String error = this.getFirstConvertMessage(convResults);
                apiResult.setMessage(error);
                apiResult.setData(SingleBillResult.toMap(convResults.get(0)));
            }
            return apiResult;
        }
        ApiResult apiResult = new ApiResult();
        ArrayList<Map<String, Object>> billResults = new ArrayList<Map<String, Object>>();
        if (saveResult == null) {
            for (SingleBillResult item : convResults) {
                billResults.add(SingleBillResult.toMap(item));
            }
            apiResult.setSuccess(false);
            String error = this.getFirstConvertMessage(convResults);
            apiResult.setMessage(this.getFirstErrorMessage(error, convResults.size()));
            apiResult.setData(billResults);
        } else {
            HashSet<String> successIds = new HashSet<String>();
            Map<Object, Object> fromDB = new HashMap();
            BillEntityType mainType = (BillEntityType)model.getDataEntityType();
            IDataEntityProperty numberProp = StringUtils.isBlank((CharSequence)mainType.getBillNo()) ? null : mainType.findProperty(mainType.getBillNo());
            MainOrgProp orgProp = mainType.getMainOrgProperty();
            if (saveResult.getSuccessPkIds() != null) {
                for (Object pk : saveResult.getSuccessPkIds()) {
                    if (pk == null) continue;
                    successIds.add(pk.toString());
                }
                fromDB = this.loadSuccessObjs(saveResult.getSuccessPkIds(), mainType, numberProp, (IDataEntityProperty)orgProp);
            }
            ArrayList<IOperateInfo> opFailInfos = new ArrayList<IOperateInfo>();
            HashMap<String, List<IOperateInfo>> billErrors = new HashMap<String, List<IOperateInfo>>();
            this.splitErrorInfoByBill(pkIds, saveResult, opFailInfos, billErrors);
            for (SingleBillResult item : convResults) {
                if (this.isIdExist(item.getId(), successIds)) {
                    item.setSuccess(true);
                    DynamicObject obj = (DynamicObject)fromDB.get(item.getId().toString());
                    if (obj != null) {
                        DynamicObject org;
                        if (numberProp != null) {
                            item.setNumber((String)numberProp.getValue((Object)obj));
                        }
                        if (orgProp != null && (org = (DynamicObject)orgProp.getValue((Object)obj)) != null) {
                            item.setOrgNumber(org.getString(NUMBER));
                        }
                    }
                } else {
                    item.setSuccess(false);
                    if (this.isIdExist(item.getId(), billErrors.keySet())) {
                        item.setData(billErrors.get(item.getId().toString()));
                    } else {
                        item.setData(opFailInfos);
                    }
                }
                billResults.add(SingleBillResult.toMap(item));
            }
            if (successIds.size() == billResults.size() || saveResult.getSuccessPkIds().size() == billResults.size()) {
                apiResult.setSuccess(true);
            } else {
                apiResult.setSuccess(false);
                ArrayList<String> errors = new ArrayList<String>();
                billErrors.forEach((key, value) -> value.forEach(error -> errors.add(error.getMessage())));
                errors.addAll(this.getConvertErrors(convResults));
                apiResult.setMessage(this.getFirstErrorMessage(!errors.isEmpty() ? (String)errors.get(0) : ApiConstant.OPERATIONFALSEMESSAGE, errors.size()));
            }
            apiResult.setData(billResults);
        }
        return apiResult;
    }

    private String getFirstConvertMessage(List<SingleBillResult> convResults) {
        ArrayList errors = new ArrayList();
        try {
            convResults.forEach(item -> {
                HashMap itemDetails = (HashMap)item.getConvertResult();
                itemDetails.forEach((key, value) -> errors.addAll((List)value));
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !errors.isEmpty() ? (String)errors.get(0) : convResults.get(0).getMessage();
    }

    private List<String> getConvertErrors(List<SingleBillResult> convResults) {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            convResults.forEach(item -> {
                Object convertResult = item.getConvertResult();
                if (convertResult != null) {
                    HashMap itemDetails = (HashMap)convertResult;
                    itemDetails.forEach((key, value) -> errors.addAll((List)value));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return errors;
    }

    private String getFirstErrorMessage(String message, Integer count) {
        if (count == 1) {
            return message;
        }
        return MessageFormat.format(ApiConstant.FIRSTMESSAGEERRORFMTTPL, message, count);
    }

    private boolean isIdExist(Object id, Set<String> successIds) {
        if (StringUtils.isBlank((Object)id)) {
            return Boolean.FALSE;
        }
        return successIds.contains(id.toString());
    }

    private void splitErrorInfoByBill(Set<String> pkIds, OperationResult saveResult, List<IOperateInfo> opFailInfos, Map<String, List<IOperateInfo>> billErrors) {
        OperateErrorInfo errInfo;
        if (saveResult.getSuccessPkIds() != null && saveResult.getSuccessPkIds().isEmpty() && StringUtils.isNotBlank((CharSequence)saveResult.getMessage())) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(saveResult.getMessage());
            opFailInfos.add((IOperateInfo)errInfo);
        }
        for (IOperateInfo info : saveResult.getAllErrorOrValidateInfo()) {
            Object pkValue = info.getPkValue();
            if (!this.isIdExist(pkValue, pkIds)) {
                opFailInfos.add(info);
                continue;
            }
            if (!this.isIdExist(pkValue, billErrors.keySet())) {
                billErrors.put(pkValue.toString(), new ArrayList());
            }
            billErrors.get(pkValue.toString()).add(info);
        }
        if (!saveResult.isSuccess() && opFailInfos.isEmpty()) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u7684\u4fdd\u5b58\u5931\u8d25\uff01", (String)"Save_3", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
            opFailInfos.add((IOperateInfo)errInfo);
        }
    }

    private Map<String, DynamicObject> loadSuccessObjs(List<Object> successIds, BillEntityType mainType, IDataEntityProperty numberProp, IDataEntityProperty orgProp) {
        ArrayList<String> selectedFields = new ArrayList<String>();
        selectedFields.add(mainType.getPrimaryKey().getName());
        if (numberProp != null) {
            selectedFields.add(numberProp.getName());
        }
        if (orgProp != null) {
            selectedFields.add(orgProp.getName());
        }
        MainEntityType subType = (MainEntityType)mainType.getSubEntityType(selectedFields);
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])successIds.toArray(), (DynamicObjectType)subType);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        if (objs != null) {
            for (DynamicObject obj : objs) {
                Object pkValue = subType.getPrimaryKey().getValueFast((Object)obj);
                map.put(pkValue.toString(), obj);
            }
        }
        return map;
    }

    public void clear() {
        this.updateLocaleCache(null);
    }

    private static class KeyParams {
        private String key;
        private Object id;
        private Object masterId;
        private String createOrgNumber;
        private String createOrgName;

        private KeyParams() {
        }
    }
}

