/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.form;

import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.Operations;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.Query;
import kd.bos.mservice.form.QueryOneTime;
import kd.bos.mservice.webapi.OperationWebApi;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.service.webapi.AICommandService;
import kd.bos.service.webapi.CustomWebApiService;
import kd.bos.service.webapi.WebApiHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class OperationWebApiImpl
implements OperationWebApi {
    private static final Log log = LogFactory.getLog(OperationWebApiImpl.class);

    public String delete(String formId, String data) {
        Operations ops = this.getSystemOpeations(formId);
        if (ops.getDelete() != null) {
            return this.executeOperationForWeb(formId, ops.getDelete(), data);
        }
        return null;
    }

    public String draft(String formId, String data) {
        return null;
    }

    public String loadSingle(String formId, String data) {
        Map requestData = this.parseJsonByType(data, Map.class);
        AbstractOperateWebApi webApi = (AbstractOperateWebApi)TypesContainer.createInstance((String)"kd.bos.entity.operate.webapi.Load");
        webApi.initialize(formId, requestData);
        ApiResult result = webApi.execute();
        return SerializationUtils.toJsonString((Object)ApiResult.toMap((ApiResult)WebApiHelper.convertStatusApiResult(result)));
    }

    public String save(String formId, String data) {
        Operations ops = this.getSystemOpeations(formId);
        if (ops.getSave() == null) {
            throw new KDException(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5bf9\u8c61\u672a\u914d\u7f6e\u4fdd\u5b58\u64cd\u4f5c", (String)"OperationWebApiImpl_0", (String)"bos-mservice-form", (Object[])new Object[0]));
        }
        return this.executeOperationForWeb(formId, ops.getSave(), data);
    }

    public String batchSave(String formId, String data) {
        Map req = this.parseJsonByType(data, Map.class);
        Operations ops = this.getSystemOpeations(formId);
        if (req.containsKey("data")) {
            req.put("datas", req.get("data"));
            req.remove("data");
        }
        Map<String, Object> ret = this.executeOperation(formId, ops.getSave(), req);
        return SerializationUtils.toJsonString(ret);
    }

    public String statusConvert(String formId, String data) {
        Operations ops = this.getSystemOpeations(formId);
        if (ops.getStatusConvert() != null) {
            return this.executeOperationForWeb(formId, ops.getStatusConvert(), data);
        }
        return null;
    }

    public String submit(String formId, String data) {
        Operations ops = this.getSystemOpeations(formId);
        if (ops.getSubmit() != null) {
            return this.executeOperationForWeb(formId, ops.getSubmit(), data);
        }
        return null;
    }

    public String unAudit(String formId, String data) {
        Operations ops = this.getSystemOpeations(formId);
        if (ops.getUnAudit() != null) {
            return this.executeOperationForWeb(formId, ops.getUnAudit(), data);
        }
        return null;
    }

    public String query(String formId, String[] fields, String filter, String[] orderby, int from, int to, String fmt) {
        String fldString = String.join((CharSequence)",", fields);
        String orderString = String.join((CharSequence)",", orderby);
        try (DataSet ds = new Query().query(formId, fldString, filter, orderString, to);){
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (Row row : ds) {
                sb.append(row.toString());
                sb.append(",");
            }
            if (sb.length() > 2) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]");
            String string = sb.toString();
            return string;
        }
    }

    public String queryOT(String formId, String selectFields, String filters, String orderBys, int pageNo, int pageSize) {
        return this.queryOT(formId, selectFields, filters, orderBys, pageNo, pageSize, true);
    }

    public String queryOT(String formId, String selectFields, String filters, String orderBys, int pageNo, int pageSize, boolean isDesensitize) {
        return QueryOneTime.query(formId, selectFields, filters, orderBys, pageNo, pageSize, isDesensitize);
    }

    private Operations getSystemOpeations(String formId) {
        String entityTypeId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
        return EntityMetadataCache.getDataEntityOperations((String)entityTypeId);
    }

    public String executeOperationForWeb(String formId, String opNumber, String data) {
        Map jsonData = this.parseJsonByType(data, Map.class);
        Map<String, Object> ret = this.executeOperation(formId, opNumber, jsonData);
        return SerializationUtils.toJsonString(ret);
    }

    public String appendEntryRows(String formId, String data) {
        Map requestData = this.parseJsonByType(data, Map.class);
        AbstractOperateWebApi webApi = (AbstractOperateWebApi)TypesContainer.createInstance((String)"kd.bos.entity.operate.webapi.AppendEntryRows");
        webApi.initialize(formId, requestData);
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        String appid = formConfig != null ? formConfig.getAppId() : "";
        this.setOperationContext(appid, formId, "appendEntryRows");
        ApiResult result = webApi.execute();
        return SerializationUtils.toJsonString((Object)ApiResult.toMap((ApiResult)WebApiHelper.convertStatusApiResult(result)));
    }

    public String deleteEntryRows(String formId, String data) {
        Map requestData = this.parseJsonByType(data, Map.class);
        AbstractOperateWebApi webApi = (AbstractOperateWebApi)TypesContainer.createInstance((String)"kd.bos.entity.operate.webapi.DeleteEntryRows");
        webApi.initialize(formId, requestData);
        ApiResult result = webApi.execute();
        return SerializationUtils.toJsonString((Object)ApiResult.toMap((ApiResult)WebApiHelper.convertStatusApiResult(result)));
    }

    public Map<String, Object> executeOperation(String formId, String opNumber, Map<String, Object> data) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        String entityTypeId = formConfig.getEntityTypeId();
        AbstractOperateWebApi webApi = FormMetadataCache.getFormOperationApi((String)entityTypeId, (String)opNumber);
        webApi.initialize(formId, data);
        this.setOperationContext(formConfig.getAppId(), formId, opNumber);
        ApiResult result = webApi.execute();
        Map objectMap = ApiResult.toMap((ApiResult)WebApiHelper.convertStatusApiResult(result));
        return objectMap;
    }

    public String callCustomService(String appId, String serviceName, String args) {
        this.setOperationContext(appId, null, serviceName);
        CustomWebApiService svc = new CustomWebApiService();
        return svc.call(appId, serviceName, args);
    }

    public String executeAICommand(String cmd) {
        AICommand command = this.buildAICommand(cmd);
        AICommandService svc = new AICommandService();
        ApiResult ret = svc.doCommand(command);
        return SerializationUtils.toJsonString((Object)ret);
    }

    private AICommand buildAICommand(String cmd) {
        Map params = this.parseJsonByType(cmd, Map.class);
        AICommand ai = new AICommand();
        ai.setOpenId(RequestContext.get().getUserOpenId());
        ai.setTaskId((String)params.get("taskid"));
        ai.setAppId((String)params.get("appid"));
        ai.setCommand((String)params.get("command"));
        ai.setToken((String)params.get("token"));
        ai.setParameter((Map)params.get("parameter"));
        return ai;
    }

    private void setOperationContext(String appId, String formId, String method) {
        OperationContext oc = new OperationContext();
        oc.setAppId(appId);
        oc.setFormId(formId);
        oc.setOpMethod(method);
        OperationContext.set((OperationContext)oc);
    }

    public String audit(String formId, String data) {
        Operations ops = this.getSystemOpeations(formId);
        if (ops.getAudit() != null) {
            return this.executeOperationForWeb(formId, ops.getAudit(), data);
        }
        return null;
    }

    private <T> T parseJsonByType(String data, Class<T> type) {
        try {
            if (data == null) {
                data = "";
            }
            return (T)SerializationUtils.fromJsonString((String)data, type);
        }
        catch (Exception ex) {
            int maxLength = 10000;
            String strMessage = "OperationWebApi-JSON data is invalid, error:" + ex.getMessage() + ",jsonData:" + (data.length() > maxLength ? data.substring(0, maxLength) : data);
            log.error(strMessage, (Throwable)ex);
            throw new OpenApiException((Throwable)ex, ApiErrorCode.HTTP_BAD_REQUEST, strMessage, new Object[0]);
        }
    }
}

