/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.handle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.openapi.base.util.DynamicPropertyUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.handle.PropertyHandle;
import kd.bos.openapi.handle.PropertyHandleFactory;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PropertyHandleUtil {
    public static List<Map<String, Object>> toMapListRoot(String entityName, String fullParentPropName, DynamicObject[] sources, Map<String, Set<String>> prefixMap) {
        if (sources == null || sources.length == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(sources.length);
        for (DynamicObject source : sources) {
            Map<String, Object> map = PropertyHandleUtil.toMap(source.getPkValue(), entityName, fullParentPropName, source, prefixMap);
            if (CollectionUtil.isEmpty(map)) continue;
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> toMapList(Object id, String entityName, String fullParentPropName, DynamicObjectCollection sources, Map<String, Set<String>> prefixMap) {
        if (sources == null || sources.size() == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(sources.size());
        for (DynamicObject source : sources) {
            Map<String, Object> map = PropertyHandleUtil.toMap(id, entityName, fullParentPropName, source, prefixMap);
            if (CollectionUtil.isEmpty(map)) continue;
            list.add(map);
        }
        return list;
    }

    public static Map<String, Object> toMap(Object id, String entityName, String fullParentPropName, DynamicObject source, Map<String, Set<String>> prefixMap) {
        if (source == null) {
            return null;
        }
        Set<String> set = prefixMap.get(fullParentPropName);
        if (set == null) {
            set = new HashSet<String>(1);
        }
        set.add("id");
        IDataEntityType dataEntityType = source.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(set.size());
        for (String s : set) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)s);
            if (property == null || DynamicPropertyUtil.notIncludeProperty((IDataEntityProperty)property)) continue;
            PropertyHandle propertyHandle = PropertyHandleFactory.createHandle(id, entityName, fullParentPropName, property, prefixMap);
            propertyHandle.copyValue(source, map);
        }
        return map;
    }
}

