/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.handle.prop;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.handle.AbstractPropertyHandle;
import kd.bos.openapi.service.query.QueryApiUtil;

public class ItemClassPropHandle
extends AbstractPropertyHandle<ItemClassProp> {
    public ItemClassPropHandle(ItemClassProp prop) {
        super(prop);
    }

    @Override
    public void copyValue(DynamicObject source, Map<String, Object> target) {
        super.copyValue(source, target);
        Object src = source.get(this.propName);
        if (src instanceof DynamicObject) {
            target.put(this.propName, this.toMap((DynamicObject)src));
        } else {
            target.put(this.propName, src);
        }
    }

    @Override
    public void copyValue(List<DynamicObject> sourceList, DynamicObject target) {
        super.checkNull(sourceList, target);
        String currFullPropName = this.getCurrFullPropName();
        List<DynamicObject> srcList = this.distinctByProp(sourceList, it -> DataUtil.l((Object)it.get(currFullPropName)) > 0L, it -> it.getString(currFullPropName));
        if (CollectionUtil.isEmpty(srcList)) {
            return;
        }
        String parentFullPropName = this.getParentFullPropName();
        String typePropName = (StringUtil.isEmpty((String)parentFullPropName) ? "" : parentFullPropName + ".") + ((ItemClassProp)this.prop).getTypePropName();
        if (!this.select.contains(typePropName)) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u67e5\u8be2\u591a\u9009\u57fa\u7840\u8d44\u6599 %1$s \uff0c\u9700\u8981\u5728\u8fd4\u56de\u53c2\u6570\u4e2d\u9009\u62e9\u7c7b\u522b %2$s\u3002", (String)"ItemClassPropHandle_0", (String)"bos-open-service", (Object[])new Object[0]), new Object[]{currFullPropName, typePropName});
        }
        String type = srcList.get(0).getString(typePropName);
        if (StringUtil.isEmpty((String)type)) {
            target.set(this.prop, null);
            return;
        }
        DynamicObject value = QueryApiUtil.queryObjToLoadObj(srcList, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)type), (Set<String>)this.select, currFullPropName);
        target.set(this.prop, (Object)value);
    }
}

