/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.custom;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.custom.cache.CustomApiCacheUtil;
import kd.bos.openapi.base.custom.info.CustomApiErrorCode;
import kd.bos.openapi.base.custom.info.CustomApiHeader;
import kd.bos.openapi.base.custom.info.CustomApiInfo;
import kd.bos.openapi.base.custom.info.CustomApiParam;
import kd.bos.openapi.common.constant.HttpMethod;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiHeader;
import kd.bos.openapi.common.custom.annotation.ApiHeaders;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiModel;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.resource.AnnotationMulLangUtil;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.common.util.StringUtil;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.DefaultParameterNameDiscoverer;

public class CustomApiParseUtil {
    private static final Log LOG = LogFactory.getLog(CustomApiParseUtil.class);
    private static final String BOS_OPEN_SERVICE = "bos-open-service";

    public static Set<String> getMethodNames(String className) {
        CustomApiParseUtil.checkClass(className);
        Class<?> clazz = CustomApiParseUtil.forNameClass(className);
        Set<Method> methodSet = CustomApiParseUtil.getAllMethods(clazz);
        return methodSet.stream().map(Method::getName).collect(Collectors.toSet());
    }

    public static void check(String className, String methodName) {
        CustomApiParseUtil.checkClass(className);
        CustomApiParseUtil.checkMethod(methodName);
    }

    private static void checkMethod(String methodName) {
        if (StringUtil.isEmpty((String)methodName)) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomApiParseUtil_0", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[0]);
        }
    }

    private static void checkClass(String className) {
        if (StringUtil.isEmpty((String)className)) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomApiParseUtil_1", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[0]);
        }
    }

    public static CustomApiInfo getCustomApiInfo(String className, String methodName) {
        return CustomApiParseUtil.getCustomApiInfo(className, methodName, null);
    }

    private static CustomApiInfo getCustomApiInfo(String className, String methodName, Boolean isRequest) {
        CustomApiParseUtil.check(className, methodName);
        Class<?> clazz = CustomApiParseUtil.forNameClass(className);
        Method method = CustomApiParseUtil.getMethod(clazz, methodName);
        CustomApiInfo apiInfo = CustomApiParseUtil.getCustomApiInfo(clazz, method);
        if (isRequest == null) {
            List<CustomApiParam> request = CustomApiParseUtil.getParams(clazz, method, apiInfo.getHttpMethod(), true);
            apiInfo.setRequest(request);
            List<CustomApiParam> response = CustomApiParseUtil.getParams(clazz, method, apiInfo.getHttpMethod(), false);
            apiInfo.setResponse(response);
        } else {
            List<CustomApiParam> params = CustomApiParseUtil.getParams(clazz, method, apiInfo.getHttpMethod(), (boolean)isRequest);
            if (isRequest.booleanValue()) {
                apiInfo.setRequest(params);
            } else {
                apiInfo.setResponse(params);
            }
        }
        return apiInfo;
    }

    public static List<CustomApiParam> getRequest(String className, String methodName) {
        return CustomApiParseUtil.getCustomApiInfo(className, methodName, Boolean.TRUE).getRequest();
    }

    public static List<CustomApiParam> getResponse(String className, String methodName) {
        return CustomApiParseUtil.getCustomApiInfo(className, methodName, Boolean.FALSE).getResponse();
    }

    private static CustomApiInfo getCustomApiInfo(Class<?> clazz, Method method) {
        CustomApiInfo apiInfo = new CustomApiInfo();
        ApiMapping apiMapping = clazz.getAnnotation(ApiMapping.class);
        if (apiMapping != null) {
            apiInfo.setUrl(apiMapping.value());
        }
        ApiGetMapping apiGetMapping = method.getAnnotation(ApiGetMapping.class);
        ApiPostMapping apiPostMapping = method.getAnnotation(ApiPostMapping.class);
        CustomApiParseUtil.checkMethodMapping(clazz, method, apiGetMapping, apiPostMapping);
        if (apiGetMapping != null) {
            if (StringUtil.isEmpty((String)apiGetMapping.value())) {
                throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u65b9\u6cd5 %1$s \u7684\u6ce8\u89e3 %2$s \u5c5e\u6027 value \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomApiParseUtil_3", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{clazz.getName() + "." + method.getName(), ApiGetMapping.class.getName()});
            }
            apiInfo.setHttpMethod(HttpMethod.GET);
            apiInfo.setUrl(apiGetMapping.value());
            apiInfo.setName(apiGetMapping.desc());
        } else {
            if (StringUtil.isEmpty((String)apiPostMapping.value())) {
                throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u65b9\u6cd5 %1$s \u7684\u6ce8\u89e3 %2$s \u5c5e\u6027 value \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomApiParseUtil_3", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{clazz.getName() + "." + method.getName(), ApiPostMapping.class.getName()});
            }
            apiInfo.setHttpMethod(HttpMethod.POST);
            apiInfo.setUrl(apiPostMapping.value());
            apiInfo.setName(apiPostMapping.desc());
        }
        CustomApiParseUtil.parseHeader(apiInfo, clazz.getAnnotation(ApiHeaders.class));
        CustomApiParseUtil.parseHeader(apiInfo, method.getAnnotation(ApiHeaders.class));
        CustomApiParseUtil.parseErrorCode(apiInfo, clazz.getAnnotation(ApiErrorCodes.class));
        CustomApiParseUtil.parseErrorCode(apiInfo, method.getAnnotation(ApiErrorCodes.class));
        return apiInfo;
    }

    private static void checkMethodMapping(Class<?> clazz, Method method, ApiGetMapping apiGetMapping, ApiPostMapping apiPostMapping) {
        if (apiGetMapping != null && apiPostMapping != null) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u65b9\u6cd5 %1$s \u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6ce8\u89e3 %2$s \u548c %3$s\u3002", (String)"CustomApiParseUtil_2", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{clazz.getName() + "." + method.getName(), ApiGetMapping.class.getName(), ApiPostMapping.class.getName()});
        }
    }

    private static void parseErrorCode(CustomApiInfo apiInfo, ApiErrorCodes errorCodes) {
        ApiErrorCode[] apiErrorCodes;
        if (errorCodes != null && (apiErrorCodes = errorCodes.value()) != null) {
            for (ApiErrorCode apiErrorCode : apiErrorCodes) {
                if (StringUtil.isEmpty((String)apiErrorCode.code())) continue;
                apiInfo.addErrorCodes(new CustomApiErrorCode(apiErrorCode.code(), apiErrorCode.desc()));
            }
        }
    }

    private static void parseHeader(CustomApiInfo apiInfo, ApiHeaders headers) {
        ApiHeader[] apiHeaders;
        if (headers != null && (apiHeaders = headers.value()) != null) {
            for (ApiHeader apiHeader : apiHeaders) {
                if (StringUtil.isEmpty((String)apiHeader.name())) continue;
                apiInfo.addHeader(new CustomApiHeader(apiHeader.name(), apiHeader.desc(), apiHeader.example()));
            }
        }
    }

    public static List<CustomApiParam> getParams(String className, String methodName, HttpMethod httpMethod, boolean isRequest) {
        CustomApiParseUtil.check(className, methodName);
        Class<?> clazz = CustomApiParseUtil.forNameClass(className);
        Method method = CustomApiParseUtil.getMethod(clazz, methodName);
        return CustomApiParseUtil.getParams(clazz, method, httpMethod, isRequest);
    }

    private static List<CustomApiParam> getParams(Class<?> clazz, Method method, HttpMethod httpMethod, boolean isRequest) {
        ArrayList<CustomApiParam> paramResult;
        if (isRequest) {
            Parameter[] parameters = method.getParameters();
            List<String> varNameList = CustomApiParseUtil.getVarNameList(clazz, method);
            if (parameters.length == 0) {
                return Collections.emptyList();
            }
            paramResult = new ArrayList(parameters.length);
            if (HttpMethod.GET == httpMethod) {
                for (int i = 0; i < parameters.length; ++i) {
                    String varName = varNameList.get(i);
                    Parameter parameter = parameters[i];
                    CustomApiParseUtil.checkParameter(varName, parameter, HttpMethod.GET, false);
                    Type type = parameter.getParameterizedType();
                    CustomApiParseUtil.checkGenericType(varName, type);
                    String errorMsg = String.format(ResManager.loadKDString((String)"%1$s \u8bf7\u6c42\u65b9\u5f0f\u7684\u8bf7\u6c42\u53c2\u6570\u53ea\u652f\u6301\u57fa\u672c\u7c7b\u578b\uff0c\u4e0d\u652f\u6301\u53c2\u6570 %2$s \u7684\u7c7b\u578b %3$s\u3002", (String)"CustomApiParseUtil_5", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), httpMethod, varName, type.getTypeName());
                    CustomApiParseUtil.checkGetBasicType(type, errorMsg);
                    CustomApiParam apiParam = CustomApiParseUtil.getCustomApiParam(parameter, varName, 1, type);
                    if (apiParam == null) continue;
                    paramResult.add(apiParam);
                }
            } else {
                boolean isRequestBody = CustomApiParseUtil.isRequestBody(parameters, varNameList);
                if (isRequestBody) {
                    String varName = varNameList.get(0);
                    Parameter parameter = parameters[0];
                    CustomApiParseUtil.checkParameter(varName, parameter, HttpMethod.POST, true);
                    Type type = parameter.getParameterizedType();
                    CustomApiParam param = CustomApiParseUtil.getPostParam(null, varName, 0, type, 0);
                    paramResult.addAll(param != null ? param.getChildList() : Collections.emptyList());
                } else {
                    for (int i = 0; i < parameters.length; ++i) {
                        String varName = varNameList.get(i);
                        Parameter parameter = parameters[i];
                        CustomApiParseUtil.checkParameter(varName, parameter, HttpMethod.POST, false);
                        Type type = parameter.getParameterizedType();
                        CustomApiParam param = CustomApiParseUtil.getPostParam(parameter.getAnnotation(ApiParam.class), varName, 1, type, 0);
                        paramResult.add(param);
                    }
                }
            }
        } else {
            Set<Field> fields = CustomApiParseUtil.getFields(CustomApiResult.class);
            paramResult = new ArrayList<CustomApiParam>(fields.size());
            for (Field field : fields) {
                Type genericType = field.getGenericType();
                if (genericType instanceof TypeVariable) continue;
                CustomApiParam param = CustomApiParseUtil.getPostParam(field.getAnnotation(ApiParam.class), field.getName(), 1, genericType, 0);
                paramResult.add(param);
            }
            Type returnType = method.getGenericReturnType();
            Type type = CustomApiParseUtil.getReturnType(returnType);
            CustomApiParam param = CustomApiParseUtil.getPostParam(null, "data", 1, type, 0);
            if (param != null) {
                ApiResponseBody apiResponseBody = CustomApiParseUtil.getCustomApiResultReturnAnnotated(method);
                if (apiResponseBody != null) {
                    if (StringUtil.isNotEmpty((String)apiResponseBody.value())) {
                        param.setDesc(apiResponseBody.value());
                    }
                    if (StringUtil.isNotEmpty((String)apiResponseBody.example())) {
                        LocaleString exampleML = AnnotationMulLangUtil.getLocaleString((String)apiResponseBody.example());
                        CustomApiParseUtil.setExample(type, param, exampleML);
                    }
                }
                paramResult.add(param);
            }
        }
        paramResult.sort(CustomApiParam.getComparator());
        return paramResult;
    }

    private static void setExample(Type type, CustomApiParam param, LocaleString exampleML) {
        Pair<Boolean, Object> example = CustomApiParseUtil.getExample(exampleML.getLocaleValue(), type);
        if (((Boolean)example.getKey()).booleanValue()) {
            exampleML.setLocaleValue(JacksonUtil.writeValueAsString((Object)example.getValue()));
        }
        param.setExampleML((ILocaleString)exampleML);
        param.setExample(example.getValue());
    }

    private static ApiResponseBody getCustomApiResultReturnAnnotated(Method method) {
        try {
            AnnotatedParameterizedType annotatedParameterizedType;
            Object[] actualTypeArguments;
            AnnotatedType annotatedReturnType = method.getAnnotatedReturnType();
            if (annotatedReturnType instanceof AnnotatedParameterizedType && !CollectionUtil.isEmpty((Object[])(actualTypeArguments = (annotatedParameterizedType = (AnnotatedParameterizedType)annotatedReturnType).getAnnotatedActualTypeArguments()))) {
                Object actualTypeArgument = actualTypeArguments[0];
                if (actualTypeArgument instanceof AnnotatedArrayType) {
                    return ((AnnotatedArrayType)actualTypeArgument).getAnnotatedGenericComponentType().getAnnotation(ApiResponseBody.class);
                }
                return actualTypeArguments[0].getAnnotation(ApiResponseBody.class);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        return null;
    }

    private static Type getReturnType(Type returnType) {
        Class cls;
        Class cls2;
        ParameterizedType parameterizedType;
        if (returnType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)returnType).getRawType() instanceof Class && CustomApiResult.class.isAssignableFrom(cls2 = (Class)parameterizedType.getRawType())) {
            Object[] typeArguments = parameterizedType.getActualTypeArguments();
            if (CollectionUtil.isEmpty((Object[])typeArguments)) {
                throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8fd4\u56de\u503c %s \u672a\u8bbe\u7f6e\u6cdb\u578b\u3002", (String)"CustomApiParseUtil_6", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{CustomApiResult.class.getSimpleName()});
            }
            if (typeArguments.length != 1) {
                throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8fd4\u56de\u503c %s \u8bbe\u7f6e\u6cdb\u578b\u9519\u8bef\u3002", (String)"CustomApiParseUtil_7", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{CustomApiResult.class.getSimpleName()});
            }
            return typeArguments[0];
        }
        if (returnType instanceof Class && CustomApiResult.class.isAssignableFrom(cls = (Class)returnType)) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8fd4\u56de\u503c %s \u672a\u8bbe\u7f6e\u6cdb\u578b\u3002", (String)"CustomApiParseUtil_6", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{CustomApiResult.class.getSimpleName()});
        }
        throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8fd4\u56de\u503c\u7c7b\u578b\u4e0d\u662f %s\u3002", (String)"CustomApiParseUtil_8", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{CustomApiResult.class.getSimpleName()});
    }

    public static boolean isRequestBody(Parameter[] parameters, List<String> varNameList) {
        if (parameters == null || parameters.length != 1 || varNameList == null || varNameList.size() != 1) {
            return false;
        }
        Parameter parameter = parameters[0];
        CustomApiParseUtil.checkParameterAnno(parameter, varNameList.get(0));
        boolean has = parameter.isAnnotationPresent(ApiRequestBody.class);
        if (has) {
            return CustomApiParseUtil.isApiModelClass(parameter);
        }
        return false;
    }

    private static boolean isApiModelClass(Parameter parameter) {
        Type rawType;
        Type type = parameter.getParameterizedType();
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class && ((Class)rawType).isAssignableFrom(Map.class)) {
            return true;
        }
        if (!(type instanceof Class)) {
            return false;
        }
        if (CustomApiParseUtil.isBasicType(type) || CustomApiParseUtil.isPostBasicArray(type)) {
            return false;
        }
        Class cls = (Class)type;
        if (cls.isAnnotationPresent(ApiModel.class)) {
            return true;
        }
        return Object.class != cls && cls.isAssignableFrom(Map.class);
    }

    private static void checkParameter(String varName, Parameter parameter, HttpMethod httpMethod, boolean isRequestBody) {
        CustomApiParseUtil.checkParameterAnno(parameter, varName);
        if (httpMethod == HttpMethod.GET) {
            if (parameter.isAnnotationPresent(ApiRequestBody.class)) {
                throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"GET \u8bf7\u6c42\u5165\u53c2\u4e0d\u652f\u6301\u6ce8\u89e3 {0}", (String)"CustomApiParseUtil_19", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{ApiRequestBody.class.getSimpleName()});
            }
        } else if (isRequestBody && parameter.isAnnotationPresent(ApiRequestBody.class)) {
            if (!CustomApiParseUtil.isApiModelClass(parameter)) {
                throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u5165\u53c2 {0} \u4e0d\u652f\u6301\u6ce8\u89e3 {1}", (String)"CustomApiParseUtil_25", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{varName, ApiRequestBody.class.getSimpleName()});
            }
            return;
        }
        if (!parameter.isAnnotationPresent(ApiParam.class)) {
            if (parameter.isAnnotationPresent(ApiRequestBody.class)) {
                throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u5165\u53c2 {0} \u4e0d\u652f\u6301\u6ce8\u89e3 {1}\uff0c \u8bf7\u6539\u4e3a {2}", (String)"CustomApiParseUtil_26", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{varName, ApiRequestBody.class.getSimpleName(), ApiParam.class.getSimpleName()});
            }
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u5165\u53c2 %1$s \u672a\u8bbe\u7f6e\u6ce8\u89e3 %2$s\u3002", (String)"CustomApiParseUtil_9", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{varName, ApiParam.class.getSimpleName()});
        }
    }

    private static void checkParameterAnno(Parameter parameter, String varName) {
        if (parameter.isAnnotationPresent(ApiRequestBody.class) && parameter.isAnnotationPresent(ApiParam.class)) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u5165\u53c2{0}\u4e0d\u80fd\u540c\u65f6\u6709\u6ce8\u89e3 {1} \u548c {2}", (String)"CustomApiParseUtil_20", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{varName, ApiRequestBody.class.getSimpleName(), ApiParam.class.getSimpleName()});
        }
    }

    private static CustomApiParam getPostParam(ApiParam element, String varName, int level, Type type, int arrLevel) {
        if (type instanceof ParameterizedType) {
            CustomApiParam param;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (CustomApiParseUtil.isCollection(parameterizedType)) {
                if (CustomApiParseUtil.isPostBasicCollection(parameterizedType)) {
                    return CustomApiParseUtil.getCustomApiParam(element, varName, level, type);
                }
                if (typeArguments.length > 1) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u53c2\u6570 %1$s \u7684\u7c7b\u578b %2$s\u3002", (String)"CustomApiParseUtil_10", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), varName, type.getTypeName());
                    throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, errorMsg, new Object[0]);
                }
                if (typeArguments.length == 0) {
                    return CustomApiParseUtil.getCustomApiParam(element, varName, level, type);
                }
                Type typeArgument = typeArguments[0];
                if (typeArgument instanceof WildcardType) {
                    return CustomApiParseUtil.getCustomApiParam(element, varName, level, type);
                }
                if (typeArgument instanceof Class) {
                    Class cls = (Class)typeArgument;
                    if (CustomApiParseUtil.isArray(typeArgument)) {
                        CustomApiParam param2 = CustomApiParseUtil.getCustomApiParamByClass(element, varName, level, cls, ++arrLevel);
                        return CustomApiParseUtil.getCustomApiParamByType(param2, type);
                    }
                    CustomApiParam param3 = CustomApiParseUtil.getCustomApiParam(element, varName, level, type);
                    CustomApiParseUtil.parseModelParam(param3, (Class)typeArgument, level + 1);
                    if (param3 != null) {
                        param3.setArrayLevel(++arrLevel);
                    }
                    return param3;
                }
                if (typeArgument instanceof ParameterizedType) {
                    CustomApiParam param4 = CustomApiParseUtil.getPostParam(element, varName, level, typeArgument, ++arrLevel);
                    return CustomApiParseUtil.getCustomApiParamByType(param4, type);
                }
                if (typeArgument instanceof GenericArrayType) {
                    CustomApiParam param5 = CustomApiParseUtil.getPostParam(element, varName, level, typeArgument, ++arrLevel);
                    return CustomApiParseUtil.getCustomApiParamByType(param5, type);
                }
            }
            if (CustomApiParseUtil.isMapOrMapArray(parameterizedType)) {
                param = CustomApiParseUtil.getCustomApiParamByMap(element, varName, level, type, typeArguments);
                if (param != null) {
                    param.setArrayLevel(arrLevel);
                }
                return param;
            }
            if (Class.class.equals((Object)parameterizedType.getRawType())) {
                param = CustomApiParseUtil.getCustomApiParam(element, varName, level, parameterizedType.getRawType());
                return CustomApiParseUtil.getCustomApiParamByType(param, type);
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            if (CustomApiParseUtil.isPostBasicArray(genericArrayType)) {
                return CustomApiParseUtil.getCustomApiParam(element, varName, level, (Type)genericArrayType);
            }
            if (CustomApiParseUtil.isMapOrMapArray(genericArrayType)) {
                CustomApiParam param = CustomApiParseUtil.getPostParam(element, varName, level, genericArrayType.getGenericComponentType(), ++arrLevel);
                return CustomApiParseUtil.getCustomApiParamByType(param, genericArrayType);
            }
            if (CustomApiParseUtil.isArray(genericArrayType)) {
                CustomApiParam param = CustomApiParseUtil.getPostParam(element, varName, level, genericArrayType.getGenericComponentType(), ++arrLevel);
                return CustomApiParseUtil.getCustomApiParamByType(param, genericArrayType);
            }
        } else {
            if (type instanceof Class) {
                return CustomApiParseUtil.getCustomApiParamByClass(element, varName, level, (Class)type, arrLevel);
            }
            if (type instanceof WildcardType) {
                return CustomApiParseUtil.getCustomApiParam(element, varName, level, type);
            }
            if (type instanceof TypeVariable) {
                throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6cdb\u578b\u53c2\u6570 %1$s \u7c7b\u578b %2$s\u3002", (String)"CustomApiParseUtil_11", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{varName, type.getTypeName()});
            }
        }
        throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u53c2\u6570 %1$s \u7684\u7c7b\u578b %2$s\u3002", (String)"CustomApiParseUtil_10", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{varName, type.getTypeName()});
    }

    private static CustomApiParam getCustomApiParamByType(CustomApiParam param, Type type) {
        param.setParamType(CustomApiParseUtil.getTypeName(type));
        param.setMulValue(CustomApiParseUtil.isMulValueType(type));
        param.setArray(CustomApiParseUtil.isArray(type));
        Object example = param.getExample();
        if (CustomApiParseUtil.isExampleEmpty(example)) {
            return param;
        }
        if (CustomApiParseUtil.isPostBasicArray(type)) {
            param.setExample(Collections.singletonList(example));
        }
        return param;
    }

    private static String getTypeName(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls.getSimpleName();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return CustomApiParseUtil.getTypeName(genericArrayType.getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                Class cls = (Class)rawType;
                Type[] arguments = parameterizedType.getActualTypeArguments();
                if (CustomApiParseUtil.isMap(cls)) {
                    return cls.getSimpleName() + "<" + CustomApiParseUtil.getTypeName(arguments[0]) + ", " + CustomApiParseUtil.getTypeName(arguments[1]) + ">";
                }
                if (CustomApiParseUtil.isCollection(type)) {
                    return cls.getSimpleName() + "<" + CustomApiParseUtil.getTypeName(arguments[0]) + ">";
                }
            }
            return CustomApiParseUtil.getTypeName(rawType);
        }
        return type.getTypeName();
    }

    private static CustomApiParam getCustomApiParamByClass(ApiParam element, String varName, int level, Class<?> cls, int arrLevel) {
        CustomApiParam param;
        if (Map.class.isAssignableFrom(cls)) {
            CustomApiParam param2;
            Type superType = cls.getGenericSuperclass();
            if ((superType == null || superType instanceof Class) && (param2 = CustomApiParseUtil.getCustomApiParam(element, varName, level, cls)) != null) {
                param2.addChild(CustomApiParseUtil.getCustomApiParam("$key$", level + 1, Object.class));
                param2.addChild(CustomApiParseUtil.getCustomApiParam("$value$", level + 1, Object.class));
                param2.setMap(true);
                return param2;
            }
            param2 = CustomApiParseUtil.getPostParam(element, varName, level, superType, arrLevel);
            return CustomApiParseUtil.getCustomApiParamByType(param2, cls);
        }
        if (Collection.class.isAssignableFrom(cls)) {
            CustomApiParam param3;
            Type superType = cls.getGenericSuperclass();
            if (superType == null || superType instanceof Class) {
                return CustomApiParseUtil.getCustomApiParam(element, varName, level, cls);
            }
            if ((param3 = CustomApiParseUtil.getPostParam(element, varName, level, superType, ++arrLevel)) != null) {
                param3.setArrayLevel(arrLevel);
                return CustomApiParseUtil.getCustomApiParamByType(param3, cls);
            }
        }
        if (Void.class.equals(cls) || Void.TYPE.equals(cls)) {
            return CustomApiParseUtil.getCustomApiParam(element, varName, level, cls);
        }
        if (CustomApiParseUtil.isBasicType(cls) || CustomApiParseUtil.isGetBasicArray(cls)) {
            return CustomApiParseUtil.getCustomApiParam(element, varName, level, cls);
        }
        if (CustomApiParseUtil.isArray(cls)) {
            if (CustomApiParseUtil.isMapOrMapArray(cls)) {
                param = CustomApiParseUtil.getCustomApiParamByClass(element, varName, level, cls.getComponentType(), ++arrLevel);
                return CustomApiParseUtil.getCustomApiParamByType(param, cls);
            }
            param = CustomApiParseUtil.getPostParam(element, varName, level, cls.getComponentType(), ++arrLevel);
            return CustomApiParseUtil.getCustomApiParamByType(param, cls);
        }
        param = CustomApiParseUtil.getCustomApiParam(element, varName, level, cls);
        CustomApiParseUtil.parseModelParam(param, cls, level + 1);
        if (param != null) {
            param.setArrayLevel(arrLevel);
            return param;
        }
        return null;
    }

    private static CustomApiParam getCustomApiParamByMap(ApiParam element, String varName, int level, Type type, Type[] typeArguments) {
        Type valueType;
        CustomApiParam value;
        CustomApiParam param = CustomApiParseUtil.getCustomApiParam(element, varName, level, type);
        if (param == null) {
            return null;
        }
        if (typeArguments.length != 2) {
            return param;
        }
        Type keyType = typeArguments[0];
        CustomApiParam key = CustomApiParseUtil.getPostParam(element, "$key$", level + 1, keyType, 0);
        if (key != null) {
            key.setDesc(CustomApiParseUtil.getDesc("$key$", keyType));
            param.addChild(key);
        }
        if ((value = CustomApiParseUtil.getPostParam(element, "$value$", level + 1, valueType = typeArguments[1], 0)) != null) {
            value.setDesc(CustomApiParseUtil.getDesc("$value$", valueType));
            param.addChild(value);
        }
        param.setMap(true);
        return param;
    }

    private static void parseModelParam(CustomApiParam parent, Class<?> cls, int level) {
        if (Map.class.isAssignableFrom(cls)) {
            parent.addChild(CustomApiParseUtil.getCustomApiParam("$key$", level, Object.class));
            parent.addChild(CustomApiParseUtil.getCustomApiParam("$value$", level, Object.class));
            parent.setMap(true);
            return;
        }
        ApiModel annotation = cls.getAnnotation(ApiModel.class);
        if (annotation == null) {
            return;
        }
        Set<Field> fields = CustomApiParseUtil.getFields(cls);
        for (Field field : fields) {
            CustomApiParam childParam = CustomApiParseUtil.getPostParam(field.getAnnotation(ApiParam.class), field.getName(), level, field.getGenericType(), 0);
            parent.addChild(childParam);
        }
    }

    public static Set<Field> getFields(Class<?> cls) {
        if (!cls.isAnnotationPresent(ApiModel.class)) {
            return Collections.emptySet();
        }
        Field[] fields = cls.getDeclaredFields();
        LinkedHashSet<Field> set = new LinkedHashSet<Field>(fields.length);
        for (Field field : fields) {
            if ("serialVersionUID".equals(field.getName()) || !field.isAnnotationPresent(ApiParam.class)) continue;
            set.add(field);
        }
        Set<Field> superFields = CustomApiParseUtil.getFields(cls.getSuperclass());
        for (Field field : superFields) {
            if ("serialVersionUID".equals(field.getName()) || !field.isAnnotationPresent(ApiParam.class)) continue;
            set.add(field);
        }
        return set;
    }

    private static CustomApiParam getCustomApiParam(AnnotatedElement element, String varName, int level, Type type) {
        ApiParam annotation = element.getAnnotation(ApiParam.class);
        if (level != 1 && annotation == null) {
            return null;
        }
        return CustomApiParseUtil.getCustomApiParam(annotation, varName, level, type);
    }

    private static CustomApiParam getCustomApiParam(ApiParam annotation, String varName, int level, Type type) {
        CustomApiParam apiParam = CustomApiParseUtil.getCustomApiParam(varName, level, type);
        if (annotation != null) {
            apiParam.setRequired(annotation.required());
            apiParam.setDesc(annotation.value());
            apiParam.setPosition(annotation.position());
            if (apiParam.getLevel() == 1) {
                apiParam.setPathVariable(annotation.isPathVariable());
            }
            if (!apiParam.getParamName().equals("$key$") && !apiParam.getParamName().equals("$value$")) {
                LocaleString exampleML = AnnotationMulLangUtil.getLocaleString((String)annotation.example());
                CustomApiParseUtil.setExample(type, apiParam, exampleML);
            }
        }
        if (StringUtil.isEmpty((String)apiParam.getDesc())) {
            apiParam.setDesc(CustomApiParseUtil.getDesc(varName, type));
        }
        return apiParam;
    }

    private static CustomApiParam getCustomApiParam(String varName, int level, Type type) {
        CustomApiParam apiParam = new CustomApiParam();
        apiParam.setParamName(varName);
        apiParam.setLevel(level);
        apiParam.setDesc(CustomApiParseUtil.getDesc(varName, type));
        apiParam.setParamType(CustomApiParseUtil.getTypeName(type));
        Object example = CustomApiParseUtil.getExample(type);
        apiParam.setExampleML((ILocaleString)AnnotationMulLangUtil.getLocaleString((String)JacksonUtil.writeValueAsString((Object)example)));
        apiParam.setExample(example);
        apiParam.setMulValue(CustomApiParseUtil.isMulValueType(type));
        apiParam.setArray(CustomApiParseUtil.isArray(type));
        return apiParam;
    }

    private static boolean isMulValueType(Type type) {
        return CustomApiParseUtil.isArray(type) || CustomApiParseUtil.isCollection(type);
    }

    private static Pair<Boolean, Object> getExample(String example, Type type) {
        if (StringUtil.isEmpty((String)example)) {
            return new Pair((Object)true, CustomApiParseUtil.getExample(type));
        }
        try {
            Object exampleObj = JSON.parseObject((String)example, (Type)type, (Feature[])new Feature[0]);
            if (type instanceof Class && ((Class)type).isAnnotationPresent(ApiModel.class)) {
                return new Pair((Object)false, (Object)JSON.parseObject((String)example));
            }
            return new Pair((Object)false, exampleObj);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return new Pair((Object)true, CustomApiParseUtil.getExample(type));
        }
    }

    private static Object getExample(Type type) {
        if (type instanceof Class) {
            return CustomApiParseUtil.getExampleByClass((Class)type);
        }
        if (type instanceof ParameterizedType) {
            Object it;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] arguments = parameterizedType.getActualTypeArguments();
            if (CustomApiParseUtil.isPostBasicCollection(type) && !CustomApiParseUtil.isExampleEmpty(it = CustomApiParseUtil.getExample(arguments[0]))) {
                return Collections.singletonList(it);
            }
        } else if (type instanceof GenericArrayType) {
            Object it;
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            if (CustomApiParseUtil.isPostBasicArray(type) && !CustomApiParseUtil.isExampleEmpty(it = CustomApiParseUtil.getExample(componentType))) {
                return Collections.singletonList(it);
            }
        }
        return null;
    }

    private static Object getExampleByClass(Class<?> cls) {
        Object it;
        if (String.class.isAssignableFrom(cls)) {
            return RandomStringUtils.randomAlphanumeric((int)5);
        }
        if (Date.class.isAssignableFrom(cls)) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
        }
        if (Boolean.TYPE.isAssignableFrom(cls) || Boolean.class.isAssignableFrom(cls)) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE.isAssignableFrom(cls) || Byte.class.isAssignableFrom(cls)) {
            return RandomUtils.nextInt((int)1, (int)127);
        }
        if (Character.TYPE.isAssignableFrom(cls) || Character.class.isAssignableFrom(cls)) {
            return RandomStringUtils.randomAlphabetic((int)1);
        }
        if (Short.TYPE.isAssignableFrom(cls) || Short.class.isAssignableFrom(cls)) {
            return RandomUtils.nextInt((int)1, (int)Short.MAX_VALUE);
        }
        if (Integer.TYPE.isAssignableFrom(cls) || Integer.class.isAssignableFrom(cls)) {
            return RandomUtils.nextInt((int)1, (int)256);
        }
        if (Long.TYPE.isAssignableFrom(cls) || Long.class.isAssignableFrom(cls)) {
            return System.currentTimeMillis() + (long)RandomUtils.nextInt((int)1, (int)100);
        }
        if (Double.TYPE.isAssignableFrom(cls) || Double.class.isAssignableFrom(cls)) {
            return NumberUtils.toScaledBigDecimal((Double)RandomUtils.nextDouble((double)1.0, (double)100.0), (int)3, (RoundingMode)RoundingMode.HALF_UP);
        }
        if (Float.TYPE.isAssignableFrom(cls) || Float.class.isAssignableFrom(cls)) {
            return NumberUtils.toScaledBigDecimal((Float)Float.valueOf(RandomUtils.nextFloat((float)1.0f, (float)100.0f)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
        }
        if (BigDecimal.class.isAssignableFrom(cls)) {
            return NumberUtils.toScaledBigDecimal((Double)RandomUtils.nextDouble((double)1.0, (double)100.0), (int)4, (RoundingMode)RoundingMode.HALF_UP);
        }
        if (cls.isArray() && !CustomApiParseUtil.isExampleEmpty(it = CustomApiParseUtil.getExample(cls.getComponentType()))) {
            return Collections.singletonList(it);
        }
        return null;
    }

    private static boolean isExampleEmpty(Object example) {
        return example == null || example instanceof String && StringUtil.isEmpty((String)example.toString());
    }

    private static String getDesc(String varName, Type type) {
        return varName;
    }

    private static void checkGenericType(String varName, Type type) {
        if (!(type instanceof Class)) {
            return;
        }
        Class cls = (Class)type;
        if (Map.class.isAssignableFrom(cls) || Collection.class.isAssignableFrom(cls)) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u53c2\u6570 %1$s \u7684\u7c7b\u578b %2$s \u8bf7\u8bbe\u7f6e\u5177\u4f53\u6cdb\u578b\u7c7b\u578b\u3002", (String)"CustomApiParseUtil_12", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{varName, type.getTypeName()});
        }
    }

    private static boolean isBasicType(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class cls = (Class)type;
        if (Void.TYPE.equals(cls) || Void.class.equals((Object)cls)) {
            return false;
        }
        if (ClassUtils.isPrimitiveOrWrapper((Class)cls)) {
            return true;
        }
        if (String.class.equals((Object)cls)) {
            return true;
        }
        return BigDecimal.class.equals((Object)cls) || BigInteger.class.equals((Object)cls) || Date.class.isAssignableFrom(cls);
    }

    private static boolean isMapOrMapArray(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return CustomApiParseUtil.isMapOrMapArray(rawType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            return CustomApiParseUtil.isMapOrMapArray(componentType);
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls.isArray()) {
                return CustomApiParseUtil.isMapOrMapArray(cls.getComponentType());
            }
            return Map.class.isAssignableFrom(cls);
        }
        return false;
    }

    private static boolean isMap(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            return Map.class.isAssignableFrom(cls);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return CustomApiParseUtil.isMap(rawType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            return CustomApiParseUtil.isMap(componentType);
        }
        return false;
    }

    private static boolean isCollection(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                return Collection.class.isAssignableFrom((Class)rawType);
            }
        } else if (type instanceof Class) {
            Class cls = (Class)type;
            return Collection.class.isAssignableFrom(cls);
        }
        return false;
    }

    private static boolean isPostBasicCollection(Type type) {
        if (CustomApiParseUtil.isGetBasicCollection(type)) {
            return true;
        }
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments == null || typeArguments.length != 1) {
            return false;
        }
        Type typeArgument = typeArguments[0];
        if (!(typeArgument instanceof Class)) {
            return false;
        }
        Class cls = (Class)typeArgument;
        return CustomApiParseUtil.isGetBasicArray(cls);
    }

    public static boolean isGetBasicCollection(Type type) {
        if (!CustomApiParseUtil.isCollection(type)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments == null || typeArguments.length != 1) {
            return false;
        }
        Type typeArgument = typeArguments[0];
        if (!(typeArgument instanceof Class)) {
            return false;
        }
        Class cls = (Class)typeArgument;
        return CustomApiParseUtil.isBasicType(cls);
    }

    private static boolean isArray(Type type) {
        if (type instanceof Class) {
            return ((Class)type).isArray();
        }
        return type instanceof GenericArrayType;
    }

    private static boolean isPostBasicArray(Type type) {
        if (CustomApiParseUtil.isGetBasicArray(type)) {
            return true;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            if (CustomApiParseUtil.isBasicType(componentType)) {
                return true;
            }
            if (CustomApiParseUtil.isPostBasicArray(componentType)) {
                return true;
            }
            if (CustomApiParseUtil.isPostBasicCollection(componentType)) {
                return true;
            }
        } else if (type instanceof Class) {
            Class cls = (Class)type;
            return CustomApiParseUtil.isPostBasicArray(cls.getComponentType());
        }
        return false;
    }

    public static boolean isGetBasicArray(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class cls = (Class)type;
        if (!CustomApiParseUtil.isArray(cls)) {
            return false;
        }
        if (cls.getName().startsWith("[[")) {
            return false;
        }
        Class<?> componentType = cls.getComponentType();
        return CustomApiParseUtil.isBasicType(componentType);
    }

    private static void checkGetBasicType(Type type, String errorMsg) {
        if (type instanceof ParameterizedType) {
            CustomApiParseUtil.checkBasicType(() -> CustomApiParseUtil.checkGetBasicType((ParameterizedType)type), errorMsg);
        } else if (type instanceof Class) {
            CustomApiParseUtil.checkBasicType(() -> CustomApiParseUtil.checkGetBasicType((Class)type), errorMsg);
        } else {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, errorMsg, new Object[0]);
        }
    }

    private static void checkBasicType(Supplier<Boolean> supplier, String errorMsg) {
        Boolean b = supplier.get();
        if (!b.booleanValue()) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, errorMsg, new Object[0]);
        }
    }

    private static boolean checkGetBasicType(ParameterizedType parameterizedType) {
        return CustomApiParseUtil.isGetBasicCollection(parameterizedType);
    }

    private static boolean checkGetBasicType(Class<?> cls) {
        return CustomApiParseUtil.isBasicType(cls) || CustomApiParseUtil.isGetBasicArray(cls);
    }

    public static Class<?> forNameClass(String className) {
        Class cls = CustomApiCacheUtil.getOrRegister((String)className);
        ApiController apiController = cls.getAnnotation(ApiController.class);
        if (apiController == null) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"%1$s \u672a\u8bbe\u7f6e\u6ce8\u89e3 %2$s\u3002", (String)"CustomApiParseUtil_13", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{className, ApiController.class.getName()});
        }
        if (StringUtil.isEmpty((String)apiController.value())) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"%1$s \u7684\u6ce8\u89e3 %2$s \u5c5e\u6027 value \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomApiParseUtil_14", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{className, ApiController.class.getSimpleName()});
        }
        return cls;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Set<Method> methodSet = CustomApiParseUtil.getMethodAnno(clazz);
        List methodList = methodSet.stream().filter(it -> it.getName().equals(methodName.trim())).collect(Collectors.toList());
        if (methodList.isEmpty()) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u7c7b %1$s \u4e2d\u672a\u627e\u5230\u65b9\u6cd5 %2$s\uff0c\u6216\u65b9\u6cd5\u672a\u6807\u8bb0\u6ce8\u89e3 %3$s \u6216 %4$s\u3002 ", (String)"CustomApiParseUtil_15", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{clazz.getName(), methodName, ApiGetMapping.class.getName(), ApiPostMapping.class.getName()});
        }
        if (methodList.size() != 1) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u7c7b %1$s \u4e2d\u627e\u5230\u591a\u4e2a\u540c\u540d\u65b9\u6cd5 %2$s", (String)"CustomApiParseUtil_16", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{clazz.getName(), methodName});
        }
        return (Method)methodList.get(0);
    }

    private static Set<Method> getAllMethods(Class<?> clazz) {
        Set<Method> methodSet = CustomApiParseUtil.getMethodAnno(clazz);
        Map map = methodSet.stream().map(Method::getName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Set set = map.entrySet().stream().filter(it -> (Long)it.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!set.isEmpty()) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u7c7b %1$s \u4e2d\u5b58\u5728\u91cd\u590d\u7684\u65b9\u6cd5\u540d %2$s\u3002", (String)"CustomApiParseUtil_17", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{clazz.getName(), Arrays.toString(set.toArray())});
        }
        return methodSet;
    }

    private static Set<Method> getMethodAnno(Class<?> clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        LinkedHashSet<Method> methodSet = new LinkedHashSet<Method>(methods.length);
        for (Method method : methods) {
            if (!method.isAnnotationPresent(ApiGetMapping.class) && !method.isAnnotationPresent(ApiPostMapping.class)) continue;
            methodSet.add(method);
        }
        if (methodSet.isEmpty()) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u7c7b %1$s \u4e2d\u672a\u627e\u5230\u65b9\u6cd5\u6807\u8bb0\u6ce8\u89e3 %2$s \u6216 %3$s\u3002", (String)"CustomApiParseUtil_18", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{clazz.getName(), ApiGetMapping.class.getName(), ApiPostMapping.class.getName()});
        }
        return methodSet;
    }

    public static List<String> getVarNameList(Class<?> clazz, Method method) {
        String mappingName;
        List<String> paramNameList;
        ApiGetMapping apiGetMapping = method.getAnnotation(ApiGetMapping.class);
        ApiPostMapping apiPostMapping = method.getAnnotation(ApiPostMapping.class);
        CustomApiParseUtil.checkMethodMapping(clazz, method, apiGetMapping, apiPostMapping);
        if (apiGetMapping != null) {
            paramNameList = CustomApiParseUtil.getParamName(method, apiGetMapping.methodParamNames(), ApiGetMapping.class);
            if (paramNameList != null) {
                return paramNameList;
            }
            mappingName = ApiGetMapping.class.getName();
        } else {
            paramNameList = CustomApiParseUtil.getParamName(method, apiPostMapping.methodParamNames(), ApiPostMapping.class);
            if (paramNameList != null) {
                return paramNameList;
            }
            mappingName = ApiPostMapping.class.getName();
        }
        DefaultParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();
        String[] names = discoverer.getParameterNames(method);
        paramNameList = names == null || names.length == 0 ? Collections.emptyList() : Arrays.asList(names);
        if (method.getParameterCount() != paramNameList.size()) {
            throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u83b7\u53d6\u65b9\u6cd5 %1$s \u7684\u53c2\u6570\u540d\u79f0\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u662f\u7f16\u8bd1\u65f6\u8fdb\u884c\u4e86\u4ee3\u7801\u6df7\u6dc6\u5904\u7406\u7b49\uff0c\u53ef\u901a\u8fc7\u6ce8\u89e3 %2$s \u4e2d methodParamNames \u5c5e\u6027\u8bbe\u7f6e\u65b9\u6cd5\u53c2\u6570\u540d\u3002", (String)"CustomApiParseUtil_22", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{method.getName(), mappingName});
        }
        return paramNameList;
    }

    @Nullable
    private static List<String> getParamName(Method method, String[] methodParamNames, Class<?> cls) {
        if (CollectionUtil.isNotEmpty((Object[])methodParamNames)) {
            if (method.getParameterCount() != methodParamNames.length) {
                throw new OpenApiException(kd.bos.openapi.common.constant.ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u65b9\u6cd5 %1$s \u7684\u6ce8\u89e3 %2$s \u4e2d methodParamNames \u53c2\u6570\u4e2a\u6570\u548c\u65b9\u6cd5\u5b9e\u9645\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d\u3002", (String)"CustomApiParseUtil_23", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{method.getName(), cls.getName()});
            }
            return Arrays.asList(methodParamNames);
        }
        return null;
    }
}

