/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.custom.demo;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.openapi.base.statdata.ApiAggrService;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.HttpStatus;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.result.OpenApiFile;
import kd.bos.openapi.common.util.OpenApiSdkUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.openapi.service.custom.demo.CustomDemo2Model;

@ApiController(value="dev", desc="\u81ea\u5b9a\u4e49API Demo\u6837\u4f8b2")
@ApiMapping(value="/openapi/test2")
public class CustomDemoTestController {
    @ApiPostMapping(value="/getCustomTest", desc="\u83b7\u53d6Model\u6570\u636e")
    public CustomApiResult<CustomDemo2Model> getCustomTest(@Valid @NotNull @ApiParam(value="model\u53c2\u6570") @Valid @NotNull @ApiParam(value="model\u53c2\u6570") CustomDemo2Model model) {
        CustomApiResult result = new CustomApiResult();
        if (model != null) {
            try {
                int rnd = model.getBalance();
                Thread.sleep(rnd);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            model.setDate2(new Date());
            model.setName("TinyHU1-" + ID.genStringId());
            result.setData((Object)model);
            result.setErrorCode("OK");
            result.setMessage("Success");
        }
        return result;
    }

    @ApiPostMapping(value="/getTextPlainTest", desc="\u4f20\u8f93text/plain")
    public CustomApiResult<String> getTextPlainTest(@Valid @NotNull @ApiParam(value="\u6570\u636e") @Valid @NotNull @ApiParam(value="\u6570\u636e") String data) {
        CustomApiResult result = new CustomApiResult();
        if (StringUtil.isEmpty((String)data)) {
            result.setData((Object)"data:null");
        } else {
            result.setData((Object)("data:" + data));
        }
        return result;
    }

    @ApiPostMapping(value="/getStringTest", desc="\u83b7\u53d6\u8bf7\u6c42\u5934\u3001\u54cd\u5e94\u5934")
    public CustomApiResult<String> getStringTest(@ApiParam(value="\u59d3\u540d") @ApiParam(value="\u59d3\u540d") String name) {
        String token = "";
        String xname = "";
        Map reqHeader = ServiceApiContext.getRequest().getRequestHeaders();
        if (reqHeader != null) {
            token = (String)reqHeader.get("accessToken");
            if (StringUtil.isEmpty((String)token)) {
                token = (String)reqHeader.get("accesstoken");
            }
            xname = (String)reqHeader.get("X-Name");
        }
        token = token == null || token.length() < 20 ? "(null)" : "***" + token.substring(0, 20) + "***";
        HashMap<String, String> repHeader = new HashMap<String, String>(2);
        repHeader.put("X-MyToken", "Token" + token);
        ServiceApiContext.getResponse().setResponseHeaders(repHeader);
        ServiceApiContext.getResponse().setHttpStatus(200);
        CustomApiResult result = new CustomApiResult();
        result.setMessage("Success");
        if (StringUtil.isEmpty((String)name)) {
            name = "(Name is empty)";
        }
        result.setData((Object)("YourName:" + name + ",header(X-Name):" + xname));
        return result;
    }

    @ApiPostMapping(value="/testOpenApiSdkUtil", desc="\u83b7\u53d6\u8bf7\u6c42\u5934\u3001\u54cd\u5e94\u5934")
    public CustomApiResult<String> testOpenApiSdkUtil(@ApiParam(value="\u59d3\u540d") @ApiParam(value="\u59d3\u540d") String name) {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        HashMap<String, String> header = new HashMap<String, String>(2);
        data.put("name", name);
        data.put("name-eng", "tinyhu-sdkUtil");
        data.put("age", 18);
        header.put("X-Name", "tinyhu-header-sdkUtil");
        Object result = OpenApiSdkUtil.invokeOpenApi((String)"/v2/open/openapi/test2/getStringTest", data, header);
        return CustomApiResult.success((Object)((String)result));
    }

    @ApiPostMapping(value="/getLongTest", desc="\u83b7\u53d6ID")
    public CustomApiResult<Long> getLongTest(@Valid @NotNull @ApiParam(value="ID") @Valid @NotNull @ApiParam(value="ID") long id) {
        return CustomApiResult.success((Object)(++id));
    }

    @ApiPostMapping(value="/postSleepTest", desc="\u6d4b\u8bd5\u7ebf\u7a0b\u7b49\u5f85\u65f6\u95f4")
    public CustomApiResult<String> postSleepTest(@Valid @NotNull @ApiParam(value="name") @Valid @NotNull @ApiParam(value="name") String name, @Valid @NotNull @ApiParam(value="sleep") @Valid @NotNull @ApiParam(value="sleep") long sleep) {
        String str = String.format("ParaName:%1s,CurrentUserName:%2s,ThreadSleep:%3s millseconds.", name, RequestContext.get().getUserName(), sleep);
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (sleep == 88L) {
            throw new NullPointerException();
        }
        if (sleep == 99L) {
            throw new KDException("testException");
        }
        if (sleep == 666L) {
            ApiAggrService apiAggrService = new ApiAggrService();
            apiAggrService.start();
            str = str + " apiAggrService has been started. ";
        }
        return CustomApiResult.success((Object)str);
    }

    @ApiPostMapping(value="/updateCustomerTest", desc="\u66f4\u65b0\u5355\u4e2a\u5ba2\u6237")
    public CustomApiResult<CustomDemo2Model> updateCustomerTest(@Valid @NotNull @ApiParam(value="\u5ba2\u6237") @Valid @NotNull @ApiParam(value="\u5ba2\u6237") CustomDemo2Model model) {
        if (model != null) {
            model.setName("TinyHU2-" + ID.genStringId());
        }
        return CustomApiResult.success((Object)model);
    }

    @ApiPostMapping(value="/updateCustomersTest", desc="\u6279\u91cf\u66f4\u65b0\u5ba2\u6237")
    public CustomApiResult<CustomDemo2Model[]> updateCustomersTest(@Valid @NotNull @ApiParam(value="\u5ba2\u6237") @Valid @NotNull @ApiParam(value="\u5ba2\u6237") CustomDemo2Model[] models) {
        if (models != null && models.length >= 1) {
            models[0].setName("TinyHU3-" + ID.genStringId());
        }
        return CustomApiResult.success((Object)models);
    }

    @ApiPostMapping(value="/getExceptionTest", desc="\u8bbe\u7f6e\u54cd\u5e94\u5f02\u5e38\u4ee3\u7801")
    public CustomApiResult<String> getExceptionTest(@ApiParam(value="\u662f\u5426\u629b\u51fa\u629b\u51fa\u5f02\u5e38") @ApiParam(value="\u662f\u5426\u629b\u51fa\u629b\u51fa\u5f02\u5e38") boolean throwException, @NotNull @ApiParam(value="\u5f02\u5e38\u4fe1\u606f") @NotNull @ApiParam(value="\u5f02\u5e38\u4fe1\u606f") String message) {
        if (throwException) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, message, new Object[0]);
        }
        return CustomApiResult.success((Object)"\u6267\u884c\u6210\u529f");
    }

    @ApiPostMapping(value="/uploadFile", desc="\u4e0a\u4f20\u6587\u4ef6\u6d41")
    public CustomApiResult<String> uploadFile(@ApiParam(value="\u8ba2\u5355\u53f7") @ApiParam(value="\u8ba2\u5355\u53f7") String billNo, @ApiParam(value="\u6587\u4ef6\u6d41") @ApiParam(value="\u6587\u4ef6\u6d41") OpenApiFile file1) {
        if (StringUtil.isEmpty((String)billNo) || file1 == null || file1.getFileData() == null) {
            ServiceApiContext.getResponse().setHttpStatus(HttpStatus.NOT_ACCEPTABLE.getStatusCode());
            return CustomApiResult.fail((String)"900101", (String)"billNo and file1 cannot be null.");
        }
        String msg = "OrderNo:" + billNo + ",FileName" + file1.getFileName() + ",FileType:" + file1.getContentType() + ",FileLength(bytes)" + file1.getFileData().length;
        return CustomApiResult.success((Object)msg);
    }

    @ApiPostMapping(value="/processFile", desc="\u5904\u7406\u6587\u4ef6\u6d41")
    public CustomApiResult<OpenApiFile> processFile(@ApiParam(value="\u8ba2\u5355\u53f7") @ApiParam(value="\u8ba2\u5355\u53f7") String billNo, @ApiParam(value="\u6587\u4ef6\u6d41") @ApiParam(value="\u6587\u4ef6\u6d41") OpenApiFile file1) {
        if (StringUtil.isEmpty((String)billNo) || file1 == null || file1.getFileData() == null) {
            ServiceApiContext.getResponse().setHttpStatus(HttpStatus.NOT_ACCEPTABLE.getStatusCode());
            return CustomApiResult.fail((String)"900101", (String)"billNo and file1 cannot be null.");
        }
        if (!file1.getFileName().contains(".txt")) {
            ServiceApiContext.getResponse().setHttpStatus(HttpStatus.NOT_ACCEPTABLE.getStatusCode());
            return CustomApiResult.fail((String)"900102", (String)"Only text file is allowed.");
        }
        try {
            byte[] message = ("OrderNo:" + billNo + ", Date:" + new Date().toString() + " \n\r").getBytes(Charset.forName("UTF-8"));
            byte[] resultFileData = new byte[file1.getFileData().length + message.length];
            System.arraycopy(message, 0, resultFileData, 0, message.length);
            System.arraycopy(file1.getFileData(), 0, resultFileData, message.length, file1.getFileData().length);
            OpenApiFile result = new OpenApiFile("New" + file1.getFileName(), "text/plain", true, resultFileData);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception ex) {
            ServiceApiContext.getResponse().setHttpStatus(HttpStatus.BAD_REQUEST.getStatusCode());
            return CustomApiResult.fail((String)"400", (String)("ErrorMessage\uff1a" + ex.getMessage()));
        }
    }
}

