/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.custom.open;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.custom.open.model.StatDataApiModel;
import kd.bos.openapi.service.custom.open.model.StatDataDayModel;
import kd.bos.openapi.service.custom.open.model.StatDataThirdModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

@ApiController(value="dev", desc="\u5f00\u653e\u5e73\u53f0API")
@ApiMapping(value="/openapi/apiStatdata")
public class CustomOpenApiStatDataController
implements Serializable {
    @ApiPostMapping(value="queryByTime", desc="\u6309\u65f6\u95f4\u67e5\u8be2API\u7edf\u8ba1\u4fe1\u606f")
    public CustomApiResult<List<StatDataDayModel>> queryByTime(@ApiParam(value="\u5f00\u59cb\u65f6\u95f4", required=true) @ApiParam(value="\u5f00\u59cb\u65f6\u95f4", required=true) Date starTime, @ApiParam(value="\u7ed3\u675f\u65f6\u95f4", required=true) @ApiParam(value="\u7ed3\u675f\u65f6\u95f4", required=true) Date endTime) {
        QFilter qFilter = QFilter.of((String)"time >= ?", (Object[])new Object[]{starTime.getTime()});
        qFilter.and(QFilter.of((String)"time <= ?", (Object[])new Object[]{endTime.getTime()}));
        qFilter.and(QFilter.of((String)"type = ?", (Object[])new Object[]{7}));
        return CustomApiResult.success(this.buildStatDataDayModel(qFilter));
    }

    @ApiPostMapping(value="queryByTrdapp", desc="\u6309\u7b2c\u4e09\u65b9\u5e94\u7528\u67e5\u8be2API\u7edf\u8ba1\u4fe1\u606f")
    public CustomApiResult<List<StatDataThirdModel>> queryByTrdapp(@ApiParam(value="\u7b2c\u4e09\u65b9\u5e94\u7528ID", required=true) @ApiParam(value="\u7b2c\u4e09\u65b9\u5e94\u7528ID", required=true) List<Long> thirdIds) {
        QFilter qFilter = new QFilter("thirdid", "in", (Object)thirdIds.toArray());
        qFilter.and(QFilter.of((String)"type = ?", (Object[])new Object[]{2}));
        return CustomApiResult.success(this.buildStatDataThirdModel(qFilter));
    }

    @ApiPostMapping(value="queryByApi", desc="\u6309APIID\u67e5\u8be2API\u7edf\u8ba1\u4fe1\u606f")
    public CustomApiResult<List<StatDataApiModel>> queryByApi(@ApiParam(value="API ID", required=true) @ApiParam(value="API ID", required=true) List<Long> apiIds) {
        QFilter qFilter = new QFilter("apiid", "in", (Object)apiIds.toArray());
        qFilter.and(QFilter.of((String)"type = ?", (Object[])new Object[]{2}));
        return CustomApiResult.success(this.buildStatDataApiModel(qFilter));
    }

    private List<StatDataDayModel> buildStatDataDayModel(QFilter qFilter) {
        ArrayList<StatDataDayModel> statDataModels = new ArrayList<StatDataDayModel>();
        DynamicObjectCollection ds = QueryServiceHelper.query((String)"openapi_statdata", (String)"time,apiid,thirdid,cnt,successcnt,cost,type", (QFilter[])qFilter.toArray());
        if (ds.size() > 0) {
            ds.forEach(it -> {
                StatDataDayModel statDataModel = new StatDataDayModel();
                statDataModel.setCnt(it.getInt("cnt"));
                statDataModel.setCost(it.getInt("cost") / it.getInt("cnt"));
                statDataModel.setTime(it.getDate("time"));
                statDataModel.setSuccessCnt(it.getInt("successcnt"));
                statDataModel.setFailCnt(it.getInt("cnt") - it.getInt("successcnt"));
                statDataModels.add(statDataModel);
            });
        }
        return statDataModels;
    }

    private List<StatDataThirdModel> buildStatDataThirdModel(QFilter qFilter) {
        ArrayList<StatDataThirdModel> statDataModels = new ArrayList<StatDataThirdModel>();
        DynamicObjectCollection ds = QueryServiceHelper.query((String)"openapi_statdata", (String)"thirdid,apiid,time,apiid.number,apiid.name,apiid.appid.name,thirdid.number,thirdid.name,cnt,successcnt,cost,type", (QFilter[])qFilter.toArray());
        if (ds.size() > 0) {
            Map<Long, List<DynamicObject>> groupByApiIdMap = ds.stream().collect(Collectors.groupingBy(it -> it.getLong("apiid")));
            groupByApiIdMap.forEach((apiId, dyList) -> {
                Map<Long, List<DynamicObject>> groupByThirdIdAndApiid = dyList.stream().collect(Collectors.groupingBy(it -> it.getLong("thirdid")));
                groupByThirdIdAndApiid.forEach((thirdId, apiList) -> {
                    StatDataThirdModel statDataModel = new StatDataThirdModel();
                    Integer cnt = apiList.stream().map(data -> data.getInt("cnt")).reduce(0, (x, y) -> {
                        x = x + y;
                        return x;
                    });
                    Integer successcnt = apiList.stream().map(data -> data.getInt("successcnt")).reduce(0, (x, y) -> {
                        x = x + y;
                        return x;
                    });
                    Integer costSum = apiList.stream().map(data -> data.getInt("cost")).reduce(0, (x, y) -> {
                        x = x + y;
                        return x;
                    });
                    statDataModel.setCnt(cnt);
                    statDataModel.setCost(costSum / cnt);
                    statDataModel.setSuccessCnt(successcnt);
                    statDataModel.setFailCnt(cnt - successcnt);
                    DynamicObject it = (DynamicObject)apiList.get(0);
                    statDataModel.setApiName(it.getString("apiid.name"));
                    statDataModel.setApiNumber(it.getString("apiid.number"));
                    statDataModel.setAppName(it.getString("apiid.appid.name"));
                    statDataModel.setThirdName(it.getString("thirdid.name"));
                    statDataModel.setThirdNumber(it.getString("thirdid.number"));
                    statDataModels.add(statDataModel);
                });
            });
        }
        return statDataModels;
    }

    private List<StatDataApiModel> buildStatDataApiModel(QFilter qFilter) {
        ArrayList<StatDataApiModel> statDataModels = new ArrayList<StatDataApiModel>();
        DynamicObjectCollection ds = QueryServiceHelper.query((String)"openapi_statdata", (String)"apiid,apiid.number,apiid.name,apiid.appid.name,thirdid.number,thirdid.name,cnt,successcnt,cost,type", (QFilter[])qFilter.toArray());
        if (ds.size() > 0) {
            Map<Long, List<DynamicObject>> groupByApiIdMap = ds.stream().collect(Collectors.groupingBy(it -> it.getLong("apiid")));
            groupByApiIdMap.forEach((apiId, apiList) -> {
                StatDataApiModel statDataModel = new StatDataApiModel();
                Integer cnt = apiList.stream().map(data -> data.getInt("cnt")).reduce(0, (x, y) -> {
                    x = x + y;
                    return x;
                });
                Integer successcnt = apiList.stream().map(data -> data.getInt("successcnt")).reduce(0, (x, y) -> {
                    x = x + y;
                    return x;
                });
                Integer costSum = apiList.stream().map(data -> data.getInt("cost")).reduce(0, (x, y) -> {
                    x = x + y;
                    return x;
                });
                statDataModel.setCnt(cnt);
                statDataModel.setCost(costSum / cnt);
                statDataModel.setSuccessCnt(successcnt);
                statDataModel.setFailCnt(cnt - successcnt);
                DynamicObject it = (DynamicObject)apiList.get(0);
                statDataModel.setApiName(it.getString("apiid.name"));
                statDataModel.setApiNumber(it.getString("apiid.number"));
                statDataModel.setAppName(it.getString("apiid.appid.name"));
                statDataModels.add(statDataModel);
            });
        }
        return statDataModels;
    }
}

