/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.custom.open;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.openapi.base.util.OpenApiParamsExampleUtil;
import kd.bos.openapi.common.constant.ApiStatus;
import kd.bos.openapi.common.constant.HttpMethod;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.custom.open.model.HeaderModel;
import kd.bos.openapi.service.custom.open.model.OpenApiInfoModel;
import kd.bos.openapi.service.custom.open.model.RowsModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiController(value="dev", desc="\u5f00\u653e\u5e73\u53f0API")
@ApiMapping(value="/openapi")
public class OpenApiInfoController
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(OpenApiInfoController.class);
    private static final String selectProperties = "name,urlformat,httpmethod,appid,isvid,apiservicetype,bizobject,operation,cosmicver,classname,methodname,status,customsort,modifytime,headerentryentity,headerentryentity.headername,headerentryentity.headervalue,bodyentryentity,bodyentryentity.paramname,bodyentryentity.body_level,bodyentryentity.example,bodyentryentity.paramtype,bodyentryentity.is_req_mul_value,bodyentryentity.objpropname,bodyentryentity.pid,bodyentryentity.id,isgalaxy,createtime";

    @ApiPostMapping(value="getOpenApiInfo", desc="\u5206\u9875\u83b7\u53d6\u5f00\u653e\u5e73\u53f0OpenApi\u63a5\u53e3\u4fe1\u606f")
    public CustomApiResult<@ApiResponseBody(value="\u8fd4\u56de\u4fe1\u606f") OpenApiInfoModel> getOpenApiInfo(@ApiParam(value="\u5206\u9875\u5927\u5c0f", required=true, example="10") @ApiParam(value="\u5206\u9875\u5927\u5c0f", required=true, example="10") Integer pageSize, @ApiParam(value="\u9875\u53f7", required=true, example="1") @ApiParam(value="\u9875\u53f7", required=true, example="1") Integer pageNo, @ApiParam(value="\u5f00\u53d1\u5546\u6807\u8bc6", required=true, example="[\"kingdee\"]") @ApiParam(value="\u5f00\u53d1\u5546\u6807\u8bc6", required=true, example="[\"kingdee\"]") List<String> isvid, @ApiParam(value="Api\u670d\u52a1\u7c7b\u578b 0:\u96f6\u4ee3\u7801\u914d\u7f6e 1:AI\u670d\u52a1 2:Java\u63d2\u4ef6 3:\u811a\u672c\u5f00\u53d1 4:Servlet\u5f00\u53d1", required=true, example="[\"0\",\"2\"]") @ApiParam(value="Api\u670d\u52a1\u7c7b\u578b 0:\u96f6\u4ee3\u7801\u914d\u7f6e 1:AI\u670d\u52a1 2:Java\u63d2\u4ef6 3:\u811a\u672c\u5f00\u53d1 4:Servlet\u5f00\u53d1", required=true, example="[\"0\",\"2\"]") List<String> apiservicetype) {
        OpenApiInfoModel result = new OpenApiInfoModel();
        result.setPageSize(pageSize);
        result.setPageNo(pageNo);
        QFilter qFilter = new QFilter("isvid", "in", isvid);
        qFilter.and(new QFilter("apiservicetype", "in", apiservicetype));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"openapi_apilist", (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)"", (int)(pageNo - 1), (int)pageSize);
        ArrayList<RowsModel> rows = new ArrayList<RowsModel>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            RowsModel model = new RowsModel();
            model.setId((Long)dynamicObject.getPkValue());
            model.setApiServiceType(dynamicObject.getString("apiservicetype"));
            HttpMethod httpmethod = HttpMethod.fromCode((String)dynamicObject.getString("httpmethod"));
            if (httpmethod != null) {
                model.setInterfaceType(httpmethod.getName());
            }
            model.setCosmicver(dynamicObject.getString("cosmicver"));
            model.setIsvid(dynamicObject.getString("isvid"));
            model.setName(dynamicObject.getString("name"));
            model.setOperation(dynamicObject.getString("operation"));
            model.setCloudName(dynamicObject.getString("appid.bizcloud.name"));
            model.setBusinessObject(dynamicObject.getString("bizobject.name"));
            model.setBusinessObjectFormID(dynamicObject.getString("bizobject.number"));
            model.setAppName(dynamicObject.getString("appid.name"));
            ApiStatus status = ApiStatus.fromCode((String)dynamicObject.getString("status"));
            if (status != null) {
                model.setInterfaceState(status.getName());
            }
            model.setCustomsort(dynamicObject.getString("customsort.name"));
            String url = dynamicObject.getString("urlformat");
            model.setUrl("/kapi" + url);
            model.setRequestExample(OpenApiParamsExampleUtil.getRequestExample((DynamicObject)dynamicObject));
            model.setAppId(dynamicObject.getString("appid.id"));
            model.setAppSimpleNumber(dynamicObject.getString("appid.number"));
            model.setCloudId(dynamicObject.getString("appid.bizcloud.id"));
            model.setCloudNumber(dynamicObject.getString("appid.bizcloud.number"));
            model.setApiUpdateTime(dynamicObject.getString("modifytime"));
            model.setCreatetime(dynamicObject.getDate("createtime"));
            try {
                model.setIsgalaxy(dynamicObject.getBoolean("isgalaxy"));
            }
            catch (Exception exception) {
                logger.info(exception.getMessage(), (Throwable)exception);
            }
            DynamicObjectCollection headerentryentity = dynamicObject.getDynamicObjectCollection("headerentryentity");
            List<HeaderModel> headers = headerentryentity.stream().map(obj -> {
                HeaderModel header = new HeaderModel();
                header.setHeaderName(obj.getString("headername"));
                header.setHeaderValue(obj.getString("headervalue"));
                return header;
            }).collect(Collectors.toList());
            model.setHeaders(headers);
            rows.add(model);
        }
        result.setRows(rows);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"openapi_apilist", (String)"id", (QFilter[])new QFilter[]{qFilter}, null);){
            int totalCount = dataSet.count("id", true);
            result.setTotal(totalCount);
        }
        return CustomApiResult.success((Object)result);
    }
}

