/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LogBillEntityType;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.openapi.api.QueryApiService;
import kd.bos.openapi.api.model.ApiQueryOrderByModel;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.openapi.api.params.ApiParam;
import kd.bos.openapi.api.params.ApiQueyParam;
import kd.bos.openapi.api.plugin.ApiQueryPlugin;
import kd.bos.openapi.api.plugin.upper.ApiPlugin;
import kd.bos.openapi.api.result.ApiQueryResult;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.base.dataservice.OpenApiDataUtil;
import kd.bos.openapi.base.model.ApiModel;
import kd.bos.openapi.base.util.DynamicObjectUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.ComparatorUtil;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.handle.PropertyHandleUtil;
import kd.bos.openapi.service.AbstractApiService;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.openapi.service.query.QueryApiUtil;
import kd.bos.openapi.service.util.FilterUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;

public class QueryApiServiceImpl
extends AbstractApiService<ApiQueyParam, ApiQueryResult>
implements QueryApiService {
    private static final Log LOG = LogFactory.getLog(QueryApiServiceImpl.class);

    public ApiServiceData<ApiQueryResult> doExecute(ApiQueyParam param) {
        List<Map<String, Object>> rows;
        DynamicObject[] dynamicObjects;
        String queryId;
        String url = param.getRequest().getServiceApiData().getUrl();
        ApiModel apiModel = OpenApiDataUtil.getApiModelFromCache((String)url);
        if (apiModel.isOrgAuthorFilter() && !PermissionServiceHelper.hasViewPermission((long)RequestContext.get().getCurrUserId(), (String)apiModel.getAppRealId(), (String)apiModel.getBizObject())) {
            throw new OpenApiException(ApiErrorCode.Data_NoAuth, ResManager.loadKDString((String)"\u65e0\u67e5\u8be2\u6743\u9650\u3002", (String)"ApiQuery_4", (String)ResSystemType.ACTION.getType(), (Object[])new Object[0]), new Object[0]);
        }
        Pair<Boolean, QFilter> qFilterPair = FilterUtil.getQFilters(url, (ApiParam<Map<String, Object>, ? extends ApiPlugin>)param);
        QFilter originFilter = (QFilter)qFilterPair.getValue();
        QFilter filter = originFilter != null ? originFilter.copy() : null;
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("reqData", param.getRequest().getData() != null ? Collections.unmodifiableMap((Map)param.getRequest().getData()) : Collections.emptyMap());
        map.put("reqHeaders", param.getRequest().getRequestHeaders() != null ? Collections.unmodifiableMap(param.getRequest().getRequestHeaders()) : Collections.emptyMap());
        String orderBy = param.getOrderBys();
        List pluginList = this.getPlugin(param);
        for (ApiQueryPlugin plugin : pluginList) {
            filter = plugin.getFilter(filter, param.getRequest().getData() != null ? Collections.unmodifiableMap((Map)param.getRequest().getData()) : Collections.emptyMap());
            map.put("orderBy", orderBy);
            ApiQueryOrderByModel model = new ApiQueryOrderByModel(Collections.unmodifiableMap(map));
            orderBy = plugin.getOrderBy(model);
        }
        if (StringUtil.isEmpty((String)orderBy)) {
            orderBy = "id asc";
        }
        param.setOrderBys(orderBy);
        Object[] filters = new QFilter[]{filter};
        Set newSelectSet = ComparatorUtil.getSelect((Set)param.getSelectSet());
        Map requestHeaders = ServiceApiContext.getRequest().getRequestHeaders();
        if (requestHeaders != null && requestHeaders.size() > 0 && StringUtil.isNotEmpty((String)(queryId = (String)requestHeaders.get("X-OpenApi-QueryId"))) && "true".equals(queryId)) {
            newSelectSet.add("id");
        }
        ApiQueryResult result = new ApiQueryResult();
        result.setFilter(Arrays.toString(filters));
        long startTime = System.currentTimeMillis();
        boolean filterHasEntry = (Boolean)qFilterPair.getKey();
        if (EntityMetadataCache.getDataEntityType((String)param.getFormId()) instanceof LogBillEntityType) {
            Object[] filtersLog = null;
            if (filter != null) {
                filtersLog = filters;
            }
            DynamicObjectCollection collection = LogORM.create().query(param.getFormId(), String.join((CharSequence)",", newSelectSet), (QFilter[])filtersLog, param.getPageNo() - 1, param.getPageSize());
            dynamicObjects = (DynamicObject[])collection.toArray((Object[])new DynamicObject[collection.size()]);
        } else {
            String isQuickQuery = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("quick_query", "false");
            if (filterHasEntry || "true".equals(isQuickQuery)) {
                dynamicObjects = QueryApiUtil.query(param, filter).toArray(new DynamicObject[0]);
            } else {
                LOG.info("api load fields\uff1a" + newSelectSet);
                dynamicObjects = BusinessDataServiceHelper.load((String)param.getFormId(), (String)String.join((CharSequence)",", newSelectSet), (QFilter[])filters, (String)param.getOrderBys(), (int)(param.getPageNo() - 1), (int)param.getPageSize());
            }
        }
        long endTime = System.currentTimeMillis();
        if (param.isDyObjResult()) {
            LOG.info("api isDyObjResult fields\uff1a" + newSelectSet);
            rows = DynamicObjectUtil.serializeToMap((DynamicObject[])dynamicObjects, (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)param.getFormId(), (Collection)newSelectSet), (boolean)apiModel.isSerializeDefaultValue());
        } else {
            Map<String, Set<String>> prefixMap = this.getPrefixMap(newSelectSet);
            LOG.info("api not isDyObjResult fields\uff1a" + prefixMap);
            rows = PropertyHandleUtil.toMapListRoot(param.getFormId(), "$", dynamicObjects, prefixMap);
        }
        this.desensitizeValue(rows, param.getFormId());
        if (rows == null) {
            rows = Collections.emptyList();
        }
        result.setRows(rows);
        try {
            int totalCount = ORM.create().count(this.getClass().getName(), param.getFormId(), "id", (QFilter[])filters, (Distinctable)WithEntityEntryDistinctable.get());
            result.setTotalCount(totalCount);
            result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPageSize() || param.getPageNo() * param.getPageSize() >= totalCount));
        }
        catch (Exception e) {
            result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPageSize()));
            LOG.error("\u67e5\u8be2\u603b\u6570\u62a5\u9519", (Throwable)new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, ApiErrorCode.HTTP_INTERNAL_ERROR.toString(), new Object[0]));
        }
        result.setPageNo(param.getPageNo());
        result.setPageSize(param.getPageSize());
        return ApiServiceData.ofTrue((OpenApiResponse)ServiceApiContext.getResponse((Object)result), (long)startTime, (long)endTime);
    }

    private void desensitizeValue(List<Map<String, Object>> rows, String formId) {
        if (CollectionUtil.isEmpty(rows)) {
            return;
        }
        if (!ServiceApiContext.getRequest().getServiceApiData().isDesensitize()) {
            return;
        }
        for (Map<String, Object> row : rows) {
            for (Map.Entry<String, Object> entry : row.entrySet()) {
                String fieldName = entry.getKey();
                Object value = entry.getValue();
                Object desensitizeValue = null;
                if (value instanceof Map) {
                    for (Map.Entry entry2 : ((Map)value).entrySet()) {
                        Object valueEntryValue = entry2.getValue();
                        String string = fieldName + '.' + (String)entry2.getKey();
                        Object valueEntryDesensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)formId, (String)string, (String)Lang.get().toString(), (String)"api", null, valueEntryValue);
                        entry2.setValue(valueEntryDesensitizeValue);
                    }
                    continue;
                }
                if (value instanceof List) {
                    for (Map map : (List)value) {
                        for (Map.Entry entry3 : map.entrySet()) {
                            Object objectEntryValue = entry3.getValue();
                            String objectEntryFieldName = fieldName + '.' + (String)entry3.getKey();
                            if (objectEntryValue instanceof Map) {
                                for (Map.Entry entry4 : ((Map)objectEntryValue).entrySet()) {
                                    String valueEntryFieldName = objectEntryFieldName + '.' + (String)entry4.getKey();
                                    Object object = PrivacyCenterServiceHelper.getDesensitizeValue((String)formId, (String)valueEntryFieldName, (String)Lang.get().toString(), (String)"api", null, entry4.getValue());
                                    entry4.setValue(object);
                                }
                                continue;
                            }
                            if (objectEntryValue instanceof List) {
                                for (Map map2 : (List)objectEntryValue) {
                                    for (Map.Entry entry5 : map2.entrySet()) {
                                        Object objectEntryValueMapEntryValue = entry5.getValue();
                                        String objectEntryValueMapEntryFieldName = objectEntryFieldName + '.' + (String)entry5.getKey();
                                        if (objectEntryValueMapEntryValue instanceof Map) {
                                            for (Map.Entry entry6 : ((Map)objectEntryValueMapEntryValue).entrySet()) {
                                                String valueEntryFieldName = objectEntryValueMapEntryFieldName + '.' + (String)entry6.getKey();
                                                Object valueEntryDesensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)formId, (String)valueEntryFieldName, (String)Lang.get().toString(), (String)"api", null, entry6.getValue());
                                                entry6.setValue(valueEntryDesensitizeValue);
                                            }
                                            continue;
                                        }
                                        Object valueEntryDesensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)formId, (String)objectEntryValueMapEntryFieldName, (String)Lang.get().toString(), (String)"api", null, objectEntryValueMapEntryValue);
                                        entry5.setValue(valueEntryDesensitizeValue);
                                    }
                                }
                                continue;
                            }
                            Object valueEntryDesensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)formId, (String)objectEntryFieldName, (String)Lang.get().toString(), (String)"api", null, objectEntryValue);
                            entry3.setValue(valueEntryDesensitizeValue);
                        }
                    }
                    continue;
                }
                desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)formId, (String)fieldName, (String)Lang.get().toString(), (String)"api", null, (Object)value);
                entry.setValue(desensitizeValue);
            }
        }
    }

    private Map<String, Set<String>> getPrefixMap(Set<String> newSelectSet) {
        return newSelectSet.stream().sorted(ComparatorUtil.getStringComparator()).collect(Collectors.groupingBy(it -> {
            int endIndex = it.lastIndexOf(46);
            if (endIndex != -1) {
                return it.substring(0, endIndex);
            }
            return "$";
        }, LinkedHashMap::new, Collectors.mapping(it -> {
            int indexOf = it.lastIndexOf(46);
            if (indexOf != -1) {
                return it.substring(indexOf + 1);
            }
            return it;
        }, Collectors.toCollection(LinkedHashSet::new))));
    }
}

