/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.params.ApiQueyParam;
import kd.bos.openapi.base.util.DynamicPropertyUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.ComparatorUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.handle.PropertyHandle;
import kd.bos.openapi.handle.PropertyHandleFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class QueryApiUtil {
    private static final Log LOG = LogFactory.getLog(QueryApiUtil.class);

    public static List<DynamicObject> query(ApiQueyParam param, QFilter filter) {
        Set<Object> ids = QueryApiUtil.getPageIds(param, filter);
        if (CollectionUtil.isEmpty(ids)) {
            return Collections.emptyList();
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        if (filter != null) {
            qFilter.and(filter);
        }
        Set newSelectSet = ComparatorUtil.getSelect((Set)param.getQuerySelect());
        newSelectSet.add("id");
        LOG.info("api query fields\uff1a" + newSelectSet);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)param.getFormId(), (String)String.join((CharSequence)",", newSelectSet), (QFilter[])new QFilter[]{qFilter}, (String)param.getOrderBys());
        if (CollectionUtil.isEmpty((Collection)collection)) {
            return Collections.emptyList();
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)param.getFormId());
        Map idMap = collection.stream().collect(Collectors.groupingBy(it -> it.get("id"), LinkedHashMap::new, Collectors.toList()));
        List<DynamicObject> dynamicObjects = QueryApiUtil.queryObjListToLoadObjList(idMap.values(), (DynamicObjectType)type, newSelectSet, null);
        return dynamicObjects;
    }

    public static Set<Object> getPageIds(ApiQueyParam param, QFilter filter) {
        QFilter[] qFilterArray;
        String string = param.getFormId();
        if (filter == null) {
            qFilterArray = null;
        } else {
            QFilter[] qFilterArray2 = new QFilter[1];
            qFilterArray = qFilterArray2;
            qFilterArray2[0] = filter;
        }
        Object[] objects = BusinessDataServiceHelper.load((String)string, (String)"id", (QFilter[])qFilterArray, (String)param.getOrderBys(), (int)(param.getPageNo() - 1), (int)param.getPageSize());
        if (CollectionUtil.isEmpty((Object[])objects)) {
            return Collections.emptySet();
        }
        Set<Object> ids = Arrays.stream(objects).map(it -> it.get("id")).collect(Collectors.toSet());
        return ids;
    }

    public static List<DynamicObject> queryObjListToLoadObjList(Collection<List<DynamicObject>> sourceList, DynamicObjectType targetType, Set<String> select, String fullParentPropName) {
        if (sourceList == null) {
            return null;
        }
        if (sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> targetList = new ArrayList<DynamicObject>(sourceList.size());
        for (List<DynamicObject> srcList : sourceList) {
            DynamicObject result = QueryApiUtil.queryObjToLoadObj(srcList, targetType, select, fullParentPropName);
            if (result == null) continue;
            targetList.add(result);
        }
        return targetList;
    }

    public static DynamicObject queryObjToLoadObj(List<DynamicObject> sourceList, DynamicObjectType targetType, Set<String> select, String fullParentPropName) {
        if (CollectionUtil.isEmpty(sourceList)) {
            return null;
        }
        DynamicObject target = (DynamicObject)targetType.createInstance();
        QueryApiUtil.queryObjToLoadObj(sourceList, targetType, select, fullParentPropName, target);
        return target;
    }

    public static DynamicObject queryObjToLoadObj(List<DynamicObject> sourceList, DynamicObjectCollection entry, Set<String> select, String fullParentPropName) {
        if (CollectionUtil.isEmpty(sourceList)) {
            return null;
        }
        DynamicObject target = entry.addNew();
        QueryApiUtil.queryObjToLoadObj(sourceList, entry.getDynamicObjectType(), select, fullParentPropName, target);
        return target;
    }

    private static void queryObjToLoadObj(List<DynamicObject> sourceList, DynamicObjectType targetType, Set<String> select, String fullParentPropName, DynamicObject target) {
        for (IDataEntityProperty property : targetType.getProperties()) {
            if (DynamicPropertyUtil.notIncludeProperty((IDataEntityProperty)property)) continue;
            String key = StringUtil.isEmpty((String)fullParentPropName) || "$".equals(fullParentPropName) ? "" : fullParentPropName;
            String string = key = StringUtil.isEmpty((String)key) ? property.getName() : key + "." + property.getName();
            if (!select.contains(key)) continue;
            PropertyHandle propertyHandle = PropertyHandleFactory.createHandle(fullParentPropName, property, select);
            propertyHandle.copyValue(sourceList, target);
        }
    }
}

