/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.save;

import java.util.List;
import kd.bos.openapi.api.SaveApiService;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.openapi.api.params.ApiSaveParam;
import kd.bos.openapi.api.plugin.ApiSavePlugin;
import kd.bos.openapi.api.result.ApiSaveItemData;
import kd.bos.openapi.api.result.ApiSaveResult;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.service.AbstractApiService;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.openapi.service.save.service.SaveService;

public class SaveApiServiceImpl
extends AbstractApiService<ApiSaveParam<ApiSavePlugin>, ApiSaveResult>
implements SaveApiService {
    public ApiServiceData<ApiSaveResult> doExecute(ApiSaveParam<ApiSavePlugin> param) {
        if (param.getPlugins().size() > 0) {
            List data = param.getDataList();
            List pluginList = this.getPlugin(param);
            for (ApiSavePlugin plugin : pluginList) {
                data = plugin.preHandleRequestData(data);
            }
            param.setDataList(data);
        }
        long startTime = System.currentTimeMillis();
        SaveService service = new SaveService();
        service.initialize(param);
        service.preExecute();
        ApiSaveResult apiSaveResult = service.execute();
        long modelTimeCost = System.currentTimeMillis() - startTime;
        boolean allMatch = apiSaveResult.getResult().stream().allMatch(ApiSaveItemData::isBillStatus);
        if (allMatch) {
            return ApiServiceData.ofTrue((OpenApiResponse)ServiceApiContext.getResponse((Object)apiSaveResult), (long)modelTimeCost);
        }
        return ApiServiceData.ofFalse((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)apiSaveResult.fetchFirstErrorMessage(), (OpenApiResponse)ServiceApiContext.getResponse((Object)apiSaveResult), (long)modelTimeCost);
    }
}

