/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.save.service;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.operate.webapi.OperateDataConverter;
import kd.bos.openapi.api.plugin.ApiAppendEntryRowsPlugin;
import kd.bos.openapi.api.result.ApiSaveItemData;
import kd.bos.openapi.api.result.ApiSaveResult;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.service.save.service.upper.AbstractSaveService;

public class AppendEntryRowService
extends AbstractSaveService<ApiAppendEntryRowsPlugin> {
    @Override
    public ApiSaveResult execute() {
        ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
        this.classifyByKey(this.param, insertList, updateList);
        if (updateList.size() == 0) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "data cannot be found.", new Object[0]);
        }
        List<ApiSaveItemData> opResult = this.executeSave(updateList, false);
        return ApiSaveResult.of(new ArrayList(), opResult);
    }

    @Override
    protected void prepareDataEntity(IDataModel model, Map<String, Object> sourceData, boolean insert, Supplier<OperationResult> initializer) {
        Object pkId = sourceData.get("id");
        if (null != pkId) {
            if (!this.isFirePropChanged()) {
                model.beginInit();
            }
            model.putContextVariable("MODEL_INIT_LOADHEADONLY", (Object)Boolean.TRUE);
            ((IBillModel)model).load(pkId, initializer);
            if (!this.isFirePropChanged()) {
                model.endInit();
            }
        }
    }

    @Override
    protected OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("bos_save_appendentryrows", String.valueOf(true));
        return option;
    }

    @Override
    protected OperateDataConverter getDataConverter(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        for (Map.Entry entry : model.getDataEntityType().getAllEntities().entrySet()) {
            if (!(entry.getValue() instanceof EntryType) || entry.getValue() instanceof SubEntryType || entry.getValue() instanceof LinkEntryType) continue;
            String entryName = (String)entry.getKey();
            int startIndex = this.getDBCurrentMaxSeq(model, entryName);
            obj.getDataEntityState().setEntryStartRowIndex(entryName, startIndex);
            obj.getDataEntityState().setEntryRowCount(entryName, startIndex);
        }
        return super.getDataConverter(model);
    }

    private int getDBCurrentMaxSeq(IDataModel model, String entryKey) {
        IDataEntityProperty property = model.getProperty(entryKey);
        String entryTableName = ((EntryProp)property).getItemType().getAlias();
        String dbRouteKey = model.getDataEntityType().getDBRouteKey();
        String fid = String.valueOf(model.getDataEntity().getPkValue());
        String queryCount = "select max(fseq) as seq from " + entryTableName + " where FID = " + fid;
        int count = (Integer)DB.query((DBRoute)DBRoute.of((String)dbRouteKey), (String)queryCount, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet resultSet) throws Exception {
                int maxSeq = 0;
                if (resultSet.next()) {
                    maxSeq = resultSet.getInt(1);
                }
                return maxSeq;
            }
        });
        return count;
    }
}

