/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.save.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.openapi.api.plugin.ApiDeleteEntryRowsPlugin;
import kd.bos.openapi.api.result.ApiSaveItemData;
import kd.bos.openapi.api.result.ApiSaveResult;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.service.save.service.upper.AbstractSaveService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class DeleteEntryRowService
extends AbstractSaveService<ApiDeleteEntryRowsPlugin> {
    private static final String BOS_OPEN_SERVICE = "bos-open-service";
    static final String formatStr = "{0}:{1},";
    static final char keyTagSplit = '$';

    @Override
    public ApiSaveResult execute() {
        ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
        this.classifyByKey(this.param, insertList, updateList);
        if (updateList.size() == 0) {
            throw new OpenApiException(ApiErrorCode.Data_NotFound, ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u9700\u8981\u5220\u9664\u5206\u5f55\u7684\u5355\u636e\u6570\u636e", (String)"DeleteEntryRowService_0", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[0]);
        }
        List<ApiSaveItemData> opResult = this.executeDelete(updateList);
        return ApiSaveResult.of(new ArrayList(), opResult);
    }

    private List<ApiSaveItemData> executeDelete(List<Map<String, Object>> sourceDatas) {
        HashMap<String, ApiSaveItemData> results;
        block7: {
            IDataModel model = this.getView().getModel();
            ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>(sourceDatas.size());
            results = new HashMap<String, ApiSaveItemData>(sourceDatas.size());
            for (Map<String, Object> objectMap : sourceDatas) {
                ApiSaveItemData apiSaveData = new ApiSaveItemData();
                String pkValue = objectMap.getOrDefault("id", "").toString();
                for (String key : (List)this.param.getKeyMap().get("$")) {
                    Object keyValue = objectMap.getOrDefault(key, "");
                    apiSaveData.getKeys().put(key, keyValue != null ? keyValue.toString() : "");
                }
                apiSaveData.setId(pkValue);
                this.resolve(model, objectMap);
                int index = Integer.parseInt(objectMap.get("_index_").toString());
                if (!pkValue.equals("")) {
                    apiSaveData.setBillIndex(index);
                    results.put(pkValue, apiSaveData);
                }
                billObjs.add(model.getDataEntity(true));
            }
            if (billObjs.isEmpty()) break block7;
            OperationResult result = OperationServiceHelper.executeOperate((String)this.getOperationNumber(), (String)model.getDataEntityType().getName(), (DynamicObject[])billObjs.toArray(new DynamicObject[0]), (OperateOption)this.getOperateOption());
            String billNo = ((BillEntityType)model.getDataEntityType()).getBillNo();
            if (StringUtils.isNotEmpty((CharSequence)billNo)) {
                String selectFields = "id".concat(",").concat(billNo);
                DynamicObjectCollection returnFields = QueryServiceHelper.query((String)this.param.getFormId(), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)result.getSuccessPkIds())});
                for (Object successPkId : result.getSuccessPkIds()) {
                    String sPkId = successPkId.toString();
                    ApiSaveItemData apiSaveData = (ApiSaveItemData)results.get(sPkId);
                    if (apiSaveData == null) continue;
                    apiSaveData.setBillStatus(true);
                    DynamicObject id = returnFields.stream().filter(i -> i.get("id").equals(successPkId)).findFirst().get();
                    apiSaveData.setNumber(id.getString(billNo));
                    apiSaveData.setId(sPkId);
                }
            } else {
                for (Object successPkId : result.getSuccessPkIds()) {
                    String sPkId = successPkId.toString();
                    ApiSaveItemData apiSaveData = (ApiSaveItemData)results.get(sPkId);
                    if (apiSaveData == null) continue;
                    apiSaveData.setBillStatus(true);
                    apiSaveData.setId(sPkId);
                }
            }
        }
        return new ArrayList<ApiSaveItemData>(results.values());
    }

    @Override
    protected void prepareDataEntity(IDataModel model, Map<String, Object> sourceData, boolean insert, Supplier<OperationResult> initializer) {
        model.beginInit();
        Object pkId = sourceData.get("id");
        ((IBillModel)model).load(pkId, () -> {
            OperationResult result = new OperationResult();
            BillEntityType dt = (BillEntityType)model.getDataEntityType();
            String billStatusKey = dt.getBillStatus();
            if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !dt.getProperty(billStatusKey).isDbIgnore()) {
                Object status = model.getValue(billStatusKey);
                if (BillStatus.B.name().equals(status)) {
                    result.setSuccess(false);
                    result.setMessage(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"DeleteEntryRowService_1", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.B)));
                    return result;
                }
                if (BillStatus.C.name().equals(status)) {
                    String masterIdProp;
                    boolean isDefaultAudit;
                    boolean allowOverrideAudit = isDefaultAudit = BillStatus.C.name().equals(((FieldProp)dt.getProperty(billStatusKey)).getDefValue());
                    if (!isDefaultAudit && dt instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(masterIdProp = ((BasedataEntityType)dt).getMasteridPropName()))) {
                        Object masterId = model.getValue(masterIdProp);
                        if (this.isHashCtrlStrategy(dt) && pkId.equals(masterId)) {
                            allowOverrideAudit = true;
                        }
                    }
                    if (!allowOverrideAudit) {
                        result.setSuccess(false);
                        result.setMessage(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"DeleteEntryRowService_1", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.C)));
                        return result;
                    }
                }
            }
            return (OperationResult)initializer.get();
        });
        model.endInit();
    }

    @Override
    protected OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        return option;
    }

    private void resolve(IDataModel model, Map<String, Object> sourceData) {
        OperationResult initResult = new OperationResult();
        this.prepareDataEntity(model, sourceData, false, () -> {
            for (Map.Entry entry : this.param.getKeyMap().entrySet()) {
                if ("$".equals(entry.getKey())) continue;
                String entryName = (String)entry.getKey();
                List sourcerows = (List)sourceData.get(entryName);
                if (sourcerows == null || sourcerows.size() == 0 || sourcerows.stream().allMatch(o -> ((Map)o).size() == 0)) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u672a\u4f20\u5165\u7684\u6570\u636e", (String)"DeleteEntryRowService_2", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[0]);
                }
                int entrySize = model.getEntryEntity(entryName).size();
                ArrayList<String> entryRecords = new ArrayList<String>(entrySize);
                for (int i = 0; i < entrySize; ++i) {
                    DynamicObject row = model.getEntryRowEntity(entryName, i);
                    StringBuilder sb = new StringBuilder();
                    sb.append(i);
                    sb.append('$');
                    for (String s2 : (List)entry.getValue()) {
                        sb.append(MessageFormat.format(formatStr, s2, row.getString(s2)));
                    }
                    if (sb.length() > 1) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    entryRecords.add(sb.toString());
                }
                HashMap<String, Integer> matched = new HashMap<String, Integer>(sourcerows.size());
                for (Object sourcerow : sourcerows) {
                    Map sri = (Map)sourcerow;
                    StringBuilder sb = new StringBuilder();
                    for (String s3 : (List)entry.getValue()) {
                        sb.append(MessageFormat.format(formatStr, s3, sri.get(s3).toString()));
                    }
                    if (sb.length() > 1) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    String sourceKey = sb.toString();
                    long count = entryRecords.stream().filter(s -> s.endsWith(sourceKey)).count();
                    if (count == 0L) {
                        throw new OpenApiException(ApiErrorCode.Data_NotFound, MessageFormat.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5019\u9009\u952e\uff1a{0}\uff0c\u672a\u67e5\u627e\u5230\u9700\u8981\u5220\u9664\u7684\u6570\u636e", (String)"DeleteEntryRowService_3", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), sourceKey), new Object[0]);
                    }
                    if (count > 1L) {
                        throw new OpenApiException(ApiErrorCode.Data_Duplicate, MessageFormat.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5019\u9009\u952e\uff1a{0}\uff0c\u67e5\u627e\u5230{1}\u6761\u9700\u8981\u5220\u9664\u7684\u6570\u636e", (String)"DeleteEntryRowService_4", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), sourceKey, count), new Object[0]);
                    }
                    String rowKey = entryRecords.stream().filter(s -> s.endsWith(sourceKey)).findFirst().get();
                    String key = rowKey.substring(0, rowKey.indexOf(36));
                    matched.put(sourceKey, Integer.parseInt(key));
                }
                model.deleteEntryRows(entryName, matched.values().stream().mapToInt(integer -> Integer.parseInt(String.valueOf(integer))).toArray());
            }
            return initResult;
        });
    }
}

