/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.save.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.plugin.ApiSavePlugin;
import kd.bos.openapi.api.result.ApiSaveItemData;
import kd.bos.openapi.api.result.ApiSaveResult;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.service.save.service.upper.AbstractSaveService;
import kd.bos.orm.util.CollectionUtils;

public class SaveService
extends AbstractSaveService<ApiSavePlugin> {
    private static final Log log = LogFactory.getLog(SaveService.class);

    @Override
    public ApiSaveResult execute() {
        ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
        this.classifyByKey(this.param, insertList, updateList);
        List<ApiSaveItemData> insertIds = this.batchInsert(insertList);
        List<ApiSaveItemData> updateIds = this.batchUpdate(updateList);
        return ApiSaveResult.of(insertIds, updateIds);
    }

    private List<ApiSaveItemData> batchInsert(List<Map<String, Object>> insertList) {
        if (CollectionUtils.isEmpty(insertList)) {
            return Collections.emptyList();
        }
        return this.executeSave(insertList, true);
    }

    private List<ApiSaveItemData> batchUpdate(List<Map<String, Object>> updateList) {
        if (CollectionUtils.isEmpty(updateList)) {
            return Collections.emptyList();
        }
        return this.executeSave(updateList, false);
    }

    @Override
    protected void prepareDataEntity(IDataModel model, Map<String, Object> sourceData, boolean insert, Supplier<OperationResult> initializer) {
        if (insert) {
            this.initInsertModel(model, sourceData, initializer);
        } else {
            if (!this.isFirePropChanged()) {
                model.beginInit();
            }
            this.initUpdateModel(model, sourceData.get("id"), sourceData, initializer);
            if (!this.isFirePropChanged()) {
                model.endInit();
            }
        }
    }

    @Override
    protected OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        Map<String, Object> optionVariables = this.getUserOptions();
        if (optionVariables != null) {
            for (Map.Entry<String, Object> entry : optionVariables.entrySet()) {
                option.setVariableValue(entry.getKey(), entry.getValue().toString());
            }
        }
        if (this.isMutex_ignoremodify()) {
            option.setVariableValue("mutex_ignoremodify", String.valueOf(true));
        }
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("webapitag_of_datasource", String.valueOf(true));
        return option;
    }

    private void initInsertModel(IDataModel model, Map<String, Object> dataObject, Supplier<OperationResult> initializer) {
        model.beginInit();
        model.createNewData(this.getBlankDataEntity(model), initializer);
        model.endInit();
    }

    private void initUpdateModel(IDataModel model, Object pkId, Map<String, Object> dataObject, Supplier<OperationResult> initializer) {
        ((IBillModel)model).load(pkId, () -> {
            OperationResult result = new OperationResult();
            if (this.getIsOnlyNew()) {
                result.setSuccess(false);
                String key = ((List)this.param.getKeyMap().get("$")).toString();
                result.setMessage(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5019\u9009\u952e%s\u6216ID\u67e5\u627e\u5230\u6570\u636e\u5df2\u5b58\u5728,\u4e0d\u80fd\u65b0\u589e", (String)"AbstractSaveService_4", (String)"bos-open-service", (Object[])new Object[0]), key));
                return result;
            }
            BillEntityType dt = (BillEntityType)model.getDataEntityType();
            String billStatusKey = dt.getBillStatus();
            if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !dt.getProperty(billStatusKey).isDbIgnore()) {
                Object status = model.getValue(billStatusKey);
                if (BillStatus.B.name().equals(status)) {
                    if (dt.getName().equals("gl_voucher") && this.isCheckStatus().equals("false")) {
                        return (OperationResult)initializer.get();
                    }
                    result.setSuccess(false);
                    result.setMessage(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"SaveService_0", (String)"bos-open-service", (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.B)));
                    return result;
                }
                if (BillStatus.C.name().equals(status)) {
                    if (StringUtil.isEmpty((String)this.isRmStatusControl())) {
                        String masterIdProp;
                        boolean isDefaultAudit;
                        boolean allowOverrideAudit = isDefaultAudit = BillStatus.C.name().equals(((FieldProp)dt.getProperty(billStatusKey)).getDefValue());
                        if (!isDefaultAudit && dt instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(masterIdProp = ((BasedataEntityType)dt).getMasteridPropName()))) {
                            Object masterId = model.getValue(masterIdProp);
                            if (this.isHashCtrlStrategy(dt) && pkId.equals(masterId)) {
                                allowOverrideAudit = true;
                            }
                        }
                        if (!allowOverrideAudit) {
                            result.setSuccess(false);
                            result.setMessage(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"SaveService_0", (String)"bos-open-service", (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.C)));
                            return result;
                        }
                    } else if ("false".equals(this.isRmStatusControl())) {
                        result.setSuccess(false);
                        result.setMessage(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"SaveService_0", (String)"bos-open-service", (Object[])new Object[0]), this.getStatusCaption(dt, billStatusKey, BillStatus.C)));
                        return result;
                    }
                }
            }
            return (OperationResult)initializer.get();
        });
    }
}

