/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.save.service.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.params.ApiSaveParam;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.service.save.service.convert.BaseConvert;
import kd.bos.openapi.service.save.service.convert.FormatConverterContext;
import kd.bos.openapi.service.save.service.convert.FormatConverterFactory;
import kd.bos.openapi.service.save.service.convert.SavePropConverter;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;

public class FormatConverter {
    private static final Log log = LogFactory.getLog(FormatConverter.class);
    FormatConverterContext contxt;

    Object getConvertResult(IDataEntityProperty type, Object value) {
        return this.getConvertResult(type, value, "");
    }

    Object getConvertResult(IDataEntityProperty type, Object value, String formId) {
        BaseConvert resultConvert = FormatConverterFactory.getFormatConverter(type, value);
        if (this.contxt == null) {
            this.contxt = new FormatConverterContext(formId);
        }
        resultConvert.setContext(this.contxt);
        return resultConvert.Convert();
    }

    Object getConvertResult(String typeName, Object value, String formId, String strClass) {
        SavePropConverter resultConvert = FormatConverterFactory.getFormatConverter(formId, typeName, value, strClass);
        if (this.contxt == null) {
            this.contxt = new FormatConverterContext(formId);
        }
        resultConvert.setContext(this.contxt);
        return resultConvert.Convert();
    }

    public List<String> geterrorInfos() {
        return this.contxt != null ? this.contxt.getErrorInfos() : null;
    }

    public void replaceParamData(Map<String, Object> bill, String formId) {
        MainEntityType met = MetadataServiceHelper.getDataEntityType((String)formId);
        for (Map.Entry<String, Object> entry : bill.entrySet()) {
            DynamicObject[] apipropconverters;
            IDataEntityProperty property = met.findProperty(entry.getKey());
            if (property == null) continue;
            if (property instanceof EntryProp) {
                for (Object item : (List)entry.getValue()) {
                    this.replaceParamData((Map)item, formId);
                }
            }
            String strAppid = "bos";
            List<Object> configs = new ArrayList();
            if (FormatConverter.hasSavePropConvertConfig()) {
                configs = FormatConverter.getSavePropConvertConfig();
            } else {
                QFilter filter = new QFilter("enable", "=", (Object)"1");
                filter.and(new QFilter("status", "=", (Object)"C"));
                for (DynamicObject apipropconverter : apipropconverters = BusinessDataServiceHelper.load((String)"openapi_propconvertercls", (String)"number,appid,propconverterclass", (QFilter[])new QFilter[]{filter})) {
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("number", apipropconverter.getString("number"));
                    config.put("propconverterclass", apipropconverter.getString("propconverterclass"));
                    config.put("appid", apipropconverter.getString("appid"));
                    configs.add(config);
                }
                FormatConverter.setSavePropConvertConfig(configs);
            }
            boolean rpcInvoke = false;
            apipropconverters = configs.iterator();
            while (apipropconverters.hasNext()) {
                String strClass;
                Map apipropconverter = (Map)apipropconverters.next();
                String number = (String)apipropconverter.get("number");
                String propertycanonicalName = property.getClass().getCanonicalName();
                if (!propertycanonicalName.equals(number) || StringUtil.isEmpty((String)(strClass = (String)apipropconverter.get("propconverterclass")))) continue;
                String appid = (String)apipropconverter.get("appid");
                if (!StringUtil.isEmpty((String)appid)) {
                    strAppid = appid;
                }
                Object convertResult = DispatchApiServiceHelper.invokeService((String)strAppid, (String)"ApiPropConvertService", (String)"ConvertValue", (Object[])new Object[]{propertycanonicalName, entry.getValue(), formId, strClass});
                entry.setValue(convertResult);
                rpcInvoke = true;
            }
            if (rpcInvoke) continue;
            Object convertResult = this.getConvertResult(property, entry.getValue(), formId);
            entry.setValue(convertResult);
        }
    }

    public void replaceParamDatas(ApiSaveParam source) {
        List dataList = source.getDataList();
        for (Map objectMap : dataList) {
            this.replaceParamData(objectMap, source.getFormId());
        }
    }

    static boolean hasSavePropConvertConfig() {
        Object cacheObj = LocalCacheUtil.getCacheByKey((String)"savepropconvertercls", (String)"propConverterClasses");
        return cacheObj != null;
    }

    static List<Map<String, String>> getSavePropConvertConfig() {
        Object cacheObj = LocalCacheUtil.getCacheByKey((String)"savepropconvertercls", (String)"propConverterClasses");
        return cacheObj == null ? null : (List)cacheObj;
    }

    static void setSavePropConvertConfig(List<Map<String, String>> configs) {
        if (configs.isEmpty()) {
            HashMap empty = new HashMap();
            configs.add(empty);
        }
        LocalCacheUtil.setCacheByKey((String)"savepropconvertercls", (String)"propConverterClasses", configs, (int)1800);
    }
}

