/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.security.controller;

import java.util.HashMap;
import java.util.Map;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.auth.impl.AuthHandleServiceFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.security.CertKeyUtil;
import kd.bos.openapi.security.model.CertificateInfo;
import kd.bos.openapi.security.model.Open3rdappsDto;

@ApiController(value="dev", desc="\u751f\u6210Key\u670d\u52a1")
@ApiMapping(value="/openapi/gen")
public class GeneratorKeyController {
    @ApiPostMapping(value="/rsaKey", desc="\u751f\u6210RSA\u7684\u79c1\u94a5\u548c\u516c\u94a5")
    public CustomApiResult<Map<String, String>> rsaKey() {
        Pair pair = AuthHandleServiceFactory.getCertServiceInstance().generatePairKey();
        HashMap<String, Object> rsaMap = new HashMap<String, Object>();
        rsaMap.put("prk", pair.getKey());
        rsaMap.put("puk", pair.getValue());
        return CustomApiResult.success(rsaMap);
    }

    @ApiPostMapping(value="/getBosRsaPublicKey", desc="\u83b7\u53d6\u5e73\u53f0RSA\u7684\u516c\u94a5")
    public CustomApiResult<Map<String, String>> getBosRsaPublicKey(@ApiParam(value="accountId") @ApiParam(value="accountId") String accountId, @ApiParam(value="thirdId") @ApiParam(value="thirdId") String thirdId) {
        Open3rdappsDto open3rdappsDto = ApiSecurityFactory.getApiSecurityService().getOpen3rdappsDtoBy(accountId, Long.valueOf(Long.parseLong(thirdId)));
        if (!open3rdappsDto.isSignAuthEnable()) {
            throw new OpenApiException(ApiErrorCode.ERROR, "rsaKey failed: signAuthEnable is false", new Object[0]);
        }
        if (open3rdappsDto.getSignType() == null) {
            throw new OpenApiException(ApiErrorCode.ERROR, "rsaKey failed: signType is null", new Object[0]);
        }
        CertificateInfo bosCertificateInfo = null;
        try {
            bosCertificateInfo = (CertificateInfo)open3rdappsDto.getCertMaps().get(CertKeyUtil.getCertKey((String)"5", (String)"0"));
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.ERROR, "rsaKey failed: error:" + e.getMessage(), new Object[0]);
        }
        HashMap<String, String> res = new HashMap<String, String>();
        String bosPubKey = bosCertificateInfo.getPublicKeyBase64();
        String deCodeBosPubKey = "";
        if (EncrypterFactory.getEncrypter().isEncrypted(bosPubKey)) {
            deCodeBosPubKey = EncrypterFactory.getEncrypter().decode(bosPubKey);
        }
        res.put("bosPublicKey", deCodeBosPubKey);
        return CustomApiResult.success(res);
    }
}

