/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.statusconvert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.openapi.api.BaseFilterApiService;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.openapi.api.params.BaseFilterParam;
import kd.bos.openapi.api.plugin.upper.ApiPlugin;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.api.result.BaseFilterItemData;
import kd.bos.openapi.api.result.BaseFilterResult;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.service.AbstractApiService;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.openapi.service.util.FilterUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public abstract class StatusConvertApiServiceImpl<P extends BaseFilterParam<? extends ApiPlugin>, R extends BaseFilterResult>
extends AbstractApiService<P, R>
implements BaseFilterApiService<P, R> {
    private String operationNumber;

    public ApiServiceData doExecute(P param) {
        Pair<Boolean, QFilter> qFilterPair = FilterUtil.getQFilters(param.getRequest().getServiceApiData().getUrl(), param);
        QFilter filter = this.getFilter(param, (QFilter)qFilterPair.getValue());
        if (filter == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RowStatusConvertApiServiceImpl_0", (String)"bos-open-service", (Object[])new Object[0]), new Object[0]);
        }
        Object[] filters = new QFilter[]{filter};
        FormConfig config = FormMetadataCache.getFormConfig((String)param.getFormId());
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)config.getEntityTypeId());
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)param.getFormId(), (QFilter[])filters, null, (int)Integer.MAX_VALUE);
        if (pkIds.isEmpty()) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u9700\u8981%1$s\u7684\u6570\u636e\uff0c\u8fc7\u6ee4\u6761\u4ef6\u4e3a%2$s", (String)"RowStatusConvertApiServiceImpl_1", (String)"bos-open-service", (Object[])new Object[0]), this.getRealOp(param.getOperationNumber()), Arrays.toString(filters)), new Object[0]);
        }
        long start = System.currentTimeMillis();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)this.getRealOp(param.getOperationNumber()), (String)dt.getName(), (Object[])pkIds.toArray(), (OperateOption)this.createOption(param));
        long end = System.currentTimeMillis();
        String selectFields = "id";
        boolean dbBillnoExist = StatusConvertApiServiceImpl.isDbBillnoExist(dt);
        if (dbBillnoExist) {
            selectFields = selectFields.concat(",").concat(dt.getBillNo());
        }
        DynamicObjectCollection returnFields = QueryServiceHelper.query((String)param.getFormId(), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        BaseFilterResult result = new BaseFilterResult();
        result.setSuccessCount((long)operationResult.getSuccessPkIds().size());
        result.setFailCount((long)(pkIds.size() - operationResult.getSuccessPkIds().size()));
        result.setFilter(Arrays.toString(filters));
        result.setTotalCount((long)pkIds.size());
        ArrayList<BaseFilterItemData> resultsData = new ArrayList<BaseFilterItemData>(pkIds.size());
        result.setResult(resultsData);
        Map map = operationResult.getAllErrorInfo().stream().filter(it -> StringUtil.isNotEmpty((String)it.getMessage()) && it.getPkValue() != null).collect(Collectors.groupingBy(it -> it.getPkValue().toString(), Collectors.mapping(OperateInfo::getMessage, Collectors.toSet())));
        for (Object pkId : pkIds) {
            Optional<Object> first;
            if (StringUtil.isNotEmpty((String)operationResult.getMessage())) {
                result.setMessage(operationResult.getMessage());
            }
            BaseFilterItemData data = new BaseFilterItemData();
            data.setId(pkId.toString());
            if (dbBillnoExist) {
                String sBillNo = returnFields.stream().filter(obj -> obj.get("id").equals(pkId)).findFirst().get().getString(dt.getBillNo());
                data.setNumber(sBillNo);
            }
            if ((first = operationResult.getSuccessPkIds().stream().filter(i -> i.equals(pkId)).findFirst()) == Optional.empty()) {
                for (IOperateInfo iOperateInfo : operationResult.getAllErrorOrValidateInfo().stream().filter(ev -> ev.getPkValue().equals(pkId)).collect(Collectors.toList())) {
                    data.getErrors().add(iOperateInfo.getMessage());
                }
            }
            data.setBillStatus(first != Optional.empty());
            Set set = map.get(pkId.toString());
            if (CollectionUtil.isNotEmpty(set)) {
                data.getErrors().addAll(set);
            }
            resultsData.add(data);
        }
        Set errorInfoSet = operationResult.getAllErrorInfo().stream().map(OperateInfo::getMessage).filter(StringUtil::isNotEmpty).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(errorInfoSet) && StringUtil.isEmpty((String)operationResult.getMessage())) {
            result.setMessage(errorInfoSet.toString());
        }
        if (pkIds.size() == operationResult.getSuccessPkIds().size()) {
            return ApiServiceData.of((boolean)operationResult.isSuccess(), (OpenApiResponse)ServiceApiContext.getResponse((Object)result), (long)(end - start));
        }
        return ApiServiceData.ofFalse((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)result.fetchFirstErrorMessage(), (OpenApiResponse)ServiceApiContext.getResponse((Object)result), (long)(end - start));
    }

    public void setOperationNumber(String operationNumber) {
        this.operationNumber = operationNumber;
    }

    public String getOperationNumber() {
        return this.operationNumber;
    }

    protected OperateOption createOption(P param) {
        Map optionVariables;
        OperateOption option = OperateOption.create();
        Object optionvariables = ((Map)param.getRequest().getData()).get("optionvariables");
        if (null != optionvariables && optionvariables instanceof Map && (optionVariables = (Map)optionvariables) != null) {
            for (Map.Entry entry : optionVariables.entrySet()) {
                option.setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        return option;
    }

    public String getRealOp(String op) {
        String opNum = this.getOperationNumber();
        return "$_COMMON_OP".equals(opNum) ? op : opNum;
    }

    protected QFilter getFilter(P param, QFilter originFilter) {
        return originFilter;
    }

    public static boolean isDbBillnoExist(BillEntityType dt) {
        String billNo = dt.getBillNo();
        if (StringUtil.isNotEmpty((String)billNo)) {
            String alias = dt.getProperty(billNo).getAlias();
            return StringUtil.isNotEmpty((String)alias);
        }
        return false;
    }
}

