/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.util;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.openapi.api.model.ServiceApiData;
import kd.bos.openapi.api.params.ApiParam;
import kd.bos.openapi.api.plugin.upper.ApiPlugin;
import kd.bos.openapi.base.dataservice.OpenApiDataUtil;
import kd.bos.openapi.base.model.ApiFilterModel;
import kd.bos.openapi.base.model.ApiModel;
import kd.bos.openapi.base.model.ApiRequestModel;
import kd.bos.openapi.base.model.BaseApiParamModel;
import kd.bos.openapi.base.script.OpenApiScriptUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.KHashMap;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.lang3.SerializationUtils;

public class FilterUtil {
    private static final String BOS_OPEN_SERVICE = "bos-open-service";
    private static final List<String> COMPARE_TYPE_IDS = Arrays.asList(CompareTypeEnum.EQUAL.getId(), CompareTypeEnum.NOTEQUAL.getId(), CompareTypeEnum.LIKE.getId(), CompareTypeEnum.NOTLIKE.getId(), CompareTypeEnum.LEFTLIKE.getId(), CompareTypeEnum.RIGHTLIKE.getId(), CompareTypeEnum.GREATER.getId(), CompareTypeEnum.LESS.getId(), CompareTypeEnum.GREATEROREQUAL.getId(), CompareTypeEnum.LESSOREQUAL.getId());

    public static Pair<Boolean, QFilter> getQFilters(String url, ApiParam<Map<String, Object>, ? extends ApiPlugin> apiParam) {
        Map reqData = (Map)apiParam.getRequest().getData();
        Map<String, Object> data = (Map<String, Object>)reqData.get("data");
        if (data == null) {
            data = Collections.emptyMap();
        }
        ApiModel apiModel = OpenApiDataUtil.getApiModelFromCache((String)url);
        Pair<Boolean, FilterBuilder> filterBuilderPair = FilterUtil.initFilterBuilder(apiModel, data);
        FilterBuilder filterBuilder = (FilterBuilder)filterBuilderPair.getValue();
        QFilter qFilter = null;
        if (filterBuilder != null && ((qFilter = filterBuilder.getQFilter()) == null || StringUtil.isEmpty((String)qFilter.getProperty()))) {
            qFilter = null;
        }
        QFilter orgFilter = null;
        long userId = RequestContext.get().getCurrUserId();
        ServiceApiData serviceApiData = apiParam.getRequest().getServiceApiData();
        if (apiModel.isOrgAuthorFilter()) {
            HasPermOrgResult allPermOrgs;
            String mainOrg = EntityMetadataCache.getDataEntityType((String)serviceApiData.getBizObject()).getMainOrg();
            if (StringUtil.isNotEmpty((String)mainOrg) && !(allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)serviceApiData.getAppRealId(), (String)serviceApiData.getBizObject(), (String)"47150e89000000ac")).hasAllOrgPerm() && CollectionUtil.isNotEmpty((Collection)allPermOrgs.getHasPermOrgs())) {
                orgFilter = new QFilter(mainOrg, "in", (Object)allPermOrgs.getHasPermOrgs());
            }
            QFilter oFilter = PermissionServiceHelper.getDataPermWithOrg((long)userId, (String)serviceApiData.getAppRealId(), (String)serviceApiData.getBizObject());
            if (orgFilter != null) {
                if (oFilter != null && StringUtil.isNotEmpty((String)oFilter.getProperty())) {
                    orgFilter = orgFilter.and(oFilter);
                }
            } else {
                orgFilter = oFilter;
            }
        }
        if (orgFilter != null && StringUtil.isNotEmpty((String)orgFilter.getProperty())) {
            qFilter = qFilter == null ? orgFilter : orgFilter.and(qFilter);
        }
        return new Pair(filterBuilderPair.getKey(), (Object)qFilter);
    }

    private static Pair<Boolean, FilterBuilder> initFilterBuilder(ApiModel apiModel, Map<String, Object> data) {
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)apiModel.getFormId());
        Pair<Boolean, FilterCondition> filterCondition = FilterUtil.getFilterCondition(apiModel, data);
        FilterBuilder filterBuilder = new FilterBuilder(dataType, (FilterCondition)filterCondition.getValue());
        filterBuilder.buildFilter(true);
        return new Pair(filterCondition.getKey(), (Object)filterBuilder);
    }

    private static Pair<Boolean, FilterCondition> getFilterCondition(ApiModel apiModel, Map<String, Object> data) {
        FilterCondition filterCondition = new FilterCondition();
        Pair<Boolean, List<SimpleFilterRow>> simpleFilterRow = FilterUtil.getSimpleFilterRow(apiModel, data);
        filterCondition.setFilterRow((List)simpleFilterRow.getValue());
        return new Pair(simpleFilterRow.getKey(), (Object)filterCondition);
    }

    private static Pair<Boolean, List<SimpleFilterRow>> getSimpleFilterRow(ApiModel apiModel, Map<String, Object> data) {
        Map<String, ApiRequestModel> varParamMap = apiModel.getRequestList().stream().collect(Collectors.toMap(BaseApiParamModel::getPropName, Function.identity()));
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)apiModel.getFormId());
        Set set = type.getAllEntities().keySet();
        boolean filterHasEntry = false;
        List filterList = apiModel.getFilterList();
        LinkedList<SimpleFilterRow> rows = new LinkedList<SimpleFilterRow>();
        String downLeftBracket = "";
        for (ApiFilterModel model : filterList) {
            List<FilterValue> value = FilterUtil.getValue(model, data, varParamMap);
            if (value == null) {
                downLeftBracket = FilterUtil.handleBracket(rows, model, downLeftBracket);
                continue;
            }
            String fieldName = model.getFieldName();
            if (!filterHasEntry && fieldName.contains(".") && set.contains(fieldName.substring(0, fieldName.indexOf(46)))) {
                filterHasEntry = true;
            }
            SimpleFilterRow row = new SimpleFilterRow();
            row.setEntityNumber(model.getEntityNumber());
            row.setLeftBracket(model.getLeftBracket() + downLeftBracket);
            row.setFieldName(fieldName);
            row.setCompareType(model.getCompareType());
            FilterUtil.checkValue(fieldName, model.getCompareType(), value);
            row.setValue(value);
            row.setRightBracket(model.getRightBracket());
            row.setLogic(model.getLogic());
            rows.add(row);
            downLeftBracket = "";
        }
        return new Pair((Object)filterHasEntry, rows);
    }

    private static String handleBracket(LinkedList<SimpleFilterRow> rows, ApiFilterModel model, String downLeftBracket) {
        String rightBracket;
        String leftBracket = model.getLeftBracket();
        if (leftBracket == null) {
            leftBracket = "";
        }
        if ((rightBracket = model.getRightBracket()) == null) {
            rightBracket = "";
        }
        if (leftBracket.length() == rightBracket.length()) {
            return downLeftBracket;
        }
        if (leftBracket.length() > rightBracket.length()) {
            return downLeftBracket + leftBracket.substring(0, leftBracket.length() - rightBracket.length());
        }
        String upRightBracket = rightBracket.substring(0, rightBracket.length() - leftBracket.length());
        if (downLeftBracket.length() == upRightBracket.length()) {
            return "";
        }
        if (downLeftBracket.length() > upRightBracket.length()) {
            return downLeftBracket.substring(0, downLeftBracket.length() - upRightBracket.length());
        }
        upRightBracket = upRightBracket.substring(0, upRightBracket.length() - downLeftBracket.length());
        if (rows.isEmpty()) {
            return "";
        }
        rows.getLast().setRightBracket(rows.getLast().getRightBracket() + upRightBracket);
        return "";
    }

    public static void checkValue(String fieldName, String type, List<FilterValue> value) {
        if (COMPARE_TYPE_IDS.contains(type) && value.size() > 1) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5 %s \u6bd4\u8f83\u65b9\u5f0f\u7684\u503c\u4e0d\u80fd\u662f\u6570\u7ec4\u3002", (String)"FilterUtil_0", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{fieldName});
        }
    }

    private static List<FilterValue> getValue(ApiFilterModel filterModel, Map<String, Object> data, Map<String, ApiRequestModel> varParamMap) {
        ArrayList<FilterValue> list = new ArrayList<FilterValue>(data.size());
        Object constantValue = filterModel.getConstantValue();
        if (constantValue != null) {
            return FilterUtil.getConstantFilterValues(list, constantValue, data, filterModel);
        }
        return FilterUtil.getVarFilterValues(filterModel, data, varParamMap, list);
    }

    private static List<FilterValue> getConstantFilterValues(List<FilterValue> list, Object constantValue, Map<String, Object> data, ApiFilterModel filterModel) {
        if (FilterUtil.ignoneFilter(constantValue)) {
            return null;
        }
        if (constantValue instanceof Collection) {
            Collection jsonArray = (Collection)constantValue;
            for (Object o : jsonArray) {
                list.add(FilterUtil.getFilterValue(o));
            }
        } else {
            if (OpenApiScriptUtil.isExprScript((Object)constantValue)) {
                String str = (String)constantValue;
                Object value = null;
                try {
                    value = OpenApiScriptUtil.handleExpr((String)str, (Map)((Map)((Object)SerializationUtils.clone((Serializable)KHashMap.create().setAll(data)))));
                }
                catch (Exception e) {
                    throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5\u3010{0}\u3011\u7684\u6bd4\u8f83\u5e38\u91cf\u3010{1}\u3011\u503c\u89e3\u6790\u5931\u8d25\u3002", (String)"FilterUtil_5", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{filterModel.getFieldName(), str});
                }
                if (value == null) {
                    throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5\u3010{0}\u3011\u7684\u6bd4\u8f83\u5e38\u91cf\u3010{1}\u3011\u89e3\u6790\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterUtil_6", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{filterModel.getFieldName(), str});
                }
                if (value instanceof String && StringUtil.isEmpty((String)((String)value))) {
                    throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5\u3010{0}\u3011\u7684\u6bd4\u8f83\u5e38\u91cf\u3010{1}\u3011\u89e3\u6790\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterUtil_6", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{filterModel.getFieldName(), str});
                }
                if (FilterUtil.ignoneFilter(value)) {
                    return null;
                }
                if (value instanceof Date) {
                    value = DateUtil.convertToStr((String)"yyyy-MM-dd HH:mm:ss", (Date)((Date)value));
                } else if (value instanceof LocalDateTime) {
                    value = ((LocalDateTime)value).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                } else if (value instanceof LocalDate) {
                    value = ((LocalDate)value).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                }
                return FilterUtil.getConstantFilterValues(list, value, null, filterModel);
            }
            list.add(FilterUtil.getFilterValue(constantValue));
        }
        return list;
    }

    private static FilterValue getFilterValue(Object value) {
        FilterValue filterValue = new FilterValue();
        filterValue.setValue(value instanceof String ? value : DataUtil.s((Object)value));
        return filterValue;
    }

    private static List<FilterValue> getVarFilterValues(ApiFilterModel filterModel, Map<String, Object> data, Map<String, ApiRequestModel> varParamMap, List<FilterValue> list) {
        String filterValueVar = filterModel.getFilterValue();
        if (StringUtils.isEmpty((String)filterValueVar)) {
            return list;
        }
        ApiRequestModel model = varParamMap.get(filterValueVar);
        if (model == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53d8\u91cf\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", (String)"FilterUtil_1", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{filterValueVar});
        }
        Object objValue = data.get(model.getParamName());
        if (objValue == null || objValue instanceof String && StringUtil.isEmpty((String)((String)objValue))) {
            objValue = model.getParamDefaultValue();
        }
        if (objValue == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u3010%s\u3011\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterUtil_2", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{model.getParamName()});
        }
        if (FilterUtil.ignoneFilter(objValue)) {
            return null;
        }
        if (objValue instanceof String) {
            String strValue = (String)objValue;
            if (StringUtils.isEmpty((String)strValue)) {
                throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u3010%s\u3011\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterUtil_2", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{model.getParamName()});
            }
            list.add(FilterUtil.getFilterValue(strValue, model));
        } else if (objValue instanceof Collection) {
            Collection jsonArray = (Collection)objValue;
            if (jsonArray.isEmpty()) {
                throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u3010%s\u3011\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterUtil_2", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{model.getParamName()});
            }
            for (Object o : jsonArray) {
                list.add(FilterUtil.getFilterValue(o, model));
            }
        } else if (objValue instanceof Object[]) {
            Object[] array = (Object[])objValue;
            if (array.length == 0) {
                throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u3010%s\u3011\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterUtil_2", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{model.getParamName()});
            }
            for (Object o : array) {
                list.add(FilterUtil.getFilterValue(o, model));
            }
        } else {
            list.add(FilterUtil.getFilterValue(objValue, model));
        }
        return list;
    }

    private static boolean ignoneFilter(Object objValue) {
        return "*".equals(objValue);
    }

    private static FilterValue getFilterValue(Object value, ApiRequestModel model) {
        FilterValue filterValue = new FilterValue();
        Object val = value;
        try {
            DataType type = DataType.getByType((String)model.getParamType());
            type.validator(value);
            switch (type) {
                case FLEX: 
                case ENTRIES: {
                    throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u53c2\u6570\u7c7b\u578b\uff1a %s\u3002", (String)"FilterUtil_3", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), new Object[]{type.type()});
                }
                case ARRAY_DATE: 
                case ARRAY_STRING: 
                case ARRAY_INTEGER: 
                case ARRAY_LONG: {
                    if (!(val instanceof List)) break;
                    List list = (List)val;
                    if (CollectionUtil.isEmpty((Collection)list)) {
                        val = null;
                        break;
                    }
                    val = list.get(0);
                    break;
                }
            }
        }
        catch (OpenApiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u53c2\u6570\u3010%1$s\u3011\u7684\u7c7b\u578b\u4e3a %2$s\uff0c\u4f20\u5165\u503c\u8f6c\u6362\u5931\u8d25\u3002", (String)"FilterUtil_4", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), model.getParamName(), model.getParamType()), new Object[0]);
        }
        filterValue.setValue((Object)DataUtil.s3((Object)val));
        return filterValue;
    }
}

