/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.webservice.custom;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.custom.info.CustomApiInfo;
import kd.bos.openapi.base.custom.info.CustomApiParam;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.wsdl.SoapUtil;
import kd.bos.openapi.service.webservice.constant.OpenWSDLConstants;
import kd.bos.openapi.service.webservice.util.SchemaGeneratorUtil;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PolicyLocator;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistryImpl;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;

public class AxisCustomService2WSDL11
implements Java2WSDLConstants {
    private static final Log log = LogFactory.getLog(AxisCustomService2WSDL11.class);
    protected AxisService axisService;
    protected String serviceName;
    private String targetNamespace;
    private OMElement definition;
    private OMNamespace soap;
    private OMNamespace soap12;
    private OMNamespace http;
    private OMNamespace mime;
    private OMNamespace tns;
    private OMNamespace wsdl;
    private OMNamespace wsaw;
    private String style = "document";
    private String use = "literal";
    private Map<String, Policy> policiesInDefinitions;
    private ExternalPolicySerializer serializer;
    private HashMap messagesMap;
    private boolean checkIfEndPointActive = true;
    private CustomApiInfo customApiInfo;

    public AxisCustomService2WSDL11() {
    }

    public AxisCustomService2WSDL11(AxisService service, CustomApiInfo customApiInfo) throws OpenApiException {
        this.axisService = service;
        this.serviceName = service.getName();
        this.customApiInfo = customApiInfo;
        this.init();
    }

    public void setCheckIfEndPointActive(boolean flag) {
        this.checkIfEndPointActive = flag;
    }

    protected final void init() throws OpenApiException {
        this.targetNamespace = this.axisService.getTargetNamespace();
        this.serializer = new ExternalPolicySerializer();
        AxisConfiguration configuration = this.axisService.getAxisConfiguration();
        if (configuration != null) {
            this.serializer.setAssertionsToFilter(configuration.getLocalPolicyAssertions());
        }
    }

    public OMElement generateOM() throws OpenApiException {
        OMElement types;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement definition = this.generateDefinition(fac);
        OMElement documentation = this.generateDocumentation(fac);
        if (documentation != null) {
            definition.addChild((OMNode)documentation);
        }
        if ((types = this.generateCustomTypes(fac)) != null) {
            definition.addChild((OMNode)types);
        }
        List<OMElement> messages = this.generateCustomMessages(fac);
        for (OMElement message : messages) {
            if (message == null) continue;
            definition.addChild((OMNode)message);
        }
        OMElement portType = this.generateCustomPortType(fac);
        definition.addChild((OMNode)portType);
        if (!this.isDisableSOAP11()) {
            definition.addChild((OMNode)portType);
        }
        this.generateService(fac, definition, this.isDisableREST(), this.isDisableSOAP12(), this.isDisableSOAP11());
        this.addPoliciesToDefinitionElement(this.policiesInDefinitions.values().iterator(), definition);
        return definition;
    }

    protected List<OMElement> generateCustomMessages(OMFactory fac) {
        String input = this.customApiInfo.getInputParamsName();
        String output = this.customApiInfo.getOutputParamsName();
        HashSet<String> faultMessageNames = new HashSet<String>();
        ArrayList<OMElement> messageList = new ArrayList<OMElement>();
        this.messagesMap = new HashMap();
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList<AxisMessage> faultyMessages;
            AxisMessage outAxisMessage;
            OMElement messagePart;
            OMElement messageElement;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation()) continue;
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null && StringUtil.isNotEmpty((String)input)) {
                messageElement = fac.createOMElement("message", this.wsdl);
                messageElement.addAttribute("name", input, null);
                messagePart = fac.createOMElement("part", this.wsdl);
                messageElement.addChild((OMNode)messagePart);
                messagePart.addAttribute("name", input, null);
                messagePart.addAttribute("element", this.axisService.getSchemaTargetNamespacePrefix() + ":" + input, null);
                messageList.add(messageElement);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null && StringUtil.isNotEmpty((String)output)) {
                messageElement = fac.createOMElement("message", this.wsdl);
                messageElement.addAttribute("name", output, null);
                messagePart = fac.createOMElement("part", this.wsdl);
                messageElement.addChild((OMNode)messagePart);
                messagePart.addAttribute("name", output, null);
                messagePart.addAttribute("element", this.axisService.getSchemaTargetNamespacePrefix() + ":" + output, null);
                messageList.add(messageElement);
            }
            if ((faultyMessages = this.extractWSDL11FaultMessages(axisOperation)) == null) continue;
            for (AxisMessage faultyMessage : faultyMessages) {
                String name = faultyMessage.getName();
                if (!faultMessageNames.add(name)) continue;
                messageList.add(this.writeMessage(faultyMessage, fac));
                messageList.add(this.generateHeaderMessages(faultyMessage, fac));
            }
        }
        return messageList;
    }

    private boolean isWSDL11FaultyMessagesValidForMEP(String mepURI) {
        return !"http://www.w3.org/ns/wsdl/in-only".equals(mepURI) && !"http://www.w3.org/ns/wsdl/robust-in-only".equals(mepURI);
    }

    private ArrayList<AxisMessage> extractWSDL11FaultMessages(AxisOperation axisOperation) {
        String mepURI = axisOperation.getMessageExchangePattern();
        if (this.isWSDL11FaultyMessagesValidForMEP(mepURI)) {
            return axisOperation.getFaultMessages();
        }
        return new ArrayList<AxisMessage>();
    }

    private ArrayList<AxisBindingMessage> extractWSDL11FaultMessages(AxisBindingOperation axisBindingOperation) {
        String mepURI = axisBindingOperation.getAxisOperation().getMessageExchangePattern();
        if (this.isWSDL11FaultyMessagesValidForMEP(mepURI)) {
            return axisBindingOperation.getFaults();
        }
        return new ArrayList<AxisBindingMessage>();
    }

    private OMElement generateHeaderMessages(AxisMessage axismessage, OMFactory fac) {
        ArrayList extList = axismessage.getSoapHeaders();
        if (CollectionUtil.isEmpty((Collection)extList)) {
            return null;
        }
        OMElement messageElement = null;
        for (int i = 0; i < extList.size(); ++i) {
            Object anExtList = extList.get(i);
            SOAPHeaderMessage header = (SOAPHeaderMessage)anExtList;
            messageElement = fac.createOMElement("message", this.wsdl);
            messageElement.addAttribute("name", header.getMessage().getLocalPart(), null);
            OMElement messagePart = fac.createOMElement("part", this.wsdl);
            messageElement.addChild((OMNode)messagePart);
            messagePart.addAttribute("name", header.part(), null);
            if (header.getElement() == null) {
                throw new RuntimeException("element is null for " + header.getMessage());
            }
            messagePart.addAttribute("element", WSDLSerializationUtil.getPrefix((String)header.getElement().getNamespaceURI(), (Map)this.axisService.getNamespaceMap()) + ":" + header.getElement().getLocalPart(), null);
            if (i == 0) break;
        }
        return messageElement;
    }

    private OMElement writeMessage(AxisMessage axismessage, OMFactory fac) {
        if (axismessage.getName() != null && this.messagesMap.get(axismessage.getName()) == null) {
            this.messagesMap.put(axismessage.getName(), axismessage);
            QName schemaElementName = axismessage.getElementQName();
            OMElement messageElement = fac.createOMElement("message", this.wsdl);
            messageElement.addAttribute("name", axismessage.getName(), null);
            if (schemaElementName != null) {
                OMElement messagePart = fac.createOMElement("part", this.wsdl);
                messageElement.addChild((OMNode)messagePart);
                if (axismessage.getMessagePartName() != null) {
                    messagePart.addAttribute("name", axismessage.getMessagePartName(), null);
                } else {
                    messagePart.addAttribute("name", axismessage.getPartName(), null);
                }
                messagePart.addAttribute("element", WSDLSerializationUtil.getPrefix((String)schemaElementName.getNamespaceURI(), (Map)this.axisService.getNamespaceMap()) + ":" + schemaElementName.getLocalPart(), null);
            }
            return messageElement;
        }
        return null;
    }

    protected OMElement generateCustomPortType(OMFactory fac) throws OpenApiException {
        String inputName = this.customApiInfo.getInputParamsName();
        String outputName = this.customApiInfo.getOutputParamsName();
        OMElement portType = fac.createOMElement("portType", this.wsdl);
        String portTypeName = this.serviceName + "PortType";
        Parameter param = this.axisService.getParameter("portTypeName");
        if (param != null) {
            portTypeName = (String)param.getValue();
        }
        portType.addAttribute("name", portTypeName, null);
        this.addPolicyAsExtAttribute((AxisDescription)this.axisService, portType, fac);
        Iterator operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList<AxisMessage> faultMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String operationName = this.serviceName;
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)axisOperation, (OMElement)operation, (OMFactory)fac, (OMNamespace)this.wsdl);
            portType.addChild((OMNode)operation);
            operation.addAttribute("name", operationName, null);
            this.addPolicyAsExtAttribute((AxisDescription)axisOperation, operation, fac);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null && StringUtil.isNotEmpty((String)inputName)) {
                OMElement input = fac.createOMElement("input", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)inaxisMessage, (OMElement)input, (OMFactory)fac, (OMNamespace)this.wsdl);
                input.addAttribute("message", this.tns.getPrefix() + ":" + inputName, null);
                this.addPolicyAsExtAttribute((AxisDescription)inaxisMessage, input, fac);
                WSDLSerializationUtil.addWSAWActionAttribute((OMElement)input, (String)axisOperation.getInputAction(), (OMNamespace)this.wsaw);
                operation.addChild((OMNode)input);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null && StringUtil.isNotEmpty((String)outputName)) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)outAxisMessage, (OMElement)output, (OMFactory)fac, (OMNamespace)this.wsdl);
                output.addAttribute("message", this.tns.getPrefix() + ":" + outputName, null);
                this.addPolicyAsExtAttribute((AxisDescription)outAxisMessage, output, fac);
                WSDLSerializationUtil.addWSAWActionAttribute((OMElement)output, (String)axisOperation.getOutputAction(), (OMNamespace)this.wsaw);
                operation.addChild((OMNode)output);
            }
            if ((faultMessages = this.extractWSDL11FaultMessages(axisOperation)) == null) continue;
            for (AxisMessage faultMessage : faultMessages) {
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)faultMessage, (OMElement)fault, (OMFactory)fac, (OMNamespace)this.wsdl);
                fault.addAttribute("message", this.tns.getPrefix() + ":" + faultMessage.getName(), null);
                fault.addAttribute("name", faultMessage.getName(), null);
                WSDLSerializationUtil.addWSAWActionAttribute((OMElement)fault, (String)axisOperation.getFaultAction(faultMessage.getName()), (OMNamespace)this.wsaw);
                operation.addChild((OMNode)fault);
            }
        }
        return portType;
    }

    public OMElement generateService(OMFactory fac, OMElement defintions, boolean disableREST, boolean disableSOAP12, boolean disableSOAP11) throws OpenApiException {
        OMElement service = fac.createOMElement("service", this.wsdl);
        defintions.addChild((OMNode)service);
        service.addAttribute("name", this.serviceName, null);
        if (!disableSOAP11) {
            this.generateSoap11Port(fac, defintions, service);
        }
        if (!disableSOAP12) {
            this.generateSoap12Port(fac, defintions, service);
        }
        this.addPolicyAsExtElement(6, this.axisService.getPolicySubject(), service);
        if (!disableREST) {
            this.generateHttpPort(fac, this.definition, service);
        }
        return service;
    }

    private void writeSoapHeaders(AxisMessage inaxisMessage, OMFactory fac, OMElement input, OMNamespace soapNameSpace) throws OpenApiException {
        ArrayList extElementList = inaxisMessage.getSoapHeaders();
        if (extElementList != null) {
            for (SOAPHeaderMessage soapheader : extElementList) {
                this.addSOAPHeader(fac, input, soapheader, soapNameSpace);
            }
        }
    }

    private void addExtensionElement(OMFactory fac, OMElement element, String name, String att1Name, String att1Value, String att2Name, String att2Value, OMNamespace soapNameSpace) {
        OMElement soapbinding = fac.createOMElement(name, soapNameSpace);
        element.addChild((OMNode)soapbinding);
        soapbinding.addAttribute(att1Name, att1Value, null);
        if (att2Name != null) {
            soapbinding.addAttribute(att2Name, att2Value, null);
        }
    }

    private void setDefinitionElement(OMElement defintion) {
        this.definition = defintion;
    }

    private void addSOAPHeader(OMFactory fac, OMElement element, SOAPHeaderMessage header, OMNamespace soapNameSpace) {
        OMElement extElement = fac.createOMElement("header", soapNameSpace);
        element.addChild((OMNode)extElement);
        String use = header.getUse();
        if (use != null) {
            extElement.addAttribute("use", use, null);
        }
        if (header.part() != null) {
            extElement.addAttribute("part", header.part(), null);
        }
        if (header.getMessage() != null) {
            extElement.addAttribute("message", WSDLSerializationUtil.getPrefix((String)this.targetNamespace, (Map)this.axisService.getNamespaceMap()) + ":" + header.getMessage().getLocalPart(), null);
        }
    }

    private OMElement getPolicyComponentAsOMElement(Object policyElement, boolean hasSerializer) throws OpenApiException {
        try {
            if (hasSerializer) {
                return PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)((PolicyComponent)policyElement), (ExternalPolicySerializer)this.serializer);
            }
            return PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)((PolicyComponent)policyElement));
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "wsdl/getPolicyComponentAsOMElement:" + e.getMessage(), new Object[0]);
        }
    }

    private void addPolicyAsExtElement(int type, PolicySubject policySubject, OMElement parentElement) throws OpenApiException {
        Collection elementList = policySubject.getAttachedPolicyComponents();
        for (Object policyElement : elementList) {
            Policy p;
            OMElement child;
            if (policyElement instanceof Policy) {
                child = this.getPolicyComponentAsOMElement(policyElement, true);
                parentElement.addChild((OMNode)child);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            child = this.getPolicyComponentAsOMElement(policyElement, false);
            OMElement firstChildElem = parentElement.getFirstElement();
            if (firstChildElem == null) {
                parentElement.addChild((OMNode)child);
            } else {
                firstChildElem.insertSiblingBefore((OMNode)child);
            }
            PolicyRegistryImpl reg = new PolicyRegistryImpl();
            String key = ((PolicyReference)policyElement).getURI();
            if (key.startsWith("#")) {
                key = key.substring(key.indexOf("#") + 1);
            }
            if ((p = reg.lookup(key)) == null) {
                throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "Policy cannot be found, the uri is" + key, new Object[0]);
            }
            this.addPolicyToDefinitionElement(key, p);
        }
    }

    protected void addPoliciesToDefinitionElement(Iterator iterator, OMElement definitionElement) throws OpenApiException {
        while (iterator.hasNext()) {
            Policy policy = (Policy)iterator.next();
            OMElement policyElement = this.getPolicyComponentAsOMElement(policy, true);
            OMNode firstChild = this.definition.getFirstOMChild();
            if (firstChild != null) {
                firstChild.insertSiblingBefore((OMNode)policyElement);
                continue;
            }
            definitionElement.addChild((OMNode)policyElement);
        }
    }

    private void addPolicyToDefinitionElement(String key, Policy policy) {
        this.policiesInDefinitions.put(key, policy);
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    private void generateSoap11Port(OMFactory fac, OMElement definition, OMElement service) throws OpenApiException {
        for (AxisEndpoint axisEndpoint : this.axisService.getEndpoints().values()) {
            String version;
            AxisBinding axisBinding;
            String type;
            if (this.checkIfEndPointActive && !axisEndpoint.isActive() || !"http://schemas.xmlsoap.org/soap/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType()) && !"http://www.w3.org/ns/wsdl/soap".equals(type) || !"http://schemas.xmlsoap.org/soap/envelope/".equals(version = (String)axisBinding.getProperty("wsoap:version"))) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)port, (String)"address", (String)"location", (String)(endpointURL == null ? "" : endpointURL), (OMNamespace)this.soap);
            this.generateEPRElement(axisEndpoint, fac, port, endpointURL);
            this.addPolicyAsExtElement((AxisDescription)axisEndpoint, port);
            service.addChild((OMNode)this.modifyPort(port));
            if (this.isAlreadyAdded(axisBinding, definition)) {
                return;
            }
            OMElement binding = this.generateSoap11Binding(fac, axisEndpoint.getBinding());
            OMElement serviceElement = definition.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
            serviceElement.insertSiblingBefore((OMNode)this.modifyBinding(binding));
        }
    }

    private void generateSoap12Port(OMFactory fac, OMElement definition, OMElement service) throws OpenApiException {
        for (AxisEndpoint axisEndpoint : this.axisService.getEndpoints().values()) {
            String version;
            AxisBinding axisBinding;
            String type;
            if (this.checkIfEndPointActive && !axisEndpoint.isActive() || !"http://schemas.xmlsoap.org/soap/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType()) && !"http://www.w3.org/ns/wsdl/soap".equals(type) || !"http://www.w3.org/2003/05/soap-envelope".equals(version = (String)axisBinding.getProperty("wsoap:version"))) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)port, (String)"address", (String)"location", (String)(endpointURL == null ? "" : endpointURL), (OMNamespace)this.soap12);
            this.generateEPRElement(axisEndpoint, fac, port, endpointURL);
            this.addPolicyAsExtElement((AxisDescription)axisEndpoint, port);
            service.addChild((OMNode)this.modifyPort(port));
            if (this.isAlreadyAdded(axisBinding, definition)) {
                return;
            }
            OMElement binding = this.generateSoap12Binding(fac, definition, axisEndpoint.getBinding());
            service.insertSiblingBefore((OMNode)this.modifyBinding(binding));
        }
    }

    private void generateHttpPort(OMFactory fac, OMElement definition, OMElement service) throws OpenApiException {
        for (AxisEndpoint axisEndpoint : this.axisService.getEndpoints().values()) {
            AxisBinding axisBinding;
            String type;
            if (this.checkIfEndPointActive && !axisEndpoint.isActive() || !"http://www.w3.org/ns/wsdl/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType())) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            OMElement extElement = fac.createOMElement("address", this.http);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            extElement.addAttribute("location", endpointURL == null ? "" : endpointURL, null);
            port.addChild((OMNode)extElement);
            this.addPolicyAsExtElement((AxisDescription)axisEndpoint, port);
            service.addChild((OMNode)this.modifyPort(port));
            if (this.isAlreadyAdded(axisBinding, definition)) {
                return;
            }
            OMElement binding = this.generateHttpBinding(fac, definition, axisEndpoint.getBinding());
            service.insertSiblingBefore((OMNode)this.modifyBinding(binding));
        }
    }

    protected OMElement generateSoap11Binding(OMFactory fac, AxisBinding axisBinding) throws OpenApiException {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        String portTypeName = this.serviceName + "PortType";
        Parameter param = this.axisService.getParameter("portTypeName");
        if (param != null) {
            portTypeName = (String)param.getValue();
        }
        binding.addAttribute("type", this.tns.getPrefix() + ":" + portTypeName, null);
        this.addPolicyAsExtElement((AxisDescription)axisBinding, binding);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap);
        if (AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)this.axisService).equals("optional")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"false", (OMNamespace)this.wsaw);
        } else if (AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)this.axisService).equals("required")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"true", (OMNamespace)this.wsaw);
        }
        Iterator axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            ArrayList<AxisBindingMessage> faultyMessages;
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = this.serviceName;
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            String soapAction = axisOperation.getSoapAction();
            if ("urn:route".equalsIgnoreCase(soapAction)) {
                soapAction = "urn:" + this.serviceName;
            }
            if (soapAction == null) {
                soapAction = "";
            }
            this.addPolicyAsExtElement((AxisDescription)axisBindingOperation, operation);
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)axisBindingInMessage, input);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap);
                operation.addChild((OMNode)input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap12);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"Out")) != null && (outAxisMessage = axisBindingOutMessage.getAxisMessage()) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)axisBindingOutMessage, output);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap);
                operation.addChild((OMNode)output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap12);
            }
            if ((faultyMessages = this.extractWSDL11FaultMessages(axisBindingOperation)) == null) continue;
            for (AxisBindingMessage faultyMessage1 : faultyMessages) {
                AxisBindingMessage bindingFaultyMessage = faultyMessage1;
                if (bindingFaultyMessage == null) continue;
                AxisMessage faultyMessage = bindingFaultyMessage.getAxisMessage();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)bindingFaultyMessage, fault);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild((OMNode)fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap);
            }
        }
        return binding;
    }

    private OMElement generateSoap12Binding(OMFactory fac, OMElement definitions, AxisBinding axisBinding) throws OpenApiException {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        OMElement serviceElement = definitions.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        String portTypeName = this.serviceName + "PortType";
        Parameter param = this.axisService.getParameter("portTypeName");
        if (param != null) {
            portTypeName = (String)param.getValue();
        }
        binding.addAttribute("type", this.tns.getPrefix() + ":" + portTypeName, null);
        this.addPolicyAsExtElement((AxisDescription)axisBinding, binding);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap12);
        if (AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)this.axisService).equals("optional")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"false", (OMNamespace)this.wsaw);
        } else if (AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)this.axisService).equals("required")) {
            WSDLSerializationUtil.addExtensionElement((OMFactory)fac, (OMElement)binding, (String)"UsingAddressing", (String)"wsdl:required", (String)"true", (OMNamespace)this.wsaw);
        }
        Iterator axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            ArrayList<AxisBindingMessage> faultyMessages;
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = this.serviceName;
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            String soapAction = axisOperation.getSoapAction();
            if ("urn:route".equalsIgnoreCase(soapAction)) {
                soapAction = "urn:" + this.serviceName;
            }
            if (soapAction == null) {
                soapAction = "";
            }
            this.addPolicyAsExtElement((AxisDescription)axisBindingOperation, operation);
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap12);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)axisBindingInMessage, input);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                operation.addChild((OMNode)input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap12);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"Out")) != null && (outAxisMessage = axisBindingOutMessage.getAxisMessage()) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)axisBindingOutMessage, output);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                operation.addChild((OMNode)output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap12);
            }
            if ((faultyMessages = this.extractWSDL11FaultMessages(axisBindingOperation)) == null) continue;
            for (AxisBindingMessage faultyMessage1 : faultyMessages) {
                AxisBindingMessage bindingFaultyMessage = faultyMessage1;
                if (bindingFaultyMessage == null) continue;
                AxisMessage faultyMessage = bindingFaultyMessage.getAxisMessage();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addPolicyAsExtElement((AxisDescription)bindingFaultyMessage, fault);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap12);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild((OMNode)fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap12);
            }
        }
        return binding;
    }

    private OMElement generateHttpBinding(OMFactory fac, OMElement definitions, AxisBinding axisBinding) throws OpenApiException {
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        OMElement serviceElement = definitions.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        String portTypeName = this.serviceName + "PortType";
        Parameter param = this.axisService.getParameter("portTypeName");
        if (param != null) {
            portTypeName = (String)param.getValue();
        }
        binding.addAttribute("type", this.tns.getPrefix() + ":" + portTypeName, null);
        OMElement httpBinding = fac.createOMElement("binding", this.http);
        binding.addChild((OMNode)httpBinding);
        httpBinding.addAttribute("verb", "POST", null);
        Iterator axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            ArrayList faultyMessages;
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            OMElement httpOperation = fac.createOMElement("operation", this.http);
            operation.addChild((OMNode)httpOperation);
            String location = (String)axisBindingOperation.getProperty("whttp:location");
            location = location.replace('{', '(');
            location = location.replace('}', ')');
            httpOperation.addAttribute("location", location, null);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                OMElement inputelement = fac.createOMElement("content", this.mime);
                input.addChild((OMNode)inputelement);
                String inputType = (String)axisBindingOperation.getProperty("whttp:inputSerialization");
                inputelement.addAttribute("type", inputType != null ? inputType : "application/xml", null);
                inputelement.addAttribute("part", inaxisMessage.getPartName(), null);
                operation.addChild((OMNode)input);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild((Object)"Out")) != null && (outAxisMessage = axisBindingOutMessage.getAxisMessage()) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                OMElement outElement = fac.createOMElement("content", this.mime);
                String outputType = (String)axisBindingOperation.getProperty("whttp:outputSerialization");
                outElement.addAttribute("type", outputType != null ? outputType : "application/xml", null);
                outElement.addAttribute("part", outAxisMessage.getPartName(), null);
                output.addChild((OMNode)outElement);
                operation.addChild((OMNode)output);
            }
            if ((faultyMessages = axisBindingOperation.getFaults()) == null) continue;
            for (Object faultyMessage1 : faultyMessages) {
                AxisBindingMessage bindingFaultyMessage = (AxisBindingMessage)faultyMessage1;
                if (bindingFaultyMessage == null) continue;
                AxisMessage faultyMessage = bindingFaultyMessage.getAxisMessage();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild((OMNode)fault);
            }
        }
        return binding;
    }

    private void addPolicyAsExtElement(AxisDescription axisDescription, OMElement wsdlElement) throws OpenApiException {
        PolicySubject policySubject = axisDescription.getPolicySubject();
        Collection attachPolicyComponents = policySubject.getAttachedPolicyComponents();
        for (Object policyElement : attachPolicyComponents) {
            PolicyLocator locator;
            Policy p;
            if (policyElement instanceof Policy) {
                PolicyReference policyReference = PolicyUtil.createPolicyReference((Policy)((Policy)policyElement));
                OMElement policyRefElement = this.getPolicyComponentAsOMElement(policyReference, true);
                OMElement firstChildElem = wsdlElement.getFirstElement();
                if (firstChildElem == null) {
                    wsdlElement.addChild((OMNode)policyRefElement);
                } else {
                    firstChildElem.insertSiblingBefore((OMNode)policyRefElement);
                }
                String key = policyReference.getURI();
                if (key.startsWith("#")) {
                    key = key.substring(key.indexOf("#") + 1);
                }
                this.addPolicyToDefinitionElement(key, (Policy)policyElement);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            OMElement child = this.getPolicyComponentAsOMElement(policyElement, true);
            OMElement firstChildElem = wsdlElement.getFirstElement();
            if (firstChildElem == null) {
                wsdlElement.addChild((OMNode)child);
            } else {
                firstChildElem.insertSiblingBefore((OMNode)child);
            }
            String key = ((PolicyReference)policyElement).getURI();
            if (key.startsWith("#")) {
                key = key.substring(key.indexOf("#") + 1);
            }
            if ((p = (locator = new PolicyLocator(this.axisService)).lookup(key)) == null) continue;
            this.addPolicyToDefinitionElement(key, p);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addPolicyAsExtAttribute(AxisDescription axisDescription, OMElement element, OMFactory factory) throws OpenApiException {
        String uri;
        PolicySubject policySubject = axisDescription.getPolicySubject();
        ArrayList<Object> policyURIs = new ArrayList<Object>();
        for (Object policyElement : policySubject.getAttachedPolicyComponents()) {
            void var8_14;
            if (policyElement instanceof Policy) {
                void var8_11;
                Policy p = (Policy)policyElement;
                if (p.getId() != null) {
                    String string = "#" + p.getId();
                } else if (p.getName() != null) {
                    String string = p.getName();
                } else {
                    throw new RuntimeException("Can't add the Policy as an extensibility attribute since it doesn't have a id or a name attribute");
                }
                policyURIs.add(var8_11);
                this.addPolicyToDefinitionElement((String)var8_11, p);
                continue;
            }
            uri = ((PolicyReference)policyElement).getURI();
            PolicyLocator locator = new PolicyLocator(this.axisService);
            if (uri.startsWith("#")) {
                String string = uri.substring(uri.indexOf(35) + 1);
            } else {
                String string = uri;
            }
            Policy p = locator.lookup((String)var8_14);
            if (p == null) {
                throw new RuntimeException("Cannot resolve " + uri + " to a Policy");
            }
            policyURIs.add(uri);
            this.addPolicyToDefinitionElement((String)var8_14, p);
        }
        if (!policyURIs.isEmpty()) {
            StringBuilder value = new StringBuilder();
            for (Object e : policyURIs) {
                uri = (String)e;
                if (value.length() == 0) {
                    value.append(uri);
                    continue;
                }
                value.append(" ").append(uri);
            }
            OMNamespace ns = factory.createOMNamespace("http://www.w3.org/ns/ws-policy", "wsp");
            OMAttribute oMAttribute = factory.createOMAttribute("PolicyURIs", ns, value.toString());
            element.addAttribute(oMAttribute);
        }
    }

    private boolean isAlreadyAdded(AxisBinding axisBinding, OMElement definitionElement) {
        QName bindingName = axisBinding.getName();
        QName name = new QName("name");
        Iterator iterator = definitionElement.getChildrenWithName(new QName(this.wsdl.getNamespaceURI(), "binding"));
        while (iterator.hasNext()) {
            OMElement element = (OMElement)iterator.next();
            String value = element.getAttributeValue(name);
            if (!bindingName.getLocalPart().equals(value)) continue;
            return true;
        }
        return false;
    }

    private String getEndpointURL(AxisEndpoint axisEndpoint) {
        Parameter modifyAddressParam = this.axisService.getParameter("modifyUserWSDLPortAddress");
        String endpointURL = axisEndpoint.getEndpointURL();
        if (modifyAddressParam != null && !Boolean.parseBoolean((String)modifyAddressParam.getValue())) {
            return endpointURL;
        }
        String hostIP = Utils.getHostname((AxisConfiguration)this.axisService.getAxisConfiguration());
        if (hostIP == null) {
            hostIP = WSDLSerializationUtil.extractHostIP((String)this.axisService.getEndpointURL());
        }
        if (hostIP != null) {
            return axisEndpoint.calculateEndpointURL(hostIP);
        }
        return endpointURL;
    }

    private void generateIdentityElement(OMFactory fac, OMElement epr, OMElement identity, Parameter x509CertIdentityParameter) {
        if (identity != null) {
            identity = identity.cloneOMElement();
            epr.addChild((OMNode)identity);
        }
        if (x509CertIdentityParameter != null && x509CertIdentityParameter.getValue() != null) {
            OMElement x509cert;
            OMElement x509Data;
            OMElement keyInfo;
            if (identity == null) {
                identity = fac.createOMElement(AddressingConstants.QNAME_IDENTITY);
                epr.addChild((OMNode)identity);
            }
            if ((keyInfo = identity.getFirstChildWithName(AddressingConstants.QNAME_IDENTITY_KEY_INFO)) == null) {
                keyInfo = fac.createOMElement(AddressingConstants.QNAME_IDENTITY_KEY_INFO);
                identity.addChild((OMNode)keyInfo);
            }
            if ((x509Data = keyInfo.getFirstChildWithName(AddressingConstants.QNAME_IDENTITY_X509_DATA)) == null) {
                x509Data = fac.createOMElement(AddressingConstants.QNAME_IDENTITY_X509_DATA);
                keyInfo.addChild((OMNode)x509Data);
            }
            if ((x509cert = x509Data.getFirstChildWithName(AddressingConstants.QNAME_IDENTITY_X509_CERT)) == null) {
                x509cert = fac.createOMElement(AddressingConstants.QNAME_IDENTITY_X509_CERT);
                x509Data.addChild((OMNode)x509cert);
            }
            String x509CertValue = (String)x509CertIdentityParameter.getValue();
            x509cert.setText(x509CertValue);
        }
    }

    private void generateEPRElement(AxisEndpoint endpoint, OMFactory fac, OMElement port, String endpointURL) {
        Parameter x509CertIdentityParameter = this.axisService.getParameter("WSAddressingAndIdentity");
        OMElement identityElement = AddressingHelper.getAddressingIdentityParameterValue((AxisEndpoint)endpoint);
        if ((x509CertIdentityParameter == null || x509CertIdentityParameter.getValue() == null) && identityElement == null) {
            return;
        }
        OMElement wsaEpr = fac.createOMElement(AddressingConstants.Final.WSA_ENDPOINT_REFERENCE);
        OMElement address = fac.createOMElement(AddressingConstants.Final.WSA_ADDRESS);
        address.setText(endpointURL == null ? "" : endpointURL);
        wsaEpr.addChild((OMNode)address);
        this.generateIdentityElement(fac, wsaEpr, identityElement, x509CertIdentityParameter);
        port.addChild((OMNode)wsaEpr);
    }

    protected OMElement generateDocumentation(OMFactory fac) {
        return WSDLSerializationUtil.generateDocumentationElement((AxisDescription)this.axisService, (OMFactory)fac, (OMNamespace)this.wsdl);
    }

    protected XmlSchemaForm getAttrFormDefaultSetting() {
        return XmlSchemaForm.schemaValueOf((String)"unqualified");
    }

    protected XmlSchemaForm getElementFormDefaultSetting() {
        return XmlSchemaForm.schemaValueOf((String)"unqualified");
    }

    protected XmlSchema getXmlSchema(String targetNamespace) {
        String targetNamespacePrefix = "";
        XmlSchema xmlSchema = new XmlSchema(targetNamespace, new XmlSchemaCollection());
        xmlSchema.setAttributeFormDefault(this.getAttrFormDefaultSetting());
        xmlSchema.setElementFormDefault(this.getElementFormDefaultSetting());
        NamespaceMap prefixmap = new NamespaceMap();
        prefixmap.put((Object)"xsd", (Object)"http://www.w3.org/2001/XMLSchema");
        prefixmap.put((Object)targetNamespacePrefix, (Object)targetNamespace);
        xmlSchema.setNamespaceContext((NamespacePrefixList)prefixmap);
        return xmlSchema;
    }

    protected OMElement generateCustomTypes(OMFactory fac) {
        XmlSchemaComplexType xmlSchemaComplexType;
        XmlSchemaAnnotation anno;
        OMElement wsdlTypes = fac.createOMElement("types", this.wsdl);
        String inputName = this.customApiInfo.getInputParamsName();
        boolean hasInputParams = StringUtil.isNotEmpty((String)inputName);
        String outputName = this.customApiInfo.getOutputParamsName();
        boolean hasOutputParams = StringUtil.isNotEmpty((String)outputName);
        List inputParams = this.customApiInfo.getRequest() == null ? new ArrayList() : this.customApiInfo.getRequest();
        List outputParams = this.customApiInfo.getResponse() == null ? new ArrayList() : this.customApiInfo.getResponse();
        String inputNameDT = "DT_" + inputName;
        String outputNameDT = "DT_" + outputName;
        XmlSchema xmlSchema = this.getXmlSchema(this.targetNamespace);
        if (hasInputParams) {
            XmlSchemaElement elt1 = new XmlSchemaElement(xmlSchema, false);
            elt1.setName(inputName);
            Pair namespacePair = SoapUtil.getNamespace((String)this.customApiInfo.getNamespace());
            elt1.setSchemaTypeName(SchemaGeneratorUtil.createQname((String)namespacePair.getValue(), inputNameDT, (String)namespacePair.getKey()));
            xmlSchema.getItems().add(elt1);
        }
        if (hasOutputParams) {
            XmlSchemaElement elt2 = new XmlSchemaElement(xmlSchema, false);
            elt2.setName(outputName);
            elt2.setSchemaTypeName(SchemaGeneratorUtil.createQname(outputNameDT));
            xmlSchema.getItems().add(elt2);
        }
        if (hasInputParams) {
            XmlSchemaComplexType inputNameComplexType = new XmlSchemaComplexType(xmlSchema, true);
            inputNameComplexType.setName(inputNameDT);
            inputNameComplexType.setAnnotation(SchemaGeneratorUtil.createAnnotation("https://dev.kingdee.com/index/open", OpenWSDLConstants.APPINFO, this.customApiInfo.getName() + " " + this.customApiInfo.getNumber()));
            ArrayList<XmlSchemaElement> list = new ArrayList<XmlSchemaElement>();
            for (CustomApiParam customApiParam : inputParams) {
                anno = SchemaGeneratorUtil.createAnnotation("https://dev.kingdee.com/index/open/TextID", customApiParam.getEntryId().toString(), customApiParam.getDesc());
                xmlSchemaComplexType = null;
                xmlSchemaComplexType = this.createComplexType(customApiParam, xmlSchema);
                list.add(SchemaGeneratorUtil.createElement(xmlSchema, customApiParam.getParamName(), customApiParam.isMulValue() ? Long.valueOf(Long.MAX_VALUE) : null, SchemaGeneratorUtil.isComplexType(customApiParam) ? null : SchemaGeneratorUtil.getParamType(customApiParam), anno, (XmlSchemaComplexType)(SchemaGeneratorUtil.isComplexType(customApiParam) ? xmlSchemaComplexType : null), customApiParam.isRequired() ? 1L : 0L));
            }
            XmlSchemaSequence inputNameComplexTypeSequence = SchemaGeneratorUtil.createSequence(list);
            inputNameComplexType.setParticle((XmlSchemaParticle)inputNameComplexTypeSequence);
        }
        if (hasOutputParams) {
            XmlSchemaComplexType outputNameComplexType = new XmlSchemaComplexType(xmlSchema, true);
            outputNameComplexType.setName(outputNameDT);
            outputNameComplexType.setAnnotation(SchemaGeneratorUtil.createAnnotation("https://dev.kingdee.com/index/open", OpenWSDLConstants.APPINFO, null));
            ArrayList<XmlSchemaElement> outlist = new ArrayList<XmlSchemaElement>();
            for (CustomApiParam customApiParam : outputParams) {
                anno = SchemaGeneratorUtil.createAnnotation("https://dev.kingdee.com/index/open/TextID", customApiParam.getEntryId().toString(), customApiParam.getDesc());
                xmlSchemaComplexType = null;
                xmlSchemaComplexType = this.createComplexType(customApiParam, xmlSchema);
                outlist.add(SchemaGeneratorUtil.createElement(xmlSchema, customApiParam.getParamName(), customApiParam.isMulValue() ? Long.valueOf(Long.MAX_VALUE) : null, SchemaGeneratorUtil.isComplexType(customApiParam) ? null : SchemaGeneratorUtil.getParamType(customApiParam), anno, (XmlSchemaComplexType)(SchemaGeneratorUtil.isComplexType(customApiParam) ? xmlSchemaComplexType : null), customApiParam.isRequired() ? 1L : 0L));
            }
            XmlSchemaSequence outputNameComplexTypeSequence = SchemaGeneratorUtil.createSequence(outlist);
            outputNameComplexType.setParticle((XmlSchemaParticle)outputNameComplexTypeSequence);
        }
        StringWriter writer = new StringWriter();
        xmlSchema.write((Writer)writer);
        String schemaString = writer.toString();
        if (!"".equals(schemaString)) {
            try {
                wsdlTypes.addChild(XMLUtils.toOM((Reader)new StringReader(schemaString)));
            }
            catch (XMLStreamException e) {
                log.error("writer xml error:", (Throwable)e);
                return null;
            }
        }
        return wsdlTypes;
    }

    private XmlSchemaComplexType createComplexType(CustomApiParam customApiParam, XmlSchema xmlSchema) {
        if (CollectionUtil.isEmpty((Collection)customApiParam.getChildList())) {
            return null;
        }
        Object xmlSchemaComplexType = null;
        ArrayList<XmlSchemaElement> elementList2 = new ArrayList<XmlSchemaElement>();
        for (CustomApiParam customApiParam2 : customApiParam.getChildList()) {
            XmlSchemaAnnotation anno = SchemaGeneratorUtil.createAnnotation("https://dev.kingdee.com/index/open/TextID", customApiParam2.getEntryId().toString(), customApiParam2.getDesc());
            xmlSchemaComplexType = CollectionUtil.isEmpty((Collection)customApiParam2.getChildList()) ? null : this.createComplexType(customApiParam2, xmlSchema);
            elementList2.add(SchemaGeneratorUtil.createElement(xmlSchema, customApiParam2.getParamName(), customApiParam2.isMulValue() ? Long.valueOf(Long.MAX_VALUE) : null, SchemaGeneratorUtil.isComplexType(customApiParam2) ? null : SchemaGeneratorUtil.getParamType(customApiParam2), anno, (XmlSchemaComplexType)(SchemaGeneratorUtil.isComplexType(customApiParam2) ? xmlSchemaComplexType : null), customApiParam2.isRequired() ? 1L : 0L));
        }
        xmlSchemaComplexType = SchemaGeneratorUtil.createComplexType(xmlSchema, elementList2);
        return xmlSchemaComplexType;
    }

    protected OMElement generateDefinition(OMFactory fac) {
        this.wsdl = fac.createOMNamespace("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        OMElement ele = fac.createOMElement("definitions", this.wsdl);
        this.setDefinitionElement(ele);
        this.policiesInDefinitions = new HashMap<String, Policy>();
        HashMap<String, String> namespaceMap = this.axisService.getNamespaceMap();
        if (namespaceMap == null) {
            namespaceMap = new HashMap<String, String>();
        }
        WSDLSerializationUtil.populateNamespaces((OMElement)ele, (Map)namespaceMap);
        this.soap = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        this.soap12 = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap12/", "soap12");
        this.http = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/http/", "http");
        this.mime = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        this.wsaw = ele.declareNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
        String prefix = WSDLSerializationUtil.getPrefix((String)this.axisService.getTargetNamespace(), namespaceMap);
        if (prefix == null || "".equals(prefix)) {
            prefix = this.axisService.getTargetNamespacePrefix() != null ? this.axisService.getTargetNamespacePrefix() : "axis2";
        }
        namespaceMap.put(prefix, this.axisService.getTargetNamespace());
        this.tns = ele.declareNamespace(this.axisService.getTargetNamespace(), prefix);
        this.definition.addAttribute("targetNamespace", this.axisService.getTargetNamespace(), null);
        return ele;
    }

    protected boolean isDisableREST() {
        boolean disableREST = false;
        Parameter disableRESTParameter = this.axisService.getParameter("disableREST");
        if (disableRESTParameter != null && JavaUtils.isTrueExplicitly((Object)disableRESTParameter.getValue())) {
            disableREST = true;
        }
        return disableREST;
    }

    protected boolean isDisableSOAP11() {
        boolean disableSOAP11 = false;
        Parameter disableSOAP11Parameter = this.axisService.getParameter("disableSOAP11");
        if (disableSOAP11Parameter != null && JavaUtils.isTrueExplicitly((Object)disableSOAP11Parameter.getValue())) {
            disableSOAP11 = true;
        }
        return disableSOAP11;
    }

    protected boolean isDisableSOAP12() {
        boolean disableSOAP12 = false;
        Parameter disableSOAP12Parameter = this.axisService.getParameter("disableSOAP12");
        if (disableSOAP12Parameter != null && JavaUtils.isTrueExplicitly((Object)disableSOAP12Parameter.getValue())) {
            disableSOAP12 = true;
        }
        return disableSOAP12;
    }

    protected Map<String, Policy> getPoliciesInDefinitions() {
        return this.policiesInDefinitions;
    }

    protected OMElement modifyPort(OMElement port) {
        return port;
    }

    protected OMElement modifyBinding(OMElement binding) {
        return binding;
    }
}

