/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.webapi.query.g.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.webapi.query.g.convert.BaseConvert;

class DateTimeConvert
extends BaseConvert {
    static Set<String> dateFormats = new LinkedHashSet<String>();

    DateTimeConvert(IDataEntityProperty dynamicProperty, Object value) {
        super(dynamicProperty, value);
    }

    @Override
    public Object getConvertValue() {
        String value = (String)this.getValue();
        DataConvertResult convertResult = new DataConvertResult();
        if (value.contains("'")) {
            this.dataParse(value.substring(1, value.length() - 1), convertResult);
        }
        this.dataParse(value, convertResult);
        if (!convertResult.success) {
            throw new KDException(new ErrorCode("DateTimeConvertException", String.format("field:%s value:%s convert fail", this.getName(), this.getValue())), new Object[]{convertResult.ex});
        }
        return convertResult.date;
    }

    void dataParse(String strDate, DataConvertResult convertResult) {
        for (String format : dateFormats) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            try {
                convertResult.date = sdf.parse(strDate);
                convertResult.success = true;
                return;
            }
            catch (ParseException e) {
                convertResult.ex = e;
            }
        }
    }

    static {
        dateFormats.add("yyyyy-MM-dd HH:mm:ss");
        dateFormats.add("yyyy/MM/dd HH:mm:ss");
        dateFormats.add("yyyyMMdd HH:mm:ss");
        dateFormats.add("yyyy-MM-dd");
        dateFormats.add("yyyy/MM/dd");
        dateFormats.add("yyyyMMdd");
    }

    static class DataConvertResult {
        boolean success = false;
        Date date = null;
        Exception ex;

        DataConvertResult() {
        }
    }
}

