/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.webapi.swagger;

import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.webapi.swagger.IApiToSwagger;
import kd.bos.service.webapi.swagger.Properties;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class ApiToSwaggerImpl
implements IApiToSwagger {
    private static Log log = LogFactory.getLog(ApiToSwaggerImpl.class);
    private static final String PARAMNAME = "paramname";
    private static final String PARAMTYPE = "paramtype";
    private static final String PARAMMUST = "must";
    private static final String PARAMEXAMPLE = "example";
    private static final String PARAMDES = "bodyparamdes";
    private static final String RESNAME = "respparamname";
    private static final String RESTYPE = "respparamtype";
    private static final String RESMUST = "respparammust";
    private static final String RESEXAMPLE = "respexample";
    private static final String RESDES = "respdes";

    @Override
    public List<Parameter> buildRequestHeader(DynamicObject apiInfo) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        DynamicObjectCollection headers = apiInfo.getDynamicObjectCollection("headerentryentity");
        if (!CollectionUtils.isEmpty((Collection)headers)) {
            for (DynamicObject head : headers) {
                String headername = head.getString("headername");
                String headervalue = head.getString("headervalue");
                String headerdes = head.getString("headerdes");
                HeaderParameter parameter = new HeaderParameter();
                parameter.setName(headername);
                parameter.setDefaultValue(headervalue);
                parameter.setDescription(headerdes);
                parameter.setDescription(headerdes);
                parameter.setType("string");
                parameters.add((Parameter)parameter);
            }
        }
        return parameters;
    }

    @Override
    public List<Parameter> buildQueryParameters(DynamicObject apiInfo) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        DynamicObjectCollection urlParams = apiInfo.getDynamicObjectCollection("urlparamentryentity");
        if (!CollectionUtils.isEmpty((Collection)urlParams)) {
            for (DynamicObject param : urlParams) {
                String name = param.getString("urlparamname");
                String paramType = param.getString("urlparamtype");
                String parammust = param.getString("urlparammust");
                String paramexample = param.getString("urlparamexample");
                String paramdes = param.getString("urlparamdes");
                QueryParameter parameter = new QueryParameter();
                parameter.setName(name);
                parameter.setType(paramType.trim().toLowerCase());
                parameter.setExample(paramexample);
                parameter.setRequired(this.isRequired(parammust));
                parameter.setDescription(paramdes);
                parameters.add((Parameter)parameter);
            }
        }
        return parameters;
    }

    @Override
    public List<Parameter> buildBody(DynamicObject apiInfo, Map<String, Model> definitionMap) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        DynamicObjectCollection urlParams = apiInfo.getDynamicObjectCollection("bodyentryentity");
        ArrayList<DynamicObject> tops = new ArrayList<DynamicObject>(10);
        if (!CollectionUtils.isEmpty((Collection)urlParams)) {
            Iterator iterator = urlParams.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                if (0L != dynamicObject.getLong("pid")) continue;
                tops.add(dynamicObject);
                iterator.remove();
            }
        }
        BodyParameter parameterTop = new BodyParameter();
        HashMap<String, Property> propertyMap = new HashMap<String, Property>();
        for (DynamicObject top : tops) {
            this.buildPropertyMap(urlParams, propertyMap, top);
        }
        ModelImpl model = new ModelImpl();
        model.setType("object");
        model.setProperties(propertyMap);
        parameterTop.setSchema((Model)model);
        parameterTop.setDescription(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53", (String)"ApiToSwaggerImpl_0", (String)"bos-open-service", (Object[])new Object[0]));
        parameterTop.setName("requestbody");
        parameters.add((Parameter)parameterTop);
        return parameters;
    }

    private Map<String, Property> getObjectParam(DynamicObjectCollection childrens, DynamicObject top) {
        HashMap<String, Property> propertyMap = new HashMap<String, Property>(16);
        for (DynamicObject children : childrens) {
            if (((Long)top.getPkValue()).longValue() != children.getLong("pid")) continue;
            this.buildPropertyMap(childrens, propertyMap, children);
        }
        return propertyMap;
    }

    private Map<String, Property> getResObjectParam(DynamicObjectCollection childrens, DynamicObject top) {
        HashMap<String, Property> propertyMap = new HashMap<String, Property>(16);
        for (DynamicObject children : childrens) {
            if (!top.getPkValue().toString().equals(children.getString("pid"))) continue;
            this.buildResPropertyMap(childrens, propertyMap, children);
        }
        return propertyMap;
    }

    private void buildPropertyMap(DynamicObjectCollection urlParams, Map<String, Property> propertyMap, DynamicObject urlParam) {
        Map<String, String> propMap = this.getParamProperties(urlParam, PARAMNAME, PARAMTYPE, PARAMMUST, PARAMEXAMPLE, PARAMDES);
        String name = propMap.get(PARAMNAME);
        String type = propMap.get(PARAMTYPE);
        Property property = Properties.property(type);
        if (property instanceof ObjectProperty) {
            ((ObjectProperty)property).setProperties(this.getObjectParam(urlParams, urlParam));
            propertyMap.put(name, property);
        } else if (property instanceof ArrayProperty) {
            propertyMap.put(name, (Property)this.getArrayObjectParam(urlParams, urlParam));
        } else {
            property.setName(name);
            property.setDescription(propMap.get(PARAMDES));
            property.setExample(propMap.get(PARAMEXAMPLE));
            property.setRequired(this.isRequired(propMap.get(PARAMMUST)));
            propertyMap.put(name, property);
        }
    }

    private ArrayProperty getArrayObjectParam(DynamicObjectCollection dynamicObjects, DynamicObject parent) {
        ArrayProperty arrayProperty = new ArrayProperty();
        ObjectProperty objectProperty = new ObjectProperty();
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(16);
        ArrayList<String> strEnums = new ArrayList<String>();
        ArrayList<Integer> integerEnums = new ArrayList<Integer>();
        ArrayList<Long> longEnums = new ArrayList<Long>();
        ArrayList<Double> doubleEnums = new ArrayList<Double>();
        ArrayList<Float> floatEnums = new ArrayList<Float>();
        for (DynamicObject object : dynamicObjects) {
            Map<String, String> paramProperties = this.getParamProperties(object, PARAMNAME, PARAMTYPE, PARAMMUST, PARAMEXAMPLE, PARAMDES);
            String paramname = paramProperties.get(PARAMNAME);
            String paramType = paramProperties.get(PARAMTYPE);
            Property property = Properties.property(paramType);
            String pid = object.getString("pid");
            Object pkValue = parent.getPkValue();
            if (!StringUtils.isNotBlank((CharSequence)pid) || !StringUtils.isNotBlank((Object)pkValue) || !pkValue.toString().equals(pid)) continue;
            if (StringUtils.isNotBlank((CharSequence)paramname)) {
                if (property instanceof ObjectProperty) {
                    ((ObjectProperty)property).setProperties(this.getObjectParam(dynamicObjects, object));
                    propertyMap.put(paramname, property);
                } else if (property instanceof ArrayProperty) {
                    propertyMap.put(paramname, this.getArrayObjectParam(dynamicObjects, object));
                } else {
                    property.setName(paramname);
                    property.setDescription(paramProperties.get(PARAMDES));
                    property.setExample(paramProperties.get(PARAMEXAMPLE));
                    property.setRequired(this.isRequired(paramProperties.get(PARAMMUST)));
                    propertyMap.put(paramname, property);
                }
                objectProperty.setProperties(propertyMap);
                arrayProperty.setItems((Property)objectProperty);
                continue;
            }
            String example = paramProperties.get(PARAMEXAMPLE);
            if (property instanceof ObjectProperty) {
                ((ObjectProperty)property).setProperties(this.getObjectParam(dynamicObjects, object));
            } else if (property instanceof StringProperty) {
                strEnums.add(example);
                ((StringProperty)property).setEnum(strEnums);
            } else if (property instanceof IntegerProperty) {
                integerEnums.add(Integer.valueOf(example));
                ((IntegerProperty)property).setEnum(integerEnums);
            } else if (property instanceof LongProperty) {
                longEnums.add(Long.valueOf(example));
                ((LongProperty)property).setEnum(longEnums);
            } else if (property instanceof DoubleProperty) {
                doubleEnums.add(Double.valueOf(example));
                ((DoubleProperty)property).setEnum(doubleEnums);
            } else if (property instanceof FloatProperty) {
                floatEnums.add(Float.valueOf(example));
                ((FloatProperty)property).setEnum(floatEnums);
            }
            arrayProperty.setItems(property);
        }
        return arrayProperty;
    }

    private Map<String, Property> getPropertyMap(DynamicObjectCollection doCollect, DynamicObject dynamicObject, Map<String, String> propMap, String name, String type, String must, String example, String des) {
        HashMap<String, Property> propertyMap = new HashMap<String, Property>(16);
        String paramname = propMap.get(name);
        String paramType = propMap.get(type);
        Property property = Properties.property(paramType);
        if (property instanceof ObjectProperty) {
            ((ObjectProperty)property).setProperties(this.getObjectParam(doCollect, dynamicObject));
            propertyMap.put(paramname, property);
        } else if (property instanceof ArrayProperty) {
            propertyMap.put(paramname, (Property)this.getArrayObjectParam(doCollect, dynamicObject));
        } else {
            property.setName(name);
            property.setDescription(propMap.get(des));
            property.setExample(propMap.get(example));
            property.setRequired(this.isRequired(propMap.get(must)));
            propertyMap.put(paramname, property);
        }
        return propertyMap;
    }

    @Deprecated
    private Property getProperty(String type) {
        ObjectProperty property;
        if ("Object".equalsIgnoreCase(type)) {
            property = new ObjectProperty();
        } else if ("String".equalsIgnoreCase(type)) {
            property = new StringProperty();
            ((StringProperty)property).setType(type);
        } else if ("Long".equalsIgnoreCase(type)) {
            property = new LongProperty();
            ((LongProperty)property).setType(type);
        } else if ("int".equalsIgnoreCase(type)) {
            property = new IntegerProperty();
            ((IntegerProperty)property).setType(type);
        } else if ("Boolean".equalsIgnoreCase(type)) {
            property = new BooleanProperty();
            ((BooleanProperty)property).setType(type);
        } else if ("Double".equalsIgnoreCase(type)) {
            property = new DoubleProperty();
            ((DoubleProperty)property).setType(type);
        } else if ("Float".equalsIgnoreCase(type)) {
            property = new FloatProperty();
            ((FloatProperty)property).setType(type);
        } else if ("Array".equalsIgnoreCase(type)) {
            property = new ArrayProperty();
            ((ArrayProperty)property).setType(type);
        } else {
            property = null;
        }
        return property;
    }

    @Override
    public Info getInfo() {
        Info info = new Info();
        info.setTitle(ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u670d\u52a1API", (String)"ApiToSwaggerImpl_1", (String)"bos-open-service", (Object[])new Object[0]));
        info.setDescription(ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u670d\u52a1\u7aef\u540e\u53f0\u63a5\u53e3\u8bf4\u660e\u6587\u6863", (String)"ApiToSwaggerImpl_2", (String)"bos-open-service", (Object[])new Object[0]));
        info.setVersion(DomainModelType.getVersion());
        return info;
    }

    @Override
    public List<Scheme> getSchemes() {
        ArrayList<Scheme> schemes = new ArrayList<Scheme>();
        schemes.add(Scheme.forValue((String)"https"));
        schemes.add(Scheme.forValue((String)"http"));
        return schemes;
    }

    @Override
    public List<Tag> getCloudNodes() {
        LinkedList<Tag> cloudList = new LinkedList<Tag>();
        DynamicObjectCollection clouds = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject cloud : clouds) {
            Tag tag = new Tag();
            tag.setName(cloud.getString("name"));
            cloudList.add(tag);
        }
        return cloudList;
    }

    @Override
    public Map<String, String> getParamProperties(DynamicObject dynamicObject, String name, String type, String must, String example, String des) {
        String paramName = dynamicObject.getString(name);
        String paramType = dynamicObject.getString(type);
        if (StringUtils.isBlank((CharSequence)paramType)) {
            paramType = "";
        }
        String paramDes = dynamicObject.getString(des);
        String paramMust = dynamicObject.getString(must);
        String paramExample = dynamicObject.getString(example);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(name, paramName);
        map.put(type, paramType.trim());
        map.put(must, paramMust);
        map.put(example, paramExample);
        map.put(des, paramDes);
        return map;
    }

    @Override
    public Map<String, Response> buildResponse(DynamicObject apiInfo) {
        HashMap<String, Response> responseMap = new HashMap<String, Response>();
        Response response = new Response();
        ObjectProperty objectProperty = new ObjectProperty();
        DynamicObjectCollection responsedatas = apiInfo.getDynamicObjectCollection("respentryentity");
        ArrayList<DynamicObject> tops = new ArrayList<DynamicObject>(10);
        if (!CollectionUtils.isEmpty((Collection)responsedatas)) {
            Iterator iterator = responsedatas.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                if (0L != dynamicObject.getLong("pid")) continue;
                tops.add(dynamicObject);
                iterator.remove();
            }
        }
        HashMap<String, Property> propertyMap = new HashMap<String, Property>();
        for (DynamicObject top : tops) {
            this.buildResPropertyMap(responsedatas, propertyMap, top);
        }
        objectProperty.setProperties(propertyMap);
        response.setSchema((Property)objectProperty);
        response.setDescription("OK");
        responseMap.put(String.valueOf(200), response);
        return responseMap;
    }

    private void buildResPropertyMap(DynamicObjectCollection responsedatas, Map<String, Property> propertyMap, DynamicObject responsedata) {
        Map<String, String> propMap = this.getParamProperties(responsedata, RESNAME, RESTYPE, RESMUST, RESEXAMPLE, RESDES);
        String name = propMap.get(RESNAME);
        String type = propMap.get(RESTYPE);
        Property property = Properties.property(type.trim());
        if (property instanceof ObjectProperty) {
            ((ObjectProperty)property).setProperties(this.getResObjectParam(responsedatas, responsedata));
            propertyMap.put(name, property);
        } else if (property instanceof ArrayProperty) {
            propertyMap.put(name, (Property)this.getResArrayObject(responsedatas, responsedata));
        } else {
            property.setName(name);
            property.setDescription(propMap.get(RESDES));
            property.setExample(propMap.get(RESEXAMPLE));
            property.setRequired(this.isRequired(propMap.get(RESMUST)));
            propertyMap.put(name, property);
        }
    }

    private ArrayProperty getResArrayObject(DynamicObjectCollection dynamicObjects, DynamicObject parent) {
        ArrayProperty arrayProperty = new ArrayProperty();
        ObjectProperty objectProperty = new ObjectProperty();
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(16);
        ArrayList<String> strEnums = new ArrayList<String>();
        ArrayList<Integer> integerEnums = new ArrayList<Integer>();
        ArrayList<Long> longEnums = new ArrayList<Long>();
        ArrayList<Double> doubleEnums = new ArrayList<Double>();
        ArrayList<Float> floatEnums = new ArrayList<Float>();
        for (DynamicObject object : dynamicObjects) {
            Map<String, String> paramProperties = this.getParamProperties(object, RESNAME, RESTYPE, RESMUST, RESEXAMPLE, RESDES);
            String paramname = paramProperties.get(RESNAME);
            String paramType = paramProperties.get(RESTYPE);
            Property property = Properties.property(paramType);
            String pid = object.getString("pid");
            Object pkValue = parent.getPkValue();
            if (!StringUtils.isNotBlank((CharSequence)pid) || !StringUtils.isNotBlank((Object)pkValue) || !pkValue.toString().equals(pid)) continue;
            if (StringUtils.isNotBlank((CharSequence)paramname)) {
                if (property instanceof ObjectProperty) {
                    ((ObjectProperty)property).setProperties(this.getResObjectParam(dynamicObjects, object));
                    propertyMap.put(paramname, property);
                } else if (property instanceof ArrayProperty) {
                    propertyMap.put(paramname, this.getResArrayObject(dynamicObjects, object));
                } else {
                    property.setName(paramname);
                    property.setDescription(paramProperties.get(RESDES));
                    property.setExample(paramProperties.get(RESEXAMPLE));
                    property.setRequired(this.isRequired(paramProperties.get(RESMUST)));
                    propertyMap.put(paramname, property);
                }
                objectProperty.setProperties(propertyMap);
                arrayProperty.setItems((Property)objectProperty);
                continue;
            }
            String example = paramProperties.get(PARAMEXAMPLE);
            if (property instanceof ObjectProperty) {
                ((ObjectProperty)property).setProperties(this.getResObjectParam(dynamicObjects, object));
            } else if (property instanceof StringProperty) {
                strEnums.add(example);
                ((StringProperty)property).setEnum(strEnums);
            } else if (property instanceof IntegerProperty) {
                integerEnums.add(Integer.valueOf(example));
                ((IntegerProperty)property).setEnum(integerEnums);
            } else if (property instanceof LongProperty) {
                longEnums.add(Long.valueOf(example));
                ((LongProperty)property).setEnum(longEnums);
            } else if (property instanceof DoubleProperty) {
                doubleEnums.add(Double.valueOf(example));
                ((DoubleProperty)property).setEnum(doubleEnums);
            } else if (property instanceof FloatProperty) {
                floatEnums.add(Float.valueOf(example));
                ((FloatProperty)property).setEnum(floatEnums);
            }
            arrayProperty.setItems(property);
        }
        return arrayProperty;
    }

    private boolean isRequired(String must) {
        return "1".equals(must);
    }
}

