/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.acl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.model.ApiAclInfoModel;
import kd.bos.openapi.base.model.AppAclModel;
import kd.bos.openapi.base.model.ThirdAppAclModel;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.CommonDateUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class ApilAclManager {
    private static final Log log = LogFactory.getLog(ApilAclManager.class);
    private static final String OPENAPI_3RDAPPS = "third_app";
    private static final String THIRD_ENTRY_API = "entryentity";
    private static final String THIRD_NO_LIMIT_API = "allowallapi";
    private static final String ENABLE = "enable";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ENABLE_TIME = "lastenabletime";
    private static final String STOP_TIME = "laststoptime";
    private static final String APISERVICEID = "id";
    private static final String TRUE = "true";
    private static final String API_STATUS_INCLUD = "1,2,3";
    private static final String API_SERVICE = "apiservice";
    private static final String FIELD_URL = "urlformat";
    private static final String APPID = "appid.id";
    private static final String ALLOWGUEST = "allowguest";
    private static final String IS_AGENCY_USER = "isagencyuser";
    private static final String AGENCY_USER = "agencyuser";
    private static final String IS_PRESET = "is_preset";
    private static final String KEY_IS_ONLY_THIRDAPP_AUTH = "isonlythirdappauth";
    private static final String OPEN_APISERVICE = "open_apiservice";
    private static final String IS_FORBIDDEN = "isforbidden";
    private static final String BIZ_APP = "bizapp";
    private static final String APP_ID = "appid";
    private static final String APPID_URLFORMAT = "appid,urlformat";
    private static final String APPID_URLFORMAT_ENABLE_ALLOW_GUEST = "enable,appid,urlformat,allowguest,isonlythirdappauth";
    private static final String OPEN_APP_AUTHORIZE_LIST = "open_appauthorize_list";
    private static final String IS_FORBIDDEN_BIZAPP = "isforbidden,bizapp";
    private static final String OPEN_API_AUTHORIZE = "open_apiauthorize";
    private static final String API_NUMBER = "api_number";
    private static final String API_USERS = "api_users";
    private static final String BASE_DATA_ID = "fbasedataid_id";
    private static final String THIRDAPP_COUNTRY = "country";
    private static final int ONE = 1;
    private static final int OPEN_API_VERSION_2 = 2;

    private static ThirdAppAclModel getThirdAppAclInfoModelFromDb(String thirdId) {
        DynamicObject country;
        if (thirdId == null || "null".equalsIgnoreCase(thirdId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The thirdId cannot be null.", new Object[0]);
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(thirdId), (String)OPENAPI_3RDAPPS);
        if (object == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "Can't find object by thirdId:%s.", new Object[]{thirdId});
        }
        ThirdAppAclModel model = new ThirdAppAclModel();
        model.setVersion(2);
        model.setAllowAllApi(object.getBoolean(THIRD_NO_LIMIT_API));
        model.setAppAccess(API_STATUS_INCLUD.contains(object.getString(ENABLE)));
        model.setThirdAppCode(object.getString(NUMBER));
        model.setLastEnableTime(object.getDate(ENABLE_TIME));
        model.setLastStopTime(object.getDate(STOP_TIME));
        model.setAgencyUser(object.getBoolean(IS_AGENCY_USER));
        model.setPreset(object.getBoolean(IS_PRESET));
        if (model.isAgencyUser()) {
            QFilter[] filters = new QFilter[]{new QFilter(APISERVICEID, "=", (Object)Long.parseLong(thirdId))};
            DynamicObjectCollection dy = QueryServiceHelper.query((String)"third_app.agencyuser", (String)"fbasedataid", (QFilter[])filters);
            ApilAclManager.updateAgencyUser(model, dy);
        }
        if (!model.isAllowAllApi() && model.isAppAccess()) {
            DynamicObjectCollection apiServiceIds = object.getDynamicObjectCollection(THIRD_ENTRY_API);
            model.setAllowApiMap(ApilAclManager.getApiActByUrl(apiServiceIds));
        }
        if ((country = object.getDynamicObject(THIRDAPP_COUNTRY)) != null) {
            model.setCountry(country.getString(NUMBER));
        }
        return model;
    }

    private static void updateAgencyUser(ThirdAppAclModel model, DynamicObjectCollection agencyUsers) {
        HashMap<Long, Integer> agentUserMap = new HashMap<Long, Integer>();
        for (DynamicObject obj : agencyUsers) {
            if (obj == null || obj.get("fbasedataid") == null) continue;
            agentUserMap.put(obj.getLong("fbasedataid"), 1);
        }
        model.setAgencyUserMap(agentUserMap);
    }

    private static Map<String, ApiAclInfoModel> getApiActByUrl(DynamicObjectCollection apiServiceIds) {
        HashMap<String, ApiAclInfoModel> apiMap = new HashMap<String, ApiAclInfoModel>();
        for (DynamicObject obj : apiServiceIds) {
            if (obj == null || obj.get(API_SERVICE) == null) continue;
            String url = ((DynamicObject)obj.get(API_SERVICE)).getString(FIELD_URL);
            ApiAclInfoModel apiAclInfoModel = ApilAclManager.getApiAclModelFromCache(url);
            apiMap.put(url, apiAclInfoModel);
        }
        return apiMap;
    }

    public static ThirdAppAclModel getThirdAppAclInfoModelFromCache(String thirdId) {
        ThirdAppAclModel model = (ThirdAppAclModel)LocalCacheUtil.getCacheByKey("ThirdAppAclModel", thirdId);
        if (model != null) {
            return model;
        }
        model = ApilAclManager.getThirdAppAclInfoModelFromDb(thirdId);
        LocalCacheUtil.setCacheByKey("ThirdAppAclModel", thirdId, model);
        return model;
    }

    public static ApiAclInfoModel getApiAclModelFromCache(String accessUrl) {
        ApiAclInfoModel apiService = (ApiAclInfoModel)LocalCacheUtil.getCacheByKey("ApiAclInfoModel", accessUrl);
        if (apiService != null) {
            return apiService;
        }
        apiService = ApilAclManager.getApiServiceFromDb(accessUrl);
        LocalCacheUtil.setCacheByKey("ApiAclInfoModel", accessUrl, apiService);
        return apiService;
    }

    private static ApiAclInfoModel getApiServiceFromDb(String accessUrl) {
        if (StringUtils.isEmpty((CharSequence)accessUrl)) {
            throw new OpenApiException(ApiErrorCode.HTTP_NOT_FOUND, "The accessUrl cannot be null.", new Object[0]);
        }
        DynamicObject apiObj = ApilAclManager.getApiObjForUrl(accessUrl);
        if (apiObj == null || apiObj.getString(APPID) == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, "The appId cannot be null.", new Object[0]);
        }
        String appId = apiObj.getString(APPID);
        String allowGuest = apiObj.getString(ALLOWGUEST);
        String onlyThirdAppAuth = apiObj.getString(KEY_IS_ONLY_THIRDAPP_AUTH);
        ApiAclInfoModel apiAclInfoModel = new ApiAclInfoModel();
        apiAclInfoModel.setAppId(appId);
        apiAclInfoModel.setOnlyThirdAppAuth(StringUtils.isNotEmpty((CharSequence)onlyThirdAppAuth) && TRUE.equalsIgnoreCase(onlyThirdAppAuth));
        if (apiAclInfoModel.isOnlyThirdAppAuth()) {
            apiAclInfoModel.setAnonymousAccess(false);
        } else {
            apiAclInfoModel.setAnonymousAccess(StringUtils.isNotEmpty((CharSequence)allowGuest) && TRUE.equalsIgnoreCase(allowGuest));
        }
        apiAclInfoModel.setApiServiceId(apiObj.getString(APISERVICEID));
        apiAclInfoModel.setApiEnable(API_STATUS_INCLUD.contains(apiObj.getString(ENABLE)));
        String serviceNumber = apiObj.getString(NUMBER);
        apiAclInfoModel.setApiUserAccessMap(ApilAclManager.getApiUsersByApiNumber(serviceNumber));
        String url = apiObj.getString(FIELD_URL);
        apiAclInfoModel.setUrl(url);
        return apiAclInfoModel;
    }

    private static AppAclModel getAppAclInfoModelFromDb(String appId) {
        if (StringUtils.isEmpty((CharSequence)appId)) {
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, "The appId cannot be null.", new Object[0]);
        }
        Object[] apiObjs = ApilAclManager.getApiObjByAppid(appId);
        AppAclModel model = new AppAclModel();
        model.setAppId(appId);
        DynamicObject object = ApilAclManager.findAppInfoByAppId(appId);
        HashMap<String, Integer> apiDisabledMap = new HashMap<String, Integer>();
        if (object == null) {
            model.setApiDisableMap(apiDisabledMap);
            model.setEnable(true);
            return model;
        }
        model.setEnable(!object.getBoolean(IS_FORBIDDEN));
        model.setAppName(object.getDynamicObject(BIZ_APP).getString(NAME));
        if (!model.isEnable() && apiObjs != null && !CollectionUtil.isEmpty((Object[])apiObjs)) {
            for (Object api : apiObjs) {
                apiDisabledMap.put(api.getString(FIELD_URL), 1);
            }
        }
        model.setApiDisableMap(apiDisabledMap);
        return model;
    }

    public static void removeIpinfondThirdAppAcl(String thirdAppId) {
        LocalCacheUtil.removeCacheByKey("IpinfoModel", thirdAppId);
        LocalCacheUtil.removeCacheByKey("ThirdAppAclModel", thirdAppId);
    }

    public static void removeApiAclModel(String url) {
        LocalCacheUtil.removeCacheByKey("ApiAclInfoModel", url);
    }

    public static void removeApiAclInfoModel(ListSelectedRowCollection selectedRows) {
        ArrayList ids = new ArrayList();
        selectedRows.forEach(row -> {
            Long id = (Long)row.getPrimaryKeyValue();
            ids.add(id);
        });
        QFilter[] filters = new QFilter[]{new QFilter(APISERVICEID, "in", ids)};
        Map res = BusinessDataServiceHelper.loadFromCache((String)OPEN_APISERVICE, (String)APPID_URLFORMAT, (QFilter[])filters);
        HashSet appSet = new HashSet();
        res.values().forEach(api -> {
            String accessUrl = api.getString(FIELD_URL);
            LocalCacheUtil.removeCacheByKey("ApiAclInfoModel", accessUrl);
            DynamicObject apiObj = ApilAclManager.getApiObjForUrl(accessUrl);
            appSet.add(apiObj.getString(APPID));
        });
        if (!CollectionUtil.isEmpty(appSet)) {
            appSet.forEach(appId -> LocalCacheUtil.removeCacheByKey("AppAclModel", appId));
        }
    }

    public static void removeAppAclModel(String appId) {
        LocalCacheUtil.removeCacheByKey("AppAclModel", appId);
    }

    public static AppAclModel getAppAclInfoModelFromCache(String appId) {
        AppAclModel model = (AppAclModel)LocalCacheUtil.getCacheByKey("AppAclModel", appId);
        if (model != null) {
            return model;
        }
        model = ApilAclManager.getAppAclInfoModelFromDb(appId);
        LocalCacheUtil.setCacheByKey("AppAclModel", appId, model);
        return model;
    }

    public static boolean checkAppAclModel(String accessUrl, AppAclModel appAclModel) {
        return appAclModel.isEnable() || appAclModel.getApiDisableMap().get(accessUrl) == null || appAclModel.getApiDisableMap().get(accessUrl) != 1;
    }

    public static boolean checkApiAnonymousAccess(ApiAclInfoModel apiAclInfoModel, boolean anonymousAccess) {
        return anonymousAccess && apiAclInfoModel != null && apiAclInfoModel.isAnonymousAccess() && !apiAclInfoModel.isOnlyThirdAppAuth();
    }

    public static boolean checkApiEnable(ApiAclInfoModel apiAclInfoModel) {
        return apiAclInfoModel != null && apiAclInfoModel.isApiEnable();
    }

    public static boolean checkAppEnableDateRange(ThirdAppAclModel thirdAppAclModel) {
        return CommonDateUtil.compareDateTime((Date)thirdAppAclModel.getLastEnableTime(), (Date)thirdAppAclModel.getLastStopTime());
    }

    public static boolean checkApiAuthUser(ApiAclInfoModel apiAclInfoModel, Long userId) {
        Map<String, Integer> authMap = apiAclInfoModel.getApiUserAccessMap();
        if (CollectionUtil.isEmpty(authMap)) {
            return true;
        }
        return authMap.get(userId.toString()) != null && authMap.get(userId.toString()) == 1;
    }

    public static boolean checkAgencyUser(ThirdAppAclModel appAclModel, Long userId) {
        Integer result = appAclModel.getAgencyUserMap().get(userId);
        return result == null ? false : result == 1;
    }

    public static boolean checkApiAct(String accessUrl, ThirdAppAclModel appAclModel) {
        ApiAclInfoModel res = appAclModel.getAllowApiMap().get(accessUrl);
        return res != null && res.isApiEnable();
    }

    public static DynamicObject getApiObjForUrl(String url) {
        QFilter[] filters = new QFilter[]{new QFilter(FIELD_URL, "=", (Object)url)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)OPEN_APISERVICE, (String)APPID_URLFORMAT_ENABLE_ALLOW_GUEST, (QFilter[])filters);
    }

    private static DynamicObject[] getApiObjByAppid(String appId) {
        QFilter[] filters = new QFilter[]{new QFilter(APP_ID, "=", (Object)appId)};
        return BusinessDataServiceHelper.load((String)OPEN_APISERVICE, (String)APPID_URLFORMAT, (QFilter[])filters);
    }

    private static DynamicObject findAppInfoByAppId(String appId) {
        QFilter[] filters = new QFilter[]{new QFilter(BIZ_APP, "=", (Object)appId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)OPEN_APP_AUTHORIZE_LIST, (String)IS_FORBIDDEN_BIZAPP, (QFilter[])filters);
    }

    public static Map<String, Integer> getApiUsersByApiNumber(String apiNumber) {
        DynamicObjectCollection users;
        QFilter[] filters = new QFilter[]{new QFilter(API_NUMBER, "=", (Object)apiNumber)};
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)OPEN_API_AUTHORIZE, (String)API_USERS, (QFilter[])filters);
        HashMap<String, Integer> uidMap = new HashMap<String, Integer>();
        if (object != null && !(users = object.getDynamicObjectCollection(API_USERS)).isEmpty()) {
            for (DynamicObject user : users) {
                uidMap.put(String.valueOf(user.get(BASE_DATA_ID)), 1);
            }
        }
        return uidMap;
    }

    public static Long getThirdIdByNum(String thirdAppNumber, String accountId) {
        return ThirdAppSecurityUtil.getThirdIdByNum(thirdAppNumber, accountId);
    }
}

