/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.custom;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.CustomApiService;
import kd.bos.openapi.api.WsdlService;
import kd.bos.openapi.base.custom.info.CustomApiInfo;
import kd.bos.openapi.base.custom.info.CustomApiParam;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.KHashMap;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;

public class CustomApiUtil {
    private static final Log LOG = LogFactory.getLog(CustomApiUtil.class);
    public static final String MAP_KEY = "$key$";
    public static final String MAP_VALUE = "$value$";

    public static Set<String> getMethodNames(String appId, String className) {
        CustomApiUtil.checkAppId(appId);
        return (Set)DispatchApiServiceHelper.invokeApiService((String)appId, (String)CustomApiService.class.getSimpleName(), (String)"getMethodNames", (Object[])new Object[]{className});
    }

    public static CustomApiInfo getCustomApiInfo(String appId, String className, String methodName) {
        CustomApiUtil.checkAppId(appId);
        return (CustomApiInfo)DispatchApiServiceHelper.invokeApiService((String)appId, (String)CustomApiService.class.getSimpleName(), (String)"getCustomApiInfo", (Object[])new Object[]{className, methodName});
    }

    public static Object getRequestObj(String appId, String className, String methodName) {
        return CustomApiUtil.toMap(CustomApiUtil.getRequest(appId, className, methodName));
    }

    public static List<CustomApiParam> getRequest(String appId, String className, String methodName) {
        CustomApiUtil.checkAppId(appId);
        return (List)DispatchApiServiceHelper.invokeApiService((String)appId, (String)CustomApiService.class.getSimpleName(), (String)"getRequest", (Object[])new Object[]{className, methodName});
    }

    public static Object getResponseObj(String appId, String className, String methodName) {
        return CustomApiUtil.toMap(CustomApiUtil.getResponse(appId, className, methodName)).get("data");
    }

    public static List<CustomApiParam> getResponse(String appId, String className, String methodName) {
        CustomApiUtil.checkAppId(appId);
        return (List)DispatchApiServiceHelper.invokeApiService((String)appId, (String)CustomApiService.class.getSimpleName(), (String)"getResponse", (Object[])new Object[]{className, methodName});
    }

    public static String getNameSpace(String appId, String className) {
        CustomApiUtil.checkAppId(appId);
        return (String)DispatchApiServiceHelper.invokeApiService((String)appId, (String)WsdlService.class.getSimpleName(), (String)"genNameSpace", (Object[])new Object[]{className});
    }

    public static Map<Object, Object> toMap(List<CustomApiParam> paramList) {
        Set set;
        if (CollectionUtil.isEmpty(paramList)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(paramList.size());
        if (paramList.size() == 2 && (set = paramList.stream().map(CustomApiParam::getParamName).collect(Collectors.toSet())).contains(MAP_KEY) && set.contains(MAP_VALUE)) {
            Pair<Object, Object> pairKey = CustomApiUtil.toMap(paramList.get(0));
            Pair<Object, Object> pairValue = CustomApiUtil.toMap(paramList.get(1));
            map.put(pairKey.getValue(), pairValue.getValue());
            return map;
        }
        for (CustomApiParam param : paramList) {
            Pair<Object, Object> pair = CustomApiUtil.toMap(param);
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    private static Pair<Object, Object> toMap(CustomApiParam param) {
        KHashMap value;
        if (param.getChildList().isEmpty()) {
            List<Object> value2 = param.getExample();
            if (param.isMulValue()) {
                if (value2 == null) {
                    value2 = Collections.emptyList();
                }
                for (int i = 1; i < param.getArrayLevel(); ++i) {
                    value2 = Collections.singletonList(value2);
                }
            }
            return new Pair((Object)param.getParamName(), value2);
        }
        if (param.isMap()) {
            List<CustomApiParam> childList = param.getChildList();
            Pair<Object, Object> pairKey = CustomApiUtil.toMap(childList.get(0));
            Pair<Object, Object> pairValue = CustomApiUtil.toMap(childList.get(1));
            value = new KHashMap(1).set(pairKey.getValue(), pairValue.getValue());
        } else {
            value = CustomApiUtil.toMap(param.getChildList());
        }
        if (param.isMulValue()) {
            value = Collections.singletonList(value);
            for (int i = 1; i < param.getArrayLevel(); ++i) {
                value = Collections.singletonList(value);
            }
        }
        return new Pair((Object)param.getParamName(), (Object)value);
    }

    private static void checkAppId(String appId) {
        if (StringUtil.isEmpty((String)appId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u5e94\u7528 appId \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomApiUtil_0", (String)"bos-open-base", (Object[])new Object[0]), new Object[0]);
        }
    }

    public static Object getCustomParams(String entryKey, DynamicObjectCollection entryEntity) {
        if (entryEntity == null || entryEntity.isEmpty()) {
            return Collections.emptyMap();
        }
        String paramName = "bodyentryentity".equals(entryKey) ? "paramname" : "respparamname";
        String paramType = "bodyentryentity".equals(entryKey) ? "paramtype" : "respparamtype";
        String example = "bodyentryentity".equals(entryKey) ? "example" : "respexample";
        String levelName = "bodyentryentity".equals(entryKey) ? "body_level" : "resp_level";
        String mulValue = "bodyentryentity".equals(entryKey) ? "is_req_mul_value" : "is_resp_mul_value";
        LinkedHashMap pidMap = entryEntity.stream().collect(Collectors.groupingBy(it -> it.getLong("pid"), LinkedHashMap::new, Collectors.toList()));
        return CustomApiUtil.getCustomParams(paramName, paramType, mulValue, example, levelName, pidMap, 0L, 1);
    }

    private static Object getCustomParams(String paramName, String paramType, String mulValue, String example, String levelName, LinkedHashMap<Long, List<DynamicObject>> pidMap, Long pid, int level) {
        List<DynamicObject> current = pidMap.get(pid);
        if (CollectionUtil.isEmpty(current)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>(current.size());
        for (DynamicObject entry : current) {
            String type = entry.getString(paramType);
            if (StringUtil.isEmpty((String)type)) continue;
            DataType dataType = DataType.getByType((String)type);
            if (!DataType.getCustomDataType().contains(dataType)) {
                throw new OpenApiException(ApiErrorCode.HTTP_NOT_ACCEPTABLE, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u53c2\u6570\u7c7b\u578b %s\u3002", (String)"CustomApiUtil_1", (String)"bos-open-base", (Object[])new Object[0]), new Object[]{type});
            }
            String name = entry.getString(paramName);
            List<Object> value = null;
            if (DataType.STRUCT == dataType) {
                value = CustomApiUtil.getCustomParams(paramName, paramType, mulValue, example, levelName, pidMap, entry.getLong("id"), ++level);
            } else {
                try {
                    String strValue = StringUtil.isEmpty((String)entry.getLocaleString(example).getLocaleValue()) ? (String)entry.getLocaleString(example).getDefaultItem() : entry.getLocaleString(example).getLocaleValue();
                    Object obj = JsonUtil.parseJson((String)strValue);
                    value = dataType.validator(obj);
                }
                catch (Exception e) {
                    LOG.warn("\u53c2\u6570" + name + "\u793a\u4f8b\u503c\u89e3\u6790\u5f02\u5e38\uff1a", (Throwable)e);
                    value = dataType.defaultValue();
                }
            }
            boolean isMulValue = entry.getBoolean(mulValue);
            map.put(name, isMulValue ? Collections.singletonList(value) : value);
        }
        return map;
    }

    public static <T> T getInstance(String appId, String className) {
        CustomApiUtil.checkAppId(appId);
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        return (T)DispatchApiServiceHelper.invokeApiService((String)appId, (String)CustomApiService.class.getSimpleName(), (String)"getInstance", (Object[])new Object[]{className});
    }

    public static <T> T getPluginInstance(String appId, String className) {
        CustomApiUtil.checkAppId(appId);
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        return (T)DispatchApiServiceHelper.invokeApiService((String)appId, (String)CustomApiService.class.getSimpleName(), (String)"getPluginInstance", (Object[])new Object[]{className});
    }

    public static <T> Class<T> getClass(String appId, String className) {
        CustomApiUtil.checkAppId(appId);
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        return (Class)DispatchApiServiceHelper.invokeApiService((String)appId, (String)CustomApiService.class.getSimpleName(), (String)"getClass", (Object[])new Object[]{className});
    }

    public static Map<Class<?>, Boolean> getApiPluginResult(String appId, String operation, String className) {
        return CustomApiUtil.getApiPluginResult(appId, operation, className, null);
    }

    public static Map<Class<?>, Boolean> getApiPluginResult(String appId, String operation, String className, Integer pluginType) {
        CustomApiUtil.checkAppId(appId);
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        return (Map)DispatchApiServiceHelper.invokeApiService((String)appId, (String)CustomApiService.class.getSimpleName(), (String)"getApiPluginResult", (Object[])new Object[]{operation, className, pluginType});
    }

    public static Boolean isHasApiControllerAnnotation(String appId, String className) {
        CustomApiUtil.checkAppId(appId);
        if (StringUtil.isEmpty((String)className)) {
            return false;
        }
        return (Boolean)DispatchApiServiceHelper.invokeApiService((String)appId, (String)CustomApiService.class.getSimpleName(), (String)"isHasApiControllerAnnotation", (Object[])new Object[]{className});
    }
}

