/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.dataservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.AlarmTypeEnum;
import kd.bos.openapi.common.model.DefaultAlarmMsgEnum;
import kd.bos.openapi.common.model.OpenApiAlarmMsgResult;
import kd.bos.openapi.common.spi.OpenApiAlarmService;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class OpenApiAlarmServiceImpl
implements OpenApiAlarmService {
    private static final String OPEN = "OPEN";
    private static final int DEFAULT_ALARMTIME_INTERVAL = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpenApiAlarmMsgResult> sendMsg(AlarmTypeEnum alarmTypeEnum, Map<String, String> map) {
        ArrayList<OpenApiAlarmMsgResult> resList = new ArrayList<OpenApiAlarmMsgResult>(3);
        DynamicObject[] allAlarmConfig = this.getAllAlarmConfig(alarmTypeEnum);
        if (allAlarmConfig == null || allAlarmConfig.length <= 0) {
            if (!this.checkIsRepeatMsgSendByInterval(alarmTypeEnum, 0L, null)) {
                this.writeAlarmLog(alarmTypeEnum, null, null, null, map, null);
            }
            return resList;
        }
        for (DynamicObject alarmConfig : allAlarmConfig) {
            MulBasedataDynamicObjectCollection msgtypes = (MulBasedataDynamicObjectCollection)alarmConfig.get("msgtype");
            Map<Long, String> msgtypeMap = msgtypes.stream().collect(Collectors.toMap(it -> it.getLong("fbasedataid_id"), it -> it.getDynamicObject(1).getString("number")));
            for (Map.Entry<Long, String> entry : msgtypeMap.entrySet()) {
                if (this.checkIsRepeatMsgSendByInterval(alarmTypeEnum, entry.getKey(), alarmConfig)) continue;
                MessageInfo message = new MessageInfo();
                OpenApiAlarmMsgResult openApiAlarmMsgResult = new OpenApiAlarmMsgResult();
                Map<String, Object> msgResult = new HashMap<String, Object>(3);
                try {
                    message.setMessageTag((ILocaleString)new LocaleString(OPEN));
                    message.setSource(OPEN);
                    message.setEntityNumber("openapi_alarmconfig");
                    message.setBizDataId(Long.valueOf(alarmConfig.getLong("id")));
                    message.setNestAppid(OPEN);
                    message.setMessageTitle((ILocaleString)new LocaleString(OpenApiAlarmServiceImpl.replaceTemplateStr(alarmConfig.getString("msgtitle"), map)));
                    String msgtemplate = alarmConfig.getString("msgtemplate");
                    message.setMessageContent((ILocaleString)new LocaleString(OpenApiAlarmServiceImpl.replaceTemplateStr(msgtemplate, map)));
                    message.setMessageSenderName((ILocaleString)new LocaleString("OpenAPI#" + alarmConfig.getString("number")));
                    MulBasedataDynamicObjectCollection receiverids = (MulBasedataDynamicObjectCollection)alarmConfig.get("receiverids");
                    List userIds = receiverids.stream().map(it -> it.getLong("fbasedataid_id")).collect(Collectors.toList());
                    message.setUserIds(userIds);
                    message.setNotifyType(entry.getValue());
                    msgResult = MessageCenterServiceHelper.batchSendMessages(Collections.singletonList(message));
                    openApiAlarmMsgResult.setAlarmConfigId(Long.valueOf(alarmConfig.getLong("id")));
                    openApiAlarmMsgResult.setAlarmConfigNumber(alarmConfig.getString("number"));
                    openApiAlarmMsgResult.setAlarmConfigName(alarmConfig.getString("name"));
                    openApiAlarmMsgResult.setMsgResult(msgResult);
                    resList.add(openApiAlarmMsgResult);
                }
                finally {
                    this.writeAlarmLog(alarmTypeEnum, entry.getKey(), msgResult, message, map, alarmConfig);
                }
            }
        }
        return resList;
    }

    private boolean checkIsRepeatMsgSendByInterval(AlarmTypeEnum alarmTypeEnum, Long msgtypeId, DynamicObject alarmConfig) {
        Long alarmconfigId = 0L;
        int interval = 30;
        if (alarmConfig != null) {
            alarmconfigId = alarmConfig.getLong("id");
            interval = alarmConfig.getInt("interval");
        }
        Date timeBeforeInterval = DateUtil.getDateAdd((Date)new Date(), (int)12, (int)(-interval));
        QFilter filter1 = new QFilter("alarmconfig", "=", (Object)alarmconfigId);
        QFilter filter2 = new QFilter("alarmconfig", "=", (Object)alarmconfigId).and(new QFilter("msgtype", "=", (Object)msgtypeId)).and(new QFilter("createtime", ">", (Object)timeBeforeInterval));
        if (alarmConfig == null) {
            filter1.and(new QFilter("alarmtype", "=", (Object)alarmTypeEnum.getCode()));
            filter2.and(new QFilter("alarmtype", "=", (Object)alarmTypeEnum.getCode()));
        }
        if (!QueryServiceHelper.exists((String)"openapi_alarmlog", (QFilter[])new QFilter[]{filter1})) {
            return false;
        }
        return QueryServiceHelper.exists((String)"openapi_alarmlog", (QFilter[])new QFilter[]{filter2});
    }

    private DynamicObject[] getAllAlarmConfig(AlarmTypeEnum alarmTypeEnum) {
        List allCodes = AlarmTypeEnum.getAllCodes();
        if (!allCodes.contains(alarmTypeEnum.getCode())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "Cannot found this alarmType.", new Object[0]);
        }
        return BusinessDataServiceHelper.load((String)"openapi_alarmconfig", (String)"id,number,msgtype,receiverids,interval,msgtitle,msgtemplate", (QFilter[])new QFilter[]{new QFilter("alarmtype", "=", (Object)alarmTypeEnum.getCode()).and(new QFilter("enable", "=", (Object)"1"))});
    }

    private static String replaceTemplateStr(String template, Map<String, String> map) {
        for (String key : map.keySet()) {
            if (!StringUtil.isNotEmpty((String)template)) continue;
            template = template.replace("#{" + key + "}", map.getOrDefault(key, ""));
        }
        return template;
    }

    private void writeAlarmLog(AlarmTypeEnum alarmTypeEnum, Long msgtypeId, Map<String, Object> msgResult, MessageInfo message, Map<String, String> map, DynamicObject alarmConfig) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"openapi_alarmlog");
        if (alarmConfig == null || message == null || msgResult == null || msgResult.size() <= 0) {
            DefaultAlarmMsgEnum defaultAlarmMsgEnum = DefaultAlarmMsgEnum.values()[alarmTypeEnum.ordinal()];
            log.set("msgtitle", (Object)StringUtil.substring((Object)OpenApiAlarmServiceImpl.replaceTemplateStr(defaultAlarmMsgEnum.getTitle(), map), (int)50));
            log.set("msg", (Object)StringUtil.substring((Object)OpenApiAlarmServiceImpl.replaceTemplateStr(defaultAlarmMsgEnum.getMsg(), map), (int)1000));
            log.set("status", (Object)"1");
            log.set("createtime", (Object)new Date());
            log.set("alarmtype", (Object)alarmTypeEnum.getCode());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
            return;
        }
        String title = message.getTitle();
        title = StringUtil.substring((Object)title, (int)50);
        log.set("msgtitle", (Object)title);
        String content = message.getContent();
        content = StringUtil.substring((Object)content, (int)1000);
        log.set("msg", (Object)content);
        log.set("createtime", (Object)new Date());
        log.set("alarmtype", (Object)alarmTypeEnum.getCode());
        if (alarmConfig != null) {
            log.set("msgtype", (Object)msgtypeId);
            log.set("alarmConfig", (Object)alarmConfig.getLong("id"));
        }
        MulBasedataDynamicObjectCollection receiverids = (MulBasedataDynamicObjectCollection)alarmConfig.get("receiverids");
        String receversName = receiverids.stream().map(it -> {
            if (it.get(1) != null) {
                return it.getDynamicObject(1).getString("name");
            }
            return "";
        }).collect(Collectors.joining(","));
        log.set("recevers", (Object)StringUtil.substring((Object)receversName, (int)100));
        this.setChannelmsgid(msgResult, log);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    private void setChannelmsgid(Map<String, Object> msgResult, DynamicObject log) {
        Boolean status = (Boolean)ObjectConverter.convert((Object)msgResult.get("success"), Boolean.class, (boolean)false);
        if (status.booleanValue()) {
            Map data = (Map)msgResult.get("data");
            List successMsgIds = (List)data.get("successMsgIds");
            log.set("channelmsgid", successMsgIds.get(0));
        }
    }
}

