/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.dataservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.model.ApiModel;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.Version;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OpenApiDataUtil {
    private static Log logger = LogFactory.getLog(OpenApiDataUtil.class);
    private static final String FORMID_APISERVICE_NEW = "open_apiservice_new";
    private static final String FORMID_APISERVICE = "open_apiservice";
    public static final String APISERVICETYPE = "apiservicetype";
    private static final String ENABLE = "enable";
    private static final String APISERVICEID = "id";
    private static final String APISERVICEID_ISDESENSITIZE = "id,isdesensitize";
    private static final String APISERVICE_ISDESENSITIZE = "isdesensitize";
    private static final String VERSION = "version";
    private static final String APISERVICETYPE_OPERATION = "0";
    private static final String APISERVICETYPE_AI = "1";
    private static final String APISERVICETYPE_CUSTOM = "2";
    private static final String OP_FORMID = "formId";
    private static final String OP_OPERATIONID = "operationId";
    private static final String CUS_SERVICENAME = "servicename";
    private static final String AP_COMMAND = "command";
    private static final String SPLIT = "-";

    private static ApiModel getApiModelFromDb(String url) {
        if (StringUtil.isEmpty((String)url)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u5730\u5740 [url] \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OpenApiDataUtil_0", (String)"bos-open-base", (Object[])new Object[0]), new Object[0]);
        }
        DynamicObject one = QueryServiceHelper.queryOne((String)"openapi_apilist", (String)"id, apiservicetype", (QFilter[])QFilterUtil.builder().put("urlformat", "=", url).put(Version.VERSION, "=", Version.TWO.getVer()).build());
        if (one == null) {
            String tenantId = RequestContext.get().getTenantId();
            String accountId = RequestContext.get().getAccountId();
            String userName = RequestContext.get().getUserName();
            String logMsg = String.format("Cannot found OpenAPI(or disabled), tenantId: %s, accountId: %s, userName: %s, url:%s", tenantId, accountId, userName, url);
            logger.info(logMsg);
            String msg = String.format("Cannot found OpenAPI(or disabled), url:%s", url);
            throw new OpenApiException(ApiErrorCode.HTTP_NOT_FOUND, msg, new Object[0]);
        }
        Object pkValue = one.get(APISERVICEID);
        ApiServiceType type = ApiServiceType.get((int)one.getInt(APISERVICETYPE));
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)type.getEntityName());
        return new ApiModel(object);
    }

    public static ApiModel getApiModelFromOnlyCache(String url) {
        if (StringUtil.isEmpty((String)url)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u5730\u5740 [url] \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OpenApiDataUtil_0", (String)"bos-open-base", (Object[])new Object[0]), new Object[0]);
        }
        ApiModel apiModel = LocalCacheUtil.getCacheByKey(ApiModel.class, url);
        return apiModel;
    }

    public static ApiModel getApiModelFromCache(String url) {
        ApiModel apiModel = OpenApiDataUtil.getApiModelFromOnlyCache(url);
        if (apiModel != null) {
            return apiModel;
        }
        apiModel = OpenApiDataUtil.getApiModelFromDb(url);
        LocalCacheUtil.setCacheByKey(url, apiModel);
        return apiModel;
    }

    public static ApiModel getApiModelFromCache(Long apiId) {
        if (apiId != null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"apiId \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OpenApiDataUtil_1", (String)"bos-open-base", (Object[])new Object[0]), new Object[0]);
        }
        DynamicObject api = BusinessDataServiceHelper.loadSingle((String)"openapi_apilist", (String)"id,urlformat", (QFilter[])new QFilter[]{new QFilter(APISERVICEID, "=", (Object)apiId)});
        return OpenApiDataUtil.getApiModelFromCache(api.getString("urlformat"));
    }

    public static OpenApiData getApiOldModelFromCache(Map<String, String> params) {
        String formId = params.get(OP_FORMID);
        String operationId = params.get(OP_OPERATIONID);
        String apiservicetype = params.get(APISERVICETYPE);
        String servicename = params.get(CUS_SERVICENAME);
        String aiCommand = params.get(AP_COMMAND);
        String url = params.get("urlformat");
        String cacheKey = "";
        if (ApiServiceType.OPERATION.name().equalsIgnoreCase(apiservicetype)) {
            cacheKey = apiservicetype + SPLIT + formId + SPLIT + operationId;
        } else if (ApiServiceType.CUSTOM.name().equalsIgnoreCase(apiservicetype)) {
            cacheKey = apiservicetype + SPLIT + servicename;
        } else if (ApiServiceType.AI.name().equalsIgnoreCase(apiservicetype)) {
            cacheKey = apiservicetype + SPLIT + aiCommand;
        } else {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "Invalid apiservicetype for API 1.0.", new Object[0]);
        }
        OpenApiData apiModel = LocalCacheUtil.getCacheByKey(OpenApiData.class, cacheKey);
        if (apiModel != null) {
            return apiModel;
        }
        if (ApiServiceType.OPERATION.name().equalsIgnoreCase(apiservicetype)) {
            Boolean apiIsDesensitize;
            QFilter[] qFilters = OpenApiDataUtil.getFilterforOp(formId, operationId);
            Map<String, Object> apiService = OpenApiDataUtil.getApiserviceIdAndDesensize(FORMID_APISERVICE_NEW, qFilters);
            String apiid = apiService != null ? (String)apiService.get(APISERVICEID) : null;
            Boolean bl = apiIsDesensitize = apiService != null && apiService.get(APISERVICE_ISDESENSITIZE) != null ? (Boolean)apiService.get(APISERVICE_ISDESENSITIZE) : Boolean.TRUE;
            if (apiid != null) {
                apiModel = new OpenApiData();
                apiModel.setApiId(Long.parseLong(apiid));
                apiModel.setApiServiceType(ApiServiceType.OPERATION);
                apiModel.setCheckRepeatReq(((Boolean)apiService.getOrDefault("check_repeat_req", false)).booleanValue());
                apiModel.setDesensitize(apiIsDesensitize.booleanValue());
            }
        } else if (ApiServiceType.CUSTOM.name().equalsIgnoreCase(apiservicetype)) {
            DynamicObject apiid = OpenApiDataUtil.getApiserviceIdforCus(servicename);
            if (apiid != null) {
                apiModel = new OpenApiData();
                apiModel.setApiId(apiid.getLong(APISERVICEID));
                apiModel.setApiServiceType(ApiServiceType.CUSTOM);
                apiModel.setCheckRepeatReq(apiid.getBoolean("check_repeat_req"));
            }
        } else if (ApiServiceType.AI.name().equalsIgnoreCase(apiservicetype)) {
            DynamicObject apiid = OpenApiDataUtil.getApiserviceIdforAi(aiCommand);
            if (apiid != null) {
                apiModel = new OpenApiData();
                apiModel.setApiId(apiid.getLong(APISERVICEID));
                apiModel.setApiServiceType(ApiServiceType.AI);
                apiModel.setCheckRepeatReq(apiid.getBoolean("check_repeat_req"));
            }
        } else {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "Invalid apiservicetype for API 1.0.", new Object[0]);
        }
        if (apiModel != null) {
            LocalCacheUtil.setCacheByKey(cacheKey, apiModel);
        }
        return apiModel;
    }

    static DynamicObject getApiserviceIdforOp(String formId, String operationKey) {
        QFilter[] qFilters = OpenApiDataUtil.getFilterforOp(formId, operationKey);
        return OpenApiDataUtil.getApiserviceId(FORMID_APISERVICE_NEW, qFilters);
    }

    static DynamicObject getApiserviceIdforCus(String number) {
        QFilter[] qFilters = OpenApiDataUtil.getFilterforCus(number);
        return OpenApiDataUtil.getApiserviceId(qFilters);
    }

    static DynamicObject getApiserviceIdforAi(String command) {
        QFilter[] qFilters = OpenApiDataUtil.getFilterforAi(command);
        return OpenApiDataUtil.getApiserviceId(FORMID_APISERVICE, qFilters);
    }

    private static QFilter[] getFilterforOp(String formId, String operationKey) {
        QFilter[] qFilters = new QFilter[]{new QFilter("bizobject", "=", (Object)formId), new QFilter("operation", "=", (Object)operationKey), new QFilter(APISERVICETYPE, "=", (Object)APISERVICETYPE_OPERATION), new QFilter(ENABLE, "=", (Object)APISERVICETYPE_AI), new QFilter(VERSION, "!=", (Object)APISERVICETYPE_CUSTOM)};
        return qFilters;
    }

    private static QFilter[] getFilterforCus(String number) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter(APISERVICETYPE, "=", (Object)APISERVICETYPE_CUSTOM), new QFilter(ENABLE, "=", (Object)APISERVICETYPE_AI)};
        return qFilters;
    }

    private static QFilter[] getFilterforAi(String command) {
        QFilter[] qFilters = new QFilter[]{new QFilter("aicommand.ainumber", "=", (Object)command), new QFilter(APISERVICETYPE, "=", (Object)APISERVICETYPE_AI), new QFilter(ENABLE, "=", (Object)APISERVICETYPE_AI)};
        return qFilters;
    }

    private static DynamicObject getApiserviceId(QFilter[] qFilters) {
        return OpenApiDataUtil.getApiserviceId(FORMID_APISERVICE, qFilters);
    }

    private static DynamicObject getApiserviceId(String formId, QFilter[] qFilters) {
        DynamicObjectCollection apis = OpenApiDataUtil.getApis(formId, "id,check_repeat_req", qFilters);
        if (apis.size() > 0) {
            return (DynamicObject)apis.get(0);
        }
        return null;
    }

    private static Map<String, Object> getApiserviceIdAndDesensize(String formId, QFilter[] qFilters) {
        DynamicObjectCollection apis = OpenApiDataUtil.getApis(formId, "id,isdesensitize,check_repeat_req", qFilters);
        if (apis.size() > 0) {
            DynamicObject apiObj = (DynamicObject)apis.get(0);
            HashMap<String, Object> res = new HashMap<String, Object>(3);
            res.put(APISERVICEID, apiObj.getString(APISERVICEID));
            res.put(APISERVICE_ISDESENSITIZE, StringUtil.isNotEmpty((String)apiObj.getString(APISERVICE_ISDESENSITIZE)) ? Boolean.valueOf(apiObj.getBoolean(APISERVICE_ISDESENSITIZE)) : Boolean.FALSE);
            res.put("check_repeat_req", apiObj.getBoolean("check_repeat_req"));
            return res;
        }
        return null;
    }

    private static DynamicObjectCollection getApis(String formId, String selectFields, QFilter[] qFilters) {
        return QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])qFilters);
    }
}

