/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.openapi.base.model.IpModel;
import kd.bos.orm.util.CollectionUtils;

public class IpinfoModel {
    private static final String FROM_IP = "fromIp";
    private static final String TO_IP = "toIp";
    private static final int INIT_SIZE = 2;
    private boolean noLimitAccess;
    private int sense;
    private List<IpModel> list;
    private List<IpModel> blackList;
    private int ipv6Sense;
    private List<IpModel> ipv6WhiteList;
    private List<IpModel> ipv6BlackList;

    public List<Map<String, String>> getMapList() {
        if (CollectionUtils.isEmpty(this.getList())) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>(this.getList().size());
        for (IpModel ip : this.getList()) {
            HashMap<String, String> ipMap = new HashMap<String, String>(2);
            ipMap.put(FROM_IP, ip.getFromIp());
            ipMap.put(TO_IP, ip.getToIp());
            res.add(ipMap);
        }
        return res;
    }

    public List<Map<String, String>> getMapBlackList() {
        if (CollectionUtils.isEmpty(this.getBlackList())) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>(this.getBlackList().size());
        for (IpModel ip : this.getBlackList()) {
            HashMap<String, String> ipMap = new HashMap<String, String>(2);
            ipMap.put(FROM_IP, ip.getFromIp());
            ipMap.put(TO_IP, ip.getToIp());
            res.add(ipMap);
        }
        return res;
    }

    public List<Map<String, String>> getMapIPv6BlackList() {
        if (CollectionUtils.isEmpty(this.getIpv6BlackList())) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>(this.getIpv6BlackList().size());
        for (IpModel ip : this.getIpv6BlackList()) {
            HashMap<String, String> ipMap = new HashMap<String, String>(2);
            ipMap.put(FROM_IP, ip.getFromIp());
            ipMap.put(TO_IP, ip.getToIp());
            res.add(ipMap);
        }
        return res;
    }

    public List<Map<String, String>> getMapIPv6WhiteList() {
        if (CollectionUtils.isEmpty(this.getIpv6WhiteList())) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>(this.getIpv6WhiteList().size());
        for (IpModel ip : this.getIpv6WhiteList()) {
            HashMap<String, String> ipMap = new HashMap<String, String>(2);
            ipMap.put(FROM_IP, ip.getFromIp());
            ipMap.put(TO_IP, ip.getToIp());
            res.add(ipMap);
        }
        return res;
    }

    public void setList(List<IpModel> list) {
        this.list = list;
    }

    public void add(String fromIp, String toIp) {
        if (this.list == null) {
            this.list = new ArrayList<IpModel>();
        }
        IpModel ipModel = new IpModel(fromIp, toIp, "0");
        this.list.add(ipModel);
    }

    public void addBlack(String fromIp, String toIp) {
        if (this.blackList == null) {
            this.blackList = new ArrayList<IpModel>();
        }
        IpModel ipModel = new IpModel(fromIp, toIp, "1");
        this.blackList.add(ipModel);
    }

    public void addIPv6(String policy, String fromIp, String toIp) {
        if ("1".equals(policy)) {
            if (this.ipv6BlackList == null) {
                this.ipv6BlackList = new ArrayList<IpModel>();
            }
            IpModel ipModel = new IpModel(fromIp, toIp, "0");
            this.ipv6BlackList.add(ipModel);
        } else {
            if (this.ipv6WhiteList == null) {
                this.ipv6WhiteList = new ArrayList<IpModel>();
            }
            IpModel ipModel = new IpModel(fromIp, toIp, "0");
            this.ipv6WhiteList.add(ipModel);
        }
    }

    public List<IpModel> getBlackList() {
        return this.blackList;
    }

    public void setBlackList(List<IpModel> blackList) {
        this.blackList = blackList;
    }

    public List<IpModel> getList() {
        return this.list;
    }

    public boolean isNoLimitAccess() {
        return this.noLimitAccess;
    }

    public void setNoLimitAccess(boolean noLimitAccess) {
        this.noLimitAccess = noLimitAccess;
    }

    public int getSense() {
        return this.sense;
    }

    public void setSense(int sense) {
        this.sense = sense;
    }

    public List<IpModel> getIpv6WhiteList() {
        return this.ipv6WhiteList;
    }

    public void setIpv6WhiteList(List<IpModel> ipv6WhiteList) {
        this.ipv6WhiteList = ipv6WhiteList;
    }

    public List<IpModel> getIpv6BlackList() {
        return this.ipv6BlackList;
    }

    public void setIpv6BlackList(List<IpModel> ipv6BlackList) {
        this.ipv6BlackList = ipv6BlackList;
    }

    public int getIpv6Sense() {
        return this.ipv6Sense;
    }

    public void setIpv6Sense(int ipv6Sense) {
        this.ipv6Sense = ipv6Sense;
    }
}

