/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.queue;

import java.util.Arrays;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;

public enum OpenQueueType {
    None(0, "Other"),
    Event(1, "EventMsg"),
    Pooling(2, "PoolingMsg"),
    ApiAction(3, "ApiAction");

    private final int mCode;
    private final String title;

    private OpenQueueType(int value, String title) {
        this.mCode = value;
        this.title = title;
    }

    public int getCode() {
        return this.mCode;
    }

    public String getTitle() {
        return this.title;
    }

    public static OpenQueueType getQueueType(int code) {
        return Arrays.stream(OpenQueueType.values()).filter(it -> it.getCode() == code).findFirst().orElseThrow(() -> new OpenApiException(ApiErrorCode.Data_Invalid, "OpenQueueType code \u201c" + code + "\u201d is not supported", new Object[0]));
    }
}

