/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.queue;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.openapi.base.queue.OpenQueueConsumer;
import kd.bos.openapi.base.queue.OpenQueueExecutor;
import kd.bos.openapi.base.queue.OpenQueueItem;
import kd.bos.openapi.base.queue.OpenQueueMgr;
import kd.bos.openapi.base.queue.OpenQueueThreadMgr;

public class OpenQueueWorkerMgr {
    private static final Map<String, Set<Long>> concurrentTaskSet = new HashMap<String, Set<Long>>();

    private OpenQueueWorkerMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getConcurrentTaskSet() {
        String key = RequestContext.get().getAccountId();
        Set running = concurrentTaskSet.get(key);
        if (running == null) {
            Map<String, Set<Long>> map = concurrentTaskSet;
            synchronized (map) {
                running = concurrentTaskSet.computeIfAbsent(key, k -> Sets.newConcurrentHashSet());
            }
        }
        return running;
    }

    public static boolean canRun() {
        return OpenQueueWorkerMgr.getConcurrentTaskSet().size() < 15;
    }

    public static void submit(OpenQueueItem item, OpenQueueExecutor worker) {
        Set<Long> running = OpenQueueWorkerMgr.getConcurrentTaskSet();
        if (running.size() > 15) {
            return;
        }
        if (!running.add(item.getId())) {
            return;
        }
        OpenQueueThreadMgr.WORKER.submit(() -> {
            try {
                String queue = item.getQueue();
                String type = item.getType().toString();
                OpenQueueConsumer consumer = OpenQueueMgr.get().findConsumeByQueue(queue, type);
                if (consumer != null && worker.canHandle(item)) {
                    worker.handle(item, consumer);
                }
            }
            finally {
                running.remove(item.getId());
            }
        }, 0);
    }
}

