/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.queue.impl.db;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.openapi.base.queue.OpenQueue;
import kd.bos.openapi.base.queue.OpenQueueItem;
import kd.bos.openapi.base.queue.OpenQueueItemStatus;
import kd.bos.openapi.base.queue.OpenQueuePriority;
import kd.bos.openapi.base.queue.OpenQueueRequestContext;
import kd.bos.openapi.base.queue.OpenQueueType;
import kd.bos.openapi.base.queue.impl.db.OpenDbQueueNotifier;
import kd.bos.openapi.base.queue.impl.db.OpenDbQueueSaver;
import kd.bos.openapi.common.constant.ApiConstant;
import kd.bos.util.JSONUtils;

public class OpenDbQueueImpl
implements OpenQueue {
    private String name;

    public String getName() {
        return this.name;
    }

    public OpenDbQueueImpl(String name) {
        this.name = name;
    }

    @Override
    public void publish(long msgId, String queue, OpenQueueType type, OpenQueuePriority priority, Date scheduleTime, int deliveryCount, Object msg, long reqId, String remark) {
        OpenQueueItem item = new OpenQueueItem();
        if (msgId <= 0L) {
            msgId = ID.genLongId();
        }
        item.setId(msgId);
        item.setType(type);
        item.setQueue(queue);
        try {
            item.setData(JSONUtils.toString((Object)msg));
        }
        catch (Exception exception) {
            // empty catch block
        }
        item.setStatus(OpenQueueItemStatus.C1);
        item.setScheduleTime(scheduleTime);
        item.setPriority(priority);
        item.setDeliveryCount(deliveryCount);
        item.setReqId(reqId);
        item.setErrMsg("");
        item.setRemark(remark);
        OpenQueueRequestContext rc = new OpenQueueRequestContext();
        rc.setUserId(RequestContext.get().getUserId());
        rc.setUserName(RequestContext.get().getUserName());
        item.setRequestContext(rc);
        OpenDbQueueSaver.add(item);
        OpenDbQueueNotifier.notify(item);
    }

    @Override
    public void deleteByMsgId(String queue, long msgId) {
        String sql = "DELETE FROM t_openapi_queue WHERE fid=? and fqueue=?";
        DB.execute((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])new Object[]{msgId, queue});
    }
}

