/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.queue.impl.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.openapi.base.queue.OpenQueueConsumer;
import kd.bos.openapi.base.queue.OpenQueueExecutor;
import kd.bos.openapi.base.queue.OpenQueueItem;
import kd.bos.openapi.base.queue.OpenQueueItemStatus;
import kd.bos.openapi.base.queue.OpenQueuePriority;
import kd.bos.openapi.base.queue.OpenQueueRequestContext;
import kd.bos.openapi.base.queue.OpenQueueThreadMgr;
import kd.bos.openapi.base.queue.OpenQueueType;
import kd.bos.openapi.base.queue.OpenQueueUtil;
import kd.bos.openapi.base.queue.OpenQueueWorkerMgr;
import kd.bos.openapi.base.queue.impl.db.OpenDbQueueAcker;
import kd.bos.openapi.base.queue.impl.db.OpenDbQueueSaver;
import kd.bos.openapi.common.constant.ApiConstant;
import kd.bos.openapi.common.model.OpenApiAsyncMsgModel;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.util.JSONUtils;

public class OpenDbQueueLoader
implements Runnable,
OpenQueueExecutor {
    private final long id = ID.genLongId();
    private long nextScheduleTime = System.currentTimeMillis();
    private static final String QUEUE_FIELDS = " fid,fstatus,fqueue,ftype,fpriority,fdata,fscheduletime,fdeliverycount, freqid,fqueuetag,ferrmsg,fremark,fctx ";

    protected OpenDbQueueLoader() {
    }

    public long getId() {
        return this.id;
    }

    @Override
    public boolean canHandle(OpenQueueItem item) {
        return OpenDbQueueSaver.setRunning(item.getId(), this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(OpenQueueItem item, OpenQueueConsumer consumer) {
        if (item.getRequestContext() != null && RequestContext.get().getCurrUserId() < 0L) {
            RequestContext.get().setUserId(item.getRequestContext().getUserId());
            RequestContext.get().setUserName(item.getRequestContext().getUserName());
        }
        OpenDbQueueAcker acker = new OpenDbQueueAcker();
        try {
            Object data;
            OpenQueueType type = item.getType();
            switch (type) {
                case Event: 
                case Pooling: {
                    data = JacksonUtil.readValue((String)item.getData(), Object.class);
                    break;
                }
                case ApiAction: {
                    data = JacksonUtil.readValue((String)item.getData(), OpenApiAsyncMsgModel.class);
                    break;
                }
                case None: {
                    data = item.getData();
                    break;
                }
                default: {
                    data = item.getData();
                }
            }
            consumer.onMessage(data, item.getId(), item.getDeliveryCount() > 0, acker);
        }
        catch (Exception ex) {
            OpenDbQueueSaver.setQueueItemStatus(item.getId(), OpenQueueItemStatus.E1, ex.getMessage());
        }
        finally {
            acker.ack(item.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int delay;
        boolean isEmpty = true;
        try {
            List<OpenQueueItem> queueItems = this.loadFromDb();
            isEmpty = queueItems.isEmpty();
            for (OpenQueueItem item : queueItems) {
                OpenQueueWorkerMgr.submit(item, this);
            }
            delay = isEmpty ? 300 : 5;
        }
        catch (Throwable throwable) {
            int delay2 = isEmpty ? 300 : 5;
            this.nextScheduleTime = OpenQueueThreadMgr.MAIN.submit(this, delay2);
            throw throwable;
        }
        this.nextScheduleTime = OpenQueueThreadMgr.MAIN.submit(this, delay);
    }

    public boolean runNow(OpenQueueItem item) {
        if (OpenQueueWorkerMgr.canRun()) {
            OpenQueueWorkerMgr.submit(item, this);
            return true;
        }
        long t = System.currentTimeMillis() + 5000L;
        if (this.nextScheduleTime > t) {
            OpenQueueThreadMgr.MAIN.runAhead(this, 5);
            this.nextScheduleTime = t;
        }
        return false;
    }

    public boolean runNow(long msgId) {
        OpenQueueItem item = null;
        String sql = "select  fid,fstatus,fqueue,ftype,fpriority,fdata,fscheduletime,fdeliverycount, freqid,fqueuetag,ferrmsg,fremark,fctx  from t_openapi_queue  where fid = ? and fscheduletime<=? and fstatus = ? and fqueuetag=?";
        Object[] params = new Object[]{msgId, new Date(System.currentTimeMillis() + 200L), OpenQueueItemStatus.C1, OpenQueueUtil.getHostTag()};
        try (DataSet dataSet = DB.queryDataSet((String)"openapi.queue", (DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])params);){
            RowMeta rowMeta = dataSet.getRowMeta();
            List<String> fieldNames = Arrays.asList(rowMeta.getFieldNames());
            for (Row row : dataSet) {
                item = this.covertRowToItem(row, fieldNames);
            }
        }
        if (item != null) {
            return this.runNow(item);
        }
        return false;
    }

    private List<OpenQueueItem> loadFromDb() {
        String sql = String.format("select top %s  fid,fstatus,fqueue,ftype,fpriority,fdata,fscheduletime,fdeliverycount, freqid,fqueuetag,ferrmsg,fremark,fctx  from t_openapi_queue  where fscheduletime<=? and fstatus = ? and fqueuetag=?  order by fscheduletime,fpriority ", 50);
        Object[] params = new Object[]{new Date(System.currentTimeMillis() + 500L), OpenQueueItemStatus.C1, OpenQueueUtil.getHostTag()};
        ArrayList<OpenQueueItem> rtn = new ArrayList<OpenQueueItem>(50);
        try (DataSet dataSet = DB.queryDataSet((String)"openapi.queue", (DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])params);){
            RowMeta rowMeta = dataSet.getRowMeta();
            List<String> fieldNames = Arrays.asList(rowMeta.getFieldNames());
            for (Row row : dataSet) {
                rtn.add(this.covertRowToItem(row, fieldNames));
            }
        }
        return rtn;
    }

    private OpenQueueItem covertRowToItem(Row row, List<String> fieldNames) {
        OpenQueueItem item = new OpenQueueItem();
        if (fieldNames.contains("fid")) {
            item.setId(row.getLong("fid"));
        }
        if (fieldNames.contains("fstatus")) {
            item.setStatus(OpenQueueItemStatus.valueOf(row.getString("fstatus")));
        }
        if (fieldNames.contains("fqueue")) {
            item.setQueue(row.getString("fqueue"));
        }
        if (fieldNames.contains("ftype")) {
            int type = DataUtil.i((Object)row.getString("ftype"));
            item.setType(OpenQueueType.getQueueType(type));
        }
        if (fieldNames.contains("fpriority")) {
            int priority = DataUtil.i((Object)row.getString("fpriority"));
            item.setPriority(OpenQueuePriority.getPriority(priority));
        }
        if (fieldNames.contains("fdata")) {
            item.setData(row.getString("fdata"));
        }
        if (fieldNames.contains("fscheduletime")) {
            item.setScheduleTime(row.getDate("fscheduletime"));
        }
        if (fieldNames.contains("fdeliverycount")) {
            item.setDeliveryCount(row.getInteger("fdeliverycount"));
        }
        if (fieldNames.contains("freqid")) {
            item.setReqId(row.getLong("freqid"));
        }
        if (fieldNames.contains("fqueuetag")) {
            item.setQueueTag(row.getString("fqueuetag"));
        }
        if (fieldNames.contains("ferrmsg")) {
            item.setErrMsg(row.getString("ferrmsg"));
        }
        if (fieldNames.contains("fremark")) {
            item.setRemark(row.getString("fremark"));
        }
        if (fieldNames.contains("fctx")) {
            String fctx = row.getString("fctx");
            OpenQueueRequestContext rc = null;
            try {
                if (StringUtil.isNotEmpty((String)fctx)) {
                    rc = (OpenQueueRequestContext)JSONUtils.cast((String)fctx, OpenQueueRequestContext.class);
                }
            }
            catch (Exception ignore) {
                rc = null;
            }
            item.setRequestContext(rc);
        }
        return item;
    }
}

