/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.queue.impl.db;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.queue.OpenQueueItemStatus;
import kd.bos.openapi.base.queue.OpenQueueThreadMgr;
import kd.bos.openapi.base.queue.OpenQueueUtil;
import kd.bos.openapi.base.queue.impl.db.OpenDbQueueLoader;
import kd.bos.openapi.common.constant.ApiConstant;

public class OpenDbQueueMgr {
    private static final Log log = LogFactory.getLog(OpenDbQueueMgr.class);
    private static final Map<String, OpenDbQueueLoader> tasks = new HashMap<String, OpenDbQueueLoader>();
    private static final int INIT_THREAD_DELAY = 30;
    private static final Object lockObject = new Object();

    private OpenDbQueueMgr() {
    }

    public static void clearDbLoader() {
        tasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenDbQueueLoader getLoader() {
        String key = RequestContext.get().getAccountId();
        OpenDbQueueLoader loader = tasks.get(key);
        if (loader == null) {
            Object object = lockObject;
            synchronized (object) {
                loader = new OpenDbQueueLoader();
                tasks.put(key, loader);
                OpenQueueThreadMgr.MAIN.submit(loader, 5);
                OpenQueueThreadMgr.MAIN.submit(new UpdateOnline(), 5);
                OpenQueueThreadMgr.MAIN.submit(new WorkerChecker(), 30);
                OpenQueueThreadMgr.MAIN.submit(new UnackItemChecker(), 30);
            }
        }
        return loader;
    }

    public static boolean getOpenQueueEnabled() {
        boolean existsOpenSub = false;
        try {
            SqlBuilder sql = new SqlBuilder().append("select top 1 fid from t_openapi_asyncdata", new Object[0]);
            try (DataSet dataSet = DB.queryDataSet((String)"openapi.queue", (DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);){
                if (dataSet != null && !dataSet.isEmpty()) {
                    log.info("Open--OpenQueue service is enabled, accountId\uff1a" + RequestContext.get().getAccountId());
                    existsOpenSub = true;
                }
            }
        }
        catch (Exception nothing) {
            log.info(String.format("Open-Error occurred when Loading t_openapi_asycdata, accountId\uff1a%s,error message: %s", RequestContext.get().getAccountId(), nothing.getMessage()));
        }
        return existsOpenSub;
    }

    static long getWorkerId() {
        return OpenDbQueueMgr.getLoader().getId();
    }

    private static class UnackItemChecker
    implements Runnable {
        private UnackItemChecker() {
        }

        @Override
        public void run() {
            try {
                this.updateUnackItem();
            }
            finally {
                OpenQueueThreadMgr.MAIN.submit(this, 300);
            }
        }

        private void updateUnackItem() {
            Date checkDate = new Date(System.currentTimeMillis() - 1800000L);
            Date startDate = new Date(0L);
            String sql = "UPDATE t_openapi_queue set fstatus=?,fmodifytime=? WHERE fstatus=? and fstarttime>? and fstarttime<? ";
            DB.update((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])new Object[]{OpenQueueItemStatus.T1, new Date(), OpenQueueItemStatus.R1, startDate, checkDate});
        }
    }

    private static class WorkerChecker
    implements Runnable {
        private WorkerChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SqlBuilder sql = new SqlBuilder().append("select fid,fhost,factiveat from t_openapi_queue_worker where factiveat<=?", new Object[]{new Date(System.currentTimeMillis() - 1800000L)});
                ArrayList<Long> delIds = new ArrayList<Long>(2);
                try (DataSet dataSet = DB.queryDataSet((String)"openapi.queue", (DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);){
                    for (Row row : dataSet) {
                        Long id = row.getLong("fid");
                        String host = row.getString("fhost");
                        this.updateByHost(id, host);
                        delIds.add(id);
                    }
                }
                if (!delIds.isEmpty()) {
                    sql = new SqlBuilder().append("DELETE FROM t_openapi_queue_worker where ", new Object[0]).appendIn("fid", delIds);
                    DB.execute((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
                }
            }
            finally {
                OpenQueueThreadMgr.MAIN.submit(this, 300);
            }
        }

        public void updateByHost(long id, String host) {
            String sql = "UPDATE t_openapi_queue set fstatus=?,fstarttime=null,fmodifytime=null WHERE fstatus=? and fdeliveryhost=?";
            DB.update((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])new Object[]{OpenQueueItemStatus.C1, OpenQueueItemStatus.R1, host});
        }
    }

    private static class UpdateOnline
    implements Runnable {
        private UpdateOnline() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long workerId = OpenDbQueueMgr.getWorkerId();
                SqlBuilder sql = new SqlBuilder().append("UPDATE t_openapi_queue_worker set factiveat=? WHERE fid=?", new Object[]{new Date(), workerId});
                int updateCount = DB.update((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
                if (updateCount == 0) {
                    String host = OpenQueueUtil.getHostName(workerId);
                    sql = new SqlBuilder().append("INSERT INTO t_openapi_queue_worker (fid,fhost,factiveat) values (?,?,?)", new Object[]{workerId, host, new Date()});
                    DB.execute((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
                }
            }
            finally {
                OpenQueueThreadMgr.MAIN.submit(this, 300);
            }
        }
    }
}

