/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.script;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.isc.util.dt.D;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.dataservice.OpenApiDataUtil;
import kd.bos.openapi.base.script.OpenApiScript;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.trace.TraceSpan;

public class OpenApiScriptUtil {
    protected static final Log LOG = LogFactory.getLog(OpenApiScriptUtil.class);
    private static final String VAR_NAME = "$api";

    public static Map<String, Object> parseInScript(String url, Map<String, Object> reqData, Map<String, String> queryString, Map<String, String> reqHeaders) {
        OpenApiScript inScript = OpenApiDataUtil.getApiModelFromCache(url).getInScript();
        if (inScript == null) {
            return reqData;
        }
        return null;
    }

    public static Object parseOutScript(String url, Map<String, Object> reqData, Map<String, String> queryString, Map<String, String> reqHeaders, Object respData, Map<String, String> respHeaders) {
        OpenApiScript outScript = OpenApiDataUtil.getApiModelFromCache(url).getOutScript();
        if (outScript == null) {
            return respData;
        }
        return null;
    }

    public static void checkParam(TraceSpan traceSpan, String functionName, Object[] args, String ... paramNames) {
        if (paramNames == null) {
            paramNames = new String[]{};
        }
        if (args.length != paramNames.length) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"%s\uff1a \u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d\u3002", (String)"OpenApiScriptUtil_0", (String)"bos-open-base", (Object[])new Object[0]), functionName), new Object[0]);
        }
        for (int i = 0; i < paramNames.length; ++i) {
            String key = paramNames[i];
            String value = OpenJsonUtil.toJson((Object)args[i]);
            traceSpan.addTag(key, value);
        }
    }

    public static boolean isEmptyScript(OpenApiScript script) {
        if (script == null) {
            return true;
        }
        return "(EOF)".equals(script.toString().replace(" ", ""));
    }

    public static boolean isExprScript(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String str = ((String)obj).trim();
        if (str.startsWith("#{") && str.endsWith("}")) {
            return true;
        }
        return str.startsWith("<%") && str.endsWith("%>");
    }

    public static Object handleExpr(String str, Map<String, Object> data) {
        if (str.startsWith("#{") && str.endsWith("}")) {
            return OpenApiScriptUtil.translate(str, data);
        }
        if (str.startsWith("<%") && str.endsWith("%>")) {
            return OpenApiScriptUtil.handleScript(str, data);
        }
        return str;
    }

    private static Object translate(String s, Map<String, Object> data) {
        if ("#{now}".equals(s)) {
            return Timestamp.valueOf(LocalDateTime.now());
        }
        if ("#{today}".equals(s)) {
            return DataUtil.toTimestamp((LocalDate)LocalDate.now());
        }
        if ("#{tenantId}".equals(s)) {
            return RequestContext.get().getTenantId();
        }
        if (s.startsWith("#{now-") || s.startsWith("#{now+")) {
            LocalDateTime localDateTime = OpenApiScriptUtil.parseLocalDateTime(LocalDateTime.now(), s, 5);
            return Timestamp.valueOf(localDateTime);
        }
        if (s.startsWith("#{today-") || s.startsWith("#{today+")) {
            LocalDate localDate = OpenApiScriptUtil.parseLocalDate(LocalDate.now(), s, 7);
            return DataUtil.toTimestamp((LocalDate)localDate);
        }
        if (s.startsWith("#{replace(")) {
            return OpenApiScriptUtil.replaceSubString(s, data);
        }
        if (s.startsWith("#{rtrim(")) {
            return OpenApiScriptUtil.rtrim(s, data);
        }
        throw new IllegalArgumentException(s);
    }

    private static Object handleScript(String str, Map<String, Object> data) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(1);
        ctx.put("$data", data);
        OpenApiScript script = OpenApiScriptUtil.parseScript(str, ctx);
        return script.eval(ctx);
    }

    public static OpenApiScript parseScript(String expr, Map<String, Object> ctx) {
        if (expr.startsWith("<%") && expr.endsWith("%>")) {
            int start = expr.indexOf("<%");
            int end = expr.lastIndexOf("%>");
            String scriptStr = expr.substring(start + 2, end);
            return OpenApiScript.compile(scriptStr, ctx);
        }
        throw new OpenApiException(ApiErrorCode.SCRIPT_ERROR, "The script pattern is \u201c <%xxx%> \u201d", new Object[0]);
    }

    private static LocalDateTime parseLocalDateTime(LocalDateTime now, String s, int startIndex) {
        if (s.endsWith("day}")) {
            int i = s.indexOf("day}");
            long days = Long.parseLong(OpenApiScriptUtil.getTrim(s, startIndex, i));
            return now.plusDays(days);
        }
        if (s.endsWith("hour}")) {
            int i = s.indexOf("hour}");
            long hours = Long.parseLong(OpenApiScriptUtil.getTrim(s, startIndex, i));
            return now.plusHours(hours);
        }
        if (s.endsWith("minute}")) {
            int i = s.indexOf("minute}");
            long minutes = Long.parseLong(OpenApiScriptUtil.getTrim(s, startIndex, i));
            return now.plusMinutes(minutes);
        }
        if (s.endsWith("month}")) {
            int i = s.indexOf("month}");
            long months = Long.parseLong(OpenApiScriptUtil.getTrim(s, startIndex, i));
            return now.plusMonths(months);
        }
        if (s.endsWith("year}")) {
            int i = s.indexOf("year}");
            long years = Long.parseLong(OpenApiScriptUtil.getTrim(s, startIndex, i));
            return now.plusYears(years);
        }
        if (s.endsWith("week}")) {
            int i = s.indexOf("week}");
            long weeks = Long.parseLong(OpenApiScriptUtil.getTrim(s, startIndex, i));
            return now.plusWeeks(weeks);
        }
        throw new IllegalArgumentException("\u201c" + s + "\u201d is illegal");
    }

    private static LocalDate parseLocalDate(LocalDate now, String s, int startIndex) {
        if (s.endsWith("day}")) {
            int i = s.indexOf("day}");
            long days = Long.parseLong(OpenApiScriptUtil.getTrim(s, startIndex, i));
            return now.plusDays(days);
        }
        if (s.endsWith("month}")) {
            int i = s.indexOf("month}");
            long months = Long.parseLong(OpenApiScriptUtil.getTrim(s, startIndex, i));
            return now.plusMonths(months);
        }
        if (s.endsWith("year}")) {
            int i = s.indexOf("year}");
            long years = Long.parseLong(OpenApiScriptUtil.getTrim(s, startIndex, i));
            return now.plusYears(years);
        }
        if (s.endsWith("week}")) {
            int i = s.indexOf("week}");
            long weeks = Long.parseLong(OpenApiScriptUtil.getTrim(s, startIndex, i));
            return now.plusWeeks(weeks);
        }
        throw new IllegalArgumentException("\u201c" + s + "\u201d is illegal");
    }

    private static String getTrim(String s, int startIndex, int i) {
        return s.substring(startIndex, i).replace(" ", "").trim();
    }

    private static Object replaceSubString(String s, Map<String, Object> data) {
        int k;
        int i = s.indexOf(40);
        int j = s.indexOf(44);
        String[] patterns = s.substring(j + 1, k = s.indexOf(41)).trim().split(",");
        if (patterns.length % 2 == 1) {
            throw new IllegalArgumentException("\u201c" + s + "\u201d is illegal");
        }
        String field = s.substring(i + 1, j).trim();
        String value = D.s((Object)data.get(field));
        if (value == null) {
            return null;
        }
        for (i = 0; i < patterns.length; i += 2) {
            String regex = patterns[i];
            String replacement = patterns[i + 1];
            String s1 = regex.substring(1, regex.length() - 1);
            String s2 = replacement.substring(1, replacement.length() - 1);
            value = value.replace(s1, s2);
        }
        return value;
    }

    private static Object rtrim(String s, Map<String, Object> data) {
        int k;
        int i = s.indexOf(40);
        int j = s.indexOf(44);
        String[] patterns = s.substring(j + 1, k = s.indexOf(41)).trim().split(",");
        if (patterns.length < 1) {
            throw new IllegalArgumentException("\u201c" + s + "\u201d is illegal");
        }
        String field = s.substring(i + 1, j).trim();
        String value = D.s((Object)data.get(field));
        if (value == null) {
            return null;
        }
        for (i = 0; i < patterns.length; ++i) {
            String regex = patterns[i];
            String s1 = regex.substring(1, regex.length() - 1);
            if (!value.endsWith(s1)) continue;
            value = value.substring(0, value.lastIndexOf(s1));
            break;
        }
        return value;
    }

    static {
        OpenApiScript.init();
    }
}

