/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.api.impl;

import com.alibaba.fastjson.JSON;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.acl.ApilAclManager;
import kd.bos.openapi.base.acl.IplimitManager;
import kd.bos.openapi.base.model.IpinfoModel;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.auth.AuthCheckService;
import kd.bos.openapi.base.security.auth.impl.AuthHandleServiceFactory;
import kd.bos.openapi.base.security.auth.impl.JwtAuthCheckServiceImpl;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.IpTypeEnum;
import kd.bos.openapi.common.util.IPWhiteListUtil;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.service.authorize.ApiAuthService;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.ApiIpInfo;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.service.authorize.model.AuthTypeEnum;
import kd.bos.service.authorize.model.JwtInfo;

public class ApiAuthServiceImpl
implements ApiAuthService {
    private static final Log log = LogFactory.getLog(ApiAuthServiceImpl.class);

    public AuthResult auth(AuthInfo authInfo) {
        AuthResult authResult = null;
        try {
            if (ApiSecurityFactory.isSecurityLogOpen()) {
                log.info("--------ApiAuthServiceImpl traceId:" + RequestContext.get().getTraceId());
                this.logInfo(authInfo);
            }
            AuthCheckService authCheckService = AuthHandleServiceFactory.getInstance(authInfo.getAuthType());
            authResult = authCheckService.doAuthCheck(authInfo);
        }
        catch (Exception e) {
            String msg = "traceId:" + RequestContext.get().getTraceId() + " auth error:" + e.getMessage();
            log.error(msg, (Throwable)e);
            authResult = AuthResult.fail((String)msg);
        }
        if (ApiSecurityFactory.isSecurityLogOpen()) {
            log.info("--------ApiAuthServiceImpl traceId:" + RequestContext.get().getTraceId() + " auth result:" + JSON.toJSONString((Object)authResult));
        }
        if (!authResult.isStatus()) {
            log.warn("--------ApiAuthServiceImpl traceId:" + RequestContext.get().getTraceId() + " auth result failed, message:" + authResult.getMessage());
        }
        return authResult;
    }

    private void logInfo(AuthInfo authInfo) {
        if (authInfo == null) {
            return;
        }
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append("--------params:");
        logBuilder.append(" accountId:").append(authInfo.getAccountId());
        logBuilder.append(" tenantId:").append(authInfo.getTenantId());
        logBuilder.append(" authType:").append(authInfo.getAuthType());
        logBuilder.append(" thirdAppNumber:").append(authInfo.getThirdAppNumber());
        logBuilder.append(" thirdAppId:").append(authInfo.getThirdId());
        logBuilder.append(" signInfo:").append(OpenJsonUtil.toJson((Object)authInfo.getSignInfo()));
        log.info(logBuilder.toString());
    }

    public <T> String generateJWTToken(JwtInfo<T> jwtInfo) {
        AuthCheckService authCheckService = AuthHandleServiceFactory.getInstance(AuthTypeEnum.AUTH_JWT.getId());
        if (authCheckService instanceof JwtAuthCheckServiceImpl) {
            JwtAuthCheckServiceImpl jwtAuthCheckService = (JwtAuthCheckServiceImpl)authCheckService;
            return jwtAuthCheckService.generateJWTToken(jwtInfo);
        }
        throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "the authCheckService is not jwtAuthService.", new Object[0]);
    }

    public ApiCommonResult checkIP(ApiIpInfo apiIpInfo) {
        if (apiIpInfo == null) {
            return ApiCommonResult.getFailResult((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)ResManager.loadKDString((String)"\u975e\u6cd5\u53c2\u6570", (String)"ApiAuthServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        String ip = apiIpInfo.getIp();
        if (IPWhiteListUtil.LOCAL_IP_127.equals(ip) || IPWhiteListUtil.LOCAL_IP.equals(ip)) {
            return ApiCommonResult.getSuccessResult((String)"0", (String)ResManager.loadKDString((String)"\u672c\u5730\u5f00\u53d1\u76f4\u63a5\u8fd4\u56de", (String)"ApiAuthServiceImpl_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        if (StringUtil.isEmpty((String)ip)) {
            return ApiCommonResult.getFailResult((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)String.format(ResManager.loadKDString((String)"%s \u53c2\u6570\u4e3a\u7a7a", (String)"ApiAuthServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), "IP"));
        }
        if (StringUtil.isEmpty((String)apiIpInfo.getThirdAppNumber())) {
            return ApiCommonResult.getFailResult((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)String.format(ResManager.loadKDString((String)"%s \u53c2\u6570\u4e3a\u7a7a", (String)"ApiAuthServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), "thirdAppNumber"));
        }
        if (StringUtil.isEmpty((String)apiIpInfo.getAccountId())) {
            return ApiCommonResult.getFailResult((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)String.format(ResManager.loadKDString((String)"%s \u53c2\u6570\u4e3a\u7a7a", (String)"ApiAuthServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), "accountId"));
        }
        Long thirdId = ApilAclManager.getThirdIdByNum(apiIpInfo.getThirdAppNumber(), apiIpInfo.getAccountId());
        if (thirdId == null || thirdId == 0L) {
            return ApiCommonResult.getFailResult((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)String.format(ResManager.loadKDString((String)"\u6839\u636e\u7b2c\u4e09\u65b9\u5e94\u7528\u7f16\u7801\uff1a%1$s \u548c\u6570\u636e\u4e2d\u5fc3\uff1a%2$s \u627e\u4e0d\u5230\u7b2c\u4e09\u65b9\u5e94\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApiAuthServiceImpl_3", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), apiIpInfo.getThirdAppNumber(), apiIpInfo.getAccountId()));
        }
        IpinfoModel model = IplimitManager.getIpInfoModelFromCacheByAccountId(thirdId.toString(), apiIpInfo.getAccountId());
        if (!model.isNoLimitAccess()) {
            boolean result = false;
            IpTypeEnum ipType = IPWhiteListUtil.getIpType((String)ip);
            if (IpTypeEnum.IPV4 == ipType) {
                result = this.checkClientIpValid(model, ip);
            } else if (IpTypeEnum.IPV6 == ipType) {
                result = this.checkClientIpv6Valid(model, ip);
            } else {
                throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, "invalid ipType for ip:" + ip, new Object[0]);
            }
            if (!result) {
                String ipNote = ip;
                if (ip.contains(IPWhiteListUtil.LOCAL_IP_127)) {
                    ipNote = ip.replaceAll(IPWhiteListUtil.LOCAL_IP_127, "");
                }
                throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, String.format("Client's IP: %s is not in white IP list", ipNote), new Object[0]);
            }
        }
        return ApiCommonResult.getSuccessResult((String)"0", (String)"OK");
    }

    private boolean checkClientIpValid(IpinfoModel model, String ip) {
        boolean result = false;
        String[] ips = ip.split(",");
        if (ips != null && ips.length > 0) {
            for (String ipstr : ips) {
                if (!StringUtil.isEmpty((String)ipstr) && !IPWhiteListUtil.LOCAL_IP_127.equals(ipstr.trim()) && (result = IPWhiteListUtil.checkIp((String)ipstr.trim(), model.getMapList()))) break;
            }
        }
        return result;
    }

    private boolean checkClientIpv6Valid(IpinfoModel model, String ip) {
        String ipStr;
        boolean result = false;
        String[] ips = ip.split(",");
        if (ips != null && ips.length > 0 && StringUtil.isNotEmpty((String)(ipStr = ips[0])) && !IPWhiteListUtil.LOCAL_IP_127.equals(ipStr.trim())) {
            result = IPWhiteListUtil.checkIpv6((String)ipStr.trim(), model.getMapIPv6WhiteList());
        }
        return result;
    }
}

