/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.api.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.encrypt.EncryptService;
import kd.bos.openapi.base.security.encrypt.impl.EncryptServiceImpl;
import kd.bos.openapi.base.security.gate.impl.ApiGateServiceImpl;
import kd.bos.openapi.base.security.sign.SignService;
import kd.bos.openapi.base.security.sign.impl.SignServiceImpl;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.security.ApiGateService;
import kd.bos.openapi.security.ApiSecurityService;
import kd.bos.openapi.security.acl.ThirdAclService;
import kd.bos.openapi.security.oauth.token.ApiTokenService;
import kd.bos.service.authorize.token.AccessTokenService;

public class ApiSecurityFactory {
    private static Log log = LogFactory.getLog(ApiSecurityFactory.class);
    private static volatile SignService signService;
    private static volatile EncryptService encryptService;
    private static volatile ThirdAclService thirdAclService;
    private static volatile ApiGateService apiGateService;
    private static volatile AccessTokenService accessTokenService;
    private static volatile Map<String, ApiTokenService> apiTokenServiceMap;
    private static ApiSecurityService apiSecurityService;

    public static boolean isSecurityLogOpen() {
        return McConfigUtil.isSecurityLogOpen((String)RequestContext.get().getTenantId());
    }

    public static SignService getSignService() {
        if (signService == null) {
            signService = new SignServiceImpl();
        }
        return signService;
    }

    public static EncryptService getEncryptService() {
        if (encryptService == null) {
            encryptService = new EncryptServiceImpl();
        }
        return encryptService;
    }

    public static ThirdAclService getThirdAclService() {
        if (thirdAclService == null) {
            thirdAclService = (ThirdAclService)ApiSecurityFactory.loadService(ThirdAclService.class);
        }
        return thirdAclService;
    }

    private static Object loadService(Class<?> clazz) {
        ServiceLoader<?> loadedService = ServiceLoader.load(clazz);
        Iterator<?> serviceIterator = loadedService.iterator();
        if (serviceIterator.hasNext()) {
            return serviceIterator.next();
        }
        throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "Cannot found ServiceImpl:" + clazz.getCanonicalName(), new Object[0]);
    }

    public static ApiSecurityService getApiSecurityService() {
        if (apiSecurityService == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the apiSecurityService.", new Object[0]);
        }
        return apiSecurityService;
    }

    public static ApiGateService getApiGateService() {
        if (apiGateService == null) {
            apiGateService = new ApiGateServiceImpl();
        }
        return apiGateService;
    }

    public static AccessTokenService getAccessTokenService() {
        if (accessTokenService == null) {
            accessTokenService = (AccessTokenService)ApiSecurityFactory.loadService(AccessTokenService.class);
        }
        return accessTokenService;
    }

    public static synchronized ApiTokenService getApiTokenService(String version) {
        ApiTokenService tokenService = null;
        if (apiTokenServiceMap == null) {
            apiTokenServiceMap = new ConcurrentHashMap<String, ApiTokenService>(2);
            ServiceLoader<ApiTokenService> loadedService = ServiceLoader.load(ApiTokenService.class);
            Iterator<ApiTokenService> serviceIterator = loadedService.iterator();
            try {
                while (serviceIterator.hasNext()) {
                    tokenService = serviceIterator.next();
                    apiTokenServiceMap.put(tokenService.getVersion(), tokenService);
                }
            }
            catch (Throwable e) {
                String msg = "An error occurred while creating the ApiTokenService:" + e.getMessage();
                throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, msg, new Object[]{e});
            }
        }
        if ((tokenService = apiTokenServiceMap.get(version)) == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "Cannot found ServiceImpl:" + ApiTokenService.class.getCanonicalName(), new Object[0]);
        }
        return tokenService;
    }

    static {
        apiSecurityService = (ApiSecurityService)ApiSecurityFactory.loadService(ApiSecurityService.class);
    }
}

