/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.api.impl;

import kd.bos.encrypt.EncrypterFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.auth.ResultHandleService;
import kd.bos.openapi.base.security.auth.impl.AuthHandleServiceFactory;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.ApiSecurityService;
import kd.bos.openapi.security.CertKeyUtil;
import kd.bos.openapi.security.model.CertificateInfo;
import kd.bos.openapi.security.model.EncryptInfo;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.openapi.security.model.ResponseSecurityDto;
import kd.bos.openapi.security.model.SignInfoDto;
import org.apache.commons.lang3.RandomStringUtils;

public class ApiSecurityServiceImpl
implements ApiSecurityService {
    private static final Log log = LogFactory.getLog(ApiSecurityServiceImpl.class);
    private static final String CACHE_KEY_RSA = "RSA_PAIR_KEY";
    private static int DEFAULT_RANDOM_KEY_LENGTH = 16;

    public EncryptInfo encrypt(String content, String algorithm, String publicKeyBase64, String privateKeyBase64) {
        String randomKey = RandomStringUtils.randomAlphabetic((int)DEFAULT_RANDOM_KEY_LENGTH);
        String result = ApiSecurityFactory.getEncryptService().encrypt(content, algorithm, randomKey);
        String dgtlEnvlp = "";
        if (StringUtil.isNotEmpty((String)publicKeyBase64) && StringUtil.isEmpty((String)privateKeyBase64)) {
            dgtlEnvlp = this.signByPublicKey(randomKey, publicKeyBase64);
        } else if (StringUtil.isEmpty((String)publicKeyBase64) && StringUtil.isNotEmpty((String)privateKeyBase64)) {
            dgtlEnvlp = this.signByPrivateKey(randomKey, privateKeyBase64);
        } else {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "only support one of key(publicKeyBase64,privateKeyBase64), please set null for other key", new Object[0]);
        }
        return EncryptInfo.valueOf((String)result, (String)dgtlEnvlp);
    }

    public String decrypt(String encryptContent, String algorithm, String randomKey) {
        return ApiSecurityFactory.getEncryptService().decrypt(encryptContent, algorithm, randomKey);
    }

    public String signByPublicKey(String content, String publicKeyBase64) {
        publicKeyBase64 = this.deCodeKey(publicKeyBase64);
        return ApiSecurityFactory.getSignService().signByPublicKey(content, publicKeyBase64);
    }

    public String signByPrivateKey(String content, String privateKeyBase64) {
        privateKeyBase64 = this.deCodeKey(privateKeyBase64);
        return ApiSecurityFactory.getSignService().signByPrivateKey(content, privateKeyBase64);
    }

    public String unSignByPublicKey(String signedContent, String publicKeyBase64) {
        publicKeyBase64 = this.deCodeKey(publicKeyBase64);
        return ApiSecurityFactory.getSignService().unSignByPublicKey(signedContent, publicKeyBase64);
    }

    public String unSignByPrivateKey(String signedContent, String privateKeyBase64) {
        privateKeyBase64 = this.deCodeKey(privateKeyBase64);
        return ApiSecurityFactory.getSignService().unSignByPrivateKey(signedContent, privateKeyBase64);
    }

    private String deCodeKey(String base64Key) {
        String result = base64Key;
        if (EncrypterFactory.getEncrypter().isEncrypted(base64Key)) {
            result = EncrypterFactory.getEncrypter().decode(base64Key);
        }
        return result;
    }

    public CertificateInfo getRsaKey(String accountId, Long thirdId, String authType, String certType) {
        if (StringUtil.isEmpty((String)accountId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the accountId is null", new Object[0]);
        }
        if (thirdId == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdId is null", new Object[0]);
        }
        if (StringUtil.isEmpty((String)authType)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the authType is null", new Object[0]);
        }
        if (StringUtil.isEmpty((String)certType)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the certType is null", new Object[0]);
        }
        Open3rdappsDto open3rdappsDto = ThirdAppSecurityUtil.getThirdByAccountAndThirdId(accountId, thirdId);
        if (open3rdappsDto == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "getRsaKey the open3rdappsDto is null", new Object[0]);
        }
        String certKey = "";
        try {
            certKey = CertKeyUtil.getCertKey((String)authType, (String)certType);
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "getRsaKey the open3rdappsDto is null", new Object[0]);
        }
        return (CertificateInfo)open3rdappsDto.getCertMaps().get(certKey);
    }

    public Open3rdappsDto getOpen3rdappsDtoBy(String accountId, Long thirdId) {
        if (StringUtil.isEmpty((String)accountId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the accountId is null", new Object[0]);
        }
        if (StringUtil.isEmpty((String)accountId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdId is null", new Object[0]);
        }
        return ThirdAppSecurityUtil.getOpen3rdAppsById(accountId, thirdId);
    }

    private String signBySha256(String content, String key) {
        if (StringUtil.isEmpty((String)content)) {
            return "";
        }
        if (StringUtil.isEmpty((String)key)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the key is invalid", new Object[0]);
        }
        key = this.deCodeKey(key);
        return ApiSecurityFactory.getSignService().signBySha256(content, key);
    }

    public <T> Object resultHandle(ResponseSecurityDto<T> responseSecurityDto) {
        if (StringUtil.isEmpty((String)responseSecurityDto.getAuthType()) || "4".equalsIgnoreCase(responseSecurityDto.getAuthType()) || "3".equalsIgnoreCase(responseSecurityDto.getAuthType()) || "1".equalsIgnoreCase(responseSecurityDto.getAuthType())) {
            return responseSecurityDto.getData();
        }
        if (responseSecurityDto.getThirdId() == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "ThirdAppId is null", new Object[0]);
        }
        ResultHandleService resultHandleService = AuthHandleServiceFactory.getResultHandleServiceInstance(responseSecurityDto.getAuthType());
        return resultHandleService.doResultHandle(responseSecurityDto);
    }

    public String signing(SignInfoDto signInfo) {
        return ApiSecurityFactory.getSignService().signing(signInfo);
    }

    public String signingBySha256(String signKey, SignInfoDto signInfoDto) {
        return ApiSecurityFactory.getSignService().signingBySha256(signKey, signInfoDto);
    }
}

