/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.api.impl;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.LoginUserService;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.auth.AuthCheckService;
import kd.bos.openapi.base.security.auth.impl.AuthHandleServiceFactory;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CacheUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.StrategyTypeCodeEnum;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.security.auth.OpenApiAuthService;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.openapi.security.model.SsoIpInfoDto;
import kd.bos.service.authorize.model.AccessTokenInfo;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.service.authorize.model.OAuth2Authentication;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang3.RandomUtils;

public class OpenApiAuthServiceImpl
implements OpenApiAuthService {
    private static final Log log = LogFactory.getLog(OpenApiAuthServiceImpl.class);
    public static final String ENTITY_THIRD_APP = "third_app";
    public static final String ENTITY_SSOIP = "entity_ssoip";
    public static final String ENTITY_SUB_STRATEGY = "strategy";
    public static final String DOMAIN_IP = "domain_ip";
    public static final String STRATEGYTYPEID_ID = "strategytypeid_id";

    public AuthResult auth(AuthInfo authInfo) {
        String traceId = "traceId:";
        if (ApiSecurityFactory.isSecurityLogOpen()) {
            traceId = traceId + (RequestContext.get() == null ? RandomUtils.nextLong() + "" : RequestContext.get().getTraceId());
        }
        AuthResult authResult = null;
        try {
            AuthCheckService authCheckService = AuthHandleServiceFactory.getInstance(authInfo.getAuthType());
            authResult = authCheckService.doAuthCheck(authInfo);
        }
        catch (Exception e) {
            String msg = traceId + " auth error:" + e.getMessage();
            log.error(msg, (Throwable)e);
            if (e instanceof OpenApiException) {
                throw e;
            }
            authResult = AuthResult.fail((String)msg);
        }
        return authResult;
    }

    public Long getThirdIdByNum(String thirdAppNum, String accountId) {
        return ThirdAppSecurityUtil.getThirdIdByNum(thirdAppNum, accountId);
    }

    public Open3rdappsDto getThirdAppDtoByNum(String thirdAppNum, String accountId) {
        Long thirdId = ThirdAppSecurityUtil.getThirdIdByNum(thirdAppNum, accountId);
        return ThirdAppSecurityUtil.getThirdByAccountAndThirdId(accountId, thirdId);
    }

    public Map<String, String> getUserInfoByUserName(String userName) {
        return LoginUserService.getErpUserInfoByUserName((Account)OpenApiAuthContext.getContext().getCurrentCenter(), (String)userName, (String)OpenApiAuthContext.getContext().getLang().getLangTag());
    }

    public String getAccountIdByToken(String token) {
        String realToken = token;
        if (token.startsWith("OPENAPIAUTH_")) {
            try {
                String oldTokenBase = token.substring("OPENAPIAUTH_".length());
                realToken = new String(Base64.getUrlDecoder().decode(oldTokenBase));
            }
            catch (Exception e) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u65e0\u6548Token\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApiTokenServiceImpl_18", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
            }
        }
        OAuth2Authentication oAuth2Authentication = new OAuth2Authentication();
        AccessTokenInfo accessTokenInfo = new AccessTokenInfo();
        accessTokenInfo.setToken(realToken);
        oAuth2Authentication.setToken(accessTokenInfo);
        ApiCommonResult result = ApiSecurityFactory.getAccessTokenService().getAccountIdByToken(oAuth2Authentication);
        if (result == null || !result.getStatus().booleanValue() || StringUtil.isEmpty((String)((String)result.getData()))) {
            if (realToken.indexOf("_") > 0) {
                return realToken.substring(0, realToken.indexOf("_"));
            }
            return null;
        }
        return (String)result.getData();
    }

    public DynamicObject updateSsoIpInfoByThirdAppNum(String thirdAppNum, List<String> domainIps, boolean isHasRight) {
        if (CollectionUtil.isEmpty(domainIps)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "domainIps is null.", new Object[0]);
        }
        if (StringUtil.isEmpty((String)thirdAppNum)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The thirdAppNum is null.", new Object[0]);
        }
        Long thirdId = ThirdAppSecurityUtil.getThirdIdByNum(thirdAppNum, RequestContext.get().getAccountId());
        if (thirdId == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "updateSsoIpInfoByThirdAppNum failed: thirdId is null", new Object[0]);
        }
        String key = OpenApiAuthServiceImpl.getSsoIPCacheKey(thirdId);
        LocalCacheUtil.removeCacheByKey("THIRDAPP_SSOLIST", key);
        return this.updateSsoInfoListByThirdAppId(thirdId, domainIps, isHasRight);
    }

    public List<SsoIpInfoDto> findSsoIpInfoByThirdAppNum(String thirdAppNum) {
        List<SsoIpInfoDto> ssoIpInfoDtoList;
        if (StringUtil.isEmpty((String)thirdAppNum)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The thirdAppNum is null.", new Object[0]);
        }
        Long thirdId = ThirdAppSecurityUtil.getThirdIdByNum(thirdAppNum, RequestContext.get().getAccountId());
        if (thirdId == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "findSsoIpInfoByThirdAppNum failed: thirdId is null", new Object[0]);
        }
        String key = OpenApiAuthServiceImpl.getSsoIPCacheKey(thirdId);
        Object listObj = CacheUtil.getCacheByKey((String)"THIRDAPP_SSOLIST", (String)key, (String)RequestContext.get().getAccountId());
        if (listObj == null) {
            ssoIpInfoDtoList = this.getSsoInfoListByThirdAppId(thirdId);
            if (ssoIpInfoDtoList != null) {
                LocalCacheUtil.setCacheByKey("THIRDAPP_SSOLIST", key, ssoIpInfoDtoList);
            }
        } else {
            ssoIpInfoDtoList = (List<SsoIpInfoDto>)listObj;
        }
        return ssoIpInfoDtoList;
    }

    private static String getSsoIPCacheKey(Long thirdId) {
        return "THIRDAPP_SSOLIST".concat("_").concat(thirdId.toString());
    }

    private List<SsoIpInfoDto> getSsoInfoListByThirdAppId(Long thirdId) {
        String sql_third = " select fid,fentryid,fseq,fdomain_ip from t_open_3rdapps_ssoip t where t.fid = ? ";
        List list = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql_third, (Object[])new SqlParameter[]{new SqlParameter(":fid", -5, (Object)thirdId)}, rs -> {
            ArrayList<SsoIpInfoDto> ssoIpInfoDtoList = new ArrayList<SsoIpInfoDto>(8);
            while (rs.next()) {
                SsoIpInfoDto ssoIpInfoDto = new SsoIpInfoDto();
                ssoIpInfoDto.setDomainIp(rs.getString("fdomain_ip"));
                ssoIpInfoDto.setEntryId(Long.valueOf(rs.getLong("fentryid")));
                ssoIpInfoDto.setThirdAppId(thirdId);
                ssoIpInfoDto.setSeq(rs.getInt("fseq"));
                ssoIpInfoDtoList.add(ssoIpInfoDto);
            }
            return ssoIpInfoDtoList;
        });
        return list;
    }

    private DynamicObject updateSsoInfoListByThirdAppId(Long thirdId, List<String> domainIps, boolean isHasRight) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)thirdId, (String)ENTITY_THIRD_APP);
        DynamicObjectCollection ssoIp = object.getDynamicObjectCollection(ENTITY_SSOIP);
        ssoIp.clear();
        for (String domainIp : domainIps) {
            DynamicObject item = new DynamicObject(ssoIp.getDynamicObjectType());
            item.set(DOMAIN_IP, (Object)domainIp);
            ssoIp.add((Object)item);
        }
        DynamicObjectCollection strategy = object.getDynamicObjectCollection(ENTITY_SUB_STRATEGY);
        if (strategy.stream().noneMatch(it -> StrategyTypeCodeEnum.SSOIP_POLICY.getId().longValue() == it.getLong(STRATEGYTYPEID_ID))) {
            DynamicObject item = new DynamicObject(strategy.getDynamicObjectType());
            item.set(STRATEGYTYPEID_ID, (Object)StrategyTypeCodeEnum.SSOIP_POLICY.getId());
            strategy.add((Object)item);
        }
        OperateOption option = OperateOption.create();
        if (isHasRight) {
            option.setVariableValue("ishasright", String.valueOf(true));
        }
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_THIRD_APP, (DynamicObject[])new DynamicObject[]{object}, (OperateOption)option);
        OpenApiAuthServiceImpl.check(saveResult);
        return object;
    }

    public static void check(OperationResult rs) {
        if (!rs.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo op : rs.getAllErrorOrValidateInfo()) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(op.getTitle()).append(' ').append(op.getMessage());
            }
            if (sb.length() == 0) {
                throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, rs.getMessage(), new Object[0]);
            }
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, sb.toString(), new Object[0]);
        }
    }
}

