/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.auth.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.auth.filter.HandleResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.CustomApiService;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.openapi.base.security.auth.ResultHandleService;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.utils.OpenApiPluginUtil;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.openapi.security.model.ResponseSecurityDto;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;
import kd.bos.service.authorize.model.ApiCommonResult;

public class AuthExtendResultHandleServiceImpl
implements ResultHandleService {
    private static final Log log = LogFactory.getLog(AuthExtendResultHandleServiceImpl.class);

    @Override
    public <T> Object doResultHandle(ResponseSecurityDto<T> responseSecurityDto) {
        Open3rdappsDto thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndThirdId(responseSecurityDto.getAccountId(), responseSecurityDto.getThirdId());
        if (!thirdApp.isEnableAuthExtPlugin()) {
            return responseSecurityDto.getData();
        }
        Map<String, String> map = AuthExtendResultHandleServiceImpl.getHeards();
        responseSecurityDto.setHeaders(map);
        Object[] data = new Object[]{responseSecurityDto};
        HandleResult result = HandleResult.getHandleResult(null);
        Map pluginMap = OpenApiPluginUtil.getAuthPluginClass((String)"api_global_authplugin", (String)responseSecurityDto.getAccountId());
        String plugin = (String)pluginMap.get("api_global_authplugin");
        String appId = (String)pluginMap.get("api_global_pluginappid");
        if (StringUtil.isEmpty((String)plugin) || StringUtil.isEmpty((String)appId)) {
            result.setHandled(false);
            return result;
        }
        ApiCommonResult apiCommonResult = null;
        OpenApiResponse response = null;
        try {
            ArrayList<Object> args = new ArrayList<Object>(16);
            args.add(plugin);
            args.add("signAndEncrypt");
            if (data != null) {
                args.add(data);
            }
            if ((response = (OpenApiResponse)DispatchApiServiceHelper.invokeApiService((String)appId, (String)CustomApiService.class.getSimpleName(), (String)"invokePlugin", (Object[])args.toArray())) == null || response.getData() == null) {
                return responseSecurityDto.getData();
            }
            apiCommonResult = (ApiCommonResult)response.getData();
            if (!apiCommonResult.getStatus().booleanValue()) {
                throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, String.format(ResManager.loadKDString((String)"API\u8ba4\u8bc1\u63d2\u4ef6\u52a0\u5bc6\u5931\u8d25\u3002message: %1$s", (String)"OpenAuthExtendFilter_0", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), apiCommonResult == null ? "" : apiCommonResult.getMessage()), new Object[0]);
            }
            return apiCommonResult.getData();
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, "AuthExtendResultHandleServiceImpl.doResultHandle  error:" + e.getMessage(), new Object[0]);
        }
    }

    private static Map<String, String> getHeards() {
        HttpServletRequest request = OpenApiContext.getRequest();
        HashMap<String, String> map = new HashMap<String, String>();
        if (null == request) {
            return null;
        }
        Enumeration enumerationHeards = request.getHeaderNames();
        if (null == enumerationHeards) {
            return null;
        }
        while (enumerationHeards.hasMoreElements()) {
            String name = (String)enumerationHeards.nextElement();
            String value = request.getHeader(name);
            map.put(name, value);
        }
        return map;
    }
}

