/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.auth.impl;

import kd.bos.openapi.base.security.auth.AuthCheckService;
import kd.bos.openapi.base.security.auth.ResultHandleService;
import kd.bos.openapi.base.security.auth.impl.AccessTokenAuthCheckServiceImpl;
import kd.bos.openapi.base.security.auth.impl.AuthExtendResultHandleServiceImpl;
import kd.bos.openapi.base.security.auth.impl.BasicAuthCheckServiceImpl;
import kd.bos.openapi.base.security.auth.impl.DigestAuthCheckServiceImpl;
import kd.bos.openapi.base.security.auth.impl.DigestResultHandleServiceImpl;
import kd.bos.openapi.base.security.auth.impl.JwtAuthCheckServiceImpl;
import kd.bos.openapi.base.security.auth.impl.SignAuthCheckServiceImpl;
import kd.bos.openapi.base.security.auth.impl.SignResultHandleServiceImpl;
import kd.bos.openapi.base.security.cert.CertService;
import kd.bos.openapi.base.security.cert.impl.CertServiceImpl;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.service.authorize.model.AuthTypeEnum;

public class AuthHandleServiceFactory {
    public static AuthCheckService getInstance(String authType) {
        if (AuthTypeEnum.getAuthEnum((String)authType) == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "only support one of accessToken, digest,jwt,basicAuth, signAuth", new Object[0]);
        }
        AuthCheckService authCheckService = null;
        switch (authType) {
            case "1": {
                authCheckService = new AccessTokenAuthCheckServiceImpl();
                break;
            }
            case "2": {
                authCheckService = new DigestAuthCheckServiceImpl();
                break;
            }
            case "3": {
                authCheckService = new JwtAuthCheckServiceImpl();
                break;
            }
            case "4": {
                authCheckService = new BasicAuthCheckServiceImpl();
                break;
            }
            case "5": {
                authCheckService = new SignAuthCheckServiceImpl();
                break;
            }
        }
        if (authCheckService == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "only support one of digest,jwt,basicAuth, signAuth", new Object[0]);
        }
        return authCheckService;
    }

    public static ResultHandleService getResultHandleServiceInstance(String auth) {
        if (StringUtil.isEmpty((String)auth) || !"5".equalsIgnoreCase(auth) && !"2".equalsIgnoreCase(auth) && !"6".equalsIgnoreCase(auth)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "only support one of digest,signAuth, authExt", new Object[0]);
        }
        ResultHandleService resultHandleService = null;
        switch (auth) {
            case "2": {
                resultHandleService = new DigestResultHandleServiceImpl();
                break;
            }
            case "5": {
                resultHandleService = new SignResultHandleServiceImpl();
                break;
            }
            case "6": {
                resultHandleService = new AuthExtendResultHandleServiceImpl();
            }
        }
        if (resultHandleService == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "only support one of digest,signAuth, authExt", new Object[0]);
        }
        return resultHandleService;
    }

    public static CertService getCertServiceInstance() {
        return new CertServiceImpl();
    }
}

