/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.cert.impl;

import java.security.KeyPair;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.encrypt.impl.RSAEncrypterUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.isc.util.db.DbUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.cert.CertService;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CertificateUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.model.CertificateInfo;
import org.apache.commons.codec.binary.Base64;

public class CertServiceImpl
implements CertService {
    private static final Log log = LogFactory.getLog(CertServiceImpl.class);
    private static final String KINGDEE = "kingdee";
    private static final String COUNTRY_CHINA = "china";

    public static String base64encode(byte[] key) {
        return Base64.encodeBase64String((byte[])key);
    }

    public static byte[] base64Decode(String base64) {
        return Base64.decodeBase64((String)base64);
    }

    public static KeyPair generatorKeyPair() {
        KeyPair keyPair = null;
        try {
            keyPair = RSAEncrypterUtil.genKeyPair((int)1024);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "generateKey is error:" + e.getMessage(), new Object[0]);
        }
        return keyPair;
    }

    @Override
    public Pair<String, String> generatePairKey() {
        KeyPair keyPair = CertServiceImpl.generatorKeyPair();
        String publicKey = CertServiceImpl.base64encode(keyPair.getPublic().getEncoded());
        String privateKey = CertServiceImpl.base64encode(keyPair.getPrivate().getEncoded());
        return new Pair((Object)privateKey, (Object)publicKey);
    }

    public Map<String, String> generateKey() {
        Pair<String, String> keyPair = this.generatePairKey();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("privateKey", (String)keyPair.getKey());
        resultMap.put("publicKey", (String)keyPair.getValue());
        return resultMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean createCert(CertificateInfo certificateInfo) {
        boolean bl;
        Long csrId;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        boolean result;
        boolean createNew;
        String certType;
        Long thirdId;
        block13: {
            if (StringUtil.isEmpty((String)certificateInfo.getAccountId())) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "The accountId is null", new Object[0]);
            }
            thirdId = certificateInfo.getThirdId();
            certType = certificateInfo.getCertType();
            createNew = certificateInfo.isCreateNew();
            if (StringUtil.isEmpty((String)certType)) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "The certType is null", new Object[0]);
            }
            if (thirdId == null) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "The thirdId is null", new Object[0]);
            }
            Account account = AccountUtils.getAccountById((String)certificateInfo.getAccountId());
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account);
            if (dataBaseProperties == null) {
                String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u79df\u6237\u6570\u636e\u5e93\u8fde\u63a5!", (String)"ThirdAppSecurityUtil_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]);
                throw new KDException(BosErrorCode.configNotFound, new Object[]{msg});
            }
            result = false;
            conn = null;
            pstmt = null;
            rs = null;
            conn = MCDBUtil.getConnection((Account)account, (Properties)dataBaseProperties);
            String sql_check = " select t1.fcaid, t1.fcertificatetype,t1.fcsrid,t1.fcertificateid from T_OPEN_CERTIFICATE_USE t1 where t1.fthirdid=?  ";
            csrId = null;
            pstmt = conn.prepareStatement(sql_check);
            pstmt.setLong(1, thirdId);
            rs = pstmt.executeQuery();
            String exitsCertType = "";
            if (rs.next()) {
                csrId = rs.getLong("fcsrid");
                exitsCertType = rs.getString("fcertificatetype");
            }
            if (createNew || csrId == null || !certType.equalsIgnoreCase(exitsCertType)) break block13;
            boolean bl2 = true;
            DbUtil.close((Connection)conn, (Statement)pstmt, (ResultSet)rs);
            return bl2;
        }
        try {
            java.util.Date now = new java.util.Date();
            boolean updateCertResult = true;
            if (createNew && csrId != null) {
                pstmt = conn.prepareStatement("update T_OPEN_CERTIFICATE set fstatus='X',fmodifierid=?,fmodifytime=? where fcsrid =? and fcertificatetype=? and fstatus='A' ");
                pstmt.setLong(1, certificateInfo.getModifierid());
                pstmt.setTimestamp(2, new Timestamp(now.getTime()));
                pstmt.setLong(3, csrId);
                pstmt.setString(4, certType);
                boolean certUpdateResult = pstmt.executeUpdate() > 0;
                pstmt = conn.prepareStatement("update T_OPEN_CERT_AUTHORIZ set fstatus='X',fmodifierid=?,fmodifytime=? where fcsrid =? and fcertificatetype=? and fstatus='A' ");
                pstmt.setLong(1, certificateInfo.getModifierid());
                pstmt.setTimestamp(2, new Timestamp(now.getTime()));
                pstmt.setLong(3, csrId);
                pstmt.setString(4, certType);
                boolean certAuthUpdateResult = pstmt.executeUpdate() > 0;
                pstmt = conn.prepareStatement("update T_OPEN_CERTIFICATE_USE set fstatus='X',fmodifierid=?,fmodifytime=? where fcsrid =? and fcertificatetype=? and fstatus='A' ");
                pstmt.setLong(1, certificateInfo.getModifierid());
                pstmt.setTimestamp(2, new Timestamp(now.getTime()));
                pstmt.setLong(3, csrId);
                pstmt.setString(4, certType);
                boolean certUseUpdateResult = pstmt.executeUpdate() > 0;
                updateCertResult = certUpdateResult && certAuthUpdateResult && certUseUpdateResult;
            }
            String sql_csr = " insert into T_OPEN_CERT_SIGNING_REQUEST(fid,fnumber,fcompany,fcountry,fname,fstatus,fthirdid,fcreatorid,fmodifierid,fmodifytime) values(?,?,?,?,?,'A',?,?,?,?) ";
            String sql_cert = " insert into T_OPEN_CERTIFICATE(fid,fnumber,fpublickey,fprivatekey,fcertificatetype,fcsrid,fstatus,fcreatorid,fmodifierid,fmodifytime) values(?,?,?,?,?,?,'A',?,?,?) ";
            String sql_auth = " insert into T_OPEN_CERT_AUTHORIZ(fid,fnumber,fcertificateid,fissuer,fstarttime,fendtime,fcsrid,fcertificatetype,fstatus,fcreatorid,fmodifierid,fmodifytime) values(?,?,?,?,?,?,?,?,'A',?,?,?) ";
            String sql_use = " insert into T_OPEN_CERTIFICATE_USE(fid,fthirdid,fcaid,fcertificatetype,fcsrid,fcertificateid,fstatus,fcreatorid,fmodifierid,fmodifytime) values(?,?,?,?,?,?,'A',?,?,?) ";
            boolean csrResult = true;
            if (csrId == null) {
                csrId = ID.genLongId();
                pstmt = conn.prepareStatement(sql_csr);
                pstmt.setLong(1, csrId);
                pstmt.setString(2, CertificateUtil.generateNo((String)"CR", (long)csrId));
                pstmt.setString(3, KINGDEE);
                pstmt.setString(4, COUNTRY_CHINA);
                pstmt.setString(5, thirdId.toString());
                pstmt.setLong(6, thirdId);
                pstmt.setLong(7, certificateInfo.getModifierid());
                pstmt.setLong(8, certificateInfo.getModifierid());
                pstmt.setTimestamp(9, new Timestamp(now.getTime()));
                csrResult = pstmt.executeUpdate() > 0;
            }
            Pair<String, String> pairKey = this.generatePairKey();
            Long certId = ID.genLongId();
            pstmt = conn.prepareStatement(sql_cert);
            pstmt.setLong(1, certId);
            pstmt.setString(2, CertificateUtil.generateNo((String)"CT", (long)certId));
            pstmt.setString(3, EncrypterFactory.getEncrypter().encode((String)pairKey.getValue()));
            pstmt.setString(4, EncrypterFactory.getEncrypter().encode((String)pairKey.getKey()));
            pstmt.setString(5, certType);
            pstmt.setLong(6, csrId);
            pstmt.setLong(7, certificateInfo.getModifierid());
            pstmt.setLong(8, certificateInfo.getModifierid());
            pstmt.setTimestamp(9, new Timestamp(now.getTime()));
            boolean certResult = pstmt.executeUpdate() > 0;
            Long certAuthId = ID.genLongId();
            pstmt = conn.prepareStatement(sql_auth);
            pstmt.setLong(1, certAuthId);
            pstmt.setString(2, CertificateUtil.generateNo((String)"CA", (long)certAuthId));
            pstmt.setLong(3, certId);
            pstmt.setString(4, KINGDEE);
            pstmt.setDate(5, new Date(now.getTime()));
            pstmt.setDate(6, new Date(DateUtil.getDateAdd((java.util.Date)now, (int)1, (int)3).getTime()));
            pstmt.setLong(7, csrId);
            pstmt.setString(8, certType);
            pstmt.setLong(9, certificateInfo.getModifierid());
            pstmt.setLong(10, certificateInfo.getModifierid());
            pstmt.setTimestamp(11, new Timestamp(now.getTime()));
            boolean certAuthResult = pstmt.executeUpdate() > 0;
            Long certUseId = ID.genLongId();
            pstmt = conn.prepareStatement(sql_use);
            pstmt.setLong(1, certUseId);
            pstmt.setLong(2, thirdId);
            pstmt.setLong(3, certAuthId);
            pstmt.setString(4, certType);
            pstmt.setLong(5, csrId);
            pstmt.setLong(6, certId);
            pstmt.setLong(7, certificateInfo.getModifierid());
            pstmt.setLong(8, certificateInfo.getModifierid());
            pstmt.setTimestamp(9, new Timestamp(now.getTime()));
            boolean certUsehResult = pstmt.executeUpdate() > 0;
            bl = result = csrResult && certResult && certAuthResult && certUsehResult && updateCertResult;
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e.getMessage())});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e2.getMessage())});
                }
            }
            catch (Throwable throwable) {
                DbUtil.close((Connection)conn, pstmt, rs);
                throw throwable;
            }
        }
        DbUtil.close((Connection)conn, (Statement)pstmt, (ResultSet)rs);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkCertExits(String accountId, String certType, Long thirdId) {
        boolean bl;
        if (StringUtil.isEmpty((String)accountId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The accountId is null", new Object[0]);
        }
        if (StringUtil.isEmpty((String)certType)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The certType is null", new Object[0]);
        }
        if (thirdId == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The thirdId is null", new Object[0]);
        }
        Account account = AccountUtils.getAccountById((String)accountId);
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account);
        if (dataBaseProperties == null) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u79df\u6237\u6570\u636e\u5e93\u8fde\u63a5!", (String)"ThirdAppSecurityUtil_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]);
            throw new KDException(BosErrorCode.configNotFound, new Object[]{msg});
        }
        boolean result = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = MCDBUtil.getConnection((Account)account, (Properties)dataBaseProperties);
            String sql_check = " select t1.fcaid, t1.fcertificatetype,t1.fcsrid,t1.fcertificateid from T_OPEN_CERTIFICATE_USE t1 where t1.fthirdid=? and t1.fcertificatetype=? ";
            pstmt = conn.prepareStatement(sql_check);
            pstmt.setLong(1, thirdId);
            pstmt.setString(2, certType);
            rs = pstmt.executeQuery();
            Long csrId = null;
            String exitsCertType = "";
            if (rs.next()) {
                csrId = rs.getLong("fcsrid");
                exitsCertType = rs.getString("fcertificatetype");
            }
            log.info("csrId:" + csrId + " exitsCertType:" + exitsCertType);
            if (csrId != null) {
                result = true;
            }
            bl = result;
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e.getMessage())});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e2.getMessage())});
                }
            }
            catch (Throwable throwable) {
                DbUtil.close((Connection)conn, pstmt, rs);
                throw throwable;
            }
        }
        DbUtil.close((Connection)conn, (Statement)pstmt, (ResultSet)rs);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CertificateInfo findCert(CertificateInfo certificateInfo) {
        CertificateInfo certificateInfo2;
        if (StringUtil.isEmpty((String)certificateInfo.getAccountId())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The accountId is null", new Object[0]);
        }
        if (StringUtil.isEmpty((String)certificateInfo.getCertType())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The certType is null", new Object[0]);
        }
        if (certificateInfo.getThirdId() == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The thirdId is null", new Object[0]);
        }
        Account account = AccountUtils.getAccountById((String)certificateInfo.getAccountId());
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account);
        if (dataBaseProperties == null) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u79df\u6237\u6570\u636e\u5e93\u8fde\u63a5!", (String)"ThirdAppSecurityUtil_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]);
            throw new KDException(BosErrorCode.configNotFound, new Object[]{msg});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = MCDBUtil.getConnection((Account)account, (Properties)dataBaseProperties);
            String sql = "select a.fnumber,a.fstarttime,a.fendtime, c.fpublickey,c.fprivatekey,c.fcertificatetype  from T_OPEN_CERTIFICATE_USE u  left join T_OPEN_CERT_AUTHORIZ a on u.fcaid=a.fid  left join T_OPEN_CERTIFICATE c on u.fcertificateid=c.fid  where a.fstatus='A' and c.fstatus='A' and u.fstatus='A' and u.fthirdid=? and u.fcertificatetype=? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, certificateInfo.getThirdId());
            pstmt.setString(2, certificateInfo.getCertType());
            CertificateInfo certificateResult = null;
            rs = pstmt.executeQuery();
            if (rs.next()) {
                String publickey = rs.getString("fpublickey");
                String privatekey = rs.getString("fprivatekey");
                String certificatetype = rs.getString("fcertificatetype");
                Date startDate = rs.getDate("fstarttime");
                Date endDate = rs.getDate("fendtime");
                certificateResult = new CertificateInfo(privatekey, publickey, certificatetype, (java.util.Date)startDate, (java.util.Date)endDate, "A");
            }
            certificateInfo2 = certificateResult;
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e.getMessage())});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e2.getMessage())});
                }
            }
            catch (Throwable throwable) {
                DbUtil.close((Connection)conn, pstmt, rs);
                throw throwable;
            }
        }
        DbUtil.close((Connection)conn, (Statement)pstmt, (ResultSet)rs);
        return certificateInfo2;
    }
}

