/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.encrypt.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.crypto.EncryptorFactory;
import kd.bos.openapi.base.security.encrypt.EncryptService;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;

public class EncryptServiceImpl
implements EncryptService {
    private static Map<String, String> algorithmMap = new HashMap<String, String>();
    private static int DEFAULT_ENCRYPT_LENGTH = 128;

    @Override
    public String encrypt(String content, String algorithm, String randomKey) {
        return this.encrypt(content, algorithm, randomKey, DEFAULT_ENCRYPT_LENGTH);
    }

    @Override
    public String encrypt(String content, String algorithm, String randomKey, int encryptLength) {
        if (StringUtil.isEmpty((String)content)) {
            return "";
        }
        if (!algorithmMap.containsKey(algorithm)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "not support algorithm:" + algorithm, new Object[0]);
        }
        if (StringUtil.isEmpty((String)randomKey)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "not support randomKey, the randomKey is null", new Object[0]);
        }
        if (encryptLength < 128) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "not support encryptLength, the length should not be less 128, encryptLength:" + encryptLength, new Object[0]);
        }
        return EncryptorFactory.getEncryptor((String)algorithmMap.get(algorithm)).encrypt(content, randomKey, encryptLength);
    }

    @Override
    public String decrypt(String encryptContent, String algorithm, String randomKey) {
        return this.decrypt(encryptContent, algorithm, randomKey, DEFAULT_ENCRYPT_LENGTH);
    }

    @Override
    public String decrypt(String encryptContent, String algorithm, String randomKey, int encryptLength) {
        if (StringUtil.isEmpty((String)encryptContent)) {
            return "";
        }
        if (!algorithmMap.containsKey(algorithm)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "not support algorithm:" + algorithm, new Object[0]);
        }
        if (StringUtil.isEmpty((String)randomKey)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "not support randomKey:" + randomKey, new Object[0]);
        }
        if (encryptLength < 128) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "not support encryptLength, the length should not be less 128, encryptLength:" + encryptLength, new Object[0]);
        }
        return EncryptorFactory.getEncryptor((String)algorithmMap.get(algorithm)).decrypt(encryptContent, randomKey, encryptLength);
    }

    static {
        algorithmMap.put("AES", "AES/GCM/NoPadding");
        algorithmMap.put("SM4", "SM4/GCM/NoPadding");
    }
}

