/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.gate.impl;

import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.acl.IplimitManager;
import kd.bos.openapi.base.model.IpconfigSenseEnum;
import kd.bos.openapi.base.model.IpinfoModel;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.IpTypeEnum;
import kd.bos.openapi.common.util.IPWhiteListUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.ApiGateService;
import kd.bos.openapi.security.model.ApiIpInfoDto;
import kd.bos.service.authorize.model.ApiCommonResult;

public class ApiGateServiceImpl
implements ApiGateService {
    private static Log log = LogFactory.getLog(ApiGateServiceImpl.class);

    public ApiCommonResult checkIP(ApiIpInfoDto apiIpInfoDto) {
        List clientIpList;
        String clientIp;
        IpTypeEnum ipType;
        String ip = apiIpInfoDto.getIp();
        if (IPWhiteListUtil.LOCAL_IP_127.equals(ip) || IPWhiteListUtil.LOCAL_IP.equals(ip)) {
            return ApiCommonResult.getSuccessResult((String)"0", (String)ResManager.loadKDString((String)"\u672c\u5730\u5f00\u53d1\u76f4\u63a5\u8fd4\u56de", (String)"ApiAuthServiceImpl_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        if (StringUtil.isEmpty((String)ip)) {
            return ApiCommonResult.getFailResult((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)String.format(ResManager.loadKDString((String)"%s \u53c2\u6570\u4e3a\u7a7a", (String)"ApiAuthServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), "IP"));
        }
        if (StringUtil.isEmpty((String)apiIpInfoDto.getThirdAppNumber()) && apiIpInfoDto.getThirdId() == null) {
            return ApiCommonResult.getFailResult((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)String.format(ResManager.loadKDString((String)"%s \u53c2\u6570\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"ApiAuthServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), "thirdAppNumber and ThirdId"));
        }
        Long thirdId = null;
        thirdId = StringUtil.isNotEmpty((String)apiIpInfoDto.getThirdAppNumber()) ? ThirdAppSecurityUtil.getThirdIdByNum(apiIpInfoDto.getThirdAppNumber(), apiIpInfoDto.getAccountId()) : apiIpInfoDto.getThirdId();
        IpinfoModel model = IplimitManager.getIpInfoModelFromCacheByAccountId(thirdId.toString(), apiIpInfoDto.getAccountId());
        if (model.isNoLimitAccess()) {
            return ApiCommonResult.getSuccessResult((String)"0", (String)ResManager.loadKDString((String)"\u5141\u8bb8\u5168\u90e8IP\u8bbf\u95ee", (String)"ApiAuthServiceImpl_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        String ipNote = ip;
        if (ip.contains(IPWhiteListUtil.LOCAL_IP_127)) {
            ipNote = ip.replaceAll(IPWhiteListUtil.LOCAL_IP_127, "");
        }
        if ((ipType = IPWhiteListUtil.getIpType((String)(clientIp = (clientIpList = IPWhiteListUtil.getAllIpLIst((String)ip)).size() > 0 ? (String)clientIpList.get(0) : ""))) != null && IpTypeEnum.IPV6 == ipType) {
            return this.ipv6CheckIP(model, clientIp);
        }
        boolean result = false;
        if (IpconfigSenseEnum.NO_CONFIG.getSense() == model.getSense()) {
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, String.format("Client's IP: %s is not allow access.", ipNote), new Object[0]);
        }
        if (IpconfigSenseEnum.WHITE.getSense() == model.getSense()) {
            String ipstr;
            Iterator iterator = clientIpList.iterator();
            while (iterator.hasNext() && !(result = IPWhiteListUtil.checkIp((String)(ipstr = (String)iterator.next()).trim(), model.getMapList()))) {
            }
            if (!result) {
                throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, String.format("Client's IP: %s is not in white IP list", ipNote), new Object[0]);
            }
        } else if (IpconfigSenseEnum.BLACK.getSense() == model.getSense()) {
            String ipstr;
            Iterator iterator = clientIpList.iterator();
            while (iterator.hasNext() && !(result = IPWhiteListUtil.checkIp((String)(ipstr = (String)iterator.next()).trim(), model.getMapBlackList()))) {
            }
            if (result) {
                throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, String.format("Client's IP: %s is in black IP list", ipNote), new Object[0]);
            }
        } else if (IpconfigSenseEnum.WHITE_AND_BLACK.getSense() == model.getSense()) {
            String ipstr;
            Iterator iterator = clientIpList.iterator();
            while (iterator.hasNext() && !(result = IPWhiteListUtil.checkIp((String)(ipstr = (String)iterator.next()).trim(), model.getMapList()))) {
            }
            if (!result) {
                iterator = clientIpList.iterator();
                while (iterator.hasNext() && !(result = IPWhiteListUtil.checkIp((String)(ipstr = (String)iterator.next()).trim(), model.getMapBlackList()))) {
                }
                if (result) {
                    throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, String.format("Client's IP: %s is in black IP list", ipNote), new Object[0]);
                }
            }
        } else {
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, String.format("This client IP check's sense: %s cannot to be support, please check it.", model.getSense()), new Object[0]);
        }
        return ApiCommonResult.getSuccessResult((String)"0", (String)"OK");
    }

    private ApiCommonResult ipv6CheckIP(IpinfoModel model, String clientIp) {
        boolean result = false;
        if (IpconfigSenseEnum.NO_CONFIG.getSense() == model.getIpv6Sense()) {
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, String.format("Client's IP: %s is not allow access.", clientIp), new Object[0]);
        }
        if (IpconfigSenseEnum.WHITE.getSense() == model.getIpv6Sense()) {
            result = IPWhiteListUtil.checkIpv6((String)clientIp, model.getMapIPv6WhiteList());
            if (!result) {
                throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, String.format("Client's IP: %s is not in white IP list", clientIp), new Object[0]);
            }
        } else if (IpconfigSenseEnum.BLACK.getSense() == model.getIpv6Sense()) {
            result = IPWhiteListUtil.checkIpv6((String)clientIp, model.getMapIPv6BlackList());
            if (result) {
                throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, String.format("Client's IP: %s is in black IP list", clientIp), new Object[0]);
            }
        } else if (IpconfigSenseEnum.WHITE_AND_BLACK.getSense() == model.getIpv6Sense()) {
            result = IPWhiteListUtil.checkIpv6((String)clientIp, model.getMapIPv6WhiteList());
            if (!result && (result = IPWhiteListUtil.checkIpv6((String)clientIp, model.getMapIPv6BlackList()))) {
                throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, String.format("Client's IP: %s is in black IP list", clientIp), new Object[0]);
            }
        } else {
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, String.format("This client IP check's sense: %s cannot to be support, please check it.", model.getSense()), new Object[0]);
        }
        return ApiCommonResult.getSuccessResult((String)"0", (String)"OK");
    }
}

