/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.oauth.token.impl;

import java.util.Base64;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.utils.DateUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.openapi.base.util.DistributeCacheUtil;
import kd.bos.openapi.base.util.ShaSignUtils;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.openapi.security.oauth.token.ApiTokenService;
import kd.bos.util.PasswordEncryptUtil;
import kd.bos.util.StringUtils;

public abstract class AbstractApiTokenService
implements ApiTokenService {
    public String getVersion() {
        return "v1";
    }

    protected void checkLock(String clientId, String clientSecret, String accountId) {
        String key = "AD_FAIL_LOCK_" + clientId;
        int lockTime = 180;
        String lockTimes = DistributeCacheUtil.getCacheByKey("CACHE_TYPE_CLIENT_ID_LOCK", key, accountId);
        if (StringUtil.isNotEmpty((String)lockTimes) && "ad_lock_key".equals(lockTimes)) {
            throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, String.format(ResManager.loadKDString((String)"\u4e0d\u6b63\u786e\u7684\u7b2c\u4e09\u65b9\u5e94\u7528\u7f16\u7801client_id\u6216client_secret\u7684\u8bbf\u95ee\u9519\u8bef\u5df2\u8fde\u7eed5\u6b21\uff0c\u8be5\u8d26\u53f7\u767b\u5f55\u5df2\u9501\u5b9a\uff0c\u8bf7\u5728%1$s\u79d2\u540e\u518d\u8bd5\u3002", (String)"ApiTokenServiceImpl_9", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), lockTime), new Object[0]);
        }
        if (StringUtil.isNotEmpty((String)lockTimes) && "5".equals(lockTimes)) {
            DistributeCacheUtil.setCacheByKey("CACHE_TYPE_CLIENT_ID_LOCK", key, "ad_lock_key", accountId, lockTime);
            throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, String.format(ResManager.loadKDString((String)"\u4e0d\u6b63\u786e\u7684\u7b2c\u4e09\u65b9\u5e94\u7528\u7f16\u7801client_id\u6216client_secret\u7684\u8bbf\u95ee\u9519\u8bef\u5df2\u8fde\u7eed5\u6b21\uff0c\u8be5\u8d26\u53f7\u767b\u5f55\u5df2\u9501\u5b9a\uff0c\u8bf7\u5728%1$s\u79d2\u540e\u518d\u8bd5\u3002", (String)"ApiTokenServiceImpl_9", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), lockTime), new Object[0]);
        }
        Open3rdappsDto thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndAppId(accountId, clientId);
        if (!PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt((String)String.valueOf(thirdApp.getFid())), (String)clientSecret, (String)thirdApp.getAccessToken())) {
            lockTimes = StringUtil.isEmpty((String)lockTimes) ? "1" : Integer.parseInt(lockTimes) + 1 + "";
            DistributeCacheUtil.setCacheByKey("CACHE_TYPE_CLIENT_ID_LOCK", key, lockTimes, accountId, lockTime);
            throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, String.format(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\uff08client_id\uff09\u6216AccessToken\u5bc6\u94a5\uff08client_secret\uff09 \u4e0d\u6b63\u786e, \u7b2c %1$s \u6b21\u5bc6\u94a5\u9a8c\u8bc1\u5931\u8d25\u3002", (String)"ApiTokenServiceImpl_10", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), lockTimes), new Object[0]);
        }
        DistributeCacheUtil.removeCacheByKey("CACHE_TYPE_CLIENT_ID_LOCK", key, accountId);
    }

    protected String getRealToken(String newToken) {
        if (StringUtil.isEmpty((String)newToken)) {
            return newToken;
        }
        if (newToken.indexOf("OPENAPIAUTH_") != 0) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u65e0\u6548Token\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApiTokenServiceImpl_18", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        String oldTokenBase = newToken.substring("OPENAPIAUTH_".length());
        String realToken = new String(Base64.getUrlDecoder().decode(oldTokenBase));
        return realToken;
    }

    protected String getNewToken(String token) {
        return "OPENAPIAUTH_" + Base64.getUrlEncoder().encodeToString(token.getBytes());
    }

    protected void checkDateTimeAndSignture(String nonce, String timestamp, String tenantId) {
        if (StringUtil.isEmpty((String)nonce)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u7f3a\u5c11nonce\u53c2\u6570\u3002", (String)"SignAuthCheckServiceImpl_13", (String)"bos-open-base", (Object[])new Object[0]), new Object[0]);
        }
        if (StringUtil.isEmpty((String)timestamp)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u7f3a\u5c11timestamp\u53c2\u6570\u3002", (String)"SignAuthCheckServiceImpl_8", (String)"bos-open-base", (Object[])new Object[0]), new Object[0]);
        }
        Date sDate = null;
        sDate = StringUtils.isNumericString((String)timestamp) ? DateUtil.getTime((String)timestamp) : DateUtils.parseDateTime((String)timestamp, (String)"yyyy-MM-dd HH:mm:ss");
        if (sDate == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:timestamp\u53c2\u6570\u4e0d\u662f\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f\uff0c\u6b63\u786e\u7684\u683c\u5f0f\u662f\uff1a{0}", (String)"SignAuthCheckServiceImpl_9", (String)"bos-open-base", (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}), new Object[0]);
        }
        int rangMiutes = ShaSignUtils.getSignRangeMinutes(tenantId);
        Date now = new Date();
        if (Math.abs(now.getTime() - sDate.getTime()) / 60000L > (long)rangMiutes) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:timestamp\u53c2\u6570\u4e0d\u5728\u6b63\u786e\u7684\u65f6\u95f4\u8303\u56f4\u3002", (String)"SignAuthCheckServiceImpl_10", (String)"bos-open-base", (Object[])new Object[0]), new Object[0]);
        }
        String currentNonce = DistributeCacheUtil.getCacheByKey("TokenAuthCheck", nonce, tenantId);
        if (StringUtil.isNotEmpty((String)currentNonce)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u672c\u6b21\u53c2\u6570nonce:{0}\u5df2\u7ecf\u8c03\u7528\u8fc7\u4e86\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u8c03\u7528\u3002", (String)"SignAuthCheckServiceImpl_14", (String)"bos-open-base", (Object[])new Object[]{currentNonce}), new Object[0]);
        }
        DistributeCacheUtil.setCacheByKey("TokenAuthCheck", nonce, "1", tenantId, rangMiutes * 60);
    }
}

