/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.oauth.token.impl;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.RequestContextInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.oauth.token.impl.AbstractApiTokenService;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.kcf.utils.ApiPluginRpcHelper;
import kd.bos.openapi.kcf.utils.OpenApiPluginUtil;
import kd.bos.service.authorize.model.ApiCommonResult;

public class ApiTokenCustomBaseServiceImpl
extends AbstractApiTokenService {
    private static final Log log = LogFactory.getLog(ApiTokenCustomBaseServiceImpl.class);

    @Override
    public String getVersion() {
        return "custom";
    }

    public <T> ApiCommonResult<T> getToken() {
        return this.callBy("getToken");
    }

    public <T> ApiCommonResult<T> refreshToken() {
        return this.callBy("refreshToken");
    }

    public <T> ApiCommonResult<T> verifyToken() {
        return this.callBy("verifyToken");
    }

    public <T> ApiCommonResult<T> withdrawToken() {
        return this.callBy("withdrawToken");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ApiCommonResult callBy(String method) {
        String accountId = OpenApiAuthContext.getContext().getCurrentCenter().getAccountId();
        String tenantId = OpenApiAuthContext.getContext().getCurrentCenter().getTenantId();
        Map pluginMap = OpenApiPluginUtil.getAuthPluginClass((String)"api_tokenext_plugin", (String)accountId);
        String plugin = (String)pluginMap.get("api_tokenext_plugin");
        String appId = (String)pluginMap.get("api_global_pluginappid");
        if (StringUtil.isEmpty((String)plugin)) throw new OpenApiException(ApiErrorCode.PLUGIN_ERROR, ResManager.loadKDString((String)"\u63d2\u4ef6\u65e0\u6548\u6216\u672a\u914d\u7f6e\u3002", (String)"ApiTokenCustomServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        if (StringUtil.isEmpty((String)appId)) {
            throw new OpenApiException(ApiErrorCode.PLUGIN_ERROR, ResManager.loadKDString((String)"\u63d2\u4ef6\u65e0\u6548\u6216\u672a\u914d\u7f6e\u3002", (String)"ApiTokenCustomServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        ApiCommonResult apiCommonResult = null;
        RequestContextInfo rc = new RequestContextInfo(tenantId, accountId);
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            apiCommonResult = (ApiCommonResult)ApiPluginRpcHelper.invokePlugin((String)appId, (String)plugin, (String)method, (Object[])new Object[0]);
            if (apiCommonResult == null || !apiCommonResult.getStatus().booleanValue()) {
                throw new OpenApiException(ApiErrorCode.Data_NoAuth, String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u63d2\u4ef6\u6267\u884c\u5931\u8d25: \u63d2\u4ef6\uff1a%1$s  method:%2$s\u3002", (String)"ApiTokenCustomServiceImpl_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), plugin, method), new Object[0]);
            }
            ApiCommonResult apiCommonResult2 = apiCommonResult;
            return apiCommonResult2;
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c error:%1$s\u3002", (String)"ApiTokenCustomServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), e.getMessage());
            throw new OpenApiException(ApiErrorCode.PLUGIN_ERROR, msg, new Object[]{e});
        }
    }
}

