/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.oauth.token.impl;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.util.DistributeCacheUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.kcf.utils.OpenApiPluginUtil;
import kd.bos.openapi.security.model.TokenUrlEnum;
import kd.bos.openapi.security.oauth.token.ApiTokenService;
import kd.bos.openapi.security.oauth.token.TokenFacadeService;
import kd.bos.service.authorize.model.ApiCommonResult;

public class TokenFacadeServiceImpl
implements TokenFacadeService {
    private static int TOKEN_LIMIT_COUNT = 30;
    private static int TOKEN_LIMIT_TIMEOUT = 60;
    private static String TOKEN_LIMIT_PREFIX = "TOKEN_LIMIT_";

    public <T> ApiCommonResult<T> invoke(String url, String version) {
        if (StringUtil.isEmpty((String)version)) {
            version = "v1";
        }
        ApiCommonResult result = null;
        if ("custom".equals(OpenApiAuthContext.getContext().getHeaders().get("OpenApiVer")) && this.isEnableTokenExt()) {
            version = "custom";
        }
        ApiTokenService apiTokenService = ApiSecurityFactory.getApiTokenService(version);
        switch (url) {
            case "/oauth2/getToken": {
                result = apiTokenService.getToken();
                break;
            }
            case "/oauth2/refreshToken": {
                result = apiTokenService.refreshToken();
                break;
            }
            case "/oauth2/verifyToken": {
                result = apiTokenService.verifyToken();
                break;
            }
            case "/oauth2/withdrawToken": {
                result = apiTokenService.withdrawToken();
                break;
            }
            default: {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: \u4e0d\u5408\u6cd5\u7684URL\u3002", (String)"OauthTokenUtil_4", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
            }
        }
        return result;
    }

    private boolean isEnableTokenExt() {
        Map pluginMap = OpenApiPluginUtil.getAuthPluginClass((String)"api_tokenext_plugin", (String)OpenApiAuthContext.getContext().getCurrentCenter().getAccountId());
        String plugin = (String)pluginMap.get("api_tokenext_plugin");
        String appId = (String)pluginMap.get("api_global_pluginappid");
        return !StringUtil.isEmpty((String)plugin) && !StringUtil.isEmpty((String)appId);
    }

    public void limit(String url, String clientId, String accountId) {
        long time = System.currentTimeMillis() / (long)(TOKEN_LIMIT_TIMEOUT * 1000);
        String key = TOKEN_LIMIT_PREFIX + clientId + "_" + TokenUrlEnum.getToken((String)url).getType() + "_" + time;
        long count = DistributeCacheUtil.inc(key, accountId, TOKEN_LIMIT_TIMEOUT);
        if (count > (long)TOKEN_LIMIT_COUNT) {
            throw new OpenApiException(ApiErrorCode.HTTP_TOO_MANY_REQUEST, "Too many request, Flow Limit is exceed.", new Object[0]);
        }
    }
}

