/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.sign.impl;

import com.alibaba.fastjson.JSON;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.encrypt.impl.RSAEncrypterUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.sign.SignService;
import kd.bos.openapi.base.util.JWTUtils;
import kd.bos.openapi.base.util.ShaSignUtils;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.CertKeyUtil;
import kd.bos.openapi.security.model.CertificateInfo;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.openapi.security.model.SignInfoDto;
import kd.bos.service.authorize.model.JwtInfo;
import kd.bos.service.authorize.model.SignInfo;
import kd.bos.session.RSAUtils;
import kd.bos.session.SystemPropertyUtils;

public class SignServiceImpl
implements SignService {
    private static final Log log = LogFactory.getLog(SignServiceImpl.class);
    private static String APP_TOKEN_TIMEOUT_KEY = "apptoken.timeout";
    private static int DEFAULT_TIMEOUT = 7200;

    @Override
    public String signBySha256(String content, String key) {
        String signData = "";
        try {
            signData = ShaSignUtils.HMACSHA256StrByKey(content, key);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, "SignServiceImpl.signBySha256 error:" + e.getMessage(), new Object[0]);
        }
        return signData;
    }

    @Override
    public String signByPublicKey(String content, PublicKey publicKey) {
        if (StringUtil.isEmpty((String)content)) {
            return "";
        }
        if (publicKey == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "SignServiceImpl.signByPublicKey not support publicKey is null", new Object[0]);
        }
        try {
            return RSAEncrypterUtil.encrypt((String)content, (PublicKey)publicKey);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, "SignServiceImpl.signByPublicKey error:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public String signByPublicKey(String content, String publicKeyBase64) {
        if (StringUtil.isEmpty((String)content)) {
            return "";
        }
        if (StringUtil.isEmpty((String)publicKeyBase64)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "SignServiceImpl.signByPublicKey not support publicKeyBase64 is null", new Object[0]);
        }
        PublicKey publicKey = null;
        try {
            publicKey = RSAEncrypterUtil.getPublicKey((String)publicKeyBase64);
            return this.signByPublicKey(content, publicKey);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, "SignServiceImpl.signByPublicKey error:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public String signByPrivateKey(String content, PrivateKey privateKey) {
        if (StringUtil.isEmpty((String)content)) {
            return "";
        }
        if (privateKey == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "SignServiceImpl.signByPrivateKey not support privateKey is null", new Object[0]);
        }
        try {
            return RSAEncrypterUtil.encrypt((String)content, (PrivateKey)privateKey);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, "SignServiceImpl.signByPrivateKey error:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public String signByPrivateKey(String content, String privateKeyBase64) {
        if (StringUtil.isEmpty((String)content)) {
            return "";
        }
        if (StringUtil.isEmpty((String)privateKeyBase64)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "SignServiceImpl.signByPrivateKey not support privateKeyBase64 is null", new Object[0]);
        }
        PrivateKey privateKey = null;
        try {
            privateKey = RSAEncrypterUtil.getPrivateKey((String)privateKeyBase64);
            return this.signByPrivateKey(content, privateKey);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, "SignServiceImpl.signByPrivateKey error:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public String unSignByPublicKey(String signedContent, PublicKey publicKey) {
        if (StringUtil.isEmpty((String)signedContent)) {
            return "";
        }
        if (publicKey == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "SignServiceImpl.unSignByPublicKey not support publicKey is null", new Object[0]);
        }
        try {
            return RSAEncrypterUtil.decrypt((String)signedContent, (PublicKey)publicKey);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, "SignServiceImpl.unSignByPublicKey error:", new Object[0]);
        }
    }

    @Override
    public String unSignByPublicKey(String signedContent, String publicKeyBase64) {
        if (StringUtil.isEmpty((String)signedContent)) {
            return "";
        }
        if (StringUtil.isEmpty((String)publicKeyBase64)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "SignServiceImpl.unSignByPublicKey not support publicKeyBase64 is null", new Object[0]);
        }
        PublicKey publicKey = null;
        try {
            publicKey = RSAEncrypterUtil.getPublicKey((String)publicKeyBase64);
            return this.unSignByPublicKey(signedContent, publicKey);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, "SignServiceImpl.unSignByPublicKey error:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public String unSignByPrivateKey(String signedContent, PrivateKey privateKey) {
        if (StringUtil.isEmpty((String)signedContent)) {
            return "";
        }
        if (privateKey == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "SignServiceImpl.unSignByPrivateKey not support privateKey is null", new Object[0]);
        }
        try {
            return RSAEncrypterUtil.decrypt((String)signedContent, (PrivateKey)privateKey);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, "SignServiceImpl.unSignByPrivateKey error:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public String unSignByPrivateKey(String signedContent, String privateKeyBase64) {
        if (StringUtil.isEmpty((String)signedContent)) {
            return "";
        }
        if (StringUtil.isEmpty((String)privateKeyBase64)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "SignServiceImpl.unSignByPrivateKey not support privateKeyBase64 is null", new Object[0]);
        }
        PrivateKey privateKey = null;
        try {
            privateKey = RSAEncrypterUtil.getPrivateKey((String)privateKeyBase64);
            return this.unSignByPrivateKey(signedContent, privateKey);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, "SignServiceImpl.unSignByPrivateKey error:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public String signing(SignInfoDto signInfo) {
        if (signInfo == null || StringUtil.isEmpty((String)signInfo.getAccountId())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, " signing params error", new Object[0]);
        }
        String accountId = signInfo.getAccountId();
        Open3rdappsDto thirdApp = new Open3rdappsDto();
        if (signInfo.getThirdId() != null) {
            thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndThirdId(accountId, signInfo.getThirdId());
        } else if (StringUtil.isNotEmpty((String)signInfo.getThirdAppNumber())) {
            thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndAppId(accountId, signInfo.getThirdAppNumber());
        }
        String currentSignature = "";
        if (thirdApp.getDigestSignType() == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's digestSignType is null", new Object[0]);
        }
        switch (thirdApp.getDigestSignType().intValue()) {
            case 1: {
                String digestSignKey = thirdApp.getDigestSignKey();
                String singKeyDecode = "";
                singKeyDecode = EncrypterFactory.getEncrypter().isEncrypted(digestSignKey) ? EncrypterFactory.getEncrypter().decode(digestSignKey) : digestSignKey;
                StringBuilder sb = ShaSignUtils.getSignatureString(signInfo.getDateTime(), signInfo.getSignatureNonce(), signInfo.getContent());
                currentSignature = this.signBySha256(sb.toString(), singKeyDecode);
                break;
            }
            default: {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's DigestSignType is invalid", new Object[0]);
            }
        }
        return currentSignature;
    }

    @Override
    public String signingBySha256(String singKey, SignInfoDto signInfo) {
        StringBuilder sb = ShaSignUtils.getSignatureString(signInfo.getDateTime(), signInfo.getSignatureNonce(), signInfo.getContent());
        return this.signBySha256(sb.toString(), singKey);
    }

    @Override
    public boolean vertifySign(SignInfo signInfo) {
        boolean result = false;
        if (signInfo == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the signInfo is invalid", new Object[0]);
        }
        Open3rdappsDto thirdApp = new Open3rdappsDto();
        if (signInfo.getThirdId() != null) {
            thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndThirdId(signInfo.getAccountId(), signInfo.getThirdId());
        } else if (StringUtil.isNotEmpty((String)signInfo.getThirdAppNumber())) {
            thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndAppId(signInfo.getAccountId(), signInfo.getThirdAppNumber());
        }
        if (thirdApp.getDigestSignType() == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's digestSignType is null", new Object[0]);
        }
        switch (thirdApp.getDigestSignType().intValue()) {
            case 1: {
                if (thirdApp == null || thirdApp.getDigestSignKey() == null) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's digest key is invalid", new Object[0]);
                }
                String digestSignKey = thirdApp.getDigestSignKey();
                String singKeyDecode = "";
                singKeyDecode = EncrypterFactory.getEncrypter().isEncrypted(digestSignKey) ? EncrypterFactory.getEncrypter().decode(digestSignKey) : digestSignKey;
                String signature = signInfo.getSignature();
                StringBuilder sb = ShaSignUtils.getSignatureString(signInfo.getDateTime(), signInfo.getSignatureNonce(), signInfo.getContent());
                String currentSignature = this.signBySha256(sb.toString(), singKeyDecode);
                if (ApiSecurityFactory.isSecurityLogOpen()) {
                    log.info("------traceId:" + RequestContext.get().getTraceId() + "--signType:" + thirdApp.getDigestSignType() + " signKey:" + EncrypterFactory.getEncrypter().encode(singKeyDecode) + " currentSignature:" + currentSignature + " signature:" + signature);
                }
                if (!currentSignature.equals(signature)) break;
                result = true;
                break;
            }
            default: {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's DigestSignType is invalid", new Object[0]);
            }
        }
        return result;
    }

    @Override
    public <T> String generateJWTToken(JwtInfo<T> jwtInfo) {
        long expireTime;
        if (jwtInfo == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the jwtInfo is invalid", new Object[0]);
        }
        String accountId = jwtInfo.getAccountId();
        String appId = jwtInfo.getThirdAppNumber();
        Object userInfo = jwtInfo.getData();
        String tenantId = StringUtil.isNotEmpty((String)jwtInfo.getTenantId()) ? jwtInfo.getTenantId() : (RequestContext.get() != null ? RequestContext.get().getTenantId() : "");
        Open3rdappsDto thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndAppId(accountId, appId);
        if (ApiSecurityFactory.isSecurityLogOpen()) {
            log.info("--------traceId:" + RequestContext.get().getTraceId() + "jwt generate signType:" + thirdApp.getJwtSignType());
        }
        String jwt = "";
        long l = expireTime = jwtInfo.getExpires() == null || jwtInfo.getExpires() == 0L ? this.getExpiredTime(tenantId) : jwtInfo.getExpires().longValue();
        if (thirdApp.getJwtSignType() == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's jwtSignType is null", new Object[0]);
        }
        try {
            switch (thirdApp.getJwtSignType().intValue()) {
                case 1: {
                    String jwtShaKey = thirdApp.getJwtShaKey();
                    String singKeyDecode = "";
                    singKeyDecode = EncrypterFactory.getEncrypter().isEncrypted(jwtShaKey) ? EncrypterFactory.getEncrypter().decode(jwtShaKey) : jwtShaKey;
                    jwt = JWTUtils.generateJWTByMapParameters(userInfo, singKeyDecode, expireTime);
                    if (ApiSecurityFactory.isSecurityLogOpen()) {
                        log.info("--------traceId:" + RequestContext.get().getTraceId() + "jwt singKey:" + EncrypterFactory.getEncrypter().encode(singKeyDecode) + " expireTime:" + expireTime);
                    }
                    break;
                }
                case 2: {
                    Map certificateInfoMap = thirdApp.getCertMaps();
                    String certKey = CertKeyUtil.getCertKey((String)"3", (String)"2");
                    CertificateInfo certificateInfo = (CertificateInfo)certificateInfoMap.get(certKey);
                    if (certificateInfo == null || StringUtil.isEmpty((String)certificateInfo.getPublicKeyBase64())) {
                        throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's RSA private key is invalid", new Object[0]);
                    }
                    String privateKeyDecode = "";
                    if (EncrypterFactory.getEncrypter().isEncrypted(certificateInfo.getPrivateKeyBase64())) {
                        privateKeyDecode = EncrypterFactory.getEncrypter().decode(certificateInfo.getPrivateKeyBase64());
                    }
                    PrivateKey key = RSAUtils.getPrivateKeyBase64((String)privateKeyDecode);
                    jwt = JWTUtils.generateRSAJWTByMapParameters(userInfo, (Key)key, expireTime);
                    if (ApiSecurityFactory.isSecurityLogOpen()) {
                        log.info("--------traceId:" + RequestContext.get().getTraceId() + "jwt pKey:" + EncrypterFactory.getEncrypter().encode(privateKeyDecode) + " expireTime:" + expireTime);
                    }
                    break;
                }
                default: {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's jwtSignType is invalid", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "generateJWTToken error:" + e.getMessage(), new Object[0]);
        }
        if (ApiSecurityFactory.isSecurityLogOpen()) {
            log.info("--------traceId:" + RequestContext.get().getTraceId() + "jwt:" + jwt);
        }
        return jwt;
    }

    @Override
    public <T> T versifyJWTToken(JwtInfo<T> jwtInfo) {
        if (jwtInfo == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the jwtInfo is invalid", new Object[0]);
        }
        String accountId = jwtInfo.getAccountId();
        String appId = jwtInfo.getThirdAppNumber();
        String jwt = jwtInfo.getJwt();
        Open3rdappsDto thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndAppId(accountId, appId);
        Map<String, String> result = null;
        if (thirdApp.getJwtSignType() == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's jwtSignType is null", new Object[0]);
        }
        if (ApiSecurityFactory.isSecurityLogOpen()) {
            log.info("--------traceId:" + RequestContext.get().getTraceId() + " jwt signType:" + thirdApp.getJwtSignType());
        }
        try {
            switch (thirdApp.getJwtSignType().intValue()) {
                case 1: {
                    String jwtShaKey = thirdApp.getJwtShaKey();
                    if (thirdApp == null || jwtShaKey == null) {
                        throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's jwtSha key is invalid", new Object[0]);
                    }
                    String singKeyDecode = "";
                    singKeyDecode = EncrypterFactory.getEncrypter().isEncrypted(jwtShaKey) ? EncrypterFactory.getEncrypter().decode(jwtShaKey) : jwtShaKey;
                    result = JWTUtils.getJWTClaimsByKey(singKeyDecode, jwt);
                    if (ApiSecurityFactory.isSecurityLogOpen()) {
                        log.info("--------traceId:" + RequestContext.get().getTraceId() + "jwt:" + jwt + "jwt singKey:" + EncrypterFactory.getEncrypter().encode(singKeyDecode));
                    }
                    break;
                }
                case 2: {
                    Map certificateInfoMap = thirdApp.getCertMaps();
                    String certKey = CertKeyUtil.getCertKey((String)"3", (String)"2");
                    CertificateInfo certificateInfo = (CertificateInfo)certificateInfoMap.get(certKey);
                    if (certificateInfo == null || StringUtil.isEmpty((String)certificateInfo.getPublicKeyBase64())) {
                        throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's RSA public key is invalid", new Object[0]);
                    }
                    String publicKeyDecode = "";
                    if (EncrypterFactory.getEncrypter().isEncrypted(certificateInfo.getPublicKeyBase64())) {
                        publicKeyDecode = EncrypterFactory.getEncrypter().decode(certificateInfo.getPublicKeyBase64());
                    }
                    PublicKey key = RSAUtils.getPublicKeyBase64((String)publicKeyDecode);
                    result = JWTUtils.getJWTClaimsByPublicKey(key, jwt);
                    if (ApiSecurityFactory.isSecurityLogOpen()) {
                        log.info("--------traceId:" + RequestContext.get().getTraceId() + "jwt:" + jwt + "jwt pubKey:" + EncrypterFactory.getEncrypter().encode(publicKeyDecode));
                    }
                    break;
                }
                default: {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdApp's jwtSignType is invalid", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "versifyJWTToken error:" + e.getMessage(), new Object[0]);
        }
        if (ApiSecurityFactory.isSecurityLogOpen()) {
            log.info("--------traceId:" + RequestContext.get().getTraceId() + "jwt result:" + JSON.toJSONString(result));
        }
        return (T)result;
    }

    static int getTokenTimeout(String tenantId) {
        return SystemPropertyUtils.getInteger((String)tenantId, (String)APP_TOKEN_TIMEOUT_KEY, (Integer)DEFAULT_TIMEOUT);
    }

    private long getExpiredTime(String tenantId) {
        LocalDateTime now = LocalDateTime.now();
        now = now.plusSeconds(SignServiceImpl.getTokenTimeout(tenantId));
        long time2 = now.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        return time2;
    }
}

