/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.statdata;

import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.elect.Elector;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.statdata.ApiStatUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.util.SysUtil;

public class ApiAggrService {
    private static Log log = LogFactory.getLog(ApiAggrService.class);
    private static Elector elector;
    private static final String SERVICE_NAME = "OpenApiAggrService";
    private static final AtomicBoolean aggrBusy;
    private static int aggrInterval;
    private static final Map<String, Long> lastAggrTimeMap;

    public static boolean isMaster() {
        return elector == null ? false : elector.isMaster();
    }

    public void ApiStatService() {
    }

    public void start(boolean isForceRefresh) {
        if (!ApiStatUtil.getMCApiStatEnable()) {
            log.info("OpenApiStatData-ApiAggrService was disabled. MCApiStatEnable: false");
            return;
        }
        String aggrAppId = System.getProperty("openapi.aggr.appid", "");
        if (!StringUtil.isEmpty((String)aggrAppId) && !SysUtil.isCurrentNodeDeployApp((String)aggrAppId)) {
            log.info(String.format("OpenApiStatData-ApiAggrService was not deployed in this node. IsCurrentNodeDeployApp:%b, AppIds:%s, aggrAppId:%s, InstnaceId:%s", SysUtil.isCurrentNodeDeployApp((String)aggrAppId), Instance.getAppIds(), aggrAppId, Instance.getInstanceId()));
            return;
        }
        this.aggrAllData(isForceRefresh);
    }

    public void start() {
        this.start(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean aggrAllData(boolean isForceRefresh) {
        Long lastAggrTime = lastAggrTimeMap.get(RequestContext.get().getAccountId());
        if (lastAggrTime == null) {
            lastAggrTime = 0L;
        }
        if (!isForceRefresh && System.currentTimeMillis() - lastAggrTime < (long)(aggrInterval * 1000 / 2)) {
            return false;
        }
        boolean aggrStatus = false;
        try {
            String accountId = RequestContext.get().getAccountId();
            boolean isApiStatEnableParameter = ApiStatUtil.getApiStatEnableParameter();
            if (!isApiStatEnableParameter) {
                log.info(String.format("OpenApiStatData-ApiAggrService was disabled. ApiStatEnableParameter:%b, accountId:%s, tenantId:%s", isApiStatEnableParameter, accountId, RequestContext.get().getTenantId()));
                boolean bl = false;
                return bl;
            }
            String lockKey = "ApiAggrService-" + accountId;
            DLock lock = DLock.create((String)lockKey);
            try {
                if (lock.tryLock(10000L)) {
                    aggrStatus = this.aggrData(accountId);
                } else {
                    log.info(String.format("OpenApiStatData-ApiAggrService-DLock Failed: accountId:%s", accountId));
                }
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            if (aggrStatus) {
                lastAggrTimeMap.put(RequestContext.get().getAccountId(), System.currentTimeMillis());
            }
        }
        return aggrStatus;
    }

    private boolean aggrData(String accountId) {
        long startTime = System.currentTimeMillis();
        boolean status = true;
        try {
            Date minDate = this.aggrByHour(accountId);
            this.aggrByDay(minDate, accountId);
            this.aggrByAll(minDate, accountId);
            this.aggrApiBill(accountId);
            log.info(String.format("OpenApiStatData-ApiAggrService-aggregating done: accountId:%s, the cost(ms):%d ", accountId, System.currentTimeMillis() - startTime));
        }
        catch (Exception ex) {
            log.error(String.format("OpenApiStatData-An error occurred while write aggregating the OpenApiStatData: accountId:%s, errorMsg:%s, ", accountId, ex.getMessage()), (Throwable)ex);
            status = false;
        }
        long cost = System.currentTimeMillis() - startTime;
        this.writeStatLog(cost, status, accountId);
        return status;
    }

    private int getTimeoffset() {
        return TimeZone.getDefault().getRawOffset();
    }

    public Date queryMinDateByMinute() {
        String sql = "select min(ftime) as ftime from t_openapi_statdata_min ";
        return (Date)DB.query((DBRoute)DBRoute.basedata, (String)sql, rs -> {
            Date date = new Date(0L);
            while (rs.next()) {
                long minDate = rs.getLong(1);
                date = new Date(minDate);
            }
            return date;
        });
    }

    public Date aggrByHour(String accountId) {
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            Date lowDate;
            Date currentTime = this.getCurrentTime();
            Date queryMinDateByMinute = this.queryMinDateByMinute();
            if (queryMinDateByMinute.compareTo(new Date(0L)) <= 0) {
                Date date = new Date(0L);
                return date;
            }
            Date minDate = DateUtil.getMinDate((Date)queryMinDateByMinute, (Date)currentTime);
            if (minDate.compareTo(lowDate = DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-7)) < 0) {
                minDate = lowDate;
            }
            Date minDateWithoutMinute = DateUtil.getDateWithoutMinute((Date)minDate);
            long nMinDateWithoutMinute = minDateWithoutMinute.getTime() / 3600000L * 3600000L;
            String sql = "DELETE from t_openapi_statdata_sum where ftype=1 and ftime>=?";
            Object[] params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)nMinDateWithoutMinute)};
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            sql = "INSERT INTO t_openapi_statdata_sum(ftime,fapiid,fthirdid,fcnt,fsuccesscnt,fbillcnt,fcost,ftype)  SELECT floor(ftime/(1000*3600))*(1000*3600) as ftime,fapiid,fthirdid,SUM(fcnt) as fcnt, SUM(fsuccesscnt) as fsuccesscnt,SUM(fbillcnt) as fbillcnt, SUM(fcost) as fcost,1 as ftype  from t_openapi_statdata_min where ftime>=?  group by floor(ftime/(1000*3600))*(1000*3600),fapiid,fthirdid ";
            params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)nMinDateWithoutMinute)};
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            sql = "DELETE from t_openapi_statdata_min where ftime<?";
            long nCurrentTime = DateUtil.getDateWithoutMinute((Date)currentTime).getTime();
            params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)nCurrentTime)};
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            Date date = minDateWithoutMinute;
            return date;
        }
        catch (Exception e) {
            try {
                handle.markRollback();
                throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, e.getMessage(), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Date queryMaxDateByType(int type) {
        String sql = "select max(ftime) as ftime from t_openapi_statdata_sum where ftime>0 and ftype=? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FTime", 4, (Object)type)};
        return (Date)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            Date date = this.getCurrentTime();
            while (rs.next()) {
                long nDbDate = rs.getLong(1);
                Date dbDate = new Date(nDbDate);
                if (date.compareTo(dbDate) <= 0) continue;
                date = dbDate;
            }
            return date;
        });
    }

    public Date aggrByDay(Date minDate, String accountId) {
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            int timeOffset = this.getTimeoffset();
            if (minDate.compareTo(new Date(0L)) <= 0) {
                Date date = new Date(0L);
                return date;
            }
            Date queryMaxDate = this.queryMaxDateByType(2);
            minDate = DateUtil.getMinDate((Date)queryMaxDate, (Date)minDate);
            Date minDateWithoutHour = DateUtil.getDateWithoutHour((Date)DateUtil.getDateAdd((Date)minDate, (int)6, (int)-1));
            long nMinDateWithoutHour = (minDateWithoutHour.getTime() + (long)timeOffset) / 86400000L * 86400000L - (long)timeOffset;
            String sql = "DELETE from t_openapi_statdata_sum where ftype=2 and ftime>=?";
            Object[] params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)nMinDateWithoutHour)};
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            String timeGrp = " floor((ftime+" + timeOffset + ")/(24*1000*3600))*(24*1000*3600)-" + timeOffset;
            sql = "INSERT INTO t_openapi_statdata_sum(ftime,fapiid,fthirdid,fcnt,fsuccesscnt,fbillcnt,fcost,ftype)  SELECT " + timeGrp + " as ftime,fapiid,fthirdid,SUM(fcnt) as fcnt, SUM(fsuccesscnt) as fsuccesscnt,SUM(fbillcnt) as fbillcnt,SUM(fcost) as fcost,2 as ftype  from t_openapi_statdata_sum where ftype=1 and ftime>=? group by " + timeGrp + ",fapiid,fthirdid ";
            params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)nMinDateWithoutHour)};
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)nMinDateWithoutHour)};
            sql = "DELETE from t_openapi_statdata_sum where ftime<? and ftype=1";
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            Date date = minDateWithoutHour;
            return date;
        }
        catch (Exception e) {
            try {
                handle.markRollback();
                throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, e.getMessage(), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Date aggrByAll(Date minDate, String accountId) {
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            if (minDate.compareTo(new Date(0L)) <= 0) {
                Date date = new Date(0L);
                return date;
            }
            long nDataKeepDate = this.getDataKeepDate().getTime();
            String sql = "DELETE from t_openapi_statdata_sum where ftime<? and ftype=2 ";
            Object[] params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)nDataKeepDate)};
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            Date queryMaxDate = this.queryMaxDateByType(7);
            Date queryMinDate = DateUtil.getMinDate((Date)queryMaxDate, (Date)minDate);
            Date twoDays = DateUtil.getDateAdd((Date)queryMinDate, (int)6, (int)-2);
            long n2Days = DateUtil.getDateWithoutHour((Date)twoDays).getTime();
            params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)n2Days)};
            sql = "DELETE from t_openapi_statdata_sum where ftype=7 and ftime>=?";
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            sql = "INSERT INTO t_openapi_statdata_sum(ftime,ftype,fapiid,fthirdid,fcnt,fsuccesscnt,fbillcnt,fcost)  SELECT ftime,7 as ftype,0 as fapiid,0 as fthirdid,SUM(fcnt) as fcnt, SUM(fsuccesscnt) as fsuccesscnt,SUM(fbillcnt) as fbillcnt,SUM(fcost) as fcost  from t_openapi_statdata_sum where ftype=2 and ftime>=? group by ftime ";
            params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)n2Days)};
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            sql = "DELETE from t_openapi_statdata_sum where ftype=9";
            DB.execute((DBRoute)DBRoute.basedata, (String)sql);
            params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)0)};
            sql = "INSERT INTO t_openapi_statdata_sum(ftime,ftype,fapiid,fthirdid,fcnt,fsuccesscnt,fbillcnt,fcost)  SELECT 0 as ftime,9 as ftype,0 as fapiid,0 as fthirdid,SUM(fcnt) as fcnt, SUM(fsuccesscnt) as fsuccesscnt,SUM(fbillcnt) as fbillcnt,SUM(fcost) as fcost  from t_openapi_statdata_sum where ftype=7 and ftime>=?  ";
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            Date date = this.getDataKeepDate();
            return date;
        }
        catch (Exception e) {
            try {
                handle.markRollback();
                throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, e.getMessage(), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private Date getDataKeepDate() {
        return DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-365);
    }

    private Date getCurrentTime() {
        return DateUtil.getDateAdd((Date)new Date(), (int)13, (int)-600);
    }

    private void writeStatLog(long cost, boolean status, String accountId) {
        int statusCode = status ? 1 : 0;
        try (TXHandle handle = TX.requiresNew();){
            try {
                String sql = "DELETE from t_openapi_statdata_sum where ftype=10 and ftime>0 ";
                DB.execute((DBRoute)DBRoute.basedata, (String)sql);
                sql = "INSERT INTO t_openapi_statdata_sum(ftime,fapiid,fthirdid,fcnt,fsuccesscnt,fcost,ftype)  VALUES(?,0,0,0,?,?,10) ";
                Object[] params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)new Date().getTime()), new SqlParameter(":FSuccesscnt", -5, (Object)statusCode), new SqlParameter(":FCost", -5, (Object)cost)};
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            }
            catch (Exception e) {
                handle.markRollback();
                log.error(String.format("OpenApiStatData-An error occurred while writing aggregating log(writeStatLog), accountId:%s, errorMsg:%s ", accountId, e.getMessage()), (Throwable)e);
            }
        }
    }

    private void aggrApiBill(String accountId) {
        if (!OpenApiDataServiceFactory.getOpenApiBillService().getBillEnabled()) {
            return;
        }
        long fLicenseCnt = OpenApiDataServiceFactory.getOpenApiBillService().getBillLicenseNumber();
        long fCreditCnt = OpenApiDataServiceFactory.getOpenApiBillService().getBillCreditCount();
        Map dateMap = OpenApiDataServiceFactory.getOpenApiBillService().getBillTimeRange();
        Date dateFm = (Date)dateMap.get("beginDate");
        Date dateTo = (Date)dateMap.get("expireDate");
        if (dateFm == null) {
            dateFm = DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-365);
        }
        if (dateTo == null) {
            dateTo = new Date();
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                String sql = "DELETE from t_openapi_statdata_sum where ftype=11 and ftime>0";
                DB.execute((DBRoute)DBRoute.basedata, (String)sql);
                Object[] params = new SqlParameter[]{new SqlParameter(":ftime0", -5, (Object)new Date().getTime()), new SqlParameter(":fcnt", -5, (Object)fLicenseCnt), new SqlParameter(":fsuccesscnt", -5, (Object)fCreditCnt), new SqlParameter(":ftime1", -5, (Object)dateFm.getTime()), new SqlParameter(":ftime2", -5, (Object)dateTo.getTime())};
                sql = "INSERT INTO t_openapi_statdata_sum(ftime,ftype,fapiid,fthirdid,fcnt,fsuccesscnt,fbillcnt,fcost)  SELECT ? as ftime,11 as ftype,0 as fapiid,0 as fthirdid,? as fcnt, ? as fsuccesscnt,SUM(fbillcnt) as fbillcnt,0 as fcost  from t_openapi_statdata_sum where ftype=7 and ftime>=? and ftime<=? ";
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            }
            catch (Exception e) {
                handle.markRollback();
                String msg = String.format("OpenApiStatData-An error occurred while writing aggregating log(writeApiBillInfo), accountId:%s, errorMsg:%s ", accountId, e.getMessage());
                throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, msg, new Object[0]);
            }
        }
    }

    static {
        aggrBusy = new AtomicBoolean(false);
        aggrInterval = 310;
        lastAggrTimeMap = new ConcurrentHashMap<String, Long>(8);
    }
}

