/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.statdata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.id.IDService;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.statdata.ApiStatData;
import kd.bos.openapi.base.statdata.ApiStatUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.thread.ThreadLifeCycleManager;

public class ApiStatService {
    private static Log log = LogFactory.getLog(ApiStatService.class);
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private static final AtomicBoolean collectBusy = new AtomicBoolean(false);
    private static final ApiStatService INSTANCE;
    private static final String serviceName = "OpenApiStatData";
    private static long lastStatTime;
    private static ConcurrentHashMap<String, Map<String, ApiStatData>> accountStatMap;

    public static ApiStatService getInstance() {
        return INSTANCE;
    }

    public void ApiStatService() {
    }

    private void start() {
        if (!ApiStatUtil.getMCApiStatEnable()) {
            log.info("OpenApiStatData-Collecting service was disabled. MCApiStatEnable:false");
            return;
        }
        if (started.compareAndSet(false, true)) {
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            List<Account> accounts = ApiStatUtil.getAllAccountsOfCurrentEnv();
            if (CollectionUtil.isEmpty(accounts)) {
                log.error("OpenApiStatData-An error occurred while getting AllAccountsOfCurrentEnv, getAllAccountsOfCurrentEnv is empty.");
                return;
            }
            Runnable runnable = ThreadLifeCycleManager.wrapRunnable(() -> {
                try {
                    this.collectAllToDb(accounts, false);
                }
                catch (Exception ex) {
                    log.error("OpenApiStatData-An error occurred while collecting AllDataToDb:" + ex.getMessage(), (Throwable)ex);
                }
            });
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName(serviceName);
            int interval = 305;
            scheduledExecutorService.scheduleAtFixedRate(thread, interval, interval, TimeUnit.SECONDS);
            log.info(String.format("OpenApiStatData-Collecting service start successfully. InstanceId:%s, CollectInterval:%d (seconds)", Instance.getInstanceId(), interval));
        }
    }

    public void forceCollectAllToDb() {
        List<Account> accounts = ApiStatUtil.getAllAccountsOfCurrentEnv();
        this.collectAllToDb(accounts, true);
    }

    public void collect(long apiId, long thirdId, boolean status, int cost, int billCnt) {
        if (!ApiStatUtil.getMCApiStatEnable()) {
            return;
        }
        String accountId = RequestContext.get().getAccountId();
        Map<String, ApiStatData> statDataMaps = accountStatMap.get(accountId);
        if (statDataMaps == null && (statDataMaps = (Map<String, ApiStatData>)accountStatMap.putIfAbsent(accountId, new ConcurrentHashMap(256))) == null) {
            statDataMaps = accountStatMap.get(accountId);
        }
        int succCnt = status ? 1 : 0;
        String key = this.getStatKey(apiId, thirdId);
        ApiStatData stat = (ApiStatData)statDataMaps.get(key);
        if (stat == null) {
            statDataMaps.putIfAbsent(key, new ApiStatData(apiId, thirdId, 1, succCnt, cost, billCnt));
        } else {
            statDataMaps.compute(key, (k, v) -> {
                v.setCnt(v.getCnt() + 1);
                v.setSuccCnt(v.getSuccCnt() + succCnt);
                v.setCost(v.getCost() + cost);
                v.setBillCnt(v.getBillCnt() + billCnt);
                return v;
            });
        }
    }

    private void collectAllToDb(List<Account> accounts, boolean isForceRefresh) {
        if (!isForceRefresh && System.currentTimeMillis() - lastStatTime < 152500L) {
            return;
        }
        if (collectBusy.compareAndSet(false, true)) {
            try {
                accounts.forEach(account -> {
                    String accountId = account.getAccountId();
                    Map<String, ApiStatData> statDataMaps = this.getApiStatDataMap(accountId);
                    if (CollectionUtil.isEmpty(statDataMaps)) {
                        return;
                    }
                    ThreadLifeCycleManager.start();
                    try {
                        ApiStatUtil.createRequstContext(accountId, account.getTenantId());
                        boolean isApiStatEnableParameter = ApiStatUtil.getApiStatEnableParameter();
                        if (!isApiStatEnableParameter) {
                            log.info(String.format("OpenApiStatData-ApiCollectService was disabled. ApiStatEnableParameter:%b, accountId:%s, tenantId:%s", isApiStatEnableParameter, accountId, account.getTenantId()));
                            return;
                        }
                        this.collectToDb(accountId);
                    }
                    finally {
                        ThreadLifeCycleManager.end();
                    }
                });
            }
            finally {
                collectBusy.set(false);
                lastStatTime = System.currentTimeMillis();
            }
        }
    }

    private Map<String, ApiStatData> getApiStatDataMap(String accountId) {
        Map<String, ApiStatData> statDataMaps = accountStatMap.get(accountId);
        return statDataMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collectToDb(String accountId) {
        Map<String, ApiStatData> statDataMaps = this.getApiStatDataMap(accountId);
        if (CollectionUtil.isEmpty(statDataMaps)) {
            return true;
        }
        long now = System.currentTimeMillis();
        String sql = "INSERT INTO t_openapi_statdata_min (fid,ftime,fapiid,fthirdid,fcnt,fsuccesscnt,fbillcnt,fcost)  VALUES (?, ?, ?, ?, ?, ?, ?, ?) ";
        long startWriteDb = System.currentTimeMillis();
        boolean dbError = false;
        try (TXHandle handle = TX.requiresNew();){
            try {
                ArrayList<SqlParameter[]> sqlData = new ArrayList<SqlParameter[]>(statDataMaps.size());
                for (Map.Entry<String, ApiStatData> item : statDataMaps.entrySet()) {
                    ApiStatData statData = item.getValue();
                    SqlParameter[] params = new SqlParameter[8];
                    long id = IDService.get().genLongId();
                    params[0] = new SqlParameter(":fid", -5, (Object)id);
                    params[1] = new SqlParameter(":ftime", -5, (Object)now);
                    params[2] = new SqlParameter(":fapiid", -5, (Object)statData.getApiId());
                    params[3] = new SqlParameter(":fthirdid", -5, (Object)statData.getThirdId());
                    params[4] = new SqlParameter(":fcnt", -5, (Object)statData.getCnt());
                    params[5] = new SqlParameter(":fsuccesscnt", -5, (Object)statData.getSuccCnt());
                    params[6] = new SqlParameter(":fbillcnt", -5, (Object)statData.getBillCnt());
                    params[7] = new SqlParameter(":fcost", -5, (Object)statData.getCost());
                    sqlData.add(params);
                }
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, sqlData);
            }
            catch (Exception e) {
                dbError = true;
                handle.markRollback();
                log.error(String.format("OpenApiStatData-An error occurred while writing the OpenApiStatData into db, accountId:%s, errorMsg:%s", accountId, e.getMessage()), (Throwable)e);
            }
            finally {
                if (!dbError) {
                    Iterator<Map.Entry<String, ApiStatData>> it2 = statDataMaps.entrySet().iterator();
                    while (it2.hasNext()) {
                        it2.next();
                        it2.remove();
                    }
                }
            }
        }
        log.info(String.format("OpenApiStatData-ApiStatService-collectToDb done, the cost of witting db:%d(ms), InstanceId:%s, accountId:%s ", System.currentTimeMillis() - startWriteDb, Instance.getInstanceId(), accountId));
        return !dbError;
    }

    private String getStatKey(long apiId, long thirdId) {
        return apiId + "-" + thirdId;
    }

    static {
        lastStatTime = 0L;
        accountStatMap = new ConcurrentHashMap(8);
        INSTANCE = new ApiStatService();
        INSTANCE.start();
    }
}

